package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddResourcePermissionsResponse(
    shareResults: Option[Iterable[zio.aws.workdocs.model.ShareResult]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse = {
    import AddResourcePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse
      .builder()
      .optionallyWith(
        shareResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shareResults)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.AddResourcePermissionsResponse.ReadOnly =
    zio.aws.workdocs.model.AddResourcePermissionsResponse.wrap(buildAwsValue())
}
object AddResourcePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.AddResourcePermissionsResponse =
      zio.aws.workdocs.model.AddResourcePermissionsResponse(
        shareResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def shareResults: Option[List[zio.aws.workdocs.model.ShareResult.ReadOnly]]
    def getShareResults: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.ShareResult.ReadOnly
    ]] = AwsError.unwrapOptionField("shareResults", shareResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse
  ) extends zio.aws.workdocs.model.AddResourcePermissionsResponse.ReadOnly {
    override val shareResults
        : Option[List[zio.aws.workdocs.model.ShareResult.ReadOnly]] = scala
      .Option(impl.shareResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.ShareResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse
  ): zio.aws.workdocs.model.AddResourcePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
