package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  DocumentVersionIdType,
  AuthenticationHeaderType,
  ResourceIdType,
  CustomMetadataKeyType
}
import scala.jdk.CollectionConverters._
final case class DeleteCustomMetadataRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    resourceId: ResourceIdType,
    versionId: Option[DocumentVersionIdType] = None,
    keys: Option[Iterable[CustomMetadataKeyType]] = None,
    deleteAll: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest = {
    import DeleteCustomMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .resourceId(ResourceIdType.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        versionId.map(value =>
          DocumentVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            CustomMetadataKeyType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keys)
      .optionallyWith(
        deleteAll.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.deleteAll)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeleteCustomMetadataRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteCustomMetadataRequest.wrap(buildAwsValue())
}
object DeleteCustomMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeleteCustomMetadataRequest =
      zio.aws.workdocs.model.DeleteCustomMetadataRequest(
        authenticationToken.map(value => value),
        resourceId,
        versionId.map(value => value),
        keys.map(value => value),
        deleteAll.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def resourceId: ResourceIdType
    def versionId: Option[DocumentVersionIdType]
    def keys: Option[List[CustomMetadataKeyType]]
    def deleteAll: Option[BooleanType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getResourceId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(resourceId)
    def getVersionId: ZIO[Any, AwsError, DocumentVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getKeys: ZIO[Any, AwsError, List[CustomMetadataKeyType]] =
      AwsError.unwrapOptionField("keys", keys)
    def getDeleteAll: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("deleteAll", deleteAll)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest
  ) extends zio.aws.workdocs.model.DeleteCustomMetadataRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val resourceId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.resourceId())
    override val versionId: Option[DocumentVersionIdType] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.workdocs.model.primitives.DocumentVersionIdType(value)
      )
    override val keys: Option[List[CustomMetadataKeyType]] = scala
      .Option(impl.keys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.primitives.CustomMetadataKeyType(item)
        }.toList
      )
    override val deleteAll: Option[BooleanType] = scala
      .Option(impl.deleteAll())
      .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest
  ): zio.aws.workdocs.model.DeleteCustomMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
