package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait DocumentSourceType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.DocumentSourceType
}
object DocumentSourceType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.DocumentSourceType
  ): zio.aws.workdocs.model.DocumentSourceType = value match {
    case software.amazon.awssdk.services.workdocs.model.DocumentSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.DocumentSourceType.ORIGINAL =>
      val r = ORIGINAL
      r
    case software.amazon.awssdk.services.workdocs.model.DocumentSourceType.WITH_COMMENTS =>
      val r = WITH_COMMENTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.DocumentSourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentSourceType =
      software.amazon.awssdk.services.workdocs.model.DocumentSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ORIGINAL extends zio.aws.workdocs.model.DocumentSourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentSourceType =
      software.amazon.awssdk.services.workdocs.model.DocumentSourceType.ORIGINAL
  }
  case object WITH_COMMENTS extends zio.aws.workdocs.model.DocumentSourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentSourceType =
      software.amazon.awssdk.services.workdocs.model.DocumentSourceType.WITH_COMMENTS
  }
}
