package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  CustomMetadataValueType,
  CustomMetadataKeyType
}
import scala.jdk.CollectionConverters._
final case class GetDocumentVersionResponse(
    metadata: Option[zio.aws.workdocs.model.DocumentVersionMetadata] = None,
    customMetadata: Option[
      Map[CustomMetadataKeyType, CustomMetadataValueType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse = {
    import GetDocumentVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(
        customMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (CustomMetadataKeyType
                .unwrap(key): java.lang.String) -> (CustomMetadataValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.customMetadata)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetDocumentVersionResponse.ReadOnly =
    zio.aws.workdocs.model.GetDocumentVersionResponse.wrap(buildAwsValue())
}
object GetDocumentVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetDocumentVersionResponse =
      zio.aws.workdocs.model.GetDocumentVersionResponse(
        metadata.map(value => value.asEditable),
        customMetadata.map(value => value)
      )
    def metadata
        : Option[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly]
    def customMetadata
        : Option[Map[CustomMetadataKeyType, CustomMetadataValueType]]
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
    def getCustomMetadata: ZIO[Any, AwsError, Map[
      CustomMetadataKeyType,
      CustomMetadataValueType
    ]] = AwsError.unwrapOptionField("customMetadata", customMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse
  ) extends zio.aws.workdocs.model.GetDocumentVersionResponse.ReadOnly {
    override val metadata
        : Option[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly] =
      scala
        .Option(impl.metadata())
        .map(value =>
          zio.aws.workdocs.model.DocumentVersionMetadata.wrap(value)
        )
    override val customMetadata
        : Option[Map[CustomMetadataKeyType, CustomMetadataValueType]] = scala
      .Option(impl.customMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.workdocs.model.primitives
              .CustomMetadataKeyType(key) -> zio.aws.workdocs.model.primitives
              .CustomMetadataValueType(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse
  ): zio.aws.workdocs.model.GetDocumentVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
