package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.PageMarkerType
import scala.jdk.CollectionConverters._
final case class GetResourcesResponse(
    folders: Option[Iterable[zio.aws.workdocs.model.FolderMetadata]] = None,
    documents: Option[Iterable[zio.aws.workdocs.model.DocumentMetadata]] = None,
    marker: Option[PageMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetResourcesResponse = {
    import GetResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetResourcesResponse
      .builder()
      .optionallyWith(
        folders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.folders)
      .optionallyWith(
        documents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documents)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetResourcesResponse.ReadOnly =
    zio.aws.workdocs.model.GetResourcesResponse.wrap(buildAwsValue())
}
object GetResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetResourcesResponse =
      zio.aws.workdocs.model.GetResourcesResponse(
        folders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def folders: Option[List[zio.aws.workdocs.model.FolderMetadata.ReadOnly]]
    def documents
        : Option[List[zio.aws.workdocs.model.DocumentMetadata.ReadOnly]]
    def marker: Option[PageMarkerType]
    def getFolders: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.FolderMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("folders", folders)
    def getDocuments: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.DocumentMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("documents", documents)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetResourcesResponse
  ) extends zio.aws.workdocs.model.GetResourcesResponse.ReadOnly {
    override val folders
        : Option[List[zio.aws.workdocs.model.FolderMetadata.ReadOnly]] = scala
      .Option(impl.folders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.FolderMetadata.wrap(item)
        }.toList
      )
    override val documents
        : Option[List[zio.aws.workdocs.model.DocumentMetadata.ReadOnly]] = scala
      .Option(impl.documents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.DocumentMetadata.wrap(item)
        }.toList
      )
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetResourcesResponse
  ): zio.aws.workdocs.model.GetResourcesResponse.ReadOnly = new Wrapper(impl)
}
