package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workdocs.model.primitives.{
  DocumentContentType,
  ResourceNameType,
  TimestampType,
  SizeType,
  AuthenticationHeaderType,
  ResourceIdType
}
import scala.jdk.CollectionConverters._
final case class InitiateDocumentVersionUploadRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    id: Option[ResourceIdType] = None,
    name: Option[ResourceNameType] = None,
    contentCreatedTimestamp: Option[TimestampType] = None,
    contentModifiedTimestamp: Option[TimestampType] = None,
    contentType: Option[DocumentContentType] = None,
    documentSizeInBytes: Option[SizeType] = None,
    parentFolderId: ResourceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest = {
    import InitiateDocumentVersionUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        id.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        contentCreatedTimestamp.map(value =>
          TimestampType.unwrap(value): Instant
        )
      )(_.contentCreatedTimestamp)
      .optionallyWith(
        contentModifiedTimestamp.map(value =>
          TimestampType.unwrap(value): Instant
        )
      )(_.contentModifiedTimestamp)
      .optionallyWith(
        contentType.map(value =>
          DocumentContentType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        documentSizeInBytes.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.documentSizeInBytes)
      .parentFolderId(ResourceIdType.unwrap(parentFolderId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest.ReadOnly =
    zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest
      .wrap(buildAwsValue())
}
object InitiateDocumentVersionUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest =
      zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest(
        authenticationToken.map(value => value),
        id.map(value => value),
        name.map(value => value),
        contentCreatedTimestamp.map(value => value),
        contentModifiedTimestamp.map(value => value),
        contentType.map(value => value),
        documentSizeInBytes.map(value => value),
        parentFolderId
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def id: Option[ResourceIdType]
    def name: Option[ResourceNameType]
    def contentCreatedTimestamp: Option[TimestampType]
    def contentModifiedTimestamp: Option[TimestampType]
    def contentType: Option[DocumentContentType]
    def documentSizeInBytes: Option[SizeType]
    def parentFolderId: ResourceIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getContentCreatedTimestamp: ZIO[Any, AwsError, TimestampType] = AwsError
      .unwrapOptionField("contentCreatedTimestamp", contentCreatedTimestamp)
    def getContentModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField(
        "contentModifiedTimestamp",
        contentModifiedTimestamp
      )
    def getContentType: ZIO[Any, AwsError, DocumentContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDocumentSizeInBytes: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("documentSizeInBytes", documentSizeInBytes)
    def getParentFolderId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(parentFolderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest
  ) extends zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val id: Option[ResourceIdType] = scala
      .Option(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val name: Option[ResourceNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val contentCreatedTimestamp: Option[TimestampType] = scala
      .Option(impl.contentCreatedTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val contentModifiedTimestamp: Option[TimestampType] = scala
      .Option(impl.contentModifiedTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val contentType: Option[DocumentContentType] = scala
      .Option(impl.contentType())
      .map(value =>
        zio.aws.workdocs.model.primitives.DocumentContentType(value)
      )
    override val documentSizeInBytes: Option[SizeType] = scala
      .Option(impl.documentSizeInBytes())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
    override val parentFolderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.parentFolderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest
  ): zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest.ReadOnly =
    new Wrapper(impl)
}
