package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  ResourceNameType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters._
final case class UpdateFolderRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    folderId: ResourceIdType,
    name: Option[ResourceNameType] = None,
    parentFolderId: Option[ResourceIdType] = None,
    resourceState: Option[zio.aws.workdocs.model.ResourceStateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest = {
    import UpdateFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .folderId(ResourceIdType.unwrap(folderId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        parentFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.parentFolderId)
      .optionallyWith(resourceState.map(value => value.unwrap))(_.resourceState)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UpdateFolderRequest.ReadOnly =
    zio.aws.workdocs.model.UpdateFolderRequest.wrap(buildAwsValue())
}
object UpdateFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UpdateFolderRequest =
      zio.aws.workdocs.model.UpdateFolderRequest(
        authenticationToken.map(value => value),
        folderId,
        name.map(value => value),
        parentFolderId.map(value => value),
        resourceState.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def folderId: ResourceIdType
    def name: Option[ResourceNameType]
    def parentFolderId: Option[ResourceIdType]
    def resourceState: Option[zio.aws.workdocs.model.ResourceStateType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getFolderId: ZIO[Any, Nothing, ResourceIdType] = ZIO.succeed(folderId)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getParentFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentFolderId", parentFolderId)
    def getResourceState
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceStateType] =
      AwsError.unwrapOptionField("resourceState", resourceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest
  ) extends zio.aws.workdocs.model.UpdateFolderRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val folderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.folderId())
    override val name: Option[ResourceNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val parentFolderId: Option[ResourceIdType] = scala
      .Option(impl.parentFolderId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val resourceState
        : Option[zio.aws.workdocs.model.ResourceStateType] = scala
      .Option(impl.resourceState())
      .map(value => zio.aws.workdocs.model.ResourceStateType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest
  ): zio.aws.workdocs.model.UpdateFolderRequest.ReadOnly = new Wrapper(impl)
}
