package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait CommentStatusType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.CommentStatusType
}
object CommentStatusType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.CommentStatusType
  ): zio.aws.workdocs.model.CommentStatusType = value match {
    case software.amazon.awssdk.services.workdocs.model.CommentStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.CommentStatusType.DRAFT =>
      val r = DRAFT
      r
    case software.amazon.awssdk.services.workdocs.model.CommentStatusType.PUBLISHED =>
      val r = PUBLISHED
      r
    case software.amazon.awssdk.services.workdocs.model.CommentStatusType.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.CommentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.CommentStatusType =
      software.amazon.awssdk.services.workdocs.model.CommentStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object DRAFT extends zio.aws.workdocs.model.CommentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.CommentStatusType =
      software.amazon.awssdk.services.workdocs.model.CommentStatusType.DRAFT
  }
  case object PUBLISHED extends zio.aws.workdocs.model.CommentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.CommentStatusType =
      software.amazon.awssdk.services.workdocs.model.CommentStatusType.PUBLISHED
  }
  case object DELETED extends zio.aws.workdocs.model.CommentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.CommentStatusType =
      software.amazon.awssdk.services.workdocs.model.CommentStatusType.DELETED
  }
}
