package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workdocs.model.primitives.{SubscriptionEndPointType, IdType}
import scala.jdk.CollectionConverters._
final case class CreateNotificationSubscriptionRequest(
    organizationId: IdType,
    endpoint: SubscriptionEndPointType,
    protocol: zio.aws.workdocs.model.SubscriptionProtocolType,
    subscriptionType: zio.aws.workdocs.model.SubscriptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest = {
    import CreateNotificationSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest
      .builder()
      .organizationId(IdType.unwrap(organizationId): java.lang.String)
      .endpoint(SubscriptionEndPointType.unwrap(endpoint): java.lang.String)
      .protocol(protocol.unwrap)
      .subscriptionType(subscriptionType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.CreateNotificationSubscriptionRequest.ReadOnly =
    zio.aws.workdocs.model.CreateNotificationSubscriptionRequest
      .wrap(buildAwsValue())
}
object CreateNotificationSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.CreateNotificationSubscriptionRequest =
      zio.aws.workdocs.model.CreateNotificationSubscriptionRequest(
        organizationId,
        endpoint,
        protocol,
        subscriptionType
      )
    def organizationId: IdType
    def endpoint: SubscriptionEndPointType
    def protocol: zio.aws.workdocs.model.SubscriptionProtocolType
    def subscriptionType: zio.aws.workdocs.model.SubscriptionType
    def getOrganizationId: ZIO[Any, Nothing, IdType] =
      ZIO.succeed(organizationId)
    def getEndpoint: ZIO[Any, Nothing, SubscriptionEndPointType] =
      ZIO.succeed(endpoint)
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.workdocs.model.SubscriptionProtocolType] =
      ZIO.succeed(protocol)
    def getSubscriptionType
        : ZIO[Any, Nothing, zio.aws.workdocs.model.SubscriptionType] =
      ZIO.succeed(subscriptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest
  ) extends zio.aws.workdocs.model.CreateNotificationSubscriptionRequest.ReadOnly {
    override val organizationId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.organizationId())
    override val endpoint: SubscriptionEndPointType =
      zio.aws.workdocs.model.primitives
        .SubscriptionEndPointType(impl.endpoint())
    override val protocol: zio.aws.workdocs.model.SubscriptionProtocolType =
      zio.aws.workdocs.model.SubscriptionProtocolType.wrap(impl.protocol())
    override val subscriptionType: zio.aws.workdocs.model.SubscriptionType =
      zio.aws.workdocs.model.SubscriptionType.wrap(impl.subscriptionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest
  ): zio.aws.workdocs.model.CreateNotificationSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
