package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  IdType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType,
  ResourceIdType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeResourcePermissionsRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    resourceId: ResourceIdType,
    principalId: Optional[IdType] = Optional.Absent,
    limit: Optional[LimitType] = Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest = {
    import DescribeResourcePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .resourceId(ResourceIdType.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        principalId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeResourcePermissionsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeResourcePermissionsRequest
      .wrap(buildAwsValue())
}
object DescribeResourcePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeResourcePermissionsRequest =
      zio.aws.workdocs.model.DescribeResourcePermissionsRequest(
        authenticationToken.map(value => value),
        resourceId,
        principalId.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def resourceId: ResourceIdType
    def principalId: Optional[IdType]
    def limit: Optional[LimitType]
    def marker: Optional[PageMarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getResourceId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(resourceId)
    def getPrincipalId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest
  ) extends zio.aws.workdocs.model.DescribeResourcePermissionsRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val resourceId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.resourceId())
    override val principalId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest
  ): zio.aws.workdocs.model.DescribeResourcePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
