package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{PageMarkerType, SizeType}
import scala.jdk.CollectionConverters._
final case class DescribeUsersResponse(
    users: Optional[Iterable[zio.aws.workdocs.model.User]] = Optional.Absent,
    totalNumberOfUsers: Optional[SizeType] = Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse = {
    import DescribeUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        totalNumberOfUsers.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.totalNumberOfUsers)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeUsersResponse.wrap(buildAwsValue())
}
object DescribeUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeUsersResponse =
      zio.aws.workdocs.model.DescribeUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalNumberOfUsers.map(value => value),
        marker.map(value => value)
      )
    def users: Optional[List[zio.aws.workdocs.model.User.ReadOnly]]
    def totalNumberOfUsers: Optional[SizeType]
    def marker: Optional[PageMarkerType]
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.User.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getTotalNumberOfUsers: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("totalNumberOfUsers", totalNumberOfUsers)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse
  ) extends zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly {
    override val users: Optional[List[zio.aws.workdocs.model.User.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.User.wrap(item)
          }.toList
        )
    override val totalNumberOfUsers: Optional[SizeType] = zio.aws.core.internal
      .optionalFromNullable(impl.totalNumberOfUsers())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse
  ): zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly = new Wrapper(impl)
}
