package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait DocumentThumbnailType {
  def unwrap
      : software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType
}
object DocumentThumbnailType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType
  ): zio.aws.workdocs.model.DocumentThumbnailType = value match {
    case software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType.SMALL =>
      val r = SMALL
      r
    case software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType.SMALL_HQ =>
      val r = SMALL_HQ
      r
    case software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType.LARGE =>
      val r = LARGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.DocumentThumbnailType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType =
      software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType.UNKNOWN_TO_SDK_VERSION
  }
  case object SMALL extends zio.aws.workdocs.model.DocumentThumbnailType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType =
      software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType.SMALL
  }
  case object SMALL_HQ extends zio.aws.workdocs.model.DocumentThumbnailType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType =
      software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType.SMALL_HQ
  }
  case object LARGE extends zio.aws.workdocs.model.DocumentThumbnailType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType =
      software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType.LARGE
  }
}
