package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workdocs.model.primitives.AuthenticationHeaderType
import scala.jdk.CollectionConverters._
final case class GetCurrentUserRequest(
    authenticationToken: AuthenticationHeaderType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest = {
    import GetCurrentUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest
      .builder()
      .authenticationToken(
        AuthenticationHeaderType.unwrap(authenticationToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetCurrentUserRequest.ReadOnly =
    zio.aws.workdocs.model.GetCurrentUserRequest.wrap(buildAwsValue())
}
object GetCurrentUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetCurrentUserRequest =
      zio.aws.workdocs.model.GetCurrentUserRequest(authenticationToken)
    def authenticationToken: AuthenticationHeaderType
    def getAuthenticationToken: ZIO[Any, Nothing, AuthenticationHeaderType] =
      ZIO.succeed(authenticationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest
  ) extends zio.aws.workdocs.model.GetCurrentUserRequest.ReadOnly {
    override val authenticationToken: AuthenticationHeaderType =
      zio.aws.workdocs.model.primitives
        .AuthenticationHeaderType(impl.authenticationToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest
  ): zio.aws.workdocs.model.GetCurrentUserRequest.ReadOnly = new Wrapper(impl)
}
