package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  PageMarkerType,
  LimitType,
  IdType,
  AuthenticationHeaderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetResourcesRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    userId: Optional[IdType] = Optional.Absent,
    collectionType: Optional[zio.aws.workdocs.model.ResourceCollectionType] =
      Optional.Absent,
    limit: Optional[LimitType] = Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetResourcesRequest = {
    import GetResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetResourcesRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        userId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(collectionType.map(value => value.unwrap))(
        _.collectionType
      )
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetResourcesRequest.ReadOnly =
    zio.aws.workdocs.model.GetResourcesRequest.wrap(buildAwsValue())
}
object GetResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetResourcesRequest =
      zio.aws.workdocs.model.GetResourcesRequest(
        authenticationToken.map(value => value),
        userId.map(value => value),
        collectionType.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def userId: Optional[IdType]
    def collectionType: Optional[zio.aws.workdocs.model.ResourceCollectionType]
    def limit: Optional[LimitType]
    def marker: Optional[PageMarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getUserId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("userId", userId)
    def getCollectionType
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceCollectionType] =
      AwsError.unwrapOptionField("collectionType", collectionType)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetResourcesRequest
  ) extends zio.aws.workdocs.model.GetResourcesRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val userId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val collectionType
        : Optional[zio.aws.workdocs.model.ResourceCollectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionType())
        .map(value => zio.aws.workdocs.model.ResourceCollectionType.wrap(value))
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetResourcesRequest
  ): zio.aws.workdocs.model.GetResourcesRequest.ReadOnly = new Wrapper(impl)
}
