package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InitiateDocumentVersionUploadResponse(
    metadata: Optional[zio.aws.workdocs.model.DocumentMetadata] =
      Optional.Absent,
    uploadMetadata: Optional[zio.aws.workdocs.model.UploadMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse = {
    import InitiateDocumentVersionUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(uploadMetadata.map(value => value.buildAwsValue()))(
        _.uploadMetadata
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly =
    zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse
      .wrap(buildAwsValue())
}
object InitiateDocumentVersionUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse =
      zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse(
        metadata.map(value => value.asEditable),
        uploadMetadata.map(value => value.asEditable)
      )
    def metadata: Optional[zio.aws.workdocs.model.DocumentMetadata.ReadOnly]
    def uploadMetadata: Optional[zio.aws.workdocs.model.UploadMetadata.ReadOnly]
    def getMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getUploadMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.UploadMetadata.ReadOnly] =
      AwsError.unwrapOptionField("uploadMetadata", uploadMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse
  ) extends zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly {
    override val metadata
        : Optional[zio.aws.workdocs.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value => zio.aws.workdocs.model.DocumentMetadata.wrap(value))
    override val uploadMetadata
        : Optional[zio.aws.workdocs.model.UploadMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploadMetadata())
        .map(value => zio.aws.workdocs.model.UploadMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse
  ): zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly =
    new Wrapper(impl)
}
