package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Participants(
    users: Optional[Iterable[zio.aws.workdocs.model.UserMetadata]] =
      Optional.Absent,
    groups: Optional[Iterable[zio.aws.workdocs.model.GroupMetadata]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Participants = {
    import Participants.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Participants
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Participants.ReadOnly =
    zio.aws.workdocs.model.Participants.wrap(buildAwsValue())
}
object Participants {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.Participants
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Participants =
      zio.aws.workdocs.model.Participants(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def users: Optional[List[zio.aws.workdocs.model.UserMetadata.ReadOnly]]
    def groups: Optional[List[zio.aws.workdocs.model.GroupMetadata.ReadOnly]]
    def getUsers: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.UserMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("users", users)
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.GroupMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Participants
  ) extends zio.aws.workdocs.model.Participants.ReadOnly {
    override val users
        : Optional[List[zio.aws.workdocs.model.UserMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.UserMetadata.wrap(item)
          }.toList
        )
    override val groups
        : Optional[List[zio.aws.workdocs.model.GroupMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.GroupMetadata.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Participants
  ): zio.aws.workdocs.model.Participants.ReadOnly = new Wrapper(impl)
}
