package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.IdType
import scala.jdk.CollectionConverters._
final case class Principal(
    id: Optional[IdType] = Optional.Absent,
    `type`: Optional[zio.aws.workdocs.model.PrincipalType] = Optional.Absent,
    roles: Optional[Iterable[zio.aws.workdocs.model.PermissionInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Principal = {
    import Principal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Principal
      .builder()
      .optionallyWith(id.map(value => IdType.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roles)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Principal.ReadOnly =
    zio.aws.workdocs.model.Principal.wrap(buildAwsValue())
}
object Principal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.Principal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Principal =
      zio.aws.workdocs.model.Principal(
        id.map(value => value),
        `type`.map(value => value),
        roles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[IdType]
    def `type`: Optional[zio.aws.workdocs.model.PrincipalType]
    def roles: Optional[List[zio.aws.workdocs.model.PermissionInfo.ReadOnly]]
    def getId: ZIO[Any, AwsError, IdType] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.PrincipalType] =
      AwsError.unwrapOptionField("type", `type`)
    def getRoles: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.PermissionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("roles", roles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Principal
  ) extends zio.aws.workdocs.model.Principal.ReadOnly {
    override val id: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val `type`: Optional[zio.aws.workdocs.model.PrincipalType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.workdocs.model.PrincipalType.wrap(value))
    override val roles
        : Optional[List[zio.aws.workdocs.model.PermissionInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.PermissionInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Principal
  ): zio.aws.workdocs.model.Principal.ReadOnly = new Wrapper(impl)
}
