package zio.aws.workdocs.model
import scala.jdk.CollectionConverters._
sealed trait RolePermissionType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.RolePermissionType
}
object RolePermissionType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.RolePermissionType
  ): zio.aws.workdocs.model.RolePermissionType = value match {
    case software.amazon.awssdk.services.workdocs.model.RolePermissionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.RolePermissionType.DIRECT =>
      val r = DIRECT
      r
    case software.amazon.awssdk.services.workdocs.model.RolePermissionType.INHERITED =>
      val r = INHERITED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.RolePermissionType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.RolePermissionType =
      software.amazon.awssdk.services.workdocs.model.RolePermissionType.UNKNOWN_TO_SDK_VERSION
  }
  case object DIRECT extends zio.aws.workdocs.model.RolePermissionType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.RolePermissionType =
      software.amazon.awssdk.services.workdocs.model.RolePermissionType.DIRECT
  }
  case object INHERITED extends zio.aws.workdocs.model.RolePermissionType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.RolePermissionType =
      software.amazon.awssdk.services.workdocs.model.RolePermissionType.INHERITED
  }
}
