package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  ResourceNameType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters._
final case class UpdateFolderRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    folderId: ResourceIdType,
    name: Optional[ResourceNameType] = Optional.Absent,
    parentFolderId: Optional[ResourceIdType] = Optional.Absent,
    resourceState: Optional[zio.aws.workdocs.model.ResourceStateType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest = {
    import UpdateFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .folderId(ResourceIdType.unwrap(folderId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        parentFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.parentFolderId)
      .optionallyWith(resourceState.map(value => value.unwrap))(_.resourceState)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UpdateFolderRequest.ReadOnly =
    zio.aws.workdocs.model.UpdateFolderRequest.wrap(buildAwsValue())
}
object UpdateFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UpdateFolderRequest =
      zio.aws.workdocs.model.UpdateFolderRequest(
        authenticationToken.map(value => value),
        folderId,
        name.map(value => value),
        parentFolderId.map(value => value),
        resourceState.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def folderId: ResourceIdType
    def name: Optional[ResourceNameType]
    def parentFolderId: Optional[ResourceIdType]
    def resourceState: Optional[zio.aws.workdocs.model.ResourceStateType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getFolderId: ZIO[Any, Nothing, ResourceIdType] = ZIO.succeed(folderId)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getParentFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentFolderId", parentFolderId)
    def getResourceState
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceStateType] =
      AwsError.unwrapOptionField("resourceState", resourceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest
  ) extends zio.aws.workdocs.model.UpdateFolderRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val folderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.folderId())
    override val name: Optional[ResourceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val parentFolderId: Optional[ResourceIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentFolderId())
        .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val resourceState
        : Optional[zio.aws.workdocs.model.ResourceStateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceState())
        .map(value => zio.aws.workdocs.model.ResourceStateType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest
  ): zio.aws.workdocs.model.UpdateFolderRequest.ReadOnly = new Wrapper(impl)
}
