/*
 * Decompiled with CFR 0.152.
 */
package zio.cache;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.atomic.AtomicInteger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.Exit;
import zio.Exit$;
import zio.IsSubtypeOfOutput$;
import zio.Scope;
import zio.Scope$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.cache.CacheStats;
import zio.cache.EntryStats;
import zio.cache.MapKey;
import zio.cache.MapKey$;
import zio.cache.ScopedCache;
import zio.cache.ScopedCache$CacheState$;
import zio.cache.ScopedLookup;
import zio.package;

public final class ScopedCache$ {
    public static final ScopedCache$ MODULE$ = new ScopedCache$();

    public <Key, Environment, Error, Value> ZIO<Environment, Nothing$, ScopedCache<Key, Error, Value>> make(int capacity, Duration timeToLive, ScopedLookup<Key, Environment, Error, Value> lookup) {
        return this.makeWith(capacity, lookup, (Function1 & Serializable)x$1 -> timeToLive);
    }

    public <Key, Environment, Error, Value> ZIO<Environment, Nothing$, ScopedCache<Key, Error, Value>> makeWith(int capacity, ScopedLookup<Key, Environment, Error, Value> scopedLookup, Function1<Exit<Error, Value>, Duration> timeToLive) {
        return this.makeWith(capacity, scopedLookup, Clock.systemUTC(), timeToLive);
    }

    public <Key, Environment, Error, Value> ZIO<Environment, Nothing$, ScopedCache<Key, Error, Value>> makeWith(int capacity, ScopedLookup<Key, Environment, Error, Value> scopedLookup, Clock clock, Function1<Exit<Error, Value>, Duration> timeToLive) {
        return ZIO$.MODULE$.acquireRelease((Function0 & Serializable)() -> MODULE$.buildWith(capacity, scopedLookup, clock, timeToLive), (Function1 & Serializable)x$2 -> x$2.invalidateAll(), (Object)"zio.cache.ScopedCache.makeWith(ScopedCache.scala:95)");
    }

    private <Key, Environment, Error, Value> ZIO<Environment, Nothing$, ScopedCache<Key, Error, Value>> buildWith(int capacity, ScopedLookup<Key, Environment, Error, Value> scopedLookup, Clock clock, Function1<Exit<Error, Value>, Duration> timeToLive) {
        return ZIO$.MODULE$.environment((Object)"zio.cache.ScopedCache.buildWith(ScopedCache.scala:102)").map((Function1 & Serializable)environment -> {
            ScopedCache.CacheState cacheState = ScopedCache$CacheState$.MODULE$.initial();
            return new ScopedCache<Key, Error, Value>(cacheState, scopedLookup, (ZEnvironment)environment, clock, timeToLive, capacity){
                private final ScopedCache.CacheState cacheState$1;
                private final ScopedLookup scopedLookup$2;
                private final ZEnvironment environment$1;
                private final Clock clock$2;
                private final Function1 timeToLive$3;
                private final int capacity$2;

                private ZIO<Object, Nothing$, BoxedUnit> ensureMapSizeNotExceeded(MapKey<Key> key) {
                    return ZIO$.MODULE$.foreachParDiscard((Function0 & Serializable)() -> Predef$.MODULE$.wrapRefArray((Object[])ScopedCache$.zio$cache$ScopedCache$$trackAccess$1(key, $this.cacheState$1, $this.capacity$2)), (Function1 & Serializable)cleanedMapValue -> this.cleanMapValue((ScopedCache.MapValue<Key, Error, Value>)cleanedMapValue), (Object)"zio.cache.ScopedCache.buildWith.$anon.ensureMapSizeNotExceeded(ScopedCache.scala:147)");
                }

                public ZIO<Object, Nothing$, CacheStats> cacheStats() {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> new CacheStats($this.cacheState$1.hits().longValue(), $this.cacheState$1.misses().longValue(), $this.cacheState$1.map().size()), (Object)"zio.cache.ScopedCache.buildWith.$anon.cacheStats(ScopedCache.scala:152)");
                }

                public ZIO<Object, Nothing$, Object> contains(Key k) {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.cacheState$1.map().containsKey(k), (Object)"zio.cache.ScopedCache.buildWith.$anon.contains(ScopedCache.scala:155)");
                }

                public ZIO<Object, Nothing$, Option<EntryStats>> entryStats(Key k) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                        ScopedCache.MapValue.Complete<Key, Error, Value> complete;
                        None$ none$;
                        ScopedCache.MapValue<Key, Error, Value> value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            return None$.MODULE$;
                        }
                        if (value instanceof ScopedCache.MapValue.Pending) {
                            none$ = None$.MODULE$;
                        } else if (value instanceof ScopedCache.MapValue.Complete) {
                            EntryStats entryState = ((ScopedCache.MapValue.Complete)value).entryStats();
                            none$ = Option$.MODULE$.apply((Object)new EntryStats(entryState.loaded()));
                        } else if (value instanceof ScopedCache.MapValue.Refreshing && (complete = ((ScopedCache.MapValue.Refreshing)value).complete()) != null) {
                            EntryStats entryState = complete.entryStats();
                            none$ = Option$.MODULE$.apply((Object)new EntryStats(entryState.loaded()));
                        } else {
                            throw new MatchError(value);
                        }
                        return none$;
                    }, (Object)"zio.cache.ScopedCache.buildWith.$anon.entryStats(ScopedCache.scala:158)");
                }

                public ZIO<Scope, Error, Value> get(Key k) {
                    return this.lookupValueOf(k).memoize((Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:174)").flatMap((Function1 & Serializable)lookupValue -> ZIO$.MODULE$.suspendSucceed((Function0 & Serializable)() -> {
                        MapKey<Object> key = null;
                        ScopedCache.MapValue value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            key = new MapKey<Object>(k, null, null);
                            value = $this.cacheState$1.map().putIfAbsent(k, new ScopedCache.MapValue.Pending<Object, Error, Value>(key, lookupValue));
                        }
                        if (value == null) {
                            ScopedCache$.zio$cache$ScopedCache$$trackMiss$1($this.cacheState$1);
                            return this.ensureMapSizeNotExceeded(key).$times$greater((Function0 & Serializable)() -> lookupValue, (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:184)");
                        }
                        if (value instanceof ScopedCache.MapValue.Pending) {
                            ScopedCache.MapValue.Pending pending = (ScopedCache.MapValue.Pending)value;
                            MapKey<Key> key2 = pending.key();
                            ZIO<Object, Nothing$, ZIO<Scope, Error, Value>> scoped = pending.scoped();
                            ScopedCache$.zio$cache$ScopedCache$$trackHit$1($this.cacheState$1);
                            return this.ensureMapSizeNotExceeded(key2).$times$greater((Function0 & Serializable)() -> scoped, (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:189)");
                        }
                        if (value instanceof ScopedCache.MapValue.Complete) {
                            ZIO zIO;
                            ScopedCache.MapValue.Complete complete = (ScopedCache.MapValue.Complete)value;
                            MapKey<Key> key3 = complete.key();
                            Instant timeToLive = complete.timeToLive();
                            ScopedCache$.zio$cache$ScopedCache$$trackHit$1($this.cacheState$1);
                            if (this.hasExpired(timeToLive)) {
                                $this.cacheState$1.map().remove(k, value);
                                zIO = this.ensureMapSizeNotExceeded(key3).$times$greater((Function0 & Serializable)() -> complete.releaseOwner(), (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:194)").$times$greater((Function0 & Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.get(k), (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:194)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:194)");
                                return zIO;
                            } else {
                                zIO = this.ensureMapSizeNotExceeded(key3).as((Function0 & Serializable)() -> complete.toScoped(), (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:196)");
                            }
                            return zIO;
                        }
                        if (!(value instanceof ScopedCache.MapValue.Refreshing)) throw new MatchError(value);
                        ScopedCache.MapValue.Refreshing refreshing = (ScopedCache.MapValue.Refreshing)value;
                        ZIO<Object, Nothing$, ZIO<Scope, Error, Value>> promiseInProgress = refreshing.scopedEffect();
                        ScopedCache.MapValue.Complete<Key, Error, Value> complete = refreshing.complete();
                        if (complete == null) throw new MatchError(value);
                        MapKey<Key> mapKey = complete.key();
                        Instant ttl = complete.timeToLive();
                        ScopedCache$.zio$cache$ScopedCache$$trackHit$1($this.cacheState$1);
                        return this.hasExpired(ttl) ? this.ensureMapSizeNotExceeded(mapKey).$times$greater((Function0 & Serializable)() -> promiseInProgress, (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:201)") : this.ensureMapSizeNotExceeded(mapKey).as((Function0 & Serializable)() -> complete.toScoped(), (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:203)");
                    }, (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:175)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:174)").flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.cache.ScopedCache.buildWith.$anon.get(ScopedCache.scala:208)");
                }

                public ZIO<Object, Error, BoxedUnit> refresh(Key k) {
                    return this.lookupValueOf(k).memoize((Object)"zio.cache.ScopedCache.buildWith.$anon.refresh(ScopedCache.scala:210)").flatMap((Function1 & Serializable)scoped -> {
                        ZIO zIO;
                        ScopedCache.MapValue value = $this.cacheState$1.map().get(k);
                        MapKey<Object> newKey = null;
                        if (value == null) {
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            newKey = new MapKey<Object>(k, null, null);
                            value = $this.cacheState$1.map().putIfAbsent(k, new ScopedCache.MapValue.Pending<Object, Error, Value>(newKey, scoped));
                        }
                        if (value == null) {
                            zIO = this.ensureMapSizeNotExceeded(newKey).$times$greater((Function0 & Serializable)() -> scoped, (Object)"zio.cache.ScopedCache.buildWith.$anon.refresh.finalScoped(ScopedCache.scala:218)");
                        } else {
                            ZIO zIO2;
                            if (value instanceof ScopedCache.MapValue.Pending) {
                                zIO2 = ((ScopedCache.MapValue.Pending)value).scoped();
                            } else if (value instanceof ScopedCache.MapValue.Complete) {
                                ScopedCache.MapValue.Complete complete = (ScopedCache.MapValue.Complete)value;
                                Instant ttl = complete.timeToLive();
                                zIO2 = this.hasExpired(ttl) ? ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.get(k), (Object)"zio.cache.ScopedCache.buildWith.$anon.refresh.finalScoped(ScopedCache.scala:225)") : ($this.cacheState$1.map().replace(k, complete, new ScopedCache.MapValue.Refreshing<Key, Error, Value>(scoped, complete)) ? scoped : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.get(k), (Object)"zio.cache.ScopedCache.buildWith.$anon.refresh.finalScoped(ScopedCache.scala:230)"));
                            } else if (value instanceof ScopedCache.MapValue.Refreshing) {
                                zIO2 = ((ScopedCache.MapValue.Refreshing)value).scopedEffect();
                            } else {
                                throw new MatchError(value);
                            }
                            zIO = zIO2;
                        }
                        return zIO.flatMap((Function1 & Serializable)s -> ZIO.ScopedPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.scoped(), (Function0 & Serializable)() -> s.unit((Object)"zio.cache.ScopedCache.buildWith.$anon.refresh(ScopedCache.scala:236)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.refresh(ScopedCache.scala:236)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.refresh(ScopedCache.scala:236)");
                    }, (Object)"zio.cache.ScopedCache.buildWith.$anon.refresh(ScopedCache.scala:210)");
                }

                public ZIO<Object, Nothing$, BoxedUnit> invalidate(Key k) {
                    return ZIO$.MODULE$.suspendSucceed((Function0 & Serializable)() -> {
                        ScopedCache.MapValue<Key, Error, Value> mapValue = $this.cacheState$1.map().remove(k);
                        ZIO<Object, Nothing$, BoxedUnit> zIO = mapValue instanceof ScopedCache.MapValue.Complete ? ((ScopedCache.MapValue.Complete)mapValue).releaseOwner() : (mapValue instanceof ScopedCache.MapValue.Refreshing ? ((ScopedCache.MapValue.Refreshing)mapValue).complete().releaseOwner() : ZIO$.MODULE$.unit());
                        return zIO;
                    }, (Object)"zio.cache.ScopedCache.buildWith.$anon.invalidate(ScopedCache.scala:239)");
                }

                public ZIO<Object, Nothing$, BoxedUnit> invalidateAll() {
                    return ZIO$.MODULE$.foreachParDiscard((Function0 & Serializable)() -> CollectionConverters$.MODULE$.SetHasAsScala($this.cacheState$1.map().keySet()).asScala(), (Function1 & Serializable)k -> this.invalidate(k), (Object)"zio.cache.ScopedCache.buildWith.$anon.invalidateAll(ScopedCache.scala:248)");
                }

                public ZIO<Object, Nothing$, Object> size() {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.cacheState$1.map().size(), (Object)"zio.cache.ScopedCache.buildWith.$anon.size(ScopedCache.scala:251)");
                }

                private ZIO<Object, Nothing$, BoxedUnit> cleanMapValue(ScopedCache.MapValue<Key, Error, Value> mapValue) {
                    ZIO<Object, Nothing$, BoxedUnit> zIO = mapValue instanceof ScopedCache.MapValue.Complete ? ((ScopedCache.MapValue.Complete)mapValue).releaseOwner() : (mapValue instanceof ScopedCache.MapValue.Refreshing ? ((ScopedCache.MapValue.Refreshing)mapValue).complete().releaseOwner() : ZIO$.MODULE$.unit());
                    return zIO;
                }

                private ZIO<Object, Nothing$, ZIO<Scope, Error, Value>> lookupValueOf(Key key) {
                    return Scope$.MODULE$.make((Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:262)").flatMap((Function1 & Serializable)scope -> $this.scopedLookup$2.apply(key).provideEnvironment((Function0 & Serializable)() -> $this.environment$1.add(scope, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Scope.class, LightTypeTag$.MODULE$.parse(1294249275, "\u0004\u0000\u0001\tzio.Scope\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\tzio.Scope\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 21)))), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:264)").exit((Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:265)").map((Function1 & Serializable)exit -> new Tuple2(exit, (Function1 & Serializable)x$3 -> scope.close(x$3, (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:266)")), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:263)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:262)").onInterrupt((Function0 & Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> $this.cacheState$1.map().remove(key), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:267)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:267)").flatMap((Function1 & Serializable)x0$1 -> {
                        if (x0$1 == null) throw new MatchError(null);
                        Exit exit = (Exit)x0$1._1();
                        Function1 release = (Function1)x0$1._2();
                        Instant now = Instant.now($this.clock$2);
                        Instant expiredAt = now.plus((TemporalAmount)$this.timeToLive$3.apply((Object)exit));
                        if (exit instanceof Exit.Success) {
                            Object value = ((Exit.Success)exit).value();
                            Exit exitWithReleaser = Exit$.MODULE$.succeed((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(value), (Object)release));
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            ScopedCache.MapValue.Complete<Object, Error, Value> completedResult = new ScopedCache.MapValue.Complete<Object, Error, Value>(new MapKey<Object>(key, null, null), exitWithReleaser, new AtomicInteger(1), new EntryStats(now), expiredAt);
                            ScopedCache.MapValue previousValue = $this.cacheState$1.map().put(key, completedResult);
                            return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.cleanMapValue(previousValue).as((Function0 & Serializable)() -> completedResult.toScoped(), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:285)").flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:285)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:284)");
                        }
                        if (!(exit instanceof Exit.Failure)) throw new MatchError((Object)exit);
                        Exit.Failure failure = (Exit.Failure)exit;
                        MapKey$.MODULE$.$lessinit$greater$default$2();
                        MapKey$.MODULE$.$lessinit$greater$default$3();
                        ScopedCache.MapValue.Complete<Object, Error, Value> completedResult = new ScopedCache.MapValue.Complete<Object, Error, Value>(new MapKey<Object>(key, null, null), failure, new AtomicInteger(0), new EntryStats(now), expiredAt);
                        ScopedCache.MapValue previousValue = $this.cacheState$1.map().put(key, completedResult);
                        return ((ZIO)release.apply((Function0 & Serializable)() -> failure)).$times$greater((Function0 & Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.cleanMapValue(previousValue).as((Function0 & Serializable)() -> completedResult.toScoped(), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:298)").flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:298)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:297)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:297)");
                    }, (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:268)").memoize((Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:302)").map((Function1 & Serializable)scopedEffect -> scopedEffect.flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:303)"), (Object)"zio.cache.ScopedCache.buildWith.$anon.lookupValueOf(ScopedCache.scala:261)");
                }

                private boolean hasExpired(Instant timeToLive) {
                    return Instant.now(this.clock$2).isAfter(timeToLive);
                }
                {
                    this.cacheState$1 = cacheState$1;
                    this.scopedLookup$2 = scopedLookup$2;
                    this.environment$1 = environment$1;
                    this.clock$2 = clock$2;
                    this.timeToLive$3 = timeToLive$3;
                    this.capacity$2 = capacity$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheStats$1(zio.cache.ScopedCache$$anon$1 ), $anonfun$contains$1(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$ensureMapSizeNotExceeded$1(zio.cache.ScopedCache$$anon$1 zio.cache.MapKey ), $anonfun$ensureMapSizeNotExceeded$2(zio.cache.ScopedCache$$anon$1 zio.cache.ScopedCache$MapValue ), $anonfun$entryStats$1(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$get$1(zio.cache.ScopedCache$$anon$1 java.lang.Object zio.ZIO ), $anonfun$get$10(zio.cache.ScopedCache$MapValue$Complete ), $anonfun$get$2(zio.cache.ScopedCache$$anon$1 java.lang.Object zio.ZIO ), $anonfun$get$3(zio.ZIO ), $anonfun$get$4(zio.ZIO ), $anonfun$get$5(zio.cache.ScopedCache$MapValue$Complete ), $anonfun$get$6(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$get$7(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$get$8(zio.cache.ScopedCache$MapValue$Complete ), $anonfun$get$9(zio.ZIO ), $anonfun$invalidate$1(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$invalidateAll$1(zio.cache.ScopedCache$$anon$1 ), $anonfun$invalidateAll$2(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$lookupValueOf$1(zio.cache.ScopedCache$$anon$1 java.lang.Object zio.Scope$Closeable ), $anonfun$lookupValueOf$10(zio.Exit$Failure ), $anonfun$lookupValueOf$11(zio.cache.ScopedCache$$anon$1 zio.cache.ScopedCache$MapValue zio.cache.ScopedCache$MapValue$Complete ), $anonfun$lookupValueOf$12(zio.cache.ScopedCache$$anon$1 zio.cache.ScopedCache$MapValue zio.cache.ScopedCache$MapValue$Complete ), $anonfun$lookupValueOf$13(zio.cache.ScopedCache$MapValue$Complete ), $anonfun$lookupValueOf$14(zio.ZIO ), $anonfun$lookupValueOf$2(zio.cache.ScopedCache$$anon$1 zio.Scope$Closeable ), $anonfun$lookupValueOf$3(zio.Scope$Closeable zio.Exit ), $anonfun$lookupValueOf$4(zio.Scope$Closeable scala.Function0 ), $anonfun$lookupValueOf$5(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$lookupValueOf$6(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$lookupValueOf$7(zio.cache.ScopedCache$$anon$1 java.lang.Object scala.Tuple2 ), $anonfun$lookupValueOf$8(zio.cache.ScopedCache$$anon$1 zio.cache.ScopedCache$MapValue zio.cache.ScopedCache$MapValue$Complete ), $anonfun$lookupValueOf$9(zio.cache.ScopedCache$MapValue$Complete ), $anonfun$refresh$1(zio.cache.ScopedCache$$anon$1 java.lang.Object zio.ZIO ), $anonfun$refresh$2(zio.ZIO ), $anonfun$refresh$3(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$refresh$4(zio.cache.ScopedCache$$anon$1 java.lang.Object ), $anonfun$refresh$5(zio.ZIO ), $anonfun$refresh$6(zio.ZIO ), $anonfun$size$1(zio.cache.ScopedCache$$anon$1 )}, serializedLambda);
                }
            };
        }, (Object)"zio.cache.ScopedCache.buildWith(ScopedCache.scala:102)");
    }

    public static final ScopedCache.MapValue[] zio$cache$ScopedCache$$trackAccess$1(MapKey key, ScopedCache.CacheState cacheState$1, int capacity$2) {
        ArrayBuilder cleanedKey = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScopedCache.MapValue.class));
        cacheState$1.accesses().offer((Object)key);
        if (cacheState$1.updating().compareAndSet(false, true)) {
            boolean loop = true;
            while (loop) {
                MapKey key2 = (MapKey)cacheState$1.accesses().poll(null);
                if (key2 != null) {
                    cacheState$1.keys().add(key2);
                    continue;
                }
                loop = false;
            }
            int size = cacheState$1.map().size();
            boolean bl = loop = size > capacity$2;
            while (loop) {
                MapKey key3 = cacheState$1.keys().remove();
                if (key3 != null) {
                    ScopedCache.MapValue removed = cacheState$1.map().remove(key3.value());
                    if (removed == null) continue;
                    cleanedKey.$plus$eq(removed);
                    loop = --size > capacity$2;
                    continue;
                }
                loop = false;
            }
            cacheState$1.updating().set(false);
        }
        return (ScopedCache.MapValue[])cleanedKey.result();
    }

    public static final void zio$cache$ScopedCache$$trackHit$1(ScopedCache.CacheState cacheState$1) {
        cacheState$1.hits().increment();
    }

    public static final void zio$cache$ScopedCache$$trackMiss$1(ScopedCache.CacheState cacheState$1) {
        cacheState$1.misses().increment();
    }

    private ScopedCache$() {
    }
}

