/*
 * Decompiled with CFR 0.152.
 */
package zio.cache;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.Clock;
import zio.Exit;
import zio.FiberId;
import zio.Promise;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.cache.Cache;
import zio.cache.Cache$CacheState$;
import zio.cache.CacheStats;
import zio.cache.EntryStats;
import zio.cache.Lookup;
import zio.cache.MapKey;
import zio.cache.MapKey$;

public final class Cache$ {
    public static final Cache$ MODULE$ = new Cache$();

    public <Key, Environment, Error, Value> ZIO<Environment, Nothing$, Cache<Key, Error, Value>> make(int capacity, Duration timeToLive, Lookup<Key, Environment, Error, Value> lookup, Object trace) {
        return this.makeWith(capacity, lookup, (Function1 & Serializable)x$1 -> timeToLive, trace);
    }

    public <Key, Environment, Error, Value> ZIO<Environment, Nothing$, Cache<Key, Error, Value>> makeWith(int capacity, Lookup<Key, Environment, Error, Value> lookup, Function1<Exit<Error, Value>, Duration> timeToLive, Object trace) {
        return this.makeWithKey(capacity, lookup, timeToLive, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x), trace);
    }

    public <In, Key, Environment, Error, Value> ZIO<Environment, Nothing$, Cache<In, Error, Value>> makeWithKey(int capacity, Lookup<In, Environment, Error, Value> lookup, Function1<Exit<Error, Value>, Duration> timeToLive, Function1<In, Key> keyBy, Object trace) {
        return ZIO$.MODULE$.clock(trace).flatMap((Function1 & Serializable)clock -> ZIO$.MODULE$.environment(trace).flatMap((Function1 & Serializable)environment -> ZIO$.MODULE$.fiberId(trace).map((Function1 & Serializable)fiberId -> {
            Cache.CacheState cacheState = Cache$CacheState$.MODULE$.initial();
            return new Cache<In, Error, Value>(cacheState, keyBy, trace, lookup, (ZEnvironment)environment, (Clock)clock, timeToLive, (FiberId.Runtime)fiberId, capacity){
                private final Cache.CacheState cacheState$1;
                private final Function1 keyBy$1;
                private final Object trace$1;
                private final Lookup lookup$1;
                private final ZEnvironment environment$1;
                private final Clock clock$1;
                private final Function1 timeToLive$2;
                private final FiberId.Runtime fiberId$1;
                private final int capacity$1;

                public ZIO<Object, Nothing$, CacheStats> cacheStats(Object trace) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> new CacheStats($this.cacheState$1.hits().longValue(), $this.cacheState$1.misses().longValue(), $this.cacheState$1.map().size()), trace);
                }

                public ZIO<Object, Nothing$, Object> contains(In in, Object trace) {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.cacheState$1.map().containsKey($this.keyBy$1.apply(in)), trace);
                }

                public ZIO<Object, Nothing$, Option<EntryStats>> entryStats(In in, Object trace) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                        Cache.MapValue.Complete<Key, Error, Value> complete;
                        Cache.MapValue<Key, Error, Value> value = $this.cacheState$1.map().get($this.keyBy$1.apply(in));
                        if (value == null) {
                            return None$.MODULE$;
                        }
                        if (value instanceof Cache.MapValue.Pending) {
                            return None$.MODULE$;
                        }
                        if (value instanceof Cache.MapValue.Complete) {
                            EntryStats entryState = ((Cache.MapValue.Complete)value).entryStats();
                            return Option$.MODULE$.apply((Object)new EntryStats(entryState.loaded()));
                        }
                        if (value instanceof Cache.MapValue.Refreshing && (complete = ((Cache.MapValue.Refreshing)value).complete()) != null) {
                            EntryStats entryState = complete.entryStats();
                            return Option$.MODULE$.apply((Object)new EntryStats(entryState.loaded()));
                        }
                        throw new MatchError(value);
                    }, trace);
                }

                public ZIO<Object, Error, Value> get(In in, Object trace) {
                    return ZIO$.MODULE$.suspendSucceedUnsafe((Function1 & Serializable)u -> {
                        Object k = $this.keyBy$1.apply(in);
                        MapKey<Object> key = null;
                        Promise<Error, Value> promise = null;
                        Cache.MapValue value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            promise = this.newPromise((Unsafe)u);
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            key = new MapKey<Object>(k, null, null);
                            value = $this.cacheState$1.map().putIfAbsent(k, new Cache.MapValue.Pending<Object, Error, Value>(key, promise));
                        }
                        if (value == null) {
                            Cache$.zio$cache$Cache$$trackAccess$1(key, $this.cacheState$1, $this.capacity$1);
                            Cache$.zio$cache$Cache$$trackMiss$1($this.cacheState$1);
                            return this.lookupValueOf(in, promise);
                        }
                        if (value instanceof Cache.MapValue.Pending) {
                            Cache.MapValue.Pending pending = (Cache.MapValue.Pending)value;
                            MapKey<Key> key2 = pending.key();
                            Promise<Error, Value> promise2 = pending.promise();
                            Cache$.zio$cache$Cache$$trackAccess$1(key2, $this.cacheState$1, $this.capacity$1);
                            Cache$.zio$cache$Cache$$trackHit$1($this.cacheState$1);
                            return promise2.await(trace);
                        }
                        if (value instanceof Cache.MapValue.Complete) {
                            Cache.MapValue.Complete complete = (Cache.MapValue.Complete)value;
                            MapKey<Key> key3 = complete.key();
                            Exit<Error, Value> exit = complete.exit();
                            Instant timeToLive = complete.timeToLive();
                            Cache$.zio$cache$Cache$$trackAccess$1(key3, $this.cacheState$1, $this.capacity$1);
                            Cache$.zio$cache$Cache$$trackHit$1($this.cacheState$1);
                            if (this.hasExpired(timeToLive, (Unsafe)u)) {
                                $this.cacheState$1.map().remove(k, value);
                                return this.get(in, trace);
                            }
                            return ZIO$.MODULE$.done((Function0 & Serializable)() -> exit, trace);
                        }
                        if (value instanceof Cache.MapValue.Refreshing) {
                            Cache.MapValue.Refreshing refreshing = (Cache.MapValue.Refreshing)value;
                            Promise<Error, Value> promiseInProgress = refreshing.promise();
                            Cache.MapValue.Complete<Key, Error, Value> complete = refreshing.complete();
                            if (complete != null) {
                                MapKey<Key> mapKey = complete.key();
                                Exit<Error, Value> currentResult = complete.exit();
                                Instant ttl = complete.timeToLive();
                                Cache$.zio$cache$Cache$$trackAccess$1(mapKey, $this.cacheState$1, $this.capacity$1);
                                Cache$.zio$cache$Cache$$trackHit$1($this.cacheState$1);
                                if (this.hasExpired(ttl, (Unsafe)u)) {
                                    return promiseInProgress.await(trace);
                                }
                                return ZIO$.MODULE$.done((Function0 & Serializable)() -> currentResult, trace);
                            }
                        }
                        throw new MatchError(value);
                    }, trace);
                }

                public ZIO<Object, Error, BoxedUnit> refresh(In in) {
                    return ZIO$.MODULE$.suspendSucceedUnsafe((Function1 & Serializable)u -> {
                        ZIO zIO;
                        Object k = $this.keyBy$1.apply(in);
                        Promise<Error, Value> promise = this.newPromise((Unsafe)u);
                        Cache.MapValue value = $this.cacheState$1.map().get(k);
                        if (value == null) {
                            Map<Key, Cache.MapValue<Key, Error, Value>> map = $this.cacheState$1.map();
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            value = map.putIfAbsent(k, new Cache.MapValue.Pending<Object, Error, Value>(new MapKey<Object>(k, null, null), promise));
                        }
                        if (value == null) {
                            zIO = this.lookupValueOf(in, promise);
                        } else if (value instanceof Cache.MapValue.Pending) {
                            zIO = ((Cache.MapValue.Pending)value).promise().await($this.trace$1);
                        } else if (value instanceof Cache.MapValue.Complete) {
                            Cache.MapValue.Complete complete = (Cache.MapValue.Complete)value;
                            Instant ttl = complete.timeToLive();
                            if (this.hasExpired(ttl, (Unsafe)u)) {
                                $this.cacheState$1.map().remove(k, value);
                                zIO = this.get(in, $this.trace$1);
                            } else {
                                zIO = this.lookupValueOf(in, promise).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.cacheState$1.map().replace(k, complete, new Cache.MapValue.Refreshing<Key, Error, Value>(promise, complete)), $this.trace$1);
                            }
                        } else if (value instanceof Cache.MapValue.Refreshing) {
                            zIO = ((Cache.MapValue.Refreshing)value).promise().await($this.trace$1);
                        } else {
                            throw new MatchError(value);
                        }
                        return zIO.unit($this.trace$1);
                    }, this.trace$1);
                }

                public ZIO<Object, Nothing$, BoxedUnit> invalidate(In in, Object trace) {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.cacheState$1.map().remove($this.keyBy$1.apply(in)), trace);
                }

                public ZIO<Object, Nothing$, BoxedUnit> invalidateAll() {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.cacheState$1.map().clear(), this.trace$1);
                }

                public ZIO<Object, Nothing$, Object> size(Object trace) {
                    return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.cacheState$1.map().size(), trace);
                }

                private ZIO<Object, Error, Value> lookupValueOf(In in, Promise<Error, Value> promise) {
                    return ZIO$.MODULE$.suspendSucceed((Function0 & Serializable)() -> {
                        Object key = $this.keyBy$1.apply(in);
                        return $this.lookup$1.apply(in).provideEnvironment((Function0 & Serializable)() -> $this.environment$1, $this.trace$1).exit($this.trace$1).flatMap((Function1 & Serializable)exit -> {
                            Instant now = (Instant)Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> $this.clock$1.unsafe().instant(u));
                            EntryStats entryStats = new EntryStats(now);
                            Map<Key, Cache.MapValue<Key, Error, Value>> map = $this.cacheState$1.map();
                            MapKey$.MODULE$.$lessinit$greater$default$2();
                            MapKey$.MODULE$.$lessinit$greater$default$3();
                            map.put(key, new Cache.MapValue.Complete<Object, Error, Value>(new MapKey<Object>(key, null, null), exit, entryStats, now.plus((TemporalAmount)$this.timeToLive$2.apply(exit))));
                            return promise.done(exit, $this.trace$1).$times$greater((Function0 & Serializable)() -> ZIO$.MODULE$.done((Function0 & Serializable)() -> exit, $this.trace$1), $this.trace$1);
                        }, $this.trace$1).onInterrupt((Function0 & Serializable)() -> promise.interrupt($this.trace$1).$times$greater((Function0 & Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> $this.cacheState$1.map().remove(key), $this.trace$1), $this.trace$1), $this.trace$1);
                    }, this.trace$1);
                }

                private Promise<Error, Value> newPromise(Unsafe unsafe) {
                    return Promise.unsafe$.MODULE$.make((FiberId)this.fiberId$1, unsafe);
                }

                private boolean hasExpired(Instant timeToLive, Unsafe unsafe) {
                    return this.clock$1.unsafe().instant(unsafe).isAfter(timeToLive);
                }
                {
                    this.cacheState$1 = cacheState$1;
                    this.keyBy$1 = keyBy$1;
                    this.trace$1 = trace$1;
                    this.lookup$1 = lookup$1;
                    this.environment$1 = environment$1;
                    this.clock$1 = clock$1;
                    this.timeToLive$2 = timeToLive$2;
                    this.fiberId$1 = fiberId$1;
                    this.capacity$1 = capacity$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheStats$1(zio.cache.Cache$$anon$1 ), $anonfun$contains$1(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$entryStats$1(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$get$1(zio.cache.Cache$$anon$1 java.lang.Object java.lang.Object zio.Unsafe ), $anonfun$get$2(zio.Exit ), $anonfun$get$3(zio.Exit ), $anonfun$invalidate$1(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$invalidateAll$1(zio.cache.Cache$$anon$1 ), $anonfun$lookupValueOf$1(zio.cache.Cache$$anon$1 java.lang.Object zio.Promise ), $anonfun$lookupValueOf$2(zio.cache.Cache$$anon$1 ), $anonfun$lookupValueOf$3(zio.cache.Cache$$anon$1 java.lang.Object zio.Promise zio.Exit ), $anonfun$lookupValueOf$4(zio.cache.Cache$$anon$1 zio.Unsafe ), $anonfun$lookupValueOf$5(zio.cache.Cache$$anon$1 zio.Exit ), $anonfun$lookupValueOf$6(zio.Exit ), $anonfun$lookupValueOf$7(zio.cache.Cache$$anon$1 zio.Promise java.lang.Object ), $anonfun$lookupValueOf$8(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$lookupValueOf$9(zio.cache.Cache$$anon$1 java.lang.Object ), $anonfun$refresh$1(zio.cache.Cache$$anon$1 java.lang.Object zio.Unsafe ), $anonfun$refresh$2(zio.cache.Cache$$anon$1 java.lang.Object zio.cache.Cache$MapValue$Complete zio.Promise ), $anonfun$size$1(zio.cache.Cache$$anon$1 )}, serializedLambda);
                }
            };
        }, trace), trace), trace);
    }

    public static final void zio$cache$Cache$$trackAccess$1(MapKey key, Cache.CacheState cacheState$1, int capacity$1) {
        cacheState$1.accesses().offer((Object)key);
        if (cacheState$1.updating().compareAndSet(false, true)) {
            boolean loop = true;
            while (loop) {
                MapKey key2 = (MapKey)cacheState$1.accesses().poll(null);
                if (key2 != null) {
                    cacheState$1.keys().add(key2);
                    continue;
                }
                loop = false;
            }
            int size = cacheState$1.map().size();
            boolean bl = loop = size > capacity$1;
            while (loop) {
                MapKey key3 = cacheState$1.keys().remove();
                if (key3 != null) {
                    if (cacheState$1.map().remove(key3.value()) == null) continue;
                    loop = --size > capacity$1;
                    continue;
                }
                loop = false;
            }
            cacheState$1.updating().set(false);
            return;
        }
    }

    public static final void zio$cache$Cache$$trackHit$1(Cache.CacheState cacheState$1) {
        cacheState$1.hits().increment();
    }

    public static final void zio$cache$Cache$$trackMiss$1(Cache.CacheState cacheState$1) {
        cacheState$1.misses().increment();
    }

    private Cache$() {
    }
}

