/*
 * Decompiled with CFR 0.152.
 */
package zio.cli;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import zio.cli.DocWriter$;

public class DocWriter {
    private final StringBuilder stringBuilder;
    private final int columnWidth;
    private List<Object> marginStack;
    private int currentColumn;

    public static DocWriter apply(int n, int n2) {
        return DocWriter$.MODULE$.apply(n, n2);
    }

    public static Option<String[]> splitNewlines(String string) {
        return DocWriter$.MODULE$.splitNewlines(string);
    }

    public DocWriter(StringBuilder stringBuilder, int startOffset, int columnWidth) {
        this.stringBuilder = stringBuilder;
        this.columnWidth = columnWidth;
        this.marginStack = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{startOffset}));
        this.currentColumn = startOffset;
    }

    public DocWriter append(String s) {
        DocWriter docWriter;
        if (s.isEmpty()) {
            docWriter = this;
        } else {
            Option<String[]> option = DocWriter$.MODULE$.splitNewlines(s);
            if (None$.MODULE$.equals(option)) {
                if (this.currentColumn() + s.length() > this.columnWidth) {
                    int remainder = this.columnWidth - this.currentColumn();
                    int lastSpace = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(s), remainder + 1).lastIndexOf(32);
                    int lastSpace2 = lastSpace == -1 ? remainder : lastSpace;
                    String before = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(s), lastSpace2);
                    String after = StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(s), lastSpace2)), (Function1 & Serializable)_$6 -> DocWriter.$anonfun$2(BoxesRunTime.unboxToChar((Object)_$6)));
                    this.append(before);
                    this.append("\n");
                    docWriter = this.append(after);
                } else {
                    int padding = this.currentMargin() - this.currentColumn();
                    if (padding > 0) {
                        this.stringBuilder.append(DocWriter$.MODULE$.zio$cli$DocWriter$$$margin(padding));
                        this.currentColumn_$eq(this.currentColumn() + padding);
                    }
                    this.stringBuilder.append(s);
                    this.currentColumn_$eq(this.currentColumn() + s.length());
                    docWriter = BoxedUnit.UNIT;
                }
            } else if (option instanceof Some) {
                Object[] pieces = (String[])((Some)option).value();
                Object object = Predef$.MODULE$.refArrayOps(pieces);
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String piece = (String)tuple2._1();
                        this.append(piece);
                        this.stringBuilder.append("\n");
                        this.currentColumn_$eq(0);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                docWriter = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
        return this;
    }

    public int currentMargin() {
        return BoxesRunTime.unboxToInt((Object)this.marginStack.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public int currentColumn() {
        return this.currentColumn;
    }

    public void currentColumn_$eq(int x$1) {
        this.currentColumn = x$1;
    }

    public void indent(int adjust) {
        this.marginStack = this.marginStack.$colon$colon((Object)BoxesRunTime.boxToInteger((int)adjust));
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public void unindent() {
        this.marginStack = (List)this.marginStack.drop(1);
    }

    private static final /* synthetic */ boolean $anonfun$2(char _$6) {
        return _$6 == ' ';
    }
}

