/*
 * Decompiled with CFR 0.152.
 */
package zio.cli.oauth2;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.CompletableFuture;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Clock$;
import zio.Console$;
import zio.Duration$;
import zio.DurationOps$;
import zio.DurationSyntax$;
import zio.IsSubtypeOfError$;
import zio.Ref;
import zio.Schedule;
import zio.Schedule$;
import zio.ZIO;
import zio.ZIO$;
import zio.cli.oauth2.AccessToken;
import zio.cli.oauth2.AccessToken$;
import zio.cli.oauth2.AccessTokenResponse;
import zio.cli.oauth2.AccessTokenResponse$Error$Kind$AuthorizationPending$;
import zio.cli.oauth2.AccessTokenResponse$Error$Kind$SlowDown$;
import zio.cli.oauth2.AuthorizationResponse;
import zio.cli.oauth2.OAuth2Provider;
import zio.cli.oauth2.OAuth2Token;
import zio.json.JsonDecoder$;
import zio.json.JsonEncoder$;
import zio.json.package;
import zio.package$;

public class OAuth2 {
    private final OAuth2Provider provider;
    private final Path file;
    private final List<String> scope;
    private final HttpClient client;

    public OAuth2(OAuth2Provider provider, Path file, List<String> scope) {
        this.provider = provider;
        this.file = file;
        this.scope = scope;
        this.client = HttpClient.newBuilder().build();
    }

    public HttpClient client() {
        return this.client;
    }

    public ZIO<Object, Throwable, OAuth2Token> loadOrAuthorize() {
        return Clock$.MODULE$.currentDateTime((Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:18)").flatMap((Function1 & Serializable)time -> this.loadFromFile().flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                AccessToken accessToken = (AccessToken)((Some)option).value();
                AccessToken accessToken2 = accessToken;
                if (accessToken2.expiresAt().forall((Function1 & Serializable)_$1 -> _$1.isAfter((OffsetDateTime)time))) {
                    return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> accessToken2, (Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:21)");
                }
                AccessToken accessToken3 = accessToken;
                return this.refreshAccessToken(accessToken3);
            }
            return this.authorize();
        }, (Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:26)").flatMap((Function1 & Serializable)initialToken -> this.makeOAuth2Token((AccessToken)initialToken), (Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:26)"), (Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:27)");
    }

    public ZIO<Object, Throwable, AccessToken> authorize() {
        return this.requestAuthorization().tap((Function1 & Serializable)response -> this.informUser((AuthorizationResponse)response), (Object)"zio.cli.oauth2.OAuth2.authorize(OAuth2.scala:34)").flatMap((Function1 & Serializable)response -> this.waitForAccessToken((AuthorizationResponse)response), (Object)"zio.cli.oauth2.OAuth2.authorize(OAuth2.scala:34)");
    }

    public ZIO<Object, Throwable, Option<AccessToken>> loadFromFile() {
        return ZIO$.MODULE$.readFile(this::loadFromFile$$anonfun$1, (Object)"zio.cli.oauth2.OAuth2.loadFromFile(OAuth2.scala:41)", DummyImplicit$.MODULE$.dummyImplicit()).option(CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.cli.oauth2.OAuth2.loadFromFile(OAuth2.scala:41)").map((Function1 & Serializable)_$2 -> _$2.flatMap((Function1 & Serializable)_$3 -> package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)_$3), JsonDecoder$.MODULE$.fromCodec(AccessToken$.MODULE$.stateJsonCodec())).toOption()), (Object)"zio.cli.oauth2.OAuth2.loadFromFile(OAuth2.scala:41)");
    }

    public ZIO<Object, Nothing$, OAuth2Token> makeOAuth2Token(AccessToken initialToken) {
        return Ref.Synchronized$.MODULE$.make(() -> OAuth2.makeOAuth2Token$$anonfun$1(initialToken), (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token(OAuth2.scala:51)").map((Function1 & Serializable)ref -> new OAuth2Token((Ref.Synchronized)ref, this){
            private final ZIO refreshTokenNow;
            private final ZIO accessToken;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.refreshTokenNow = ref$1.updateZIO(arg_0 -> OAuth2.zio$cli$oauth2$OAuth2$$anon$1$$_$$lessinit$greater$$anonfun$1($outer, arg_0), (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.refreshTokenNow(OAuth2.scala:54)");
                this.accessToken = ref$1.updateAndGetZIO(arg_0 -> OAuth2.zio$cli$oauth2$OAuth2$$anon$1$$_$$lessinit$greater$$anonfun$2($outer, arg_0), (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.accessToken(OAuth2.scala:65)");
            }

            public ZIO refreshTokenNow() {
                return this.refreshTokenNow;
            }

            public ZIO accessToken() {
                return this.accessToken;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$cli$oauth2$OAuth2$$anon$1$$_$$lessinit$greater$$anonfun$1(zio.cli.oauth2.OAuth2 zio.cli.oauth2.AccessToken ), zio$cli$oauth2$OAuth2$$anon$1$$_$$lessinit$greater$$anonfun$2(zio.cli.oauth2.OAuth2 zio.cli.oauth2.AccessToken )}, serializedLambda);
            }
        }, (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token(OAuth2.scala:67)");
    }

    public ZIO<Object, Throwable, AccessToken> refreshAccessToken(AccessToken accessToken) {
        return (ZIO)accessToken.refreshToken().fold(this::refreshAccessToken$$anonfun$1, (Function1 & Serializable)refreshToken -> this.requestRefreshToken((String)refreshToken));
    }

    public ZIO<Object, Throwable, AuthorizationResponse> requestAuthorization() {
        return ZIO$.MODULE$.fromCompletableFuture(this::requestAuthorization$$anonfun$1, (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:88)").flatMap((Function1 & Serializable)response -> {
            if (response.statusCode() == 200) {
                return ZIO$.MODULE$.fromEither(() -> this.requestAuthorization$$anonfun$2$$anonfun$1(response), (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:92)").mapError((Function1 & Serializable)e -> new Exception(new StringBuilder(56).append("Response of authorization request could not be decoded: ").append((String)e).toString()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:93)");
            }
            return ZIO$.MODULE$.fail(() -> OAuth2.requestAuthorization$$anonfun$2$$anonfun$3(response), (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:97)");
        }, (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:99)");
    }

    public ZIO<Object, Throwable, AccessToken> waitForAccessToken(AuthorizationResponse response2) {
        return ZIO$.MODULE$.fromCompletableFuture(() -> this.waitForAccessToken$$anonfun$1(response2), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:108)").flatMap((Function1 & Serializable)response -> ZIO$.MODULE$.fromEither(() -> this.waitForAccessToken$$anonfun$2$$anonfun$1(response), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:115)"), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:116)").repeat(() -> this.waitForAccessToken$$anonfun$3(response2), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:117)").flatMap((Function1 & Serializable)res -> this.processResponse((AccessTokenResponse)res, (Option<String>)None$.MODULE$), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:118)");
    }

    public Schedule<Object, AccessTokenResponse, AccessTokenResponse> pollingSchedule(Duration interval, Duration expiresIn) {
        Schedule delays = Schedule$.MODULE$.identity().map((Function1 & Serializable)x$1 -> {
            AccessTokenResponse accessTokenResponse = x$1;
            if (accessTokenResponse instanceof AccessTokenResponse.Error) {
                AccessTokenResponse.Error e = (AccessTokenResponse.Error)accessTokenResponse;
                AccessTokenResponse.Error.Kind kind = e.error();
                AccessTokenResponse$Error$Kind$SlowDown$ accessTokenResponse$Error$Kind$SlowDown$ = AccessTokenResponse$Error$Kind$SlowDown$.MODULE$;
                if (!(kind != null ? !kind.equals(accessTokenResponse$Error$Kind$SlowDown$) : accessTokenResponse$Error$Kind$SlowDown$ != null)) {
                    return e.interval().orElse(OAuth2::$anonfun$1$$anonfun$1);
                }
            }
            return None$.MODULE$;
        }, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule.delays(OAuth2.scala:153)").addDelay((Function1 & Serializable)_$5 -> (Duration)_$5.getOrElse(OAuth2::$anonfun$2$$anonfun$1), (Object)"zio.cli.oauth2.OAuth2.pollingSchedule.delays(OAuth2.scala:155)").fold((Object)interval, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Duration duration = (Duration)tuple2._1();
                Option option = (Option)tuple2._2();
                Duration duration2 = duration;
                if (option instanceof Some) {
                    Duration interval = (Duration)((Some)option).value();
                    return DurationOps$.MODULE$.$plus$extension(package$.MODULE$.duration2DurationOps(duration2), interval);
                }
                Duration duration3 = duration;
                return duration3;
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule.delays(OAuth2.scala:160)");
        return Schedule$.MODULE$.delayed(delays, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule(OAuth2.scala:162)").$times$greater(Schedule$.MODULE$.recurWhile((Function1 & Serializable)_$6 -> {
            AccessTokenResponse accessTokenResponse = _$6;
            if (!(accessTokenResponse instanceof AccessTokenResponse.Error)) return false;
            AccessTokenResponse.Error e = (AccessTokenResponse.Error)accessTokenResponse;
            AccessTokenResponse.Error.Kind kind = e.error();
            AccessTokenResponse$Error$Kind$AuthorizationPending$ accessTokenResponse$Error$Kind$AuthorizationPending$ = AccessTokenResponse$Error$Kind$AuthorizationPending$.MODULE$;
            if (kind == null) {
                if (accessTokenResponse$Error$Kind$AuthorizationPending$ == null) return true;
            } else if (kind.equals(accessTokenResponse$Error$Kind$AuthorizationPending$)) return true;
            AccessTokenResponse.Error.Kind kind2 = e.error();
            AccessTokenResponse$Error$Kind$SlowDown$ accessTokenResponse$Error$Kind$SlowDown$ = AccessTokenResponse$Error$Kind$SlowDown$.MODULE$;
            if (kind2 != null) {
                if (!kind2.equals(accessTokenResponse$Error$Kind$SlowDown$)) return false;
                return true;
            }
            if (accessTokenResponse$Error$Kind$SlowDown$ == null) return true;
            return false;
        }, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule(OAuth2.scala:168)").upTo(expiresIn, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule(OAuth2.scala:169)"), (Object)"zio.cli.oauth2.OAuth2.pollingSchedule(OAuth2.scala:169)");
    }

    public ZIO<Object, Throwable, AccessToken> requestRefreshToken(String refreshToken) {
        return ZIO$.MODULE$.fromEither(() -> this.requestRefreshToken$$anonfun$1(refreshToken), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:182)").flatMap((Function1 & Serializable)request -> ZIO$.MODULE$.fromCompletableFuture(() -> this.requestRefreshToken$$anonfun$2$$anonfun$1(request), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:183)"), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:183)").flatMap((Function1 & Serializable)response -> {
            if (response.statusCode() == 200) {
                return ZIO$.MODULE$.fromEither(() -> this.requestRefreshToken$$anonfun$3$$anonfun$1(response), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:192)");
            }
            return ZIO$.MODULE$.fail(() -> OAuth2.requestRefreshToken$$anonfun$3$$anonfun$2(response), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:196)");
        }, (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:198)").flatMap((Function1 & Serializable)res -> this.processResponse((AccessTokenResponse)res, (Option<String>)Some$.MODULE$.apply((Object)refreshToken)), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:199)");
    }

    public ZIO<Object, Throwable, AccessToken> processResponse(AccessTokenResponse response, Option<String> refreshToken) {
        AccessTokenResponse accessTokenResponse = response;
        if (accessTokenResponse instanceof AccessTokenResponse.Error) {
            AccessTokenResponse.Error e = (AccessTokenResponse.Error)accessTokenResponse;
            String description = (String)e.errorDescription().map((Function1 & Serializable)d -> new StringBuilder(21).append(" and with message: '").append((String)d).append("'").toString()).getOrElse(OAuth2::$anonfun$5);
            String uri2 = (String)e.errorUri().map((Function1 & Serializable)uri -> new StringBuilder(29).append(" For more information visit: ").append((String)uri).toString()).getOrElse(OAuth2::$anonfun$7);
            return ZIO$.MODULE$.fail(() -> OAuth2.processResponse$$anonfun$1(e, description, uri2), (Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:211)");
        }
        if (accessTokenResponse instanceof AccessTokenResponse.AccessToken) {
            AccessTokenResponse.AccessToken t = (AccessTokenResponse.AccessToken)accessTokenResponse;
            return Clock$.MODULE$.currentDateTime((Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:213)").map((Function1 & Serializable)time -> AccessToken$.MODULE$.apply(t.accessToken(), t.tokenType(), (Option<OffsetDateTime>)t.expiresIn().map((Function1 & Serializable)exp -> time.plus((TemporalAmount)exp)), (Option<String>)refreshToken.orElse(() -> OAuth2.processResponse$$anonfun$2$$anonfun$2(t)), t.scope()), (Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:222)").tap((Function1 & Serializable)token -> ZIO$.MODULE$.writeFile(this::processResponse$$anonfun$3$$anonfun$1, () -> OAuth2.processResponse$$anonfun$3$$anonfun$2(token), (Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:223)", DummyImplicit$.MODULE$.dummyImplicit()), (Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:223)");
        }
        throw new MatchError((Object)accessTokenResponse);
    }

    public ZIO<Object, Nothing$, BoxedUnit> informUser(AuthorizationResponse response) {
        return Clock$.MODULE$.localDateTime((Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:231)").map((Function1 & Serializable)time -> {
            int boxUrlLength = response.verificationUri().length() + 2;
            int boxCodeLength = response.userCode().length() + 2;
            long expiresIn = response.expiresIn().toMinutes();
            LocalTime expiresAt = time.plus(response.expiresIn()).withNano(0).toLocalTime();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(447).append("| >>\n          | >>  Application requests to perform OAuth2\n          | >>  authorization.\n          | >>\n          | >>  Visit following URL in a browser:\n          | >>\n          | >>   \u250f").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), boxUrlLength)).append("\u2513\n          | >>   \u2503 ").append(response.verificationUri()).append(" \u2503\n          | >>   \u2517").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), boxUrlLength)).append("\u251b\n          | >>\n          | >>  And enter following code:\n          | >>\n          | >>   \u250f").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), boxCodeLength)).append("\u2513\n          | >>   \u2503 ").append(response.userCode()).append(" \u2503\n          | >>   \u2517").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), boxCodeLength)).append("\u251b\n          | >>\n          | >>  Code will expire in ").append(expiresIn).append(" minutes at ").append(expiresAt).append(".\n          | >>\n").toString()));
        }, (Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:256)").flatMap((Function1 & Serializable)text -> Console$.MODULE$.printLine(() -> OAuth2.informUser$$anonfun$2$$anonfun$1(text), (Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:257)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:257)"), (Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:257)");
    }

    private final Path loadFromFile$$anonfun$1() {
        return this.file;
    }

    private static final AccessToken makeOAuth2Token$$anonfun$1(AccessToken initialToken$1) {
        return initialToken$1;
    }

    public static final /* synthetic */ ZIO zio$cli$oauth2$OAuth2$$anon$1$$_$$lessinit$greater$$anonfun$1(OAuth2 $outer$1, AccessToken accessToken) {
        return $outer$1.refreshAccessToken(accessToken);
    }

    public static final /* synthetic */ ZIO zio$cli$oauth2$OAuth2$$anon$1$$_$$lessinit$greater$$anonfun$2(OAuth2 $outer$3, AccessToken acc) {
        return Clock$.MODULE$.currentDateTime((Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.accessToken(OAuth2.scala:57)").flatMap((Function1 & Serializable)time -> {
            Option option = acc.expiresAt().map((Function1 & Serializable)_$4 -> _$4.isBefore((OffsetDateTime)time));
            if (option instanceof Some && BoxesRunTime.unboxToBoolean((Object)((Some)option).value())) {
                return $outer$3.refreshAccessToken(acc);
            }
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> acc, (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.accessToken(OAuth2.scala:62)");
        }, (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.accessToken(OAuth2.scala:64)");
    }

    private final ZIO refreshAccessToken$$anonfun$1() {
        return this.authorize();
    }

    private final CompletableFuture requestAuthorization$$anonfun$1() {
        return this.client().sendAsync(this.provider.authorizationRequest(this.scope), HttpResponse.BodyHandlers.ofString());
    }

    private final Either requestAuthorization$$anonfun$2$$anonfun$1(HttpResponse response$1) {
        return this.provider.decodeAuthorizationResponse((String)response$1.body());
    }

    private static final Exception requestAuthorization$$anonfun$2$$anonfun$3(HttpResponse response$2) {
        return new Exception(new StringBuilder(65).append("Authorization server returned error after authorization request: ").append(response$2.body()).toString());
    }

    private final CompletableFuture waitForAccessToken$$anonfun$1(AuthorizationResponse response$3) {
        return this.client().sendAsync(this.provider.accessTokenRequest(response$3), HttpResponse.BodyHandlers.ofString());
    }

    private final Either waitForAccessToken$$anonfun$2$$anonfun$1(HttpResponse response$4) {
        return this.provider.decodeAccessTokenResponse((String)response$4.body()).left().map((Function1 & Serializable)e -> new Exception(new StringBuilder(55).append("Response of access token request could not be decoded: ").append((String)e).toString()));
    }

    private final Schedule waitForAccessToken$$anonfun$3(AuthorizationResponse response$5) {
        return this.pollingSchedule(response$5.interval(), response$5.expiresIn());
    }

    private static final Option $anonfun$1$$anonfun$1() {
        return Some$.MODULE$.apply((Object)DurationSyntax$.MODULE$.seconds$extension(package$.MODULE$.durationInt(5)));
    }

    private static final Duration $anonfun$2$$anonfun$1() {
        return Duration$.MODULE$.Zero();
    }

    private static final Exception requestRefreshToken$$anonfun$1$$anonfun$1() {
        return new Exception("Authorization server does not support refresh tokens.");
    }

    private final Either requestRefreshToken$$anonfun$1(String refreshToken$1) {
        return this.provider.refreshTokenRequest(refreshToken$1).toRight(OAuth2::requestRefreshToken$$anonfun$1$$anonfun$1);
    }

    private final CompletableFuture requestRefreshToken$$anonfun$2$$anonfun$1(HttpRequest request$1) {
        return this.client().sendAsync(request$1, HttpResponse.BodyHandlers.ofString());
    }

    private final Either requestRefreshToken$$anonfun$3$$anonfun$1(HttpResponse response$6) {
        return this.provider.decodeAccessTokenResponse((String)response$6.body()).left().map((Function1 & Serializable)e -> new Exception(new StringBuilder(56).append("Response of refresh token request could not be decoded: ").append((String)e).toString()));
    }

    private static final Exception requestRefreshToken$$anonfun$3$$anonfun$2(HttpResponse response$7) {
        return new Exception(new StringBuilder(65).append("Authorization server returned error after refresh token request: ").append(response$7.body()).toString());
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final String $anonfun$7() {
        return "";
    }

    private static final Exception processResponse$$anonfun$1(AccessTokenResponse.Error e$1, String description$1, String uri$1) {
        return new Exception(new StringBuilder(45).append("Authorization server returned error of type ").append(e$1.error()).append(description$1).append(".").append(uri$1).toString());
    }

    private static final Option processResponse$$anonfun$2$$anonfun$2(AccessTokenResponse.AccessToken t$2) {
        return t$2.refreshToken();
    }

    private final Path processResponse$$anonfun$3$$anonfun$1() {
        return this.file;
    }

    private static final String processResponse$$anonfun$3$$anonfun$2(AccessToken token$1) {
        AccessToken accessToken = (AccessToken)zio.json.package$.MODULE$.EncoderOps((Object)token$1);
        return package.EncoderOps$.MODULE$.toJson$extension((Object)accessToken, JsonEncoder$.MODULE$.fromCodec(AccessToken$.MODULE$.stateJsonCodec()));
    }

    private static final Object informUser$$anonfun$2$$anonfun$1(String text$1) {
        return new StringBuilder(11).append(text$1).append("\nWaiting...").toString();
    }
}

