/*
 * Decompiled with CFR 0.152.
 */
package zio.cli.oauth2;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.runtime.ModuleSerializationProxy;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.ZIO;
import zio.cli.CliConfig;
import zio.cli.HelpDoc;
import zio.cli.HelpDoc$;
import zio.cli.Options;
import zio.cli.Options$Both$;
import zio.cli.Options$Empty$;
import zio.cli.Options$KeyValueMap$;
import zio.cli.Options$Map$;
import zio.cli.Options$OAuth2Options$;
import zio.cli.Options$OrElse$;
import zio.cli.Options$Single$;
import zio.cli.Options$WithDefault$;
import zio.cli.PrimType;
import zio.cli.ValidationError;
import zio.cli.ValidationError$;
import zio.cli.ValidationErrorType$InvalidValue$;
import zio.cli.oauth2.OAuth2;
import zio.cli.oauth2.OAuth2AuxiliaryOptions;
import zio.cli.oauth2.OAuth2Provider;
import zio.cli.oauth2.OAuth2Token;

public final class OAuth2PlatformSpecific$
implements Serializable {
    public static final OAuth2PlatformSpecific$ MODULE$ = new OAuth2PlatformSpecific$();

    private OAuth2PlatformSpecific$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(OAuth2PlatformSpecific$.class);
    }

    public ZIO<Object, ValidationError, Tuple2<List<String>, OAuth2Token>> validate(OAuth2Provider provider, List<String> scope, Options<OAuth2AuxiliaryOptions> auxiliaryOptions, List<String> args, CliConfig conf) {
        return auxiliaryOptions.validate(args, conf).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List args = (List)tuple2._1();
                OAuth2AuxiliaryOptions aux = (OAuth2AuxiliaryOptions)tuple2._2();
                return new OAuth2(provider, aux.file(), scope).loadOrAuthorize().mapError((Function1 & Serializable)ex -> ValidationError$.MODULE$.apply(ValidationErrorType$InvalidValue$.MODULE$, HelpDoc$.MODULE$.p(ex.getMessage())), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.cli.oauth2.OAuth2PlatformSpecific.validate(OAuth2PlatformSpecific.scala:18)").map((Function1 & Serializable)token -> Tuple2$.MODULE$.apply((Object)args, token), (Object)"zio.cli.oauth2.OAuth2PlatformSpecific.validate(OAuth2PlatformSpecific.scala:19)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.cli.oauth2.OAuth2PlatformSpecific.validate(OAuth2PlatformSpecific.scala:20)");
    }

    public Option<OAuth2Provider> findProvider(Options<Object> opt) {
        Options<Object> options;
        while (true) {
            if ((options = opt) instanceof Options.Both) {
                Options.Both both = Options$Both$.MODULE$.unapply((Options.Both)options);
                Options<Object> options2 = both._1();
                Options options3 = both._2();
                Options<Object> left = options2;
                Options right = options3;
                return this.findProvider(left).orElse(() -> this.findProvider$$anonfun$1(right));
            }
            if (options instanceof Options.Map) {
                Options.Map map = Options$Map$.MODULE$.unapply((Options.Map)options);
                Options options4 = map._1();
                Function1 function1 = map._2();
                Options value = options4;
                opt = value;
                continue;
            }
            if (options instanceof Options.KeyValueMap) {
                Options.KeyValueMap keyValueMap = Options$KeyValueMap$.MODULE$.unapply((Options.KeyValueMap)options);
                Options.Single<String> single = keyValueMap._1();
                return None$.MODULE$;
            }
            if (Options$Empty$.MODULE$.equals(options)) {
                return None$.MODULE$;
            }
            if (options instanceof Options.OrElse) {
                Options.OrElse orElse = Options$OrElse$.MODULE$.unapply((Options.OrElse)options);
                Options<Object> options5 = orElse._1();
                Options options6 = orElse._2();
                Options<Object> left = options5;
                Options right = options6;
                return this.findProvider(left).orElse(() -> this.findProvider$$anonfun$2(right));
            }
            if (options instanceof Options.Single) {
                Options.Single single = Options$Single$.MODULE$.unapply((Options.Single)options);
                String string = single._1();
                Vector<String> vector = single._2();
                PrimType primType = single._3();
                HelpDoc helpDoc = single._4();
                return None$.MODULE$;
            }
            if (options instanceof Options.OAuth2Options) {
                Options.OAuth2Options oAuth2Options = Options$OAuth2Options$.MODULE$.unapply((Options.OAuth2Options)options);
                OAuth2Provider oAuth2Provider = oAuth2Options._1();
                List<String> list = oAuth2Options._2();
                Options<OAuth2AuxiliaryOptions> options7 = oAuth2Options._3();
                OAuth2Provider provider = oAuth2Provider;
                return Some$.MODULE$.apply((Object)provider);
            }
            if (!(options instanceof Options.WithDefault)) break;
            Options.WithDefault withDefault = Options$WithDefault$.MODULE$.unapply((Options.WithDefault)options);
            Options options8 = withDefault._1();
            Object a = withDefault._2();
            Options options9 = options8;
            opt = options9;
        }
        throw new MatchError(options);
    }

    public HelpDoc oauth2HelpSection(Options<Object> options) {
        return (HelpDoc)this.findProvider(options).fold(this::oauth2HelpSection$$anonfun$1, (Function1 & Serializable)provider -> HelpDoc$.MODULE$.h1("3rd party authorization").$plus(HelpDoc$.MODULE$.p(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(440).append("|This application requires 3rd party authorization (using OAuth2 protocol)\n            |provided by ").append(provider.name()).append(". When the application is launched for the first time,\n            |instructions to perform the authorization will be displayed. Subsequent launches\n            |do not require any action unless the access has been revoked.\n            |\n            |Behavior of 3rd party authorization can be modified by options starting with '--oauth2-'.").toString())))));
    }

    private final Option findProvider$$anonfun$1(Options right$1) {
        return this.findProvider(right$1);
    }

    private final Option findProvider$$anonfun$2(Options right$2) {
        return this.findProvider(right$2);
    }

    private final HelpDoc oauth2HelpSection$$anonfun$1() {
        return HelpDoc$.MODULE$.empty();
    }
}

