/*
 * Decompiled with CFR 0.152.
 */
package zio.cli;

import java.io.Serializable;
import java.net.URI;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import zio.cli.DocWriter;
import zio.cli.DocWriter$;
import zio.cli.HelpDoc$;
import zio.cli.HelpDoc$DescriptionList$;
import zio.cli.HelpDoc$Empty$;
import zio.cli.HelpDoc$Enumeration$;
import zio.cli.HelpDoc$Header$;
import zio.cli.HelpDoc$Paragraph$;
import zio.cli.HelpDoc$Sequence$;
import zio.cli.HelpDoc$Span$;
import zio.cli.HelpDoc$Span$Code$;
import zio.cli.HelpDoc$Span$Error$;
import zio.cli.HelpDoc$Span$Sequence$;
import zio.cli.HelpDoc$Span$Strong$;
import zio.cli.HelpDoc$Span$Text$;
import zio.cli.HelpDoc$Span$URI$;
import zio.cli.HelpDoc$Span$Weak$;

public interface HelpDoc {
    public static HelpDoc blocks(HelpDoc helpDoc, Seq<HelpDoc> seq) {
        return HelpDoc$.MODULE$.blocks(helpDoc, seq);
    }

    public static HelpDoc blocks(Iterable<HelpDoc> iterable) {
        return HelpDoc$.MODULE$.blocks(iterable);
    }

    public static HelpDoc descriptionList(Seq<Tuple2<Span, HelpDoc>> seq) {
        return HelpDoc$.MODULE$.descriptionList(seq);
    }

    public static HelpDoc empty() {
        return HelpDoc$.MODULE$.empty();
    }

    public static HelpDoc enumeration(Seq<HelpDoc> seq) {
        return HelpDoc$.MODULE$.enumeration(seq);
    }

    public static HelpDoc h1(Span span) {
        return HelpDoc$.MODULE$.h1(span);
    }

    public static HelpDoc h1(String string) {
        return HelpDoc$.MODULE$.h1(string);
    }

    public static HelpDoc h2(Span span) {
        return HelpDoc$.MODULE$.h2(span);
    }

    public static HelpDoc h2(String string) {
        return HelpDoc$.MODULE$.h2(string);
    }

    public static HelpDoc h3(Span span) {
        return HelpDoc$.MODULE$.h3(span);
    }

    public static HelpDoc h3(String string) {
        return HelpDoc$.MODULE$.h3(string);
    }

    public static int ordinal(HelpDoc helpDoc) {
        return HelpDoc$.MODULE$.ordinal(helpDoc);
    }

    public static HelpDoc p(Span span) {
        return HelpDoc$.MODULE$.p(span);
    }

    public static HelpDoc p(String string) {
        return HelpDoc$.MODULE$.p(string);
    }

    public static HelpDoc $plus$(HelpDoc $this, HelpDoc that) {
        return $this.$plus(that);
    }

    default public HelpDoc $plus(HelpDoc that) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this, (Object)that);
        if (tuple2 != null) {
            HelpDoc helpDoc = (HelpDoc)tuple2._1();
            HelpDoc helpDoc2 = (HelpDoc)tuple2._2();
            HelpDoc self = helpDoc;
            HelpDoc that2 = helpDoc2;
            if (self.isEmpty()) {
                return that2;
            }
            HelpDoc self2 = helpDoc;
            HelpDoc that3 = helpDoc2;
            if (that3.isEmpty()) {
                return self2;
            }
        }
        return HelpDoc$Sequence$.MODULE$.apply(this, that);
    }

    public static HelpDoc $bar$(HelpDoc $this, HelpDoc that) {
        return $this.$bar(that);
    }

    default public HelpDoc $bar(HelpDoc that) {
        if (this.isEmpty()) {
            return that;
        }
        return this;
    }

    public static Span getSpan$(HelpDoc $this) {
        return $this.getSpan();
    }

    default public Span getSpan() {
        HelpDoc helpDoc = this;
        if (helpDoc instanceof Header) {
            Header header = HelpDoc$Header$.MODULE$.unapply((Header)helpDoc);
            Span span = header._1();
            int n = header._2();
            Span value = span;
            return value;
        }
        if (helpDoc instanceof Paragraph) {
            Span span;
            Paragraph paragraph = HelpDoc$Paragraph$.MODULE$.unapply((Paragraph)helpDoc);
            Span value = span = paragraph._1();
            return value;
        }
        return HelpDoc$Span$.MODULE$.empty();
    }

    public static boolean isEmpty$(HelpDoc $this) {
        return $this.isEmpty();
    }

    default public boolean isEmpty() {
        HelpDoc helpDoc = this;
        if (HelpDoc$Empty$.MODULE$.equals(helpDoc)) {
            return true;
        }
        if (helpDoc instanceof DescriptionList) {
            List<Tuple2<Span, HelpDoc>> list;
            DescriptionList descriptionList = HelpDoc$DescriptionList$.MODULE$.unapply((DescriptionList)helpDoc);
            List<Tuple2<Span, HelpDoc>> xs = list = descriptionList._1();
            return xs.forall((Function1 & Serializable)_$1 -> ((HelpDoc)_$1._2()).isEmpty());
        }
        if (helpDoc instanceof Sequence) {
            Sequence sequence = HelpDoc$Sequence$.MODULE$.unapply((Sequence)helpDoc);
            HelpDoc helpDoc2 = sequence._1();
            HelpDoc helpDoc3 = sequence._2();
            HelpDoc left = helpDoc2;
            HelpDoc right = helpDoc3;
            return left.isEmpty() && right.isEmpty();
        }
        if (helpDoc instanceof Enumeration) {
            List<HelpDoc> list;
            Enumeration enumeration = HelpDoc$Enumeration$.MODULE$.unapply((Enumeration)helpDoc);
            List<HelpDoc> xs = list = enumeration._1();
            return xs.forall((Function1 & Serializable)_$2 -> _$2.isEmpty());
        }
        return false;
    }

    public static boolean isHeader$(HelpDoc $this) {
        return $this.isHeader();
    }

    default public boolean isHeader() {
        HelpDoc helpDoc = this;
        if (helpDoc instanceof Header) {
            Header header = HelpDoc$Header$.MODULE$.unapply((Header)helpDoc);
            Span span = header._1();
            int n = header._2();
            return true;
        }
        if (helpDoc instanceof Sequence) {
            Sequence sequence = HelpDoc$Sequence$.MODULE$.unapply((Sequence)helpDoc);
            HelpDoc helpDoc2 = sequence._1();
            HelpDoc helpDoc3 = sequence._2();
            HelpDoc left = helpDoc2;
            return left.isHeader();
        }
        return false;
    }

    public static boolean isParagraph$(HelpDoc $this) {
        return $this.isParagraph();
    }

    default public boolean isParagraph() {
        HelpDoc helpDoc = this;
        if (helpDoc instanceof Paragraph) {
            Paragraph paragraph = HelpDoc$Paragraph$.MODULE$.unapply((Paragraph)helpDoc);
            Span span = paragraph._1();
            return true;
        }
        if (helpDoc instanceof Sequence) {
            Sequence sequence = HelpDoc$Sequence$.MODULE$.unapply((Sequence)helpDoc);
            HelpDoc helpDoc2 = sequence._1();
            HelpDoc helpDoc3 = sequence._2();
            HelpDoc left = helpDoc2;
            return left.isParagraph();
        }
        return false;
    }

    public static boolean isDescriptionList$(HelpDoc $this) {
        return $this.isDescriptionList();
    }

    default public boolean isDescriptionList() {
        HelpDoc helpDoc = this;
        if (helpDoc instanceof DescriptionList) {
            DescriptionList descriptionList = HelpDoc$DescriptionList$.MODULE$.unapply((DescriptionList)helpDoc);
            List<Tuple2<Span, HelpDoc>> list = descriptionList._1();
            return true;
        }
        if (helpDoc instanceof Sequence) {
            Sequence sequence = HelpDoc$Sequence$.MODULE$.unapply((Sequence)helpDoc);
            HelpDoc helpDoc2 = sequence._1();
            HelpDoc helpDoc3 = sequence._2();
            HelpDoc left = helpDoc2;
            return left.isDescriptionList();
        }
        return false;
    }

    public static boolean isEnumeration$(HelpDoc $this) {
        return $this.isEnumeration();
    }

    default public boolean isEnumeration() {
        HelpDoc helpDoc = this;
        if (helpDoc instanceof Enumeration) {
            Enumeration enumeration = HelpDoc$Enumeration$.MODULE$.unapply((Enumeration)helpDoc);
            List<HelpDoc> list = enumeration._1();
            return true;
        }
        if (helpDoc instanceof Sequence) {
            Sequence sequence = HelpDoc$Sequence$.MODULE$.unapply((Sequence)helpDoc);
            HelpDoc helpDoc2 = sequence._1();
            HelpDoc helpDoc3 = sequence._2();
            HelpDoc left = helpDoc2;
            return left.isEnumeration();
        }
        return false;
    }

    public static boolean isSequence$(HelpDoc $this) {
        return $this.isSequence();
    }

    default public boolean isSequence() {
        HelpDoc helpDoc = this;
        if (helpDoc instanceof Sequence) {
            Sequence sequence = HelpDoc$Sequence$.MODULE$.unapply((Sequence)helpDoc);
            HelpDoc helpDoc2 = sequence._1();
            HelpDoc helpDoc3 = sequence._2();
            return true;
        }
        return false;
    }

    public static HelpDoc mapDescriptionList$(HelpDoc $this, Function2 f) {
        return $this.mapDescriptionList((Function2<Span, HelpDoc, Tuple2<Span, HelpDoc>>)f);
    }

    default public HelpDoc mapDescriptionList(Function2<Span, HelpDoc, Tuple2<Span, HelpDoc>> f) {
        HelpDoc helpDoc = this;
        if (helpDoc instanceof DescriptionList) {
            List<Tuple2<Span, HelpDoc>> list;
            DescriptionList descriptionList = HelpDoc$DescriptionList$.MODULE$.unapply((DescriptionList)helpDoc);
            List<Tuple2<Span, HelpDoc>> list2 = list = descriptionList._1();
            return HelpDoc$DescriptionList$.MODULE$.apply((List<Tuple2<Span, HelpDoc>>)list2.map(f.tupled()));
        }
        HelpDoc x = helpDoc;
        return x;
    }

    public static String toHTML$(HelpDoc $this) {
        return $this.toHTML();
    }

    default public String toHTML() {
        StringBuilder w = new StringBuilder();
        Function1 & Serializable escape = (Function1 & Serializable)_$3 -> _$3.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        String css = "<style>\n        h1 {\n            color: rgb(36, 41, 46);\n            font-weight: 600;\n            line-height: 1.25;\n            margin-bottom: 16px;\n            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol;\n        }\n\n        h2 {\n            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol;\n            font-size: 24px;\n            letter-spacing: 0px;\n            word-spacing: 2px;\n            color: rgb(36, 41, 46);\n            font-weight: 600;\n        }\n\n        h3 {\n            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol;\n            font-size: 21px;\n            letter-spacing: 0px;\n            word-spacing: 2px;\n            color: rgb(36, 41, 46);\n            font-weight: 700;\n        }\n\n        p {\n            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol;\n            color: #24292e;\n        }\n\n        .error {\n            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol;\n            color: #24292e;\n        }\n\n        a {\n            border: 0;\n            color: rgb(189, 39, 26);\n            text-decoration: none;\n            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol;\n            font-size: inherit;\n            font-size: 100%;\n            margin: 0;\n            padding: 0;\n            vertical-align: baseline;\n        }\n\n        a:hover {\n            color: rgb(0, 0, 0);\n        }\n\n        pre {\n          background-color: rgba(27, 31, 35, .05);\n        }\n\n        code {\n            border-radius: 3px;\n            color: rgb(36, 41, 46);\n            font-family: SFMono-Regular, Menlo, Monaco, Consolas, Liberation Mono, Courier New, monospace;\n            font-size: 85%;\n            margin: 0;\n        }\n    </style>";
        w.append(new java.lang.StringBuilder(25).append("<html><head>").append(css).append("</head><body>").toString());
        HelpDoc.render$1(w, escape).apply((Object)this);
        w.append("</body></html>");
        return w.toString();
    }

    public static String toPlaintext$(HelpDoc $this, int columnWidth, boolean color) {
        return $this.toPlaintext(columnWidth, color);
    }

    default public String toPlaintext(int columnWidth, boolean color) {
        boolean bl = color;
        DocWriter writer = DocWriter$.MODULE$.apply(0, columnWidth);
        BooleanRef uppercase = BooleanRef.create((boolean)false);
        ObjectRef styles = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef lastStyle = ObjectRef.create((Object)"\u001b[0m");
        IntRef printedSep = IntRef.create((int)0);
        HelpDoc.renderHelpDoc$1(writer, uppercase, printedSep, styles, color, lastStyle, this);
        return new java.lang.StringBuilder(0).append(writer.toString()).append(color ? "\u001b[0m" : "").toString();
    }

    public static int toPlaintext$default$1$(HelpDoc $this) {
        return $this.toPlaintext$default$1();
    }

    default public int toPlaintext$default$1() {
        return 100;
    }

    public static boolean toPlaintext$default$2$(HelpDoc $this) {
        return $this.toPlaintext$default$2();
    }

    default public boolean toPlaintext$default$2() {
        return true;
    }

    private static Function1 renderSpan$1(StringBuilder w$1, Function1 escape$1) {
        return (Function1 & Serializable)x$1 -> {
            Span span = x$1;
            if (span instanceof Span.Text) {
                String string;
                Span.Text text = HelpDoc$Span$Text$.MODULE$.unapply((Span.Text)span);
                String value = string = text._1();
                return w$1.append((String)escape$1.apply((Object)value));
            }
            if (span instanceof Span.Code) {
                String string;
                Span.Code code = HelpDoc$Span$Code$.MODULE$.unapply((Span.Code)span);
                String value = string = code._1();
                return w$1.append(new java.lang.StringBuilder(24).append("<pre><code>").append(escape$1.apply((Object)value)).append("</code></pre>").toString());
            }
            if (span instanceof Span.URI) {
                URI uRI;
                Span.URI uRI2 = HelpDoc$Span$URI$.MODULE$.unapply((Span.URI)span);
                URI value = uRI = uRI2._1();
                return w$1.append(new java.lang.StringBuilder(15).append("<a href=\"").append(value).append("\">").append(value).append("</a>").toString());
            }
            if (span instanceof Span.Weak) {
                Span span2;
                Span.Weak weak = HelpDoc$Span$Weak$.MODULE$.unapply((Span.Weak)span);
                Span value = span2 = weak._1();
                return (StringBuilder)HelpDoc.renderSpan$1(w$1, escape$1).apply((Object)value);
            }
            if (span instanceof Span.Strong) {
                Span span3;
                Span.Strong strong = HelpDoc$Span$Strong$.MODULE$.unapply((Span.Strong)span);
                Span value = span3 = strong._1();
                w$1.append("<b>");
                HelpDoc.renderSpan$1(w$1, escape$1).apply((Object)value);
                return w$1.append("</b>");
            }
            if (span instanceof Span.Error) {
                Span span4;
                Span.Error error = HelpDoc$Span$Error$.MODULE$.unapply((Span.Error)span);
                Span value = span4 = error._1();
                w$1.append("<span class='error'>");
                HelpDoc.renderSpan$1(w$1, escape$1).apply((Object)value);
                return w$1.append("</span>");
            }
            if (span instanceof Span.Sequence) {
                Span.Sequence sequence = HelpDoc$Span$Sequence$.MODULE$.unapply((Span.Sequence)span);
                Span span5 = sequence._1();
                Span span6 = sequence._2();
                Span left = span5;
                Span right = span6;
                HelpDoc.renderSpan$1(w$1, escape$1).apply((Object)left);
                return (StringBuilder)HelpDoc.renderSpan$1(w$1, escape$1).apply((Object)right);
            }
            throw new MatchError((Object)span);
        };
    }

    private static Function1 render$1(StringBuilder w$3, Function1 escape$3) {
        return (Function1 & Serializable)x$12 -> {
            HelpDoc helpDoc = x$12;
            if (HelpDoc$Empty$.MODULE$.equals(helpDoc)) {
                return w$3;
            }
            if (helpDoc instanceof Header) {
                Header header = HelpDoc$Header$.MODULE$.unapply((Header)helpDoc);
                Span span = header._1();
                int n = header._2();
                Span value = span;
                int level = n;
                w$3.append(new java.lang.StringBuilder(3).append("<h").append(level).append(">").toString());
                HelpDoc.renderSpan$1(w$3, escape$3).apply((Object)value);
                return w$3.append(new java.lang.StringBuilder(4).append("</h").append(level).append(">").toString());
            }
            if (helpDoc instanceof Paragraph) {
                Span span;
                Paragraph paragraph = HelpDoc$Paragraph$.MODULE$.unapply((Paragraph)helpDoc);
                Span value = span = paragraph._1();
                w$3.append("<p>");
                HelpDoc.renderSpan$1(w$3, escape$3).apply((Object)value);
                return w$3.append("</p>");
            }
            if (helpDoc instanceof DescriptionList) {
                List<Tuple2<Span, HelpDoc>> list;
                DescriptionList descriptionList = HelpDoc$DescriptionList$.MODULE$.unapply((DescriptionList)helpDoc);
                List<Tuple2<Span, HelpDoc>> definitions = list = descriptionList._1();
                return (StringBuilder)definitions.foldRight((Object)w$3, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                        Span span = (Span)tuple2._1();
                        HelpDoc helpDoc = (HelpDoc)tuple2._2();
                        HelpDoc.renderSpan$1(w$3, escape$3).apply((Object)span);
                        return (StringBuilder)HelpDoc.render$1(w$3, escape$3).apply((Object)helpDoc);
                    }
                    throw new MatchError((Object)tuple22);
                });
            }
            if (helpDoc instanceof Enumeration) {
                List<HelpDoc> list;
                Enumeration enumeration = HelpDoc$Enumeration$.MODULE$.unapply((Enumeration)helpDoc);
                List<HelpDoc> elements = list = enumeration._1();
                w$3.append("<ul>");
                elements.foreach((Function1 & Serializable)hd -> {
                    w$3.append("<li>");
                    HelpDoc.render$1(w$3, escape$3).apply(hd);
                    return w$3.append("</li>");
                });
                return w$3.append("</ul>");
            }
            if (helpDoc instanceof Sequence) {
                Sequence sequence = HelpDoc$Sequence$.MODULE$.unapply((Sequence)helpDoc);
                HelpDoc helpDoc2 = sequence._1();
                HelpDoc helpDoc3 = sequence._2();
                HelpDoc left = helpDoc2;
                HelpDoc right = helpDoc3;
                HelpDoc.render$1(w$3, escape$3).apply((Object)left);
                w$3.append("<br/>");
                return (StringBuilder)HelpDoc.render$1(w$3, escape$3).apply((Object)right);
            }
            throw new MatchError((Object)helpDoc);
        };
    }

    private static void setStyle$1(ObjectRef styles$1, String style) {
        styles$1.elem = ((List)styles$1.elem).$colon$colon((Object)style);
    }

    private static String currentStyle$1$$anonfun$1() {
        return "\u001b[0m";
    }

    private static String currentStyle$1(ObjectRef styles$2) {
        return (String)((List)styles$2.elem).headOption().getOrElse(HelpDoc::currentStyle$1$$anonfun$1);
    }

    private static void resetStyle$1(ObjectRef styles$3) {
        styles$3.elem = (List)((List)styles$3.elem).drop(1);
    }

    private static void renderText$1(boolean color$4, ObjectRef lastStyle$4, DocWriter writer$5, BooleanRef uppercase$4, IntRef printedSep$6, ObjectRef styles$7, String text) {
        HelpDoc.renderSpan$2(color$4, lastStyle$4, writer$5, uppercase$4, printedSep$6, styles$7, HelpDoc$Span$.MODULE$.text(text));
    }

    private static void renderNewline$1(IntRef printedSep$1, DocWriter writer$1) {
        if (printedSep$1.elem < 2) {
            ++printedSep$1.elem;
            DocWriter docWriter = writer$1.append("\n");
            return;
        }
    }

    private static void clearSep$1(IntRef printedSep$2) {
        printedSep$2.elem = 0;
    }

    private static void renderHelpDoc$1(DocWriter writer$2, BooleanRef uppercase$1, IntRef printedSep$3, ObjectRef styles$4, boolean color$1, ObjectRef lastStyle$1, HelpDoc helpDoc) {
        HelpDoc helpDoc2;
        while (true) {
            if (HelpDoc$Empty$.MODULE$.equals(helpDoc2 = helpDoc)) {
                return;
            }
            if (helpDoc2 instanceof Header) {
                Header header = HelpDoc$Header$.MODULE$.unapply((Header)helpDoc2);
                Span span = header._1();
                int n = header._2();
                Span value = span;
                writer$2.unindent();
                HelpDoc.renderNewline$1(printedSep$3, writer$2);
                uppercase$1.elem = true;
                HelpDoc.setStyle$1(styles$4, "\u001b[1m");
                HelpDoc.renderSpan$2(color$1, lastStyle$1, writer$2, uppercase$1, printedSep$3, styles$4, value);
                HelpDoc.resetStyle$1(styles$4);
                uppercase$1.elem = false;
                HelpDoc.renderNewline$1(printedSep$3, writer$2);
                writer$2.indent(2);
                return;
            }
            if (helpDoc2 instanceof Paragraph) {
                Span span;
                Paragraph paragraph = HelpDoc$Paragraph$.MODULE$.unapply((Paragraph)helpDoc2);
                Span value = span = paragraph._1();
                HelpDoc.renderSpan$2(color$1, lastStyle$1, writer$2, uppercase$1, printedSep$3, styles$4, value);
                HelpDoc.renderNewline$1(printedSep$3, writer$2);
                return;
            }
            if (helpDoc2 instanceof DescriptionList) {
                List<Tuple2<Span, HelpDoc>> list;
                DescriptionList descriptionList = HelpDoc$DescriptionList$.MODULE$.unapply((DescriptionList)helpDoc2);
                List<Tuple2<Span, HelpDoc>> definitions = list = descriptionList._1();
                ((List)definitions.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x$1;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                        Span span = (Span)tuple2._1();
                        HelpDoc helpDoc = (HelpDoc)tuple2._2();
                        HelpDoc.setStyle$1(styles$4, "\u001b[1m");
                        HelpDoc.renderSpan$2(color$1, lastStyle$1, writer$2, uppercase$1, printedSep$3, styles$4, span);
                        HelpDoc.resetStyle$1(styles$4);
                        HelpDoc.renderNewline$1(printedSep$3, writer$2);
                        writer$2.indent(2);
                        HelpDoc.renderHelpDoc$1(writer$2, uppercase$1, printedSep$3, styles$4, color$1, lastStyle$1, helpDoc);
                        writer$2.unindent();
                        HelpDoc.renderNewline$1(printedSep$3, writer$2);
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                });
                return;
            }
            if (helpDoc2 instanceof Enumeration) {
                List<HelpDoc> list;
                Enumeration enumeration = HelpDoc$Enumeration$.MODULE$.unapply((Enumeration)helpDoc2);
                List<HelpDoc> elements = list = enumeration._1();
                ((List)elements.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        HelpDoc helpDoc = (HelpDoc)tuple2._1();
                        HelpDoc.renderText$1(color$1, lastStyle$1, writer$2, uppercase$1, printedSep$3, styles$4, "- ");
                        HelpDoc.renderHelpDoc$1(writer$2, uppercase$1, printedSep$3, styles$4, color$1, lastStyle$1, helpDoc);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                writer$2.unindent();
                return;
            }
            if (!(helpDoc2 instanceof Sequence)) break;
            Sequence sequence = HelpDoc$Sequence$.MODULE$.unapply((Sequence)helpDoc2);
            HelpDoc helpDoc3 = sequence._1();
            HelpDoc helpDoc4 = sequence._2();
            HelpDoc left = helpDoc3;
            HelpDoc right = helpDoc4;
            HelpDoc.renderHelpDoc$1(writer$2, uppercase$1, printedSep$3, styles$4, color$1, lastStyle$1, left);
            HelpDoc.renderNewline$1(printedSep$3, writer$2);
            helpDoc = right;
        }
        throw new MatchError((Object)helpDoc2);
    }

    private static void renderSpan$2(boolean color$3, ObjectRef lastStyle$3, DocWriter writer$4, BooleanRef uppercase$3, IntRef printedSep$5, ObjectRef styles$6, Span span) {
        DocWriter docWriter;
        HelpDoc.clearSep$1(printedSep$5);
        Span span2 = span;
        if (span2 instanceof Span.Text) {
            String string;
            Span.Text text = HelpDoc$Span$Text$.MODULE$.unapply((Span.Text)span2);
            String value = string = text._1();
            if (color$3) {
                String string2 = (String)lastStyle$3.elem;
                String string3 = HelpDoc.currentStyle$1(styles$6);
                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                    writer$4.append(HelpDoc.currentStyle$1(styles$6));
                    lastStyle$3.elem = HelpDoc.currentStyle$1(styles$6);
                }
            }
            docWriter = writer$4.append(uppercase$3.elem ? value.toUpperCase() : value);
        } else if (span2 instanceof Span.Code) {
            String string;
            Span.Code code = HelpDoc$Span$Code$.MODULE$.unapply((Span.Code)span2);
            String value = string = code._1();
            HelpDoc.setStyle$1(styles$6, "\u001b[37m");
            writer$4.append(value);
            HelpDoc.resetStyle$1(styles$6);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Error) {
            Span span3;
            Span.Error error = HelpDoc$Span$Error$.MODULE$.unapply((Span.Error)span2);
            Span value = span3 = error._1();
            HelpDoc.setStyle$1(styles$6, "\u001b[31m");
            HelpDoc.renderSpan$2(color$3, lastStyle$3, writer$4, uppercase$3, printedSep$5, styles$6, value);
            HelpDoc.resetStyle$1(styles$6);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Weak) {
            Span span4;
            Span.Weak weak = HelpDoc$Span$Weak$.MODULE$.unapply((Span.Weak)span2);
            Span value = span4 = weak._1();
            HelpDoc.setStyle$1(styles$6, "\u001b[1m");
            HelpDoc.renderSpan$2(color$3, lastStyle$3, writer$4, uppercase$3, printedSep$5, styles$6, value);
            HelpDoc.resetStyle$1(styles$6);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Strong) {
            Span span5;
            Span.Strong strong = HelpDoc$Span$Strong$.MODULE$.unapply((Span.Strong)span2);
            Span value = span5 = strong._1();
            HelpDoc.setStyle$1(styles$6, "\u001b[1m");
            HelpDoc.renderSpan$2(color$3, lastStyle$3, writer$4, uppercase$3, printedSep$5, styles$6, value);
            HelpDoc.resetStyle$1(styles$6);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.URI) {
            URI uRI;
            Span.URI uRI2 = HelpDoc$Span$URI$.MODULE$.unapply((Span.URI)span2);
            URI value = uRI = uRI2._1();
            HelpDoc.setStyle$1(styles$6, "\u001b[4m");
            HelpDoc.renderSpan$2(color$3, lastStyle$3, writer$4, uppercase$3, printedSep$5, styles$6, HelpDoc$Span$.MODULE$.text(value.toASCIIString()));
            HelpDoc.resetStyle$1(styles$6);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Sequence) {
            Span.Sequence sequence = HelpDoc$Span$Sequence$.MODULE$.unapply((Span.Sequence)span2);
            Span span6 = sequence._1();
            Span span7 = sequence._2();
            Span left = span6;
            Span right = span7;
            HelpDoc.renderSpan$2(color$3, lastStyle$3, writer$4, uppercase$3, printedSep$5, styles$6, left);
            HelpDoc.renderSpan$2(color$3, lastStyle$3, writer$4, uppercase$3, printedSep$5, styles$6, right);
            docWriter = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)span2);
        }
        DocWriter docWriter2 = docWriter;
    }

    public static final class DescriptionList
    implements HelpDoc,
    Product,
    Serializable {
        private final List definitions;

        public static DescriptionList apply(List<Tuple2<Span, HelpDoc>> list) {
            return HelpDoc$DescriptionList$.MODULE$.apply(list);
        }

        public static DescriptionList fromProduct(Product product) {
            return HelpDoc$DescriptionList$.MODULE$.fromProduct(product);
        }

        public static DescriptionList unapply(DescriptionList descriptionList) {
            return HelpDoc$DescriptionList$.MODULE$.unapply(descriptionList);
        }

        public DescriptionList(List<Tuple2<Span, HelpDoc>> definitions) {
            this.definitions = definitions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DescriptionList)) return false;
            DescriptionList descriptionList = (DescriptionList)object;
            List<Tuple2<Span, HelpDoc>> list = this.definitions();
            List<Tuple2<Span, HelpDoc>> list2 = descriptionList.definitions();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DescriptionList;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DescriptionList";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "definitions";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Tuple2<Span, HelpDoc>> definitions() {
            return this.definitions;
        }

        public DescriptionList copy(List<Tuple2<Span, HelpDoc>> definitions) {
            return new DescriptionList(definitions);
        }

        public List<Tuple2<Span, HelpDoc>> copy$default$1() {
            return this.definitions();
        }

        public List<Tuple2<Span, HelpDoc>> _1() {
            return this.definitions();
        }
    }

    public static final class Enumeration
    implements HelpDoc,
    Product,
    Serializable {
        private final List elements;

        public static Enumeration apply(List<HelpDoc> list) {
            return HelpDoc$Enumeration$.MODULE$.apply(list);
        }

        public static Enumeration fromProduct(Product product) {
            return HelpDoc$Enumeration$.MODULE$.fromProduct(product);
        }

        public static Enumeration unapply(Enumeration enumeration) {
            return HelpDoc$Enumeration$.MODULE$.unapply(enumeration);
        }

        public Enumeration(List<HelpDoc> elements) {
            this.elements = elements;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Enumeration)) return false;
            Enumeration enumeration = (Enumeration)object;
            List<HelpDoc> list = this.elements();
            List<HelpDoc> list2 = enumeration.elements();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Enumeration;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Enumeration";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "elements";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<HelpDoc> elements() {
            return this.elements;
        }

        public Enumeration flatten() {
            return HelpDoc$Enumeration$.MODULE$.apply((List<HelpDoc>)this.elements().flatMap(HelpDoc$::zio$cli$HelpDoc$Enumeration$$_$flatten$$anonfun$1));
        }

        public Enumeration copy(List<HelpDoc> elements) {
            return new Enumeration(elements);
        }

        public List<HelpDoc> copy$default$1() {
            return this.elements();
        }

        public List<HelpDoc> _1() {
            return this.elements();
        }
    }

    public static final class Header
    implements HelpDoc,
    Product,
    Serializable {
        private final Span value;
        private final int level;

        public static Header apply(Span span, int n) {
            return HelpDoc$Header$.MODULE$.apply(span, n);
        }

        public static Header fromProduct(Product product) {
            return HelpDoc$Header$.MODULE$.fromProduct(product);
        }

        public static Header unapply(Header header) {
            return HelpDoc$Header$.MODULE$.unapply(header);
        }

        public Header(Span value, int level) {
            this.value = value;
            this.level = level;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.value()));
            n = Statics.mix((int)n, (int)this.level());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Header)) return false;
            Header header = (Header)object;
            if (this.level() != header.level()) return false;
            Span span = this.value();
            Span span2 = header.value();
            if (span != null) {
                if (!span.equals(span2)) return false;
                return true;
            }
            if (span2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Header;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Header";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "level";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Span value() {
            return this.value;
        }

        public int level() {
            return this.level;
        }

        public Header copy(Span value, int level) {
            return new Header(value, level);
        }

        public Span copy$default$1() {
            return this.value();
        }

        public int copy$default$2() {
            return this.level();
        }

        public Span _1() {
            return this.value();
        }

        public int _2() {
            return this.level();
        }
    }

    public static final class Paragraph
    implements HelpDoc,
    Product,
    Serializable {
        private final Span value;

        public static Paragraph apply(Span span) {
            return HelpDoc$Paragraph$.MODULE$.apply(span);
        }

        public static Paragraph fromProduct(Product product) {
            return HelpDoc$Paragraph$.MODULE$.fromProduct(product);
        }

        public static Paragraph unapply(Paragraph paragraph) {
            return HelpDoc$Paragraph$.MODULE$.unapply(paragraph);
        }

        public Paragraph(Span value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Paragraph)) return false;
            Paragraph paragraph = (Paragraph)object;
            Span span = this.value();
            Span span2 = paragraph.value();
            if (span != null) {
                if (!span.equals(span2)) return false;
                return true;
            }
            if (span2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Paragraph;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Paragraph";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Span value() {
            return this.value;
        }

        public Paragraph copy(Span value) {
            return new Paragraph(value);
        }

        public Span copy$default$1() {
            return this.value();
        }

        public Span _1() {
            return this.value();
        }
    }

    public static final class Sequence
    implements HelpDoc,
    Product,
    Serializable {
        private final HelpDoc left;
        private final HelpDoc right;

        public static Sequence apply(HelpDoc helpDoc, HelpDoc helpDoc2) {
            return HelpDoc$Sequence$.MODULE$.apply(helpDoc, helpDoc2);
        }

        public static Sequence fromProduct(Product product) {
            return HelpDoc$Sequence$.MODULE$.fromProduct(product);
        }

        public static Sequence unapply(Sequence sequence) {
            return HelpDoc$Sequence$.MODULE$.unapply(sequence);
        }

        public Sequence(HelpDoc left, HelpDoc right) {
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Sequence)) return false;
            Sequence sequence = (Sequence)object;
            HelpDoc helpDoc = this.left();
            HelpDoc helpDoc2 = sequence.left();
            if (helpDoc == null) {
                if (helpDoc2 != null) {
                    return false;
                }
            } else if (!helpDoc.equals(helpDoc2)) return false;
            HelpDoc helpDoc3 = this.right();
            HelpDoc helpDoc4 = sequence.right();
            if (helpDoc3 == null) {
                if (helpDoc4 == null) return true;
                return false;
            } else {
                if (!helpDoc3.equals(helpDoc4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Sequence;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Sequence";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "left";
            }
            if (1 == n2) {
                return "right";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HelpDoc left() {
            return this.left;
        }

        public HelpDoc right() {
            return this.right;
        }

        public Sequence copy(HelpDoc left, HelpDoc right) {
            return new Sequence(left, right);
        }

        public HelpDoc copy$default$1() {
            return this.left();
        }

        public HelpDoc copy$default$2() {
            return this.right();
        }

        public HelpDoc _1() {
            return this.left();
        }

        public HelpDoc _2() {
            return this.right();
        }
    }

    public static interface Span {
        public static Span code(String string) {
            return HelpDoc$Span$.MODULE$.code(string);
        }

        public static Span empty() {
            return HelpDoc$Span$.MODULE$.empty();
        }

        public static Span error(Span span) {
            return HelpDoc$Span$.MODULE$.error(span);
        }

        public static Span error(String string) {
            return HelpDoc$Span$.MODULE$.error(string);
        }

        public static int ordinal(Span span) {
            return HelpDoc$Span$.MODULE$.ordinal(span);
        }

        public static Span space() {
            return HelpDoc$Span$.MODULE$.space();
        }

        public static Span spans(Iterable<Span> iterable) {
            return HelpDoc$Span$.MODULE$.spans(iterable);
        }

        public static Span spans(Span span, Seq<Span> seq) {
            return HelpDoc$Span$.MODULE$.spans(span, seq);
        }

        public static Span strong(Span span) {
            return HelpDoc$Span$.MODULE$.strong(span);
        }

        public static Span strong(String string) {
            return HelpDoc$Span$.MODULE$.strong(string);
        }

        public static Span uri(java.net.URI uRI) {
            return HelpDoc$Span$.MODULE$.uri(uRI);
        }

        public static Span weak(Span span) {
            return HelpDoc$Span$.MODULE$.weak(span);
        }

        public static Span weak(String string) {
            return HelpDoc$Span$.MODULE$.weak(string);
        }

        public static Span $plus$(Span $this, Span that) {
            return $this.$plus(that);
        }

        default public Span $plus(Span that) {
            return HelpDoc$Span$Sequence$.MODULE$.apply(this, that);
        }

        public static boolean isEmpty$(Span $this) {
            return $this.isEmpty();
        }

        default public boolean isEmpty() {
            return this.size() == 0;
        }

        public static int size$(Span $this) {
            return $this.size();
        }

        default public int size() {
            Span span;
            while (true) {
                Span span2;
                Span value;
                Span this_;
                if ((span = this_) instanceof Text) {
                    String string;
                    Text text = HelpDoc$Span$Text$.MODULE$.unapply((Text)span);
                    String value2 = string = text._1();
                    return value2.length();
                }
                if (span instanceof Code) {
                    String string;
                    Code code = HelpDoc$Span$Code$.MODULE$.unapply((Code)span);
                    String value3 = string = code._1();
                    return value3.length();
                }
                if (span instanceof Error) {
                    Span span3;
                    Span value4;
                    Error error = HelpDoc$Span$Error$.MODULE$.unapply((Error)span);
                    this_ = value4 = (span3 = error._1());
                    continue;
                }
                if (span instanceof Weak) {
                    Span span4;
                    Span value5;
                    Weak weak = HelpDoc$Span$Weak$.MODULE$.unapply((Weak)span);
                    this_ = value5 = (span4 = weak._1());
                    continue;
                }
                if (!(span instanceof Strong)) break;
                Strong strong = HelpDoc$Span$Strong$.MODULE$.unapply((Strong)span);
                this_ = value = (span2 = strong._1());
            }
            if (span instanceof URI) {
                java.net.URI uRI;
                URI uRI2 = HelpDoc$Span$URI$.MODULE$.unapply((URI)span);
                java.net.URI value = uRI = uRI2._1();
                return value.toString().length();
            }
            if (span instanceof Sequence) {
                Sequence sequence = HelpDoc$Span$Sequence$.MODULE$.unapply((Sequence)span);
                Span span5 = sequence._1();
                Span span6 = sequence._2();
                Span left = span5;
                Span right = span6;
                return left.size() + right.size();
            }
            throw new MatchError((Object)span);
        }

        public static String text$(Span $this) {
            return $this.text();
        }

        default public String text() {
            Span span;
            while (true) {
                Span span2;
                Span value;
                Span this_;
                if ((span = this_) instanceof Text) {
                    String string;
                    Text text = HelpDoc$Span$Text$.MODULE$.unapply((Text)span);
                    String value2 = string = text._1();
                    return value2;
                }
                if (span instanceof Code) {
                    String string;
                    Code code = HelpDoc$Span$Code$.MODULE$.unapply((Code)span);
                    String value3 = string = code._1();
                    return value3;
                }
                if (span instanceof Error) {
                    Span span3;
                    Span value4;
                    Error error = HelpDoc$Span$Error$.MODULE$.unapply((Error)span);
                    this_ = value4 = (span3 = error._1());
                    continue;
                }
                if (span instanceof Weak) {
                    Span span4;
                    Span value5;
                    Weak weak = HelpDoc$Span$Weak$.MODULE$.unapply((Weak)span);
                    this_ = value5 = (span4 = weak._1());
                    continue;
                }
                if (!(span instanceof Strong)) break;
                Strong strong = HelpDoc$Span$Strong$.MODULE$.unapply((Strong)span);
                this_ = value = (span2 = strong._1());
            }
            if (span instanceof URI) {
                java.net.URI uRI;
                URI uRI2 = HelpDoc$Span$URI$.MODULE$.unapply((URI)span);
                java.net.URI value = uRI = uRI2._1();
                return value.toString();
            }
            if (span instanceof Sequence) {
                Sequence sequence = HelpDoc$Span$Sequence$.MODULE$.unapply((Sequence)span);
                Span span5 = sequence._1();
                Span span6 = sequence._2();
                Span left = span5;
                Span right = span6;
                return new java.lang.StringBuilder(0).append(left.text()).append(right.text()).toString();
            }
            throw new MatchError((Object)span);
        }

        public static final class Code
        implements Span,
        Product,
        Serializable {
            private final String value;

            public static Code apply(String string) {
                return HelpDoc$Span$Code$.MODULE$.apply(string);
            }

            public static Code fromProduct(Product product) {
                return HelpDoc$Span$Code$.MODULE$.fromProduct(product);
            }

            public static Code unapply(Code code) {
                return HelpDoc$Span$Code$.MODULE$.unapply(code);
            }

            public Code(String value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Code)) return false;
                Code code = (Code)object;
                String string = this.value();
                String string2 = code.value();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Code;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Code";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String value() {
                return this.value;
            }

            public Code copy(String value) {
                return new Code(value);
            }

            public String copy$default$1() {
                return this.value();
            }

            public String _1() {
                return this.value();
            }
        }

        public static final class Error
        implements Span,
        Product,
        Serializable {
            private final Span value;

            public static Error apply(Span span) {
                return HelpDoc$Span$Error$.MODULE$.apply(span);
            }

            public static Error fromProduct(Product product) {
                return HelpDoc$Span$Error$.MODULE$.fromProduct(product);
            }

            public static Error unapply(Error error) {
                return HelpDoc$Span$Error$.MODULE$.unapply(error);
            }

            public Error(Span value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Error)) return false;
                Error error = (Error)object;
                Span span = this.value();
                Span span2 = error.value();
                if (span != null) {
                    if (!span.equals(span2)) return false;
                    return true;
                }
                if (span2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Error;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Error";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Span value() {
                return this.value;
            }

            public Error copy(Span value) {
                return new Error(value);
            }

            public Span copy$default$1() {
                return this.value();
            }

            public Span _1() {
                return this.value();
            }
        }

        public static final class Sequence
        implements Span,
        Product,
        Serializable {
            private final Span left;
            private final Span right;

            public static Sequence apply(Span span, Span span2) {
                return HelpDoc$Span$Sequence$.MODULE$.apply(span, span2);
            }

            public static Sequence fromProduct(Product product) {
                return HelpDoc$Span$Sequence$.MODULE$.fromProduct(product);
            }

            public static Sequence unapply(Sequence sequence) {
                return HelpDoc$Span$Sequence$.MODULE$.unapply(sequence);
            }

            public Sequence(Span left, Span right) {
                this.left = left;
                this.right = right;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Sequence)) return false;
                Sequence sequence = (Sequence)object;
                Span span = this.left();
                Span span2 = sequence.left();
                if (span == null) {
                    if (span2 != null) {
                        return false;
                    }
                } else if (!span.equals(span2)) return false;
                Span span3 = this.right();
                Span span4 = sequence.right();
                if (span3 == null) {
                    if (span4 == null) return true;
                    return false;
                } else {
                    if (!span3.equals(span4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Sequence;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "Sequence";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "left";
                }
                if (1 == n2) {
                    return "right";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Span left() {
                return this.left;
            }

            public Span right() {
                return this.right;
            }

            public Sequence copy(Span left, Span right) {
                return new Sequence(left, right);
            }

            public Span copy$default$1() {
                return this.left();
            }

            public Span copy$default$2() {
                return this.right();
            }

            public Span _1() {
                return this.left();
            }

            public Span _2() {
                return this.right();
            }
        }

        public static final class Strong
        implements Span,
        Product,
        Serializable {
            private final Span value;

            public static Strong apply(Span span) {
                return HelpDoc$Span$Strong$.MODULE$.apply(span);
            }

            public static Strong fromProduct(Product product) {
                return HelpDoc$Span$Strong$.MODULE$.fromProduct(product);
            }

            public static Strong unapply(Strong strong) {
                return HelpDoc$Span$Strong$.MODULE$.unapply(strong);
            }

            public Strong(Span value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Strong)) return false;
                Strong strong = (Strong)object;
                Span span = this.value();
                Span span2 = strong.value();
                if (span != null) {
                    if (!span.equals(span2)) return false;
                    return true;
                }
                if (span2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Strong;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Strong";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Span value() {
                return this.value;
            }

            public Strong copy(Span value) {
                return new Strong(value);
            }

            public Span copy$default$1() {
                return this.value();
            }

            public Span _1() {
                return this.value();
            }
        }

        public static final class Text
        implements Span,
        Product,
        Serializable {
            private final String value;

            public static Text apply(String string) {
                return HelpDoc$Span$Text$.MODULE$.apply(string);
            }

            public static Text fromProduct(Product product) {
                return HelpDoc$Span$Text$.MODULE$.fromProduct(product);
            }

            public static Text unapply(Text text) {
                return HelpDoc$Span$Text$.MODULE$.unapply(text);
            }

            public Text(String value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Text)) return false;
                Text text = (Text)object;
                String string = this.value();
                String string2 = text.value();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Text;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Text";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String value() {
                return this.value;
            }

            public Text copy(String value) {
                return new Text(value);
            }

            public String copy$default$1() {
                return this.value();
            }

            public String _1() {
                return this.value();
            }
        }

        public static final class URI
        implements Span,
        Product,
        Serializable {
            private final java.net.URI value;

            public static URI apply(java.net.URI uRI) {
                return HelpDoc$Span$URI$.MODULE$.apply(uRI);
            }

            public static URI fromProduct(Product product) {
                return HelpDoc$Span$URI$.MODULE$.fromProduct(product);
            }

            public static URI unapply(URI uRI) {
                return HelpDoc$Span$URI$.MODULE$.unapply(uRI);
            }

            public URI(java.net.URI value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof URI)) return false;
                URI uRI = (URI)object;
                java.net.URI uRI2 = this.value();
                java.net.URI uRI3 = uRI.value();
                if (uRI2 != null) {
                    if (!((Object)uRI2).equals(uRI3)) return false;
                    return true;
                }
                if (uRI3 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof URI;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "URI";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public java.net.URI value() {
                return this.value;
            }

            public URI copy(java.net.URI value) {
                return new URI(value);
            }

            public java.net.URI copy$default$1() {
                return this.value();
            }

            public java.net.URI _1() {
                return this.value();
            }
        }

        public static final class Weak
        implements Span,
        Product,
        Serializable {
            private final Span value;

            public static Weak apply(Span span) {
                return HelpDoc$Span$Weak$.MODULE$.apply(span);
            }

            public static Weak fromProduct(Product product) {
                return HelpDoc$Span$Weak$.MODULE$.fromProduct(product);
            }

            public static Weak unapply(Weak weak) {
                return HelpDoc$Span$Weak$.MODULE$.unapply(weak);
            }

            public Weak(Span value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Weak)) return false;
                Weak weak = (Weak)object;
                Span span = this.value();
                Span span2 = weak.value();
                if (span != null) {
                    if (!span.equals(span2)) return false;
                    return true;
                }
                if (span2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Weak;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Weak";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Span value() {
                return this.value;
            }

            public Weak copy(Span value) {
                return new Weak(value);
            }

            public Span copy$default$1() {
                return this.value();
            }

            public Span _1() {
                return this.value();
            }
        }
    }
}

