/*
 * Decompiled with CFR 0.152.
 */
package zio.cli.oauth2;

import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpRequest;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;
import zio.cli.oauth2.AccessTokenResponse;
import zio.cli.oauth2.AccessTokenResponse$;
import zio.cli.oauth2.AuthorizationResponse;
import zio.cli.oauth2.AuthorizationResponse$;
import zio.cli.oauth2.OAuth2Provider$;
import zio.cli.oauth2.OAuth2Provider$Facebook$;
import zio.cli.oauth2.OAuth2Provider$Facebook$FBAccessTokenError$;
import zio.cli.oauth2.OAuth2Provider$Facebook$FBAccessTokenErrorContent$;
import zio.cli.oauth2.OAuth2Provider$Facebook$FBAccessTokenResponse$;
import zio.cli.oauth2.OAuth2Provider$Facebook$FBAuthorizationResponse$;
import zio.cli.oauth2.OAuth2Provider$Github$;
import zio.cli.oauth2.OAuth2Provider$Google$;
import zio.cli.oauth2.OAuth2Provider$Google$GAuthorizationResponse$;
import zio.json.JsonDecoder;

public interface OAuth2Provider {
    public String name();

    public String clientIdentifier();

    public HttpRequest authorizationRequest(List<String> var1);

    public HttpRequest accessTokenRequest(AuthorizationResponse var1);

    public Option<HttpRequest> refreshTokenRequest(String var1);

    public static Either decodeAuthorizationResponse$(OAuth2Provider $this, String body) {
        return $this.decodeAuthorizationResponse(body);
    }

    default public Either<String, AuthorizationResponse> decodeAuthorizationResponse(String body) {
        return AuthorizationResponse$.MODULE$.authorizationResponseJsonDecoder().decodeJson((CharSequence)body);
    }

    public static Either decodeAccessTokenResponse$(OAuth2Provider $this, String body) {
        return $this.decodeAccessTokenResponse(body);
    }

    default public Either<String, AccessTokenResponse> decodeAccessTokenResponse(String body) {
        return AccessTokenResponse$.MODULE$.accessTokenResponseJsonDecoder().decodeJson((CharSequence)body);
    }

    public static final class Facebook
    implements OAuth2Provider,
    Product,
    Serializable {
        private final String appId;
        private final String clientToken;
        private final String name;
        private final String clientIdentifier;
        private final String fbAccessToken;

        public static Facebook apply(String string, String string2) {
            return OAuth2Provider$Facebook$.MODULE$.apply(string, string2);
        }

        public static JsonDecoder<FBAccessTokenError> fbAccessTokenError() {
            return OAuth2Provider$Facebook$.MODULE$.fbAccessTokenError();
        }

        public static JsonDecoder<FBAccessTokenErrorContent> fbAccessTokenErrorContent() {
            return OAuth2Provider$Facebook$.MODULE$.fbAccessTokenErrorContent();
        }

        public static JsonDecoder<FBAccessTokenResponse> fbAccessTokenResponse() {
            return OAuth2Provider$Facebook$.MODULE$.fbAccessTokenResponse();
        }

        public static JsonDecoder<FBAuthorizationResponse> fbAuthorizationResponseDecoder() {
            return OAuth2Provider$Facebook$.MODULE$.fbAuthorizationResponseDecoder();
        }

        public static Facebook fromProduct(Product product) {
            return OAuth2Provider$Facebook$.MODULE$.fromProduct(product);
        }

        public static Facebook unapply(Facebook facebook) {
            return OAuth2Provider$Facebook$.MODULE$.unapply(facebook);
        }

        public Facebook(String appId, String clientToken) {
            this.appId = appId;
            this.clientToken = clientToken;
            this.name = "Facebook";
            this.clientIdentifier = appId;
            this.fbAccessToken = new StringBuilder(3).append(appId).append("%7C").append(clientToken).toString();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Facebook)) return false;
            Facebook facebook = (Facebook)object;
            String string = this.appId();
            String string2 = facebook.appId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientToken();
            String string4 = facebook.clientToken();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Facebook;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Facebook";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "appId";
            }
            if (1 == n2) {
                return "clientToken";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String appId() {
            return this.appId;
        }

        public String clientToken() {
            return this.clientToken;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String clientIdentifier() {
            return this.clientIdentifier;
        }

        public String fbAccessToken() {
            return this.fbAccessToken;
        }

        @Override
        public HttpRequest authorizationRequest(List<String> scope) {
            return HttpRequest.newBuilder().uri(URI.create(new StringBuilder(65).append("https://graph.facebook.com/v2.6/device/login?access_token=").append(this.fbAccessToken()).append("&scope=").append(scope.mkString(",")).toString())).POST(HttpRequest.BodyPublishers.noBody()).build();
        }

        @Override
        public HttpRequest accessTokenRequest(AuthorizationResponse authorization) {
            return HttpRequest.newBuilder().uri(URI.create(new StringBuilder(71).append("https://graph.facebook.com/v2.6/device/login_status?access_token=").append(this.fbAccessToken()).append("&code=").append(authorization.deviceCode()).toString())).POST(HttpRequest.BodyPublishers.noBody()).build();
        }

        @Override
        public Option<HttpRequest> refreshTokenRequest(String refreshToken) {
            return None$.MODULE$;
        }

        @Override
        public Either<String, AuthorizationResponse> decodeAuthorizationResponse(String body) {
            return OAuth2Provider$Facebook$.MODULE$.fbAuthorizationResponseDecoder().decodeJson((CharSequence)body).map(OAuth2Provider$::zio$cli$oauth2$OAuth2Provider$Facebook$$_$decodeAuthorizationResponse$$anonfun$2);
        }

        @Override
        public Either<String, AccessTokenResponse> decodeAccessTokenResponse(String body) {
            Either decodeSuccess = OAuth2Provider$Facebook$.MODULE$.fbAccessTokenResponse().decodeJson((CharSequence)body).map(OAuth2Provider$::zio$cli$oauth2$OAuth2Provider$Facebook$$_$_$$anonfun$1);
            Either decodeError = OAuth2Provider$Facebook$.MODULE$.fbAccessTokenError().decodeJson((CharSequence)body).map(OAuth2Provider$::zio$cli$oauth2$OAuth2Provider$Facebook$$_$_$$anonfun$2);
            Either either = decodeError;
            if (either instanceof Right) {
                Right r = (Right)either;
                return r;
            }
            return decodeSuccess;
        }

        public Facebook copy(String appId, String clientToken) {
            return new Facebook(appId, clientToken);
        }

        public String copy$default$1() {
            return this.appId();
        }

        public String copy$default$2() {
            return this.clientToken();
        }

        public String _1() {
            return this.appId();
        }

        public String _2() {
            return this.clientToken();
        }

        public static final class FBAccessTokenError
        implements Product,
        Serializable {
            private final FBAccessTokenErrorContent error;

            public static FBAccessTokenError apply(FBAccessTokenErrorContent fBAccessTokenErrorContent) {
                return OAuth2Provider$Facebook$FBAccessTokenError$.MODULE$.apply(fBAccessTokenErrorContent);
            }

            public static FBAccessTokenError fromProduct(Product product) {
                return OAuth2Provider$Facebook$FBAccessTokenError$.MODULE$.fromProduct(product);
            }

            public static FBAccessTokenError unapply(FBAccessTokenError fBAccessTokenError) {
                return OAuth2Provider$Facebook$FBAccessTokenError$.MODULE$.unapply(fBAccessTokenError);
            }

            public FBAccessTokenError(FBAccessTokenErrorContent error) {
                this.error = error;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof FBAccessTokenError)) return false;
                FBAccessTokenError fBAccessTokenError = (FBAccessTokenError)object;
                FBAccessTokenErrorContent fBAccessTokenErrorContent = this.error();
                FBAccessTokenErrorContent fBAccessTokenErrorContent2 = fBAccessTokenError.error();
                if (fBAccessTokenErrorContent != null) {
                    if (!((Object)fBAccessTokenErrorContent).equals(fBAccessTokenErrorContent2)) return false;
                    return true;
                }
                if (fBAccessTokenErrorContent2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof FBAccessTokenError;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "FBAccessTokenError";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "error";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public FBAccessTokenErrorContent error() {
                return this.error;
            }

            public FBAccessTokenError copy(FBAccessTokenErrorContent error) {
                return new FBAccessTokenError(error);
            }

            public FBAccessTokenErrorContent copy$default$1() {
                return this.error();
            }

            public FBAccessTokenErrorContent _1() {
                return this.error();
            }
        }

        public static final class FBAccessTokenErrorContent
        implements Product,
        Serializable {
            private final String message;
            private final long errorSubcode;
            private final String errorUserMsg;

            public static FBAccessTokenErrorContent apply(String string, long l, String string2) {
                return OAuth2Provider$Facebook$FBAccessTokenErrorContent$.MODULE$.apply(string, l, string2);
            }

            public static FBAccessTokenErrorContent fromProduct(Product product) {
                return OAuth2Provider$Facebook$FBAccessTokenErrorContent$.MODULE$.fromProduct(product);
            }

            public static FBAccessTokenErrorContent unapply(FBAccessTokenErrorContent fBAccessTokenErrorContent) {
                return OAuth2Provider$Facebook$FBAccessTokenErrorContent$.MODULE$.unapply(fBAccessTokenErrorContent);
            }

            public FBAccessTokenErrorContent(String message, long errorSubcode, String errorUserMsg) {
                this.message = message;
                this.errorSubcode = errorSubcode;
                this.errorUserMsg = errorUserMsg;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.message()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.errorSubcode()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.errorUserMsg()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof FBAccessTokenErrorContent)) return false;
                FBAccessTokenErrorContent fBAccessTokenErrorContent = (FBAccessTokenErrorContent)object;
                if (this.errorSubcode() != fBAccessTokenErrorContent.errorSubcode()) return false;
                String string = this.message();
                String string2 = fBAccessTokenErrorContent.message();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = this.errorUserMsg();
                String string4 = fBAccessTokenErrorContent.errorUserMsg();
                if (string3 == null) {
                    if (string4 == null) return true;
                    return false;
                } else {
                    if (!string3.equals(string4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof FBAccessTokenErrorContent;
            }

            public int productArity() {
                return 3;
            }

            public String productPrefix() {
                return "FBAccessTokenErrorContent";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return BoxesRunTime.boxToLong((long)this._2());
                    }
                    case 2: {
                        return this._3();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "message";
                    }
                    case 1: {
                        return "errorSubcode";
                    }
                    case 2: {
                        return "errorUserMsg";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String message() {
                return this.message;
            }

            public long errorSubcode() {
                return this.errorSubcode;
            }

            public String errorUserMsg() {
                return this.errorUserMsg;
            }

            public FBAccessTokenErrorContent copy(String message, long errorSubcode, String errorUserMsg) {
                return new FBAccessTokenErrorContent(message, errorSubcode, errorUserMsg);
            }

            public String copy$default$1() {
                return this.message();
            }

            public long copy$default$2() {
                return this.errorSubcode();
            }

            public String copy$default$3() {
                return this.errorUserMsg();
            }

            public String _1() {
                return this.message();
            }

            public long _2() {
                return this.errorSubcode();
            }

            public String _3() {
                return this.errorUserMsg();
            }
        }

        public static final class FBAccessTokenResponse
        implements Product,
        Serializable {
            private final String accessToken;
            private final long expiresIn;

            public static FBAccessTokenResponse apply(String string, long l) {
                return OAuth2Provider$Facebook$FBAccessTokenResponse$.MODULE$.apply(string, l);
            }

            public static FBAccessTokenResponse fromProduct(Product product) {
                return OAuth2Provider$Facebook$FBAccessTokenResponse$.MODULE$.fromProduct(product);
            }

            public static FBAccessTokenResponse unapply(FBAccessTokenResponse fBAccessTokenResponse) {
                return OAuth2Provider$Facebook$FBAccessTokenResponse$.MODULE$.unapply(fBAccessTokenResponse);
            }

            public FBAccessTokenResponse(String accessToken, long expiresIn) {
                this.accessToken = accessToken;
                this.expiresIn = expiresIn;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.accessToken()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.expiresIn()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof FBAccessTokenResponse)) return false;
                FBAccessTokenResponse fBAccessTokenResponse = (FBAccessTokenResponse)object;
                if (this.expiresIn() != fBAccessTokenResponse.expiresIn()) return false;
                String string = this.accessToken();
                String string2 = fBAccessTokenResponse.accessToken();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof FBAccessTokenResponse;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "FBAccessTokenResponse";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "accessToken";
                }
                if (1 == n2) {
                    return "expiresIn";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String accessToken() {
                return this.accessToken;
            }

            public long expiresIn() {
                return this.expiresIn;
            }

            public FBAccessTokenResponse copy(String accessToken, long expiresIn) {
                return new FBAccessTokenResponse(accessToken, expiresIn);
            }

            public String copy$default$1() {
                return this.accessToken();
            }

            public long copy$default$2() {
                return this.expiresIn();
            }

            public String _1() {
                return this.accessToken();
            }

            public long _2() {
                return this.expiresIn();
            }
        }

        public static final class FBAuthorizationResponse
        implements Product,
        Serializable {
            private final String code;
            private final String userCode;
            private final String verificationUri;
            private final long expiresIn;
            private final long interval;

            public static FBAuthorizationResponse apply(String string, String string2, String string3, long l, long l2) {
                return OAuth2Provider$Facebook$FBAuthorizationResponse$.MODULE$.apply(string, string2, string3, l, l2);
            }

            public static FBAuthorizationResponse fromProduct(Product product) {
                return OAuth2Provider$Facebook$FBAuthorizationResponse$.MODULE$.fromProduct(product);
            }

            public static FBAuthorizationResponse unapply(FBAuthorizationResponse fBAuthorizationResponse) {
                return OAuth2Provider$Facebook$FBAuthorizationResponse$.MODULE$.unapply(fBAuthorizationResponse);
            }

            public FBAuthorizationResponse(String code, String userCode, String verificationUri, long expiresIn, long interval) {
                this.code = code;
                this.userCode = userCode;
                this.verificationUri = verificationUri;
                this.expiresIn = expiresIn;
                this.interval = interval;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.code()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userCode()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.verificationUri()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.expiresIn()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.interval()));
                return Statics.finalizeHash((int)n, (int)5);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof FBAuthorizationResponse)) return false;
                FBAuthorizationResponse fBAuthorizationResponse = (FBAuthorizationResponse)object;
                if (this.expiresIn() != fBAuthorizationResponse.expiresIn()) return false;
                if (this.interval() != fBAuthorizationResponse.interval()) return false;
                String string = this.code();
                String string2 = fBAuthorizationResponse.code();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = this.userCode();
                String string4 = fBAuthorizationResponse.userCode();
                if (string3 == null) {
                    if (string4 != null) {
                        return false;
                    }
                } else if (!string3.equals(string4)) return false;
                String string5 = this.verificationUri();
                String string6 = fBAuthorizationResponse.verificationUri();
                if (string5 == null) {
                    if (string6 == null) return true;
                    return false;
                } else {
                    if (!string5.equals(string6)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof FBAuthorizationResponse;
            }

            public int productArity() {
                return 5;
            }

            public String productPrefix() {
                return "FBAuthorizationResponse";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return BoxesRunTime.boxToLong((long)this._4());
                    }
                    case 4: {
                        return BoxesRunTime.boxToLong((long)this._5());
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "code";
                    }
                    case 1: {
                        return "userCode";
                    }
                    case 2: {
                        return "verificationUri";
                    }
                    case 3: {
                        return "expiresIn";
                    }
                    case 4: {
                        return "interval";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String code() {
                return this.code;
            }

            public String userCode() {
                return this.userCode;
            }

            public String verificationUri() {
                return this.verificationUri;
            }

            public long expiresIn() {
                return this.expiresIn;
            }

            public long interval() {
                return this.interval;
            }

            public FBAuthorizationResponse copy(String code, String userCode, String verificationUri, long expiresIn, long interval) {
                return new FBAuthorizationResponse(code, userCode, verificationUri, expiresIn, interval);
            }

            public String copy$default$1() {
                return this.code();
            }

            public String copy$default$2() {
                return this.userCode();
            }

            public String copy$default$3() {
                return this.verificationUri();
            }

            public long copy$default$4() {
                return this.expiresIn();
            }

            public long copy$default$5() {
                return this.interval();
            }

            public String _1() {
                return this.code();
            }

            public String _2() {
                return this.userCode();
            }

            public String _3() {
                return this.verificationUri();
            }

            public long _4() {
                return this.expiresIn();
            }

            public long _5() {
                return this.interval();
            }
        }
    }

    public static final class Github
    implements OAuth2Provider,
    Product,
    Serializable {
        private final String clientId;
        private final String name;
        private final String clientIdentifier;

        public static Github apply(String string) {
            return OAuth2Provider$Github$.MODULE$.apply(string);
        }

        public static Github fromProduct(Product product) {
            return OAuth2Provider$Github$.MODULE$.fromProduct(product);
        }

        public static Github unapply(Github github) {
            return OAuth2Provider$Github$.MODULE$.unapply(github);
        }

        public Github(String clientId) {
            this.clientId = clientId;
            this.name = "Github";
            this.clientIdentifier = clientId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Github)) return false;
            Github github = (Github)object;
            String string = this.clientId();
            String string2 = github.clientId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Github;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Github";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "clientId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String clientId() {
            return this.clientId;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String clientIdentifier() {
            return this.clientIdentifier;
        }

        @Override
        public HttpRequest authorizationRequest(List<String> scope) {
            return HttpRequest.newBuilder().uri(URI.create(new StringBuilder(54).append("https://github.com/login/device/code?client_id=").append(this.clientId()).append("&scope=").append(scope.mkString(",")).toString())).header("Accept", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build();
        }

        @Override
        public HttpRequest accessTokenRequest(AuthorizationResponse authorization) {
            return HttpRequest.newBuilder().uri(URI.create(new StringBuilder(123).append("https://github.com/login/oauth/access_token?client_id=").append(this.clientId()).append("&device_code=").append(authorization.deviceCode()).append("&grant_type=urn:ietf:params:oauth:grant-type:device_code").toString())).header("Accept", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build();
        }

        @Override
        public Option<HttpRequest> refreshTokenRequest(String refreshToken) {
            return Some$.MODULE$.apply((Object)HttpRequest.newBuilder().uri(URI.create(new StringBuilder(94).append("https://github.com/login/oauth/access_token?client_id=").append(this.clientId()).append("&grant_type=refresh_token&refresh_token=").append(refreshToken).toString())).header("Accept", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build());
        }

        public Github copy(String clientId) {
            return new Github(clientId);
        }

        public String copy$default$1() {
            return this.clientId();
        }

        public String _1() {
            return this.clientId();
        }
    }

    public static final class Google
    implements OAuth2Provider,
    Product,
    Serializable {
        private final String clientId;
        private final String clientSecret;
        private final String name;
        private final String clientIdentifier;

        public static Google apply(String string, String string2) {
            return OAuth2Provider$Google$.MODULE$.apply(string, string2);
        }

        public static Google fromProduct(Product product) {
            return OAuth2Provider$Google$.MODULE$.fromProduct(product);
        }

        public static JsonDecoder<GAuthorizationResponse> gAuthorizationResponseDecoder() {
            return OAuth2Provider$Google$.MODULE$.gAuthorizationResponseDecoder();
        }

        public static Google unapply(Google google) {
            return OAuth2Provider$Google$.MODULE$.unapply(google);
        }

        public Google(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.name = "Google";
            this.clientIdentifier = clientId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Google)) return false;
            Google google = (Google)object;
            String string = this.clientId();
            String string2 = google.clientId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientSecret();
            String string4 = google.clientSecret();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Google;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Google";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "clientId";
            }
            if (1 == n2) {
                return "clientSecret";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientSecret() {
            return this.clientSecret;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String clientIdentifier() {
            return this.clientIdentifier;
        }

        @Override
        public HttpRequest authorizationRequest(List<String> scope) {
            return HttpRequest.newBuilder().uri(URI.create("https://oauth2.googleapis.com/device/code")).headers("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(new StringBuilder(17).append("client_id=").append(this.clientId()).append("&scope=").append(scope.mkString("%20")).toString())).build();
        }

        @Override
        public HttpRequest accessTokenRequest(AuthorizationResponse authorization) {
            return HttpRequest.newBuilder().uri(URI.create("https://oauth2.googleapis.com/token")).headers("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(new StringBuilder(104).append("client_id=").append(this.clientId()).append("&client_secret=").append(this.clientSecret()).append("&device_code=").append(authorization.deviceCode()).append("&grant_type=urn%3Aietf%3Aparams%3Aoauth%3Agrant-type%3Adevice_code").toString())).build();
        }

        @Override
        public Option<HttpRequest> refreshTokenRequest(String refreshToken) {
            return Some$.MODULE$.apply((Object)HttpRequest.newBuilder().uri(URI.create("https://oauth2.googleapis.com/token")).headers("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(new StringBuilder(65).append("client_id=").append(this.clientId()).append("&client_secret=").append(this.clientSecret()).append("&refresh_token=").append(refreshToken).append("&grant_type=refresh_token").toString())).build());
        }

        @Override
        public Either<String, AuthorizationResponse> decodeAuthorizationResponse(String body) {
            return OAuth2Provider$Google$.MODULE$.gAuthorizationResponseDecoder().decodeJson((CharSequence)body).map(OAuth2Provider$::zio$cli$oauth2$OAuth2Provider$Google$$_$decodeAuthorizationResponse$$anonfun$1);
        }

        public Google copy(String clientId, String clientSecret) {
            return new Google(clientId, clientSecret);
        }

        public String copy$default$1() {
            return this.clientId();
        }

        public String copy$default$2() {
            return this.clientSecret();
        }

        public String _1() {
            return this.clientId();
        }

        public String _2() {
            return this.clientSecret();
        }

        public static final class GAuthorizationResponse
        implements Product,
        Serializable {
            private final String deviceCode;
            private final String userCode;
            private final String verificationUrl;
            private final long expiresIn;
            private final long interval;

            public static GAuthorizationResponse apply(String string, String string2, String string3, long l, long l2) {
                return OAuth2Provider$Google$GAuthorizationResponse$.MODULE$.apply(string, string2, string3, l, l2);
            }

            public static GAuthorizationResponse fromProduct(Product product) {
                return OAuth2Provider$Google$GAuthorizationResponse$.MODULE$.fromProduct(product);
            }

            public static GAuthorizationResponse unapply(GAuthorizationResponse gAuthorizationResponse) {
                return OAuth2Provider$Google$GAuthorizationResponse$.MODULE$.unapply(gAuthorizationResponse);
            }

            public GAuthorizationResponse(String deviceCode, String userCode, String verificationUrl, long expiresIn, long interval) {
                this.deviceCode = deviceCode;
                this.userCode = userCode;
                this.verificationUrl = verificationUrl;
                this.expiresIn = expiresIn;
                this.interval = interval;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.deviceCode()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userCode()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.verificationUrl()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.expiresIn()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.interval()));
                return Statics.finalizeHash((int)n, (int)5);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof GAuthorizationResponse)) return false;
                GAuthorizationResponse gAuthorizationResponse = (GAuthorizationResponse)object;
                if (this.expiresIn() != gAuthorizationResponse.expiresIn()) return false;
                if (this.interval() != gAuthorizationResponse.interval()) return false;
                String string = this.deviceCode();
                String string2 = gAuthorizationResponse.deviceCode();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = this.userCode();
                String string4 = gAuthorizationResponse.userCode();
                if (string3 == null) {
                    if (string4 != null) {
                        return false;
                    }
                } else if (!string3.equals(string4)) return false;
                String string5 = this.verificationUrl();
                String string6 = gAuthorizationResponse.verificationUrl();
                if (string5 == null) {
                    if (string6 == null) return true;
                    return false;
                } else {
                    if (!string5.equals(string6)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof GAuthorizationResponse;
            }

            public int productArity() {
                return 5;
            }

            public String productPrefix() {
                return "GAuthorizationResponse";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return BoxesRunTime.boxToLong((long)this._4());
                    }
                    case 4: {
                        return BoxesRunTime.boxToLong((long)this._5());
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "deviceCode";
                    }
                    case 1: {
                        return "userCode";
                    }
                    case 2: {
                        return "verificationUrl";
                    }
                    case 3: {
                        return "expiresIn";
                    }
                    case 4: {
                        return "interval";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String deviceCode() {
                return this.deviceCode;
            }

            public String userCode() {
                return this.userCode;
            }

            public String verificationUrl() {
                return this.verificationUrl;
            }

            public long expiresIn() {
                return this.expiresIn;
            }

            public long interval() {
                return this.interval;
            }

            public GAuthorizationResponse copy(String deviceCode, String userCode, String verificationUrl, long expiresIn, long interval) {
                return new GAuthorizationResponse(deviceCode, userCode, verificationUrl, expiresIn, interval);
            }

            public String copy$default$1() {
                return this.deviceCode();
            }

            public String copy$default$2() {
                return this.userCode();
            }

            public String copy$default$3() {
                return this.verificationUrl();
            }

            public long copy$default$4() {
                return this.expiresIn();
            }

            public long copy$default$5() {
                return this.interval();
            }

            public String _1() {
                return this.deviceCode();
            }

            public String _2() {
                return this.userCode();
            }

            public String _3() {
                return this.verificationUrl();
            }

            public long _4() {
                return this.expiresIn();
            }

            public long _5() {
                return this.interval();
            }
        }
    }
}

