/*
 * Decompiled with CFR 0.152.
 */
package zio.direct.core.util;

import java.io.Serializable;
import scala.runtime.ModuleSerializationProxy;
import zio.direct.core.util.Messages;

public final class Messages$
implements Serializable {
    private static final String ImplicitsNotAllowed;
    private static final String DeclarationNotAllowedWithRuns;
    private static final String RunRemainingAfterTransformer;
    private static final String ForeignRunRemainingAfterTransformer;
    private static final String UtilityRemainingAfterTransformer;
    private static final String UnsafeRemainingAfterTransformer;
    private static final String UnsafeNotAllowedParallel;
    private static final String LinearNotAllowedParallel;
    private static final String parallelExplanation;
    private static final String MutableAndLazyVariablesNotAllowed;
    private static final String DeclarationNotAllowed;
    private static final String RunAssignmentNotRecommended;
    private static final String RunInRunError;
    private static final String AssignmentNotAllowed;
    private static final String MoveRunOut;
    private static final String MoveOutOfDefer;
    public static final Messages$ MODULE$;

    private Messages$() {
    }

    static {
        MODULE$ = new Messages$();
        ImplicitsNotAllowed = MODULE$.StringExt("\nImplicits are not allowed inside defer clauses (they are allowed inside of `run(...)` blocks.\n").trimLeft();
        DeclarationNotAllowedWithRuns = MODULE$.StringExt("\nIn Lenient mode, Class, Function, and Mutable-Variable, and Lazy-Variable definitions are\nallowed but only so long as they do not direclty read runs. If you want to assign the\nvalue `run(...)` block to a variable, read into a val first.\n=========\nInstead of doing somethiing like this:\n  defer {\n    var i = ZIO.succeed(10).run\n    while (i - 2 >= 0) {\n      println(s\"Currently: $i\")\n      i = ZIO.succeed(i - 1).run\n    }\n  }\nConsider doing something like this:\n  defer {\n    var initial = ZIO.succeed(10).run\n    var i = initial\n    while (i - 2 > 0) {\n      println(\"Value:\" + i)\n      val update = ZIO.succeed(i - 1).run\n      i = update\n    }\n  }\n").trimLeft();
        RunRemainingAfterTransformer = MODULE$.StringExt("\nInvocations of an evaluation function e.g. `run(...)` (or `op.run`) were detected even after all the transformations\nof zio-direct were completed. That means that zio-direct cannot successfully process the input you have passed into it.\nTry to use defer.verbose to examine the tree structure in order to understand what is wrong or submit a bug-report\nat https://github.com/zio/zio-direct.\n").trimLeft();
        ForeignRunRemainingAfterTransformer = MODULE$.StringExt("\nInvocations of an evaluation function e.g. `run(...)` (or `op.run`) of a DIFFERENT kind of defer-function were detected even\nafter all the transformations of zio-direct were completed. That means that zio-direct cannot successfully process the input\nyou have passed into it. Make sure that you are using the correct evaluation function for the kind of defer that you are using,\nfor example in zio-streams, the evaluation function is `.each` e.g. `ZStream(1,2,3).each`. For ZPure it is `.eval`.\n").trimLeft();
        UtilityRemainingAfterTransformer = MODULE$.StringExt("\nInvocations of a utility-call remained after all the transformations of zio-direct were completed. This typically\nmeans that an invalid function-call is invoked for the kind of `defer` that you are using.\n").trimLeft();
        UnsafeRemainingAfterTransformer = MODULE$.StringExt("\nInvocations of `unsafe(...)` were detected even after all the transformations of zio-direct were completed.\nThat means that zio-direct cannot successfully process the input you have passed into it. Try to use defer.verbose\nto examine the tree structure in order to understand what is wrong or submit a bug-report\nat https://github.com/zio/zio-direct.\n").trimLeft();
        UnsafeNotAllowedParallel = new StringBuilder(0).append(MODULE$.StringExt("\nStatements that mix `run(...)` calls with other expressions in the same line\nare not allowed in `unsafe { ... }` blocks.\n").trimLeft()).append(MODULE$.parallelExplanation()).toString();
        LinearNotAllowedParallel = new StringBuilder(0).append(MODULE$.StringExt("\nStatements that mix `run(...)` calls with other expressions in the same line\nare not allowed in Linear-mode defer blocks i.e. `defer.linear { ... }`.\n").trimLeft()).append(MODULE$.parallelExplanation()).toString();
        parallelExplanation = MODULE$.StringExt("\nOnly code that does either a run, or a simple statement is allowed on each line here.\nThis enhanced restriction is made for the sake of correctness.\nFor Example:\n// Not allowed:\nval x = 123 + ZIO.succeed(456).run + 789\n// Change it to:\nval x0 = ZIO.succeed(456).run\nval x = 123 + x0 + 789\n\nThere are certain exceptions to this rule such as if there are pure-values\nthat come only after the effect execution (e.g. `ZIO.succeed(123).run + 456`)\nand in such cases compilation will succeed and nothing further needs to be done.\nFollow the above rule whenever errors occur.\n").trimLeft();
        MutableAndLazyVariablesNotAllowed = MODULE$.StringExt("\nMutable and Lazy Variables are not allowed inside of a defer\nblock unless they are in a ZIO effect inside of a `run` call.\n========\nFor example you cannot do this:\nvar x = 123\ndefer {\n  val y = x\n}\nHowever, you CAN do this:\nvar x = 123\ndefer {\n  ZIO.succeed { val y = x; y }.run\n}\nThis rule is enfoced for the sake of correctness.\n").trimLeft();
        DeclarationNotAllowed = MODULE$.StringExt("\nClass, Function, and Mutable-Variable. Lazy-Variable definitions\n(class X, def X, var X, lazy val X) are not allowed inside of defer blocks unless\nthey are inside of a ZIO effect in a `run(ZIO)` call.\nPlease move them outside of the defer area.\n").trimLeft();
        RunAssignmentNotRecommended = MODULE$.StringExt("\nUsing Assignment inside of run(...:ZIO) sections is permitted but not recommended,\n(outside of an `run` call they are forbidden entirely). Consider using immutable\nvariables or ZIO Refs if mutability is essential.\n=========\nInstead of doing somethiing like this:\n  defer.verbose {\n    var i = ZIO.succeed(10).run\n    while (ZIO.succeed(i - 2).run >= 0) {\n      println(s\"Currently: $i\")\n      ZIO.succeed { i = i -1 }.run\n    }\n  }\nConsider doing something like this:\n  defer.verbose {\n    var i = Ref.make(10).run\n    while (i.get.run - 2)) > 0) {\n      println(\"Value:\" + i.get.run)\n      i.getAndUpdate(i => i - 1).run\n    }\n  }\n").trimLeft();
        RunInRunError = MODULE$.StringExt("\nAn run cannot be inside an run. In order to do this,\nwrite the content of the outer run into a variable first.\n=========\nFor example:\n  run(run(ZIO.succeed  { if (foo) ZIO.succeed(x) else ZIO.succeed(y) }))\nChange it to:\n  val a = run(ZIO.succeed  { if (foo) ZIO.succeed(x) else ZIO.succeed(y) })\n  run(a)\n").trimLeft();
        AssignmentNotAllowed = "\nAssignment is generally not allowed inside of defer calls,\nbecause it can cause correctness problems with the\nsynthesized code if it directly reads the result\nof a `run(...)` call or interacts with other\neffects in `run(...)` clauses.\nPlease use a ZIO Ref instead.\n=========\nFor example, instead of this:\ndefer {\n\tval i = run(numCalls)\n\twhile (i > 0) {\n\t\tprintln(\"Value:\" + i)\n\t\ti = i - 1\n\t}\n}\nDo this:\ndefer.verbose {\n  var i = run(Ref.make(10))\n  while (run(i.get) - 2) > 0) {\n    println(\"Value:\" + run(i.get))\n    run(i.getAndUpdate(i => i - 1))\n  }\n}\n";
        MoveRunOut = MODULE$.StringExt("\nMove the `run` call outside of this structure in order to use it.\n=========\nFor example, change this:\n  defer {\n    def getUrl = run(httpGet(someUrl))\n    service.lookup(getUrl)\n  }\nTo this:\n  defer {\n    val result = run(httpGet(someUrl))\n    def getUrl = result\n    service.lookup(getUrl)\n  }\n\nIn some cases you should move the object out of the defer block entirely.\nFor example, change this:\n  defer {\n    def getUrl(url: String) = run(httpGet(url))\n    service.lookup(getUrl(someStr))\n  }\nTo this:\n  def getUrl(url: String) = httpGet(url)\n  defer {\n    val result = run(getUrl(someUrl))\n    service.lookup(result)\n  }\n").trimLeft();
        MoveOutOfDefer = MODULE$.StringExt("\nMove the construct outside of the `defer` clause in order to use it.\n=========\nFor example, change this:\n  defer {\n    class MyClass(val value: String)\n    run(ZIO.succeed(new MyClass(\"test\").value))\n  }\nTo this:\n  class MyClass(val value: String)\n  defer\n    run(ZIO.succeed(new MyClass(\"test\").value))\n  }\n\nAnother example, change this:\n  defer {\n    def getUrl(url: String) = run(httpGet(url))\n    service.lookup(getUrl(someStr))\n  }\nTo this:\n  def getUrl(url: String) = httpGet(url)\n  defer {\n    val result = run(getUrl(someUrl))\n    service.lookup(result)\n  }\n").trimLeft();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Messages$.class);
    }

    public final Messages.StringExt StringExt(String str) {
        return new Messages.StringExt(str);
    }

    public String ImplicitsNotAllowed() {
        return ImplicitsNotAllowed;
    }

    public String MutableCollectionDetected(String name) {
        return this.StringExt(new StringBuilder(226).append("\nDetected the use of a mutable collection inside a defer clause (called: ").append(name).append(").\nMutable collections can cause many potential issues as a result of defer-clause\nrewrites so they are not allowed (Unless it is inside of a run-call).\n").toString()).trimLeft();
    }

    public String DeclarationNotAllowedWithRuns() {
        return DeclarationNotAllowedWithRuns;
    }

    public String RunRemainingAfterTransformer() {
        return RunRemainingAfterTransformer;
    }

    public String ForeignRunRemainingAfterTransformer() {
        return ForeignRunRemainingAfterTransformer;
    }

    public String UtilityRemainingAfterTransformer() {
        return UtilityRemainingAfterTransformer;
    }

    public String UnsafeRemainingAfterTransformer() {
        return UnsafeRemainingAfterTransformer;
    }

    public String UnsafeNotAllowedParallel() {
        return UnsafeNotAllowedParallel;
    }

    public String LinearNotAllowedParallel() {
        return LinearNotAllowedParallel;
    }

    public String parallelExplanation() {
        return parallelExplanation;
    }

    public String MutableAndLazyVariablesNotAllowed() {
        return MutableAndLazyVariablesNotAllowed;
    }

    public String DeclarationNotAllowed() {
        return DeclarationNotAllowed;
    }

    public String RunAssignmentNotRecommended() {
        return RunAssignmentNotRecommended;
    }

    public String RunInRunError() {
        return RunInRunError;
    }

    public String AssignmentNotAllowed() {
        return AssignmentNotAllowed;
    }

    public String MoveRunOut() {
        return MoveRunOut;
    }

    public String MoveOutOfDefer() {
        return MoveOutOfDefer;
    }
}

