/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Exit;
import zio.Exit$;
import zio.FiberFailure;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ErrorResponseConfig$;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Server;
import zio.http.Status;
import zio.http.Status$SwitchingProtocols$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyResponseEncoder$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.socket.NettySocketProtocol$;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\r}a!\u0002\u001c8\u0005vz\u0004\u0002C.\u0001\u0005+\u0007I\u0011A/\t\u0011\u0019\u0004!\u0011#Q\u0001\nyC\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tc\u0002\u0011\t\u0012)A\u0005S\"A!\u000f\u0001B\u0001B\u0003-1\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0005\u0002\f\u0001\u0011\r\u0011b\u0003\u0002\u000e!A\u0011q\u0003\u0001!\u0002\u0013\ty\u0001C\u0006\u0002\u001a\u0001\u0001\r\u00111A\u0005\n\u0005m\u0001bCA\u0018\u0001\u0001\u0007\t\u0019!C\u0005\u0003cA1\"!\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e!Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011BA!\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%I!!\u0014\t\u0017\u0005E\u0003\u00011A\u0001B\u0003&\u00111\t\u0005\n\u0003'\u0002!\u0019!C\u0001\u0003+B\u0001\"a\u001c\u0001A\u0003%\u0011q\u000b\u0005\n\u0003c\u0002!\u0019!C\u0005\u0003gB\u0001\"a\u001f\u0001A\u0003%\u0011Q\u000f\u0005\n\u0003{\u0002!\u0019!C\u0005\u0003gB\u0001\"a \u0001A\u0003%\u0011Q\u000f\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\t)\t\u0001C\u0005\u0003\u0007C\u0011\"a\"\u0001\u0005\u0004%I!!#\t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u0017Cq!a%\u0001\t\u0003\n)\nC\u0004\u0002&\u0002!\t%a*\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAk\u0001\u0011%\u0011q\u001b\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013AqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003,\u0001!IA!\f\t\u000f\t}\u0002\u0001\"\u0003\u0003B!I!Q\t\u0001\u0002\u0002\u0013\u0005!q\t\u0005\n\u0005#\u0002\u0011\u0013!C\u0001\u0005'B\u0011B!\u001b\u0001#\u0003%\tAa\u001b\t\u0013\t=\u0004!!A\u0005B\tE\u0004\"\u0003B@\u0001\u0005\u0005I\u0011\u0001BA\u0011%\u0011I\tAA\u0001\n\u0003\u0011Y\tC\u0005\u0003\u0010\u0002\t\t\u0011\"\u0011\u0003\u0012\"I!q\u0014\u0001\u0002\u0002\u0013\u0005!\u0011\u0015\u0005\n\u0005K\u0003\u0011\u0011!C!\u0005OC\u0011B!+\u0001\u0003\u0003%\tEa+\t\u0013\t5\u0006!!A\u0005B\t=v\u0001\u0003Bho!\u0005QH!5\u0007\u000fY:\u0004\u0012A\u001f\u0003T\"1ap\fC\u0001\u00057D\u0011B!80\u0005\u0004%\tAa8\t\u0011\t]x\u0006)A\u0005\u0005CD\u0011B!?0\u0003\u0003%\tIa?\t\u0013\r\u0015q&!A\u0005\u0002\u000e\u001d\u0001\"CB\u000b_\u0005\u0005I\u0011BB\f\u0005Q\u0019VM\u001d<fe&s'm\\;oI\"\u000bg\u000e\u001a7fe*\u0011\u0001(O\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005iZ\u0014!\u00028fiRL(B\u0001\u001f>\u0003\u0011AG\u000f\u001e9\u000b\u0003y\n1A_5p'\u0011\u0001\u0001I\u0015-\u0011\u0007\u0005;\u0015*D\u0001C\u0015\t\u0019E)A\u0004dQ\u0006tg.\u001a7\u000b\u0005i*%\"\u0001$\u0002\u0005%|\u0017B\u0001%C\u0005m\u0019\u0016.\u001c9mK\u000eC\u0017M\u001c8fY&s'm\\;oI\"\u000bg\u000e\u001a7feB\u0011!\nU\u0007\u0002\u0017*\u0011A\b\u0014\u0006\u0003\u001b:\u000bQaY8eK\u000eT!a\u0014#\u0002\u000f!\fg\u000e\u001a7fe&\u0011\u0011k\u0013\u0002\u000b\u0011R$\bo\u00142kK\u000e$\bCA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&a\u0002)s_\u0012,8\r\u001e\t\u0003'fK!A\u0017+\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\r\u0005\u0004\bOU3g\u0007\u0001)\u0012A\u0018\t\u0003?\u000et!\u0001Y1\u000e\u0003]J!AY\u001c\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\u0007\u0003B\u0004(+\u001a4\u000b\u0005\t<\u0014aB1qaJ+g\rI\u0001\u0007G>tg-[4\u0016\u0003%\u0004\"A\u001b8\u000f\u0005-dW\"A\u001e\n\u00055\\\u0014AB*feZ,'/\u0003\u0002pa\n11i\u001c8gS\u001eT!!\\\u001e\u0002\u000f\r|gNZ5hA\u0005)AO]1dKB\u0011Ao\u001f\b\u0003kjt!A^=\u000e\u0003]T!\u0001\u001f/\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014B\u00012>\u0013\taXPA\u0003Ue\u0006\u001cWM\u0003\u0002c{\u00051A(\u001b8jiz\"b!!\u0001\u0002\b\u0005%A\u0003BA\u0002\u0003\u000b\u0001\"\u0001\u0019\u0001\t\u000bI4\u00019A:\t\u000bm3\u0001\u0019\u00010\t\u000b\u001d4\u0001\u0019A5\u0002\rUt7/\u00194f+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005MQ\"A\u001f\n\u0007\u0005UQH\u0001\u0004V]N\fg-Z\u0001\bk:\u001c\u0018MZ3!\u0003\r\t\u0007\u000f]\u000b\u0003\u0003;\u0001ra[A\u0010\u0003G\tI#C\u0002\u0002\"m\u0012aAU8vi\u0016\u001c\bcA*\u0002&%\u0019\u0011q\u0005+\u0003\u0007\u0005s\u0017\u0010E\u0002l\u0003WI1!!\f<\u0005!\u0011Vm\u001d9p]N,\u0017aB1qa~#S-\u001d\u000b\u0005\u0003g\tI\u0004E\u0002T\u0003kI1!a\u000eU\u0005\u0011)f.\u001b;\t\u0013\u0005m\"\"!AA\u0002\u0005u\u0011a\u0001=%c\u0005!\u0011\r\u001d9!\u0003\u001d\u0011XO\u001c;j[\u0016,\"!a\u0011\u0011\t\u0005\u0015\u0013qI\u0007\u0002s%\u0019\u0011\u0011J\u001d\u0003\u00199+G\u000f^=Sk:$\u0018.\\3\u0002\u0017I,h\u000e^5nK~#S-\u001d\u000b\u0005\u0003g\ty\u0005C\u0005\u0002<5\t\t\u00111\u0001\u0002D\u0005A!/\u001e8uS6,\u0007%\u0001\tj]\u001ac\u0017n\u001a5u%\u0016\fX/Z:ugV\u0011\u0011q\u000b\t\u0005\u00033\nY'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0019\tGo\\7jG*!\u0011\u0011MA2\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003K\n9'\u0001\u0003vi&d'BAA5\u0003\u0011Q\u0017M^1\n\t\u00055\u00141\f\u0002\n\u0019>tw-\u00113eKJ\f\u0011#\u001b8GY&<\u0007\u000e\u001e*fcV,7\u000f^:!\u00039\u0011X-\u00193DY&,g\u000e^\"feR,\"!!\u001e\u0011\u0007M\u000b9(C\u0002\u0002zQ\u0013qAQ8pY\u0016\fg.A\bsK\u0006$7\t\\5f]R\u001cUM\u001d;!\u0003E\tgo\\5e\u0007RD8k^5uG\"LgnZ\u0001\u0013CZ|\u0017\u000eZ\"uqN;\u0018\u000e^2iS:<\u0007%\u0001\u0006sK\u001a\u0014Xm\u001d5BaB$\"!a\r\u0002\u0019\u0015t7/\u001e:f\u0011\u0006\u001c\u0018\t\u001d9\u0002\u001dI,G.Z1tKJ+\u0017/^3tiV\u0011\u00111\u0012\t\u0006'\u00065\u00151G\u0005\u0004\u0003\u001f#&!\u0003$v]\u000e$\u0018n\u001c81\u0003=\u0011X\r\\3bg\u0016\u0014V-];fgR\u0004\u0013\u0001D2iC:tW\r\u001c*fC\u0012\u0004DCBA\u001a\u0003/\u000b\t\u000bC\u0004\u0002\u001af\u0001\r!a'\u0002\u0007\r$\b\u0010E\u0002B\u0003;K1!a(C\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDa!a)\u001a\u0001\u0004I\u0015aA7tO\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0004\u00024\u0005%\u00161\u0016\u0005\b\u00033S\u0002\u0019AAN\u0011\u001d\tiK\u0007a\u0001\u0003_\u000bQaY1vg\u0016\u0004B!!-\u0002::!\u00111WA\\\u001d\r1\u0018QW\u0005\u0002+&\u0011!\rV\u0005\u0005\u0003w\u000biLA\u0005UQJ|w/\u00192mK*\u0011!\rV\u0001\u0014C\u0012$\u0017i]=oG\n{G-\u001f%b]\u0012dWM\u001d\u000b\u0005\u0003\u0007\fI\r\u0005\u0003\u0002F\u0005\u0015\u0017bAAds\ty\u0011i]=oG\n{G-\u001f*fC\u0012,'\u000fC\u0004\u0002\u001an\u0001\r!a'\u0002!\u0005$H/Z7qi\u001a\u000b7\u000f^,sSR,GCBA;\u0003\u001f\f\t\u000eC\u0004\u0002\u001ar\u0001\r!a'\t\u000f\u0005MG\u00041\u0001\u0002*\u0005A!/Z:q_:\u001cX-\u0001\tbiR,W\u000e\u001d;Gk2dwK]5uKRQ\u0011\u0011\\At\u0003S\fY/!<\u0011\u000bQ\fY.a8\n\u0007\u0005uWP\u0001\u0003UCN\\\u0007#B*\u0002b\u0006\u0015\u0018bAAr)\n1q\n\u001d;j_:\u0004R\u0001^An\u0003gAq!!'\u001e\u0001\u0004\tY\nC\u0004\u0002@u\u0001\r!a\u0011\t\u000f\u0005MW\u00041\u0001\u0002*!9\u0011q^\u000fA\u0002\u0005E\u0018a\u0002:fcV,7\u000f\u001e\t\u0004W\u0006M\u0018bAA{w\t9!+Z9vKN$\u0018!F1ui\u0016l\u0007\u000f^%n[\u0016$\u0017.\u0019;f/JLG/\u001a\u000b\u0007\u0003k\nY0!@\t\u000f\u0005ee\u00041\u0001\u0002\u001c\"9\u0011q \u0010A\u0002\t\u0005\u0011\u0001B3ySR\u0004\"\"!\u0005\u0003\u0004\u0005\r\u0012\u0011FA\u0015\u0013\r\u0011)!\u0010\u0002\u00045&{\u0015AD7bW\u0016T\u0016n\u001c*fcV,7\u000f\u001e\u000b\u0007\u0003c\u0014YA!\u0004\t\u000f\u0005eu\u00041\u0001\u0002\u001c\"9!qB\u0010A\u0002\tE\u0011\u0001\u00038fiRL(+Z9\u0011\u0007)\u0013\u0019\"C\u0002\u0003\u0016-\u00131\u0002\u0013;uaJ+\u0017/^3ti\u0006\u0011R\u000f]4sC\u0012,Gk\\,fEN{7m[3u))\t)Oa\u0007\u0003\u001e\t}!\u0011\u0006\u0005\b\u00033\u0003\u0003\u0019AAN\u0011\u001d\ty\u000f\ta\u0001\u0003cDqA!\t!\u0001\u0004\u0011\u0019#\u0001\u0007xK\n\u001cvnY6fi\u0006\u0003\b\u000fE\u0003l\u0005K\t\u0019#C\u0002\u0003(m\u0012AbV3c'>\u001c7.\u001a;BaBDq!a\u0010!\u0001\u0004\t\u0019%A\u0007xe&$XMU3ta>t7/\u001a\u000b\u000b\u0005_\u0011)Da\u000e\u0003:\tmB\u0003BA\u001a\u0005cAqAa\r\"\u0001\u0004\tY)A\u0004f]N,(/\u001a3\t\u000f\u0005e\u0015\u00051\u0001\u0002\u001c\"9\u0011qH\u0011A\u0002\u0005\r\u0003bBA\u0000C\u0001\u0007!\u0011\u0001\u0005\b\u0005{\t\u0003\u0019AAy\u0003\r\u0011X-]\u0001\u0019o&$\b\u000eR3gCVdG/\u0012:s_J\u0014Vm\u001d9p]N,G\u0003BA\u0015\u0005\u0007Bq!!,#\u0001\u0004\ty+\u0001\u0003d_BLHC\u0002B%\u0005\u001b\u0012y\u0005\u0006\u0003\u0002\u0004\t-\u0003\"\u0002:$\u0001\b\u0019\bbB.$!\u0003\u0005\rA\u0018\u0005\bO\u000e\u0002\n\u00111\u0001j\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u0016+\u0007y\u00139f\u000b\u0002\u0003ZA!!1\fB3\u001b\t\u0011iF\u0003\u0003\u0003`\t\u0005\u0014!C;oG\",7m[3e\u0015\r\u0011\u0019\u0007V\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B4\u0005;\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u001c+\u0007%\u00149&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005g\u0002BA!\u001e\u0003|5\u0011!q\u000f\u0006\u0005\u0005s\n9'\u0001\u0003mC:<\u0017\u0002\u0002B?\u0005o\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001BB!\r\u0019&QQ\u0005\u0004\u0005\u000f#&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0012\u0005\u001bC\u0011\"a\u000f)\u0003\u0003\u0005\rAa!\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa%\u0011\r\tU%1TA\u0012\u001b\t\u00119JC\u0002\u0003\u001aR\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iJa&\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003k\u0012\u0019\u000bC\u0005\u0002<)\n\t\u00111\u0001\u0002$\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\u0004\u0006AAo\\*ue&tw\r\u0006\u0002\u0003t\u00051Q-];bYN$B!!\u001e\u00032\"I\u00111H\u0017\u0002\u0002\u0003\u0007\u00111\u0005\u0015\u0004\u0001\tU\u0006\u0003\u0002B\\\u0005\u0013tAA!/\u0003F:!!1\u0018Bb\u001d\u0011\u0011iL!1\u000f\u0007Y\u0014y,C\u0001G\u0013\tQT)\u0003\u0002D\t&\u0019!q\u0019\"\u0002\u001d\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe&!!1\u001aBg\u0005!\u0019\u0006.\u0019:bE2,'b\u0001Bd\u0005\u0006!2+\u001a:wKJLeNY8v]\u0012D\u0015M\u001c3mKJ\u0004\"\u0001Y\u0018\u0014\t=\u0012)\u000e\u0017\t\u0004'\n]\u0017b\u0001Bm)\n1\u0011I\\=SK\u001a$\"A!5\u0002\t1Lg/Z\u000b\u0003\u0005C\u0004\"\"!\u0005\u0003d\n\u001d(\u0011_A\u0002\u0013\r\u0011)/\u0010\u0002\u000752\u000b\u00170\u001a:\u0011\u000bQ\u0014IOX5\n\t\t-(Q\u001e\u0002\u0005I\u0005l\u0007/C\u0002\u0003pv\u0012a#\u00138uKJ\u001cXm\u0019;j_:$\u0016\u0010]3D_6\u0004\u0018\r\u001e\t\u0004'\nM\u0018b\u0001B{)\n9aj\u001c;iS:<\u0017!\u00027jm\u0016\u0004\u0013!B1qa2LHC\u0002B\u007f\u0007\u0003\u0019\u0019\u0001\u0006\u0003\u0002\u0004\t}\b\"\u0002:4\u0001\b\u0019\b\"B.4\u0001\u0004q\u0006\"B44\u0001\u0004I\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u0013\u0019\t\u0002E\u0003T\u0003C\u001cY\u0001E\u0003T\u0007\u001bq\u0016.C\u0002\u0004\u0010Q\u0013a\u0001V;qY\u0016\u0014\u0004\"CB\ni\u0005\u0005\t\u0019AA\u0002\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004\u001aA!!QOB\u000e\u0013\u0011\u0019iBa\u001e\u0003\r=\u0013'.Z2u\u0001")
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
scala.Serializable {
    private final AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef;
    private final Server.Config config;
    private final Object trace;
    private final Unsafe unsafe;
    private Routes<Object, Response> app;
    private NettyRuntime runtime;
    private final LongAdder inFlightRequests;
    private final boolean readClientCert;
    private final boolean avoidCtxSwitching;
    private final Function0<BoxedUnit> releaseRequest;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Server.Config>> unapply(ServerInboundHandler serverInboundHandler) {
        return ServerInboundHandler$.MODULE$.unapply(serverInboundHandler);
    }

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference, Server.Config config, Object object) {
        return ServerInboundHandler$.MODULE$.apply(atomicReference, config, object);
    }

    public static ZLayer<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Nothing$, ServerInboundHandler> live() {
        return ServerInboundHandler$.MODULE$.live();
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef() {
        return this.appRef;
    }

    public Server.Config config() {
        return this.config;
    }

    private Unsafe unsafe() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 49");
        }
        return this.unsafe;
    }

    private Routes<Object, Response> app() {
        return this.app;
    }

    private void app_$eq(Routes<Object, Response> x$1) {
        this.app = x$1;
    }

    private NettyRuntime runtime() {
        return this.runtime;
    }

    private void runtime_$eq(NettyRuntime x$1) {
        this.runtime = x$1;
    }

    public LongAdder inFlightRequests() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 54");
        }
        return this.inFlightRequests;
    }

    private boolean readClientCert() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 55");
        }
        return this.readClientCert;
    }

    private boolean avoidCtxSwitching() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 56");
        }
        return this.avoidCtxSwitching;
    }

    public void refreshApp() {
        Tuple2<Routes<Object, Response>, Runtime<Object>> pair = this.appRef().get();
        this.app_$eq((Routes)pair._1());
        this.runtime_$eq(new NettyRuntime((Runtime<Object>)((Runtime)pair._2())));
    }

    private void ensureHasApp() {
        if (this.runtime() == null) {
            this.refreshApp();
            return;
        }
    }

    private Function0<BoxedUnit> releaseRequest() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 71");
        }
        return this.releaseRequest;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.inFlightRequests().increment();
            this.ensureHasApp();
            try {
                if (httpRequest.decoderResult().isFailure()) {
                    Throwable throwable = httpRequest.decoderResult().cause();
                    this.attemptFastWrite(ctx, Response$.MODULE$.fromThrowable(throwable, this.runtime().getRef(ErrorResponseConfig$.MODULE$.configRef())));
                    this.releaseRequest().apply$mcV$sp();
                } else {
                    Request req = this.makeZioRequest(ctx, httpRequest);
                    ZIO<Object, Response, Response> exit = this.app().apply(req, (Predef.$less$colon$less<Response, Response>)Predef$.MODULE$.$conforms());
                    if (this.attemptImmediateWrite(ctx, exit)) {
                        this.releaseRequest().apply$mcV$sp();
                    } else {
                        this.writeResponse(ctx, this.runtime(), exit, req, this.releaseRequest());
                    }
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)httpRequest);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ctx.fireChannelRead((Object)httpContent);
            return;
        }
        throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String msg;
        if (cause instanceof IOException && (msg = ((IOException)cause).getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.runtime() != null && this.config().logWarningOnFatalError()) {
            this.runtime().unsafeRunSync(ZIO$.MODULE$.logWarningCause((Function0 & Serializable & scala.Serializable)() -> "Fatal exception in Netty", (Function0 & Serializable & scala.Serializable)() -> Cause$.MODULE$.die(cause, Cause$.MODULE$.die$default$2()), this.trace), this.unsafe(), this.trace);
        }
        if (cause instanceof ReadTimeoutException) {
            ctx.close();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private AsyncBodyReader addAsyncBodyHandler(ChannelHandlerContext ctx) {
        ServerAsyncBodyHandler handler = new ServerAsyncBodyHandler();
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)handler);
        return handler;
    }

    private boolean attemptFastWrite(ChannelHandlerContext ctx, Response response) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
            try {
                return this.fastEncode$1(response, unsafeBytes.unsafeAsArray(this.unsafe()), ctx);
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    return this.fastEncode$1(this.withDefaultErrorResponse(e), Array$.MODULE$.emptyByteArray(), ctx);
                }
                throw throwable;
            }
        }
        return false;
    }

    private ZIO<Object, Throwable, Option<ZIO<Object, Throwable, BoxedUnit>>> attemptFullWrite(ChannelHandlerContext ctx, NettyRuntime runtime, Response response, Request request) {
        Body body = response.body();
        if (body instanceof Body.WebsocketBody) {
            WebSocketApp<Object> socketApp = ((Body.WebsocketBody)body).socketApp();
            Status status = response.status();
            Status$SwitchingProtocols$ status$SwitchingProtocols$ = Status$SwitchingProtocols$.MODULE$;
            if (!(status != null ? !status.equals(status$SwitchingProtocols$) : status$SwitchingProtocols$ != null)) {
                return this.upgradeToWebSocket(ctx, request, socketApp, runtime).as((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, this.trace);
            }
        }
        return ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> {
            HttpResponse jResponse = NettyResponseEncoder$.MODULE$.encode(response, this.unsafe());
            if (!(jResponse instanceof FullHttpResponse)) {
                String string = jResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                None$ contentLength = string == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(string)).toLong()));
                ctx.writeAndFlush((Object)jResponse);
                return NettyBodyWriter$.MODULE$.writeAndFlush(response.body(), (Option<Object>)contentLength, ctx, $this.trace);
            }
            ctx.writeAndFlush((Object)jResponse);
            return None$.MODULE$;
        }, this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, ZIO<Object, Response, Response> exit) {
        Response response;
        if (exit instanceof Exit.Success && (response = (Response)((Exit.Success)exit).value()) != null) {
            return this.attemptFastWrite(ctx, response);
        }
        return false;
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        None$ none$;
        None$ none$2;
        Version version;
        HttpVersion nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (!(httpVersion != null ? !httpVersion.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
            version = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion2 = HttpVersion.HTTP_1_1;
            if (!(httpVersion2 != null ? !httpVersion2.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
                version = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        Version$Http_1_0$ protocolVersion = version;
        if (this.readClientCert()) {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            none$2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sslHandler.engine().getSession().getPeerCertificates())).headOption();
        } else {
            none$2 = None$.MODULE$;
        }
        None$ clientCert = none$2;
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)inetSocketAddress.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteAddress = none$;
        Headers headers = Conversions$.MODULE$.headersFromNetty(nettyReq.headers());
        Option<Object> contentTypeHeader = headers.get(Header$ContentType$.MODULE$);
        if (nettyReq instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyReq;
            Body x$1 = NettyBody$.MODULE$.fromByteBuf(fullHttpRequest.content(), contentTypeHeader);
            Method x$3 = Conversions$.MODULE$.methodFromNetty(fullHttpRequest.method());
            URL x$4 = (URL)URL$.MODULE$.decode(fullHttpRequest.uri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> URL$.MODULE$.empty());
            return new Request(protocolVersion, x$3, x$4, headers, x$1, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        Option knownContentLength = headers.get(Header$ContentLength$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.length()));
        AsyncBodyReader handler = this.addAsyncBodyHandler(ctx);
        Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(Function1 & Serializable & scala.Serializable)async -> {
            handler.connect(async);
            return BoxedUnit.UNIT;
        }, (Option<Object>)knownContentLength, contentTypeHeader);
        Method x$10 = Conversions$.MODULE$.methodFromNetty(nettyReq.method());
        URL x$11 = (URL)URL$.MODULE$.decode(nettyReq.uri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> URL$.MODULE$.empty());
        return new Request(protocolVersion, x$10, x$11, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
    }

    private ZIO<Object, Throwable, BoxedUnit> upgradeToWebSocket(ChannelHandlerContext ctx, Request request, WebSocketApp<Object> webSocketApp, NettyRuntime runtime) {
        return Promise$.MODULE$.make(this.trace).flatMap((Function1 & Serializable & scala.Serializable)handshakeCompleted -> Queue$.MODULE$.unbounded($this.trace).tap((Function1 & Serializable & scala.Serializable)queue -> ZIO$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(ctx.channel());
            Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted);
            return webSocketApp.handler().runZIO(webSocketChannel).ignoreLogged($this.trace).forkDaemon($this.trace);
        }, $this.trace), $this.trace).flatMap((Function1 & Serializable & scala.Serializable)queue -> ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> {
            ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder((WebSocketConfig)webSocketApp.customConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.config().webSocketConfig())).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted, (Option<Promise<Throwable, ChannelState>>)None$.MODULE$, $this.trace));
            DefaultFullHttpRequest jReq = new DefaultFullHttpRequest(Conversions$.MODULE$.versionToNetty(request.version()), Conversions$.MODULE$.methodToNetty(request.method()), Conversions$.MODULE$.urlToNetty(request.url()));
            jReq.headers().setAll(Conversions$.MODULE$.headersToNetty(request.allHeaders()));
            return ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)jReq));
        }, $this.trace).map((Function1 & Serializable & scala.Serializable)_ -> {
            ServerInboundHandler.$anonfun$upgradeToWebSocket$8(_);
            return BoxedUnit.UNIT;
        }, $this.trace), $this.trace), this.trace);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyRuntime runtime, ZIO<Object, Response, Response> exit, Request req, Function0<BoxedUnit> ensured) {
        ZIO program = exit.foldCauseZIO((Function1 & Serializable & scala.Serializable)x$3 -> {
            boolean bl = false;
            Right right = null;
            Either either = x$3.failureOrCause();
            if (either instanceof Left) {
                Response resp = (Response)((Left)either).value();
                return this.writeResponse$1(resp, ctx, runtime, req);
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                if (((Cause)right.value()).isInterruptedOnly()) {
                    return this.closeChannel$1(ctx);
                }
            }
            if (bl) {
                Cause c = (Cause)right.value();
                return this.writeResponse$1(this.withDefaultErrorResponse((Throwable)new FiberFailure(c)), ctx, runtime, req);
            }
            throw new MatchError((Object)either);
        }, (Function1 & Serializable & scala.Serializable)response -> this.writeResponse$1((Response)response, ctx, runtime, req), this.trace);
        runtime.run(ctx, ensured, this.avoidCtxSwitching(), (ZIO<Object, Throwable, Object>)program, this.unsafe(), this.trace);
    }

    private Response withDefaultErrorResponse(Throwable cause) {
        return Response$.MODULE$.internalServerError(cause.getMessage());
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return new ServerInboundHandler(appRef, config, trace);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> copy$default$1() {
        return this.appRef();
    }

    public Server.Config copy$default$2() {
        return this.config();
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.appRef();
            }
            case 1: {
                return this.config();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerInboundHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof ServerInboundHandler)) break block3;
                ServerInboundHandler serverInboundHandler = (ServerInboundHandler)((Object)x$1);
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference = this.appRef();
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference2 = serverInboundHandler.appRef();
                if (atomicReference != null ? !atomicReference.equals(atomicReference2) : atomicReference2 != null) break block3;
                Server.Config config = this.config();
                Server.Config config2 = serverInboundHandler.config();
                if (config != null ? !((Object)config).equals(config2) : config2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private final boolean fastEncode$1(Response response, byte[] bytes, ChannelHandlerContext ctx$1) {
        FullHttpResponse djResponse = NettyResponseEncoder$.MODULE$.fastEncode(response, bytes, this.unsafe()).retainedDuplicate();
        ctx$1.writeAndFlush((Object)djResponse, ctx$1.voidPromise());
        return true;
    }

    public static final /* synthetic */ void $anonfun$upgradeToWebSocket$8(Future _) {
    }

    private final ZIO closeChannel$1(ChannelHandlerContext ctx$4) {
        return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable & scala.Serializable)() -> ctx$4.channel().close(), this.trace);
    }

    private final ZIO writeResponse$1(Response response, ChannelHandlerContext ctx$4, NettyRuntime runtime$2, Request req$1) {
        if (this.attemptFastWrite(ctx$4, response)) {
            return Exit$.MODULE$.unit();
        }
        return this.attemptFullWrite(ctx$4, runtime$2, response, req$1).foldCauseZIO((Function1 & Serializable & scala.Serializable)cause -> {
            this.attemptFastWrite(ctx$4, this.withDefaultErrorResponse(cause.squash(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()))));
            return Exit$.MODULE$.unit();
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return Exit$.MODULE$.unit();
            }
            if (x0$1 instanceof Some) {
                return ((ZIO)((Some)x0$1).value()).orElse((Function0 & Serializable & scala.Serializable)() -> this.closeChannel$1(ctx$4), CanFail$.MODULE$.canFail(), $this.trace);
            }
            throw new MatchError(x0$1);
        }, this.trace);
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.trace = trace;
        super(false);
        Product.$init$((Product)this);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.inFlightRequests = new LongAdder();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.readClientCert = config.sslConfig().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.includeClientCert()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.avoidCtxSwitching = config.avoidContextSwitching();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.releaseRequest = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.inFlightRequests().decrement();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

