/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.model;

import com.aayushatharva.brotli4j.encoder.Encoder;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import java.io.Serializable;
import java.util.Map;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.UninitializedFieldError;
import scala.collection.AbstractIterator;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import zio.http.Header;
import zio.http.Header$SetCookie$;
import zio.http.Headers;
import zio.http.Headers$Empty$;
import zio.http.Method;
import zio.http.Method$ANY$;
import zio.http.Method$CONNECT$;
import zio.http.Method$DELETE$;
import zio.http.Method$GET$;
import zio.http.Method$HEAD$;
import zio.http.Method$OPTIONS$;
import zio.http.Method$PATCH$;
import zio.http.Method$POST$;
import zio.http.Method$PUT$;
import zio.http.Method$TRACE$;
import zio.http.Scheme;
import zio.http.Scheme$HTTP$;
import zio.http.Scheme$HTTPS$;
import zio.http.Scheme$WS$;
import zio.http.Scheme$WSS$;
import zio.http.Server;
import zio.http.Server$Config$CompressionOptions$Mode$Font$;
import zio.http.Server$Config$CompressionOptions$Mode$Generic$;
import zio.http.Server$Config$CompressionOptions$Mode$Text$;
import zio.http.Status;
import zio.http.Status$;
import zio.http.Version;
import zio.http.Version$Default$;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;

public final class Conversions$ {
    public static Conversions$ MODULE$;

    static {
        new Conversions$();
    }

    public Method methodFromNetty(HttpMethod method2) {
        HttpMethod httpMethod = HttpMethod.OPTIONS;
        if (!(httpMethod != null ? !httpMethod.equals(method2) : method2 != null)) {
            return Method$OPTIONS$.MODULE$;
        }
        HttpMethod httpMethod2 = HttpMethod.GET;
        if (!(httpMethod2 != null ? !httpMethod2.equals(method2) : method2 != null)) {
            return Method$GET$.MODULE$;
        }
        HttpMethod httpMethod3 = HttpMethod.HEAD;
        if (!(httpMethod3 != null ? !httpMethod3.equals(method2) : method2 != null)) {
            return Method$HEAD$.MODULE$;
        }
        HttpMethod httpMethod4 = HttpMethod.POST;
        if (!(httpMethod4 != null ? !httpMethod4.equals(method2) : method2 != null)) {
            return Method$POST$.MODULE$;
        }
        HttpMethod httpMethod5 = HttpMethod.PUT;
        if (!(httpMethod5 != null ? !httpMethod5.equals(method2) : method2 != null)) {
            return Method$PUT$.MODULE$;
        }
        HttpMethod httpMethod6 = HttpMethod.PATCH;
        if (!(httpMethod6 != null ? !httpMethod6.equals(method2) : method2 != null)) {
            return Method$PATCH$.MODULE$;
        }
        HttpMethod httpMethod7 = HttpMethod.DELETE;
        if (!(httpMethod7 != null ? !httpMethod7.equals(method2) : method2 != null)) {
            return Method$DELETE$.MODULE$;
        }
        HttpMethod httpMethod8 = HttpMethod.TRACE;
        if (!(httpMethod8 != null ? !httpMethod8.equals(method2) : method2 != null)) {
            return Method$TRACE$.MODULE$;
        }
        HttpMethod httpMethod9 = HttpMethod.CONNECT;
        if (!(httpMethod9 != null ? !httpMethod9.equals(method2) : method2 != null)) {
            return Method$CONNECT$.MODULE$;
        }
        return new Method.CUSTOM(method2.name());
    }

    public HttpMethod methodToNetty(Method method2) {
        if (Method$OPTIONS$.MODULE$.equals(method2)) {
            return HttpMethod.OPTIONS;
        }
        if (Method$GET$.MODULE$.equals(method2)) {
            return HttpMethod.GET;
        }
        if (Method$HEAD$.MODULE$.equals(method2)) {
            return HttpMethod.HEAD;
        }
        if (Method$POST$.MODULE$.equals(method2)) {
            return HttpMethod.POST;
        }
        if (Method$PUT$.MODULE$.equals(method2)) {
            return HttpMethod.PUT;
        }
        if (Method$PATCH$.MODULE$.equals(method2)) {
            return HttpMethod.PATCH;
        }
        if (Method$DELETE$.MODULE$.equals(method2)) {
            return HttpMethod.DELETE;
        }
        if (Method$TRACE$.MODULE$.equals(method2)) {
            return HttpMethod.TRACE;
        }
        if (Method$CONNECT$.MODULE$.equals(method2)) {
            return HttpMethod.CONNECT;
        }
        if (Method$ANY$.MODULE$.equals(method2)) {
            return HttpMethod.GET;
        }
        if (method2 instanceof Method.CUSTOM) {
            String name = ((Method.CUSTOM)method2).name();
            return new HttpMethod(name);
        }
        throw new MatchError((Object)method2);
    }

    public HttpHeaders headersToNetty(Headers headers) {
        if (headers instanceof Headers.FromIterable) {
            return this.encodeHeaderListToNetty(headers);
        }
        if (headers instanceof Headers.Native) {
            return (HttpHeaders)((Headers.Native)headers).value();
        }
        if (headers instanceof Headers.Concat) {
            return this.encodeHeaderListToNetty(headers);
        }
        if (Headers$Empty$.MODULE$.equals(headers)) {
            return new DefaultHttpHeaders();
        }
        throw new MatchError((Object)headers);
    }

    private Iterator<Header> nettyHeadersIterator(HttpHeaders headers) {
        return new AbstractIterator<Header>(headers){
            private final java.util.Iterator<Map.Entry<CharSequence, CharSequence>> nettyIterator;
            private volatile boolean bitmap$init$0;

            private java.util.Iterator<Map.Entry<CharSequence, CharSequence>> nettyIterator() {
                if (!this.bitmap$init$0) {
                    throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/model/Conversions.scala: 69");
                }
                return this.nettyIterator;
            }

            public boolean hasNext() {
                return this.nettyIterator().hasNext();
            }

            public Header next() {
                Map.Entry<CharSequence, CharSequence> entry = this.nettyIterator().next();
                return new Header.Custom(entry.getKey(), entry.getValue());
            }
            {
                this.nettyIterator = headers$1.iteratorCharSequence();
                this.bitmap$init$0 = true;
            }
        };
    }

    public Headers headersFromNetty(HttpHeaders headers2) {
        return new Headers.Native<HttpHeaders>(headers2, (Function1 & Serializable & scala.Serializable)headers -> MODULE$.nettyHeadersIterator((HttpHeaders)headers), (Function2 & Serializable & scala.Serializable)(headers, key) -> headers.get(key), (Function2 & Serializable & scala.Serializable)(headers, key) -> BoxesRunTime.boxToBoolean((boolean)headers.contains(key)));
    }

    private HttpHeaders encodeHeaderListToNetty(Iterable<Header> headers) {
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders();
        String setCookieName = Header$SetCookie$.MODULE$.name();
        for (Header header : headers) {
            String name;
            String string = name = header.headerName();
            if (!(string != null ? !string.equals(setCookieName) : setCookieName != null)) {
                nettyHeaders.add(name, (Object)header.renderedValueAsCharSequence());
                continue;
            }
            nettyHeaders.set(name, (Object)header.renderedValueAsCharSequence());
        }
        return nettyHeaders;
    }

    public HttpResponseStatus statusToNetty(Status status) {
        return HttpResponseStatus.valueOf((int)status.code());
    }

    public Status statusFromNetty(HttpResponseStatus status) {
        return Status$.MODULE$.fromInt(status.code());
    }

    public Option<HttpScheme> schemeToNetty(Scheme scheme) {
        if (Scheme$HTTP$.MODULE$.equals(scheme)) {
            return Option$.MODULE$.apply((Object)HttpScheme.HTTP);
        }
        if (Scheme$HTTPS$.MODULE$.equals(scheme)) {
            return Option$.MODULE$.apply((Object)HttpScheme.HTTPS);
        }
        return None$.MODULE$;
    }

    public Option<WebSocketScheme> schemeToNettyWebSocketScheme(Scheme scheme) {
        if (Scheme$WS$.MODULE$.equals(scheme)) {
            return Option$.MODULE$.apply((Object)WebSocketScheme.WS);
        }
        if (Scheme$WSS$.MODULE$.equals(scheme)) {
            return Option$.MODULE$.apply((Object)WebSocketScheme.WSS);
        }
        return None$.MODULE$;
    }

    public Option<Scheme> schemeFromNetty(HttpScheme scheme) {
        HttpScheme httpScheme = HttpScheme.HTTPS;
        if (!(httpScheme != null ? !httpScheme.equals(scheme) : scheme != null)) {
            return Option$.MODULE$.apply((Object)Scheme$HTTPS$.MODULE$);
        }
        HttpScheme httpScheme2 = HttpScheme.HTTP;
        if (!(httpScheme2 != null ? !httpScheme2.equals(scheme) : scheme != null)) {
            return Option$.MODULE$.apply((Object)Scheme$HTTP$.MODULE$);
        }
        return None$.MODULE$;
    }

    public Option<Scheme> schemeFromNetty(WebSocketScheme scheme) {
        WebSocketScheme webSocketScheme = WebSocketScheme.WSS;
        if (!(webSocketScheme != null ? !webSocketScheme.equals(scheme) : scheme != null)) {
            return Option$.MODULE$.apply((Object)Scheme$WSS$.MODULE$);
        }
        WebSocketScheme webSocketScheme2 = WebSocketScheme.WS;
        if (!(webSocketScheme2 != null ? !webSocketScheme2.equals(scheme) : scheme != null)) {
            return Option$.MODULE$.apply((Object)Scheme$WS$.MODULE$);
        }
        return None$.MODULE$;
    }

    public CompressionOptions compressionOptionsToNetty(Server.Config.CompressionOptions compressionOptions) {
        if (compressionOptions instanceof Server.Config.CompressionOptions.GZip) {
            Server.Config.CompressionOptions.DeflateConfig cfg = ((Server.Config.CompressionOptions.GZip)compressionOptions).cfg();
            return StandardCompressionOptions.gzip((int)cfg.level(), (int)cfg.bits(), (int)cfg.mem());
        }
        if (compressionOptions instanceof Server.Config.CompressionOptions.Deflate) {
            Server.Config.CompressionOptions.DeflateConfig cfg = ((Server.Config.CompressionOptions.Deflate)compressionOptions).cfg();
            return StandardCompressionOptions.deflate((int)cfg.level(), (int)cfg.bits(), (int)cfg.mem());
        }
        if (compressionOptions instanceof Server.Config.CompressionOptions.Brotli) {
            Server.Config.CompressionOptions.BrotliConfig cfg = ((Server.Config.CompressionOptions.Brotli)compressionOptions).cfg();
            return StandardCompressionOptions.brotli((Encoder.Parameters)new Encoder.Parameters().setQuality(cfg.quality()).setWindow(cfg.lgwin()).setMode(this.brotliModeToJava(cfg.mode())));
        }
        throw new MatchError((Object)compressionOptions);
    }

    public Encoder.Mode brotliModeToJava(Server.Config.CompressionOptions.Mode brotli) {
        if (Server$Config$CompressionOptions$Mode$Font$.MODULE$.equals(brotli)) {
            return Encoder.Mode.FONT;
        }
        if (Server$Config$CompressionOptions$Mode$Text$.MODULE$.equals(brotli)) {
            return Encoder.Mode.TEXT;
        }
        if (Server$Config$CompressionOptions$Mode$Generic$.MODULE$.equals(brotli)) {
            return Encoder.Mode.GENERIC;
        }
        throw new MatchError((Object)brotli);
    }

    public HttpVersion versionToNetty(Version version) {
        if (Version$Http_1_0$.MODULE$.equals(version)) {
            return HttpVersion.HTTP_1_0;
        }
        if (Version$Http_1_1$.MODULE$.equals(version)) {
            return HttpVersion.HTTP_1_1;
        }
        if (Version$Default$.MODULE$.equals(version)) {
            return HttpVersion.HTTP_1_1;
        }
        throw new MatchError((Object)version);
    }

    private Conversions$() {
        MODULE$ = this;
    }
}

