/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.util.Using;
import zio.http.ClientAuth;
import zio.http.ClientAuth$Optional$;
import zio.http.ClientAuth$Required$;
import zio.http.SSLConfig;
import zio.http.SSLConfig$Data$Generate$;
import zio.http.netty.server.SSLUtil;

public final class SSLUtil$ {
    public static SSLUtil$ MODULE$;

    static {
        new SSLUtil$();
    }

    public io.netty.handler.ssl.ClientAuth getClientAuth(ClientAuth clientAuth) {
        if (ClientAuth$Required$.MODULE$.equals(clientAuth)) {
            return io.netty.handler.ssl.ClientAuth.REQUIRE;
        }
        if (ClientAuth$Optional$.MODULE$.equals(clientAuth)) {
            return io.netty.handler.ssl.ClientAuth.OPTIONAL;
        }
        return io.netty.handler.ssl.ClientAuth.NONE;
    }

    public SSLUtil.SslContextBuilderOps SslContextBuilderOps(SslContextBuilder self) {
        return new SSLUtil.SslContextBuilderOps(self);
    }

    public SslContext buildSslServerContext(SSLConfig sslConfig, InputStream certInputStream, InputStream keyInputStream, Option<InputStream> trustCertCollectionPath) {
        SslContextBuilder sslServerContext = SslContextBuilder.forServer((InputStream)certInputStream, (InputStream)keyInputStream);
        trustCertCollectionPath.foreach((Function1 & Serializable & scala.Serializable)stream -> sslServerContext.trustManager(stream));
        return this.SslContextBuilderOps(sslServerContext).buildWithDefaultOptions(sslConfig);
    }

    public SslContext sslConfigToSslContext(SSLConfig sslConfig) {
        SSLConfig.Data data = sslConfig.data();
        if (SSLConfig$Data$Generate$.MODULE$.equals(data)) {
            SelfSignedCertificate selfSigned = new SelfSignedCertificate();
            return this.SslContextBuilderOps(SslContextBuilder.forServer((PrivateKey)selfSigned.key(), (X509Certificate[])new X509Certificate[]{selfSigned.cert()})).buildWithDefaultOptions(sslConfig);
        }
        if (data instanceof SSLConfig.Data.FromFile) {
            SSLConfig.Data.FromFile fromFile = (SSLConfig.Data.FromFile)data;
            String certPath = fromFile.certPath();
            String keyPath = fromFile.keyPath();
            Option<String> trustCertCollectionPath = fromFile.trustCertCollectionPath();
            return (SslContext)Using.Manager$.MODULE$.apply((Function1 & Serializable & scala.Serializable)use -> {
                FileInputStream certInputStream = (FileInputStream)use.apply((Object)new FileInputStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                FileInputStream keyInputStream = (FileInputStream)use.apply((Object)new FileInputStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Option trustCertInputStream = trustCertCollectionPath.map((Function1 & Serializable & scala.Serializable)path -> (FileInputStream)use.apply((Object)new FileInputStream((String)path), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                return MODULE$.buildSslServerContext(sslConfig, certInputStream, keyInputStream, (Option<InputStream>)trustCertInputStream);
            }).get();
        }
        if (data instanceof SSLConfig.Data.FromResource) {
            SSLConfig.Data.FromResource fromResource = (SSLConfig.Data.FromResource)data;
            String certPath = fromResource.certPath();
            String keyPath = fromResource.keyPath();
            Option<String> trustCertCollectionPath = fromResource.trustCertCollectionPath();
            ClassLoader classLoader = this.getClass().getClassLoader();
            return (SslContext)Using.Manager$.MODULE$.apply((Function1 & Serializable & scala.Serializable)use -> {
                InputStream certInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                InputStream keyInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Option trustCertInputStream = trustCertCollectionPath.map((Function1 & Serializable & scala.Serializable)path -> (InputStream)use.apply((Object)classLoader.getResourceAsStream((String)path), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                return MODULE$.buildSslServerContext(sslConfig, certInputStream, keyInputStream, (Option<InputStream>)trustCertInputStream);
            }).get();
        }
        throw new MatchError((Object)data);
    }

    private SSLUtil$() {
        MODULE$ = this;
    }
}

