/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Cause$;
import zio.Exit;
import zio.FiberFailure;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Server;
import zio.http.Status;
import zio.http.Status$SwitchingProtocols$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyResponseEncoder$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.client.NettyRequestEncoder$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.socket.NettySocketProtocol$;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\r-b!\u0002\u001c8\u0005vz\u0004\u0002C.\u0001\u0005+\u0007I\u0011A/\t\u0011\u0019\u0004!\u0011#Q\u0001\nyC\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tc\u0002\u0011\t\u0012)A\u0005S\"A!\u000f\u0001B\u0001B\u0003-1\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0005\u0002\f\u0001\u0011\r\u0011b\u0003\u0002\u000e!A\u0011q\u0003\u0001!\u0002\u0013\ty\u0001C\u0006\u0002\u001a\u0001\u0001\r\u00111A\u0005\n\u0005m\u0001bCA\u0018\u0001\u0001\u0007\t\u0019!C\u0005\u0003cA1\"!\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e!Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011BA!\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%I!!\u0014\t\u0017\u0005E\u0003\u00011A\u0001B\u0003&\u00111\t\u0005\n\u0003'\u0002!\u0019!C\u0001\u0003+B\u0001\"a\u001c\u0001A\u0003%\u0011q\u000b\u0005\n\u0003c\u0002!\u0019!C\u0005\u0003gB\u0001\"a\u001f\u0001A\u0003%\u0011Q\u000f\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\t\t\t\u0001C\u0005\u0003\u007fB\u0011\"a!\u0001\u0005\u0004%I!!\"\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u000fCq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\b\u0003g\u0004A\u0011BA{\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bAqAa\u0005\u0001\t\u0013\u0011)\u0002C\u0004\u0003(\u0001!IA!\u000b\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B)\u0001\u0011%!1\u000b\u0005\n\u0005/\u0002\u0011\u0011!C\u0001\u00053B\u0011Ba\u0019\u0001#\u0003%\tA!\u001a\t\u0013\tm\u0004!%A\u0005\u0002\tu\u0004\"\u0003BA\u0001\u0005\u0005I\u0011\tBB\u0011%\u0011\t\nAA\u0001\n\u0003\u0011\u0019\nC\u0005\u0003\u001c\u0002\t\t\u0011\"\u0001\u0003\u001e\"I!\u0011\u0015\u0001\u0002\u0002\u0013\u0005#1\u0015\u0005\n\u0005c\u0003\u0011\u0011!C\u0001\u0005gC\u0011Ba.\u0001\u0003\u0003%\tE!/\t\u0013\tm\u0006!!A\u0005B\tu\u0006\"\u0003B`\u0001\u0005\u0005I\u0011\tBa\u000f!\u0011\to\u000eE\u0001{\t\rha\u0002\u001c8\u0011\u0003i$Q\u001d\u0005\u0007}>\"\tA!<\t\u0013\t=xF1A\u0005\u0002\tE\b\u0002CB\u0002_\u0001\u0006IAa=\t\u0013\r\u0015q&!A\u0005\u0002\u000e\u001d\u0001\"CB\t_\u0005\u0005I\u0011QB\n\u0011%\u0019\tcLA\u0001\n\u0013\u0019\u0019C\u0001\u000bTKJ4XM]%oE>,h\u000e\u001a%b]\u0012dWM\u001d\u0006\u0003qe\naa]3sm\u0016\u0014(B\u0001\u001e<\u0003\u0015qW\r\u001e;z\u0015\taT(\u0001\u0003iiR\u0004(\"\u0001 \u0002\u0007iLwn\u0005\u0003\u0001\u0001JC\u0006cA!H\u00136\t!I\u0003\u0002D\t\u000691\r[1o]\u0016d'B\u0001\u001eF\u0015\u00051\u0015AA5p\u0013\tA%IA\u000eTS6\u0004H.Z\"iC:tW\r\\%oE>,h\u000e\u001a%b]\u0012dWM\u001d\t\u0003\u0015Bk\u0011a\u0013\u0006\u0003y1S!!\u0014(\u0002\u000b\r|G-Z2\u000b\u0005=#\u0015a\u00025b]\u0012dWM]\u0005\u0003#.\u0013!\u0002\u0013;ua>\u0013'.Z2u!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\u001d\u0001&o\u001c3vGR\u0004\"aU-\n\u0005i#&\u0001D*fe&\fG.\u001b>bE2,\u0017AB1qaJ+gm\u0001\u0001\u0016\u0003y\u0003\"aX2\u000f\u0005\u0001\fW\"A\u001c\n\u0005\t<\u0014a\u00029bG.\fw-Z\u0005\u0003I\u0016\u0014a!\u00119q%\u00164'B\u000128\u0003\u001d\t\u0007\u000f\u001d*fM\u0002\naaY8oM&<W#A5\u0011\u0005)tgBA6m\u001b\u0005Y\u0014BA7<\u0003\u0019\u0019VM\u001d<fe&\u0011q\u000e\u001d\u0002\u0007\u0007>tg-[4\u000b\u00055\\\u0014aB2p]\u001aLw\rI\u0001\u0006iJ\f7-\u001a\t\u0003int!!\u001e>\u000f\u0005YLX\"A<\u000b\u0005ad\u0016A\u0002\u001fs_>$h(C\u0001?\u0013\t\u0011W(\u0003\u0002}{\n)AK]1dK*\u0011!-P\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0005\u0005\u0011qAA\u0005)\u0011\t\u0019!!\u0002\u0011\u0005\u0001\u0004\u0001\"\u0002:\u0007\u0001\b\u0019\b\"B.\u0007\u0001\u0004q\u0006\"B4\u0007\u0001\u0004I\u0017AB;og\u00064W-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\n\u001b\u0005i\u0014bAA\u000b{\t1QK\\:bM\u0016\fq!\u001e8tC\u001a,\u0007%A\u0002baB,\"!!\b\u0011\u000f-\fy\"a\t\u0002*%\u0019\u0011\u0011E\u001e\u0003\rI{W\u000f^3t!\r\u0019\u0016QE\u0005\u0004\u0003O!&aA!osB\u00191.a\u000b\n\u0007\u000552H\u0001\u0005SKN\u0004xN\\:f\u0003\u001d\t\u0007\u000f]0%KF$B!a\r\u0002:A\u00191+!\u000e\n\u0007\u0005]BK\u0001\u0003V]&$\b\"CA\u001e\u0015\u0005\u0005\t\u0019AA\u000f\u0003\rAH%M\u0001\u0005CB\u0004\b%A\u0004sk:$\u0018.\\3\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u000fj\u0011!O\u0005\u0004\u0003\u0013J$\u0001\u0004(fiRL(+\u001e8uS6,\u0017a\u0003:v]RLW.Z0%KF$B!a\r\u0002P!I\u00111H\u0007\u0002\u0002\u0003\u0007\u00111I\u0001\teVtG/[7fA\u0005\u0001\u0012N\u001c$mS\u001eDGOU3rk\u0016\u001cHo]\u000b\u0003\u0003/\u0002B!!\u0017\u0002l5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003C\n\u0019'\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u001a\u0002h\u0005!Q\u000f^5m\u0015\t\tI'\u0001\u0003kCZ\f\u0017\u0002BA7\u00037\u0012\u0011\u0002T8oO\u0006#G-\u001a:\u0002#%tg\t\\5hQR\u0014V-];fgR\u001c\b%\u0001\bsK\u0006$7\t\\5f]R\u001cUM\u001d;\u0016\u0005\u0005U\u0004cA*\u0002x%\u0019\u0011\u0011\u0010+\u0003\u000f\t{w\u000e\\3b]\u0006y!/Z1e\u00072LWM\u001c;DKJ$\b%\u0001\u0006sK\u001a\u0014Xm\u001d5BaB$\"!a\r\u0002\u0019\u0015t7/\u001e:f\u0011\u0006\u001c\u0018\t\u001d9\u0002\u001dI,G.Z1tKJ+\u0017/^3tiV\u0011\u0011q\u0011\t\u0006'\u0006%\u00151G\u0005\u0004\u0003\u0017#&!\u0003$v]\u000e$\u0018n\u001c81\u0003=\u0011X\r\\3bg\u0016\u0014V-];fgR\u0004\u0013\u0001D2iC:tW\r\u001c*fC\u0012\u0004DCBA\u001a\u0003'\u000bi\nC\u0004\u0002\u0016^\u0001\r!a&\u0002\u0007\r$\b\u0010E\u0002B\u00033K1!a'C\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDa!a(\u0018\u0001\u0004I\u0015aA7tO\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0004\u00024\u0005\u0015\u0016q\u0015\u0005\b\u0003+C\u0002\u0019AAL\u0011\u001d\tI\u000b\u0007a\u0001\u0003W\u000bQaY1vg\u0016\u0004B!!,\u00026:!\u0011qVAZ\u001d\r1\u0018\u0011W\u0005\u0002+&\u0011!\rV\u0005\u0005\u0003o\u000bILA\u0005UQJ|w/\u00192mK*\u0011!\rV\u0001\u0014C\u0012$\u0017i]=oG\n{G-\u001f%b]\u0012dWM\u001d\u000b\u0005\u0003\u007f\u000b)\r\u0005\u0003\u0002F\u0005\u0005\u0017bAAbs\ty\u0011i]=oG\n{G-\u001f*fC\u0012,'\u000fC\u0004\u0002\u0016f\u0001\r!a&\u0002!\u0005$H/Z7qi\u001a\u000b7\u000f^,sSR,GCBA;\u0003\u0017\fi\rC\u0004\u0002\u0016j\u0001\r!a&\t\u000f\u0005='\u00041\u0001\u0002*\u0005A!/Z:q_:\u001cX-\u0001\tbiR,W\u000e\u001d;Gk2dwK]5uKRQ\u0011Q[Ar\u0003K\f9/!;\u0011\u000bQ\f9.a7\n\u0007\u0005eWP\u0001\u0003UCN\\\u0007#B*\u0002^\u0006\u0005\u0018bAAp)\n1q\n\u001d;j_:\u0004R\u0001^Al\u0003gAq!!&\u001c\u0001\u0004\t9\nC\u0004\u0002@m\u0001\r!a\u0011\t\u000f\u0005=7\u00041\u0001\u0002*!9\u00111^\u000eA\u0002\u00055\u0018a\u0002:fcV,7\u000f\u001e\t\u0004W\u0006=\u0018bAAyw\t9!+Z9vKN$\u0018!F1ui\u0016l\u0007\u000f^%n[\u0016$\u0017.\u0019;f/JLG/\u001a\u000b\u0007\u0003k\n90!?\t\u000f\u0005UE\u00041\u0001\u0002\u0018\"9\u00111 \u000fA\u0002\u0005u\u0018\u0001B3ySR\u0004\"\"!\u0005\u0002\u0000\u0006\r\u0012\u0011FA\u0015\u0013\r\u0011\t!\u0010\u0002\u00045&{\u0015AD7bW\u0016T\u0016n\u001c*fcV,7\u000f\u001e\u000b\u0007\u0003[\u00149A!\u0003\t\u000f\u0005UU\u00041\u0001\u0002\u0018\"9!1B\u000fA\u0002\t5\u0011\u0001\u00038fiRL(+Z9\u0011\u0007)\u0013y!C\u0002\u0003\u0012-\u00131\u0002\u0013;uaJ+\u0017/^3ti\u0006\u0011R\u000f]4sC\u0012,Gk\\,fEN{7m[3u))\t\tOa\u0006\u0003\u001a\tm!Q\u0005\u0005\b\u0003+s\u0002\u0019AAL\u0011\u001d\tYO\ba\u0001\u0003[DqA!\b\u001f\u0001\u0004\u0011y\"\u0001\u0007xK\n\u001cvnY6fi\u0006\u0003\b\u000fE\u0003l\u0005C\t\u0019#C\u0002\u0003$m\u0012AbV3c'>\u001c7.\u001a;BaBDq!a\u0010\u001f\u0001\u0004\t\u0019%A\u0007xe&$XMT8u\r>,h\u000e\u001a\u000b\u0007\u0003g\u0011YC!\f\t\u000f\u0005Uu\u00041\u0001\u0002\u0018\"9!qF\u0010A\u0002\u00055\u0018a\u0001:fc\u0006iqO]5uKJ+7\u000f]8og\u0016$\"B!\u000e\u0003<\tu\"q\bB!)\u0011\t\u0019Da\u000e\t\u000f\te\u0002\u00051\u0001\u0002\b\u00069QM\\:ve\u0016$\u0007bBAKA\u0001\u0007\u0011q\u0013\u0005\b\u0003\u007f\u0001\u0003\u0019AA\"\u0011\u001d\tY\u0010\ta\u0001\u0003{DqAa\f!\u0001\u0004\ti/A\u0006j]R,'O];qi\u0016$G\u0003\u0002B$\u0005\u001f\u0002\"\"!\u0005\u0002\u0000\u0006\r\"\u0011JA\u001a!\r\u0019&1J\u0005\u0004\u0005\u001b\"&a\u0002(pi\"Lgn\u001a\u0005\b\u0003+\u000b\u0003\u0019AAL\u0003a9\u0018\u000e\u001e5EK\u001a\fW\u000f\u001c;FeJ|'OU3ta>t7/\u001a\u000b\u0005\u0003S\u0011)\u0006C\u0004\u0002*\n\u0002\r!a+\u0002\t\r|\u0007/\u001f\u000b\u0007\u00057\u0012yF!\u0019\u0015\t\u0005\r!Q\f\u0005\u0006e\u000e\u0002\u001da\u001d\u0005\b7\u000e\u0002\n\u00111\u0001_\u0011\u001d97\u0005%AA\u0002%\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003h)\u001aaL!\u001b,\u0005\t-\u0004\u0003\u0002B7\u0005oj!Aa\u001c\u000b\t\tE$1O\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001eU\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0012yGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0000)\u001a\u0011N!\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011)\t\u0005\u0003\u0003\b\n5UB\u0001BE\u0015\u0011\u0011Y)a\u001a\u0002\t1\fgnZ\u0005\u0005\u0005\u001f\u0013II\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005+\u00032a\u0015BL\u0013\r\u0011I\n\u0016\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003G\u0011y\nC\u0005\u0002<!\n\t\u00111\u0001\u0003\u0016\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003&B1!q\u0015BW\u0003Gi!A!+\u000b\u0007\t-F+\u0001\u0006d_2dWm\u0019;j_:LAAa,\u0003*\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)H!.\t\u0013\u0005m\"&!AA\u0002\u0005\r\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\tU\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u0015\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002v\t\r\u0007\"CA\u001e[\u0005\u0005\t\u0019AA\u0012Q\r\u0001!q\u0019\t\u0005\u0005\u0013\u0014YN\u0004\u0003\u0003L\n]g\u0002\u0002Bg\u0005+tAAa4\u0003T:\u0019aO!5\n\u0003\u0019K!AO#\n\u0005\r#\u0015b\u0001Bm\u0005\u0006q1\t[1o]\u0016d\u0007*\u00198eY\u0016\u0014\u0018\u0002\u0002Bo\u0005?\u0014\u0001b\u00155be\u0006\u0014G.\u001a\u0006\u0004\u00053\u0014\u0015\u0001F*feZ,'/\u00138c_VtG\rS1oI2,'\u000f\u0005\u0002a_M!qFa:Y!\r\u0019&\u0011^\u0005\u0004\u0005W$&AB!osJ+g\r\u0006\u0002\u0003d\u0006!A.\u001b<f+\t\u0011\u0019\u0010\u0005\u0006\u0002\u0012\tU(\u0011 B%\u0003\u0007I1Aa>>\u0005\u0019QF*Y=feB)AOa?_S&!!Q B\u0000\u0005\u0011!\u0013-\u001c9\n\u0007\r\u0005QH\u0001\fJ]R,'o]3di&|g\u000eV=qK\u000e{W\u000e]1u\u0003\u0015a\u0017N^3!\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0019Ia!\u0004\u0004\u0010Q!\u00111AB\u0006\u0011\u0015\u00118\u0007q\u0001t\u0011\u0015Y6\u00071\u0001_\u0011\u001597\u00071\u0001j\u0003\u001d)h.\u00199qYf$Ba!\u0006\u0004\u001eA)1+!8\u0004\u0018A)1k!\u0007_S&\u001911\u0004+\u0003\rQ+\b\u000f\\33\u0011%\u0019y\u0002NA\u0001\u0002\u0004\t\u0019!A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u00111Q\u0005\t\u0005\u0005\u000f\u001b9#\u0003\u0003\u0004*\t%%AB(cU\u0016\u001cG\u000f")
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
scala.Serializable {
    private final AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef;
    private final Server.Config config;
    private final Object trace;
    private final Unsafe unsafe;
    private Routes<Object, Response> app;
    private NettyRuntime runtime;
    private final LongAdder inFlightRequests;
    private final boolean readClientCert;
    private final Function0<BoxedUnit> releaseRequest;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Server.Config>> unapply(ServerInboundHandler serverInboundHandler) {
        return ServerInboundHandler$.MODULE$.unapply(serverInboundHandler);
    }

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference, Server.Config config, Object object) {
        return ServerInboundHandler$.MODULE$.apply(atomicReference, config, object);
    }

    public static ZLayer<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Nothing$, ServerInboundHandler> live() {
        return ServerInboundHandler$.MODULE$.live();
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef() {
        return this.appRef;
    }

    public Server.Config config() {
        return this.config;
    }

    private Unsafe unsafe() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 51");
        }
        return this.unsafe;
    }

    private Routes<Object, Response> app() {
        return this.app;
    }

    private void app_$eq(Routes<Object, Response> x$1) {
        this.app = x$1;
    }

    private NettyRuntime runtime() {
        return this.runtime;
    }

    private void runtime_$eq(NettyRuntime x$1) {
        this.runtime = x$1;
    }

    public LongAdder inFlightRequests() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 56");
        }
        return this.inFlightRequests;
    }

    private boolean readClientCert() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 57");
        }
        return this.readClientCert;
    }

    public void refreshApp() {
        Tuple2<Routes<Object, Response>, Runtime<Object>> pair = this.appRef().get();
        this.app_$eq((Routes)pair._1());
        this.runtime_$eq(new NettyRuntime((Runtime<Object>)((Runtime)pair._2())));
    }

    private void ensureHasApp() {
        if (this.runtime() == null) {
            this.refreshApp();
            return;
        }
    }

    private Function0<BoxedUnit> releaseRequest() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 72");
        }
        return this.releaseRequest;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.inFlightRequests().increment();
            this.ensureHasApp();
            try {
                if (httpRequest.decoderResult().isFailure()) {
                    Throwable throwable = httpRequest.decoderResult().cause();
                    this.attemptFastWrite(ctx, Response$.MODULE$.fromThrowable(throwable));
                    this.releaseRequest().apply$mcV$sp();
                } else {
                    Request req = this.makeZioRequest(ctx, httpRequest);
                    ZIO<Object, Response, Response> exit = this.app().apply(req, (Predef.$less$colon$less<Response, Response>)Predef$.MODULE$.$conforms());
                    if (this.attemptImmediateWrite(ctx, exit)) {
                        this.releaseRequest().apply$mcV$sp();
                    } else {
                        this.writeResponse(ctx, this.runtime(), exit, req, this.releaseRequest());
                    }
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)httpRequest);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ctx.fireChannelRead((Object)httpContent);
            return;
        }
        throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String msg;
        if (cause instanceof IOException && (msg = ((IOException)cause).getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.runtime() != null) {
            NettyRuntime qual$1 = this.runtime();
            JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {};
            boolean x$3 = qual$1.run$default$3();
            ZIO x$4 = ZIO$.MODULE$.logWarningCause((Function0 & Serializable & scala.Serializable)() -> "Fatal exception in Netty", (Function0 & Serializable & scala.Serializable)() -> Cause$.MODULE$.die(cause, Cause$.MODULE$.die$default$2()), this.trace).when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.config().logWarningOnFatalError(), this.trace);
            qual$1.run(ctx, (Function0<BoxedUnit>)x$2, x$3, (ZIO<Object, Throwable, Object>)x$4, this.unsafe(), this.trace);
        }
        if (cause instanceof ReadTimeoutException) {
            ctx.close();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private AsyncBodyReader addAsyncBodyHandler(ChannelHandlerContext ctx) {
        ServerAsyncBodyHandler handler = new ServerAsyncBodyHandler();
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)handler);
        return handler;
    }

    private boolean attemptFastWrite(ChannelHandlerContext ctx, Response response) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
            try {
                return this.fastEncode$1(response, unsafeBytes.unsafeAsArray(this.unsafe()), ctx);
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    return this.fastEncode$1(this.withDefaultErrorResponse(e), Array$.MODULE$.emptyByteArray(), ctx);
                }
                throw throwable;
            }
        }
        return false;
    }

    private ZIO<Object, Throwable, Option<ZIO<Object, Throwable, BoxedUnit>>> attemptFullWrite(ChannelHandlerContext ctx, NettyRuntime runtime, Response response, Request request) {
        Body body = response.body();
        if (body instanceof Body.WebsocketBody) {
            WebSocketApp<Object> socketApp = ((Body.WebsocketBody)body).socketApp();
            Status status = response.status();
            Status$SwitchingProtocols$ status$SwitchingProtocols$ = Status$SwitchingProtocols$.MODULE$;
            if (!(status != null ? !status.equals(status$SwitchingProtocols$) : status$SwitchingProtocols$ != null)) {
                return this.upgradeToWebSocket(ctx, request, socketApp, runtime).as((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, this.trace);
            }
        }
        return ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> {
            HttpResponse jResponse = NettyResponseEncoder$.MODULE$.encode(response, this.unsafe());
            if (!(jResponse instanceof FullHttpResponse)) {
                String string = jResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                None$ contentLength = string == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(string)).toLong()));
                ctx.writeAndFlush((Object)jResponse);
                return NettyBodyWriter$.MODULE$.writeAndFlush(response.body(), (Option<Object>)contentLength, ctx, $this.trace);
            }
            ctx.writeAndFlush((Object)jResponse);
            return None$.MODULE$;
        }, this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, ZIO<Object, Response, Response> exit) {
        Response response;
        if (exit instanceof Exit.Success && (response = (Response)((Exit.Success)exit).value()) != null) {
            return this.attemptFastWrite(ctx, response);
        }
        return false;
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        None$ none$;
        None$ none$2;
        Version version;
        HttpVersion nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (!(httpVersion != null ? !httpVersion.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
            version = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion2 = HttpVersion.HTTP_1_1;
            if (!(httpVersion2 != null ? !httpVersion2.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
                version = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        Version$Http_1_0$ protocolVersion = version;
        if (this.readClientCert()) {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            none$2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sslHandler.engine().getSession().getPeerCertificates())).headOption();
        } else {
            none$2 = None$.MODULE$;
        }
        None$ clientCert = none$2;
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)inetSocketAddress.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteAddress = none$;
        Headers headers = Conversions$.MODULE$.headersFromNetty(nettyReq.headers());
        Option<String> contentTypeHeader = headers.headers().get(Header$ContentType$.MODULE$.name());
        if (nettyReq instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyReq;
            Body x$1 = NettyBody$.MODULE$.fromByteBuf(fullHttpRequest.content(), contentTypeHeader);
            Method x$3 = Conversions$.MODULE$.methodFromNetty(fullHttpRequest.method());
            URL x$4 = (URL)URL$.MODULE$.decode(fullHttpRequest.uri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> URL$.MODULE$.empty());
            return new Request(protocolVersion, x$3, x$4, headers, x$1, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        Option knownContentLength = headers.get(Header$ContentLength$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.length()));
        AsyncBodyReader handler = this.addAsyncBodyHandler(ctx);
        Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(Function1 & Serializable & scala.Serializable)async -> {
            handler.connect(async);
            return BoxedUnit.UNIT;
        }, (Option<Object>)knownContentLength, contentTypeHeader);
        Method x$10 = Conversions$.MODULE$.methodFromNetty(nettyReq.method());
        URL x$11 = (URL)URL$.MODULE$.decode(nettyReq.uri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> URL$.MODULE$.empty());
        return new Request(protocolVersion, x$10, x$11, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
    }

    private ZIO<Object, Throwable, BoxedUnit> upgradeToWebSocket(ChannelHandlerContext ctx, Request request, WebSocketApp<Object> webSocketApp, NettyRuntime runtime) {
        return Queue$.MODULE$.unbounded(this.trace).tap((Function1 & Serializable & scala.Serializable)queue -> ZIO$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(ctx.channel());
            Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue);
            return webSocketApp.handler().runZIO(webSocketChannel).ignoreLogged($this.trace).forkDaemon($this.trace);
        }, $this.trace), this.trace).flatMap((Function1 & Serializable & scala.Serializable)queue -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder((WebSocketConfig)webSocketApp.customConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.config().webSocketConfig())).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Option<Promise<Throwable, ChannelState>>)None$.MODULE$, $this.trace));
            HttpRequest jReq = NettyRequestEncoder$.MODULE$.encode(request);
            ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)jReq));
        }, $this.trace), this.trace);
    }

    private void writeNotFound(ChannelHandlerContext ctx, Request req) {
        Response response = Response$.MODULE$.notFound(req.url().encode());
        this.attemptFastWrite(ctx, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyRuntime runtime, ZIO<Object, Response, Response> exit, Request req, Function0<BoxedUnit> ensured) {
        runtime.run(ctx, ensured, runtime.run$default$3(), (ZIO<Object, Throwable, Object>)exit.sandbox(this.trace).catchAll((Function1 & Serializable & scala.Serializable)error -> (ZIO)error.failureOrCause().fold((Function1 & Serializable & scala.Serializable)response -> ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> response, $this.trace), (Function1 & Serializable & scala.Serializable)cause -> {
            if (cause.isInterruptedOnly()) {
                return this.interrupted(ctx).as((Function0 & Serializable & scala.Serializable)() -> null, $this.trace);
            }
            return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> this.withDefaultErrorResponse((Throwable)new FiberFailure(cause)), $this.trace);
        }), CanFail$.MODULE$.canFail(), this.trace).flatMap((Function1 & Serializable & scala.Serializable)response -> ZIO$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            if (response != null) {
                if (!this.attemptFastWrite(ctx, (Response)response)) {
                    return this.attemptFullWrite(ctx, runtime, (Response)response, req);
                }
                return ZIO$.MODULE$.none();
            }
            if (ctx.channel().isOpen()) {
                this.writeNotFound(ctx, req);
            }
            return ZIO$.MODULE$.none();
        }, $this.trace).foldCauseZIO((Function1 & Serializable & scala.Serializable)cause -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.attemptFastWrite(ctx, this.withDefaultErrorResponse(cause.squash(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms())))), $this.trace), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return ZIO$.MODULE$.unit();
            }
            if (x0$1 instanceof Some) {
                return ((ZIO)((Some)x0$1).value()).orElse((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> ctx.close(), $this.trace), CanFail$.MODULE$.canFail(), $this.trace);
            }
            throw new MatchError(x0$1);
        }, $this.trace), this.trace), this.unsafe(), this.trace);
    }

    private ZIO<Object, Nothing$, BoxedUnit> interrupted(ChannelHandlerContext ctx) {
        return ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> ctx.channel().close(), this.trace).unit(this.trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), this.trace);
    }

    private Response withDefaultErrorResponse(Throwable cause) {
        return Response$.MODULE$.internalServerError(cause.getMessage());
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return new ServerInboundHandler(appRef, config, trace);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> copy$default$1() {
        return this.appRef();
    }

    public Server.Config copy$default$2() {
        return this.config();
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.appRef();
            }
            case 1: {
                return this.config();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerInboundHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof ServerInboundHandler)) break block3;
                ServerInboundHandler serverInboundHandler = (ServerInboundHandler)((Object)x$1);
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference = this.appRef();
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference2 = serverInboundHandler.appRef();
                if (atomicReference != null ? !atomicReference.equals(atomicReference2) : atomicReference2 != null) break block3;
                Server.Config config = this.config();
                Server.Config config2 = serverInboundHandler.config();
                if (config != null ? !((Object)config).equals(config2) : config2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private final boolean fastEncode$1(Response response, byte[] bytes, ChannelHandlerContext ctx$1) {
        FullHttpResponse djResponse = NettyResponseEncoder$.MODULE$.fastEncode(response, bytes, this.unsafe()).retainedDuplicate();
        ctx$1.writeAndFlush((Object)djResponse, ctx$1.voidPromise());
        return true;
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.trace = trace;
        super(false);
        Product.$init$((Product)this);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.inFlightRequests = new LongAdder();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.readClientCert = config.sslConfig().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.includeClientCert()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.releaseRequest = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.inFlightRequests().decrement();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

