/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;
import zio.Unsafe$;
import zio.http.Body;
import zio.http.Request;
import zio.http.URL$;
import zio.http.netty.model.Conversions$;

public final class NettyRequestEncoder$ {
    public static NettyRequestEncoder$ MODULE$;

    static {
        new NettyRequestEncoder$();
    }

    public HttpRequest encode(Request req) {
        Body body;
        HttpMethod method2 = Conversions$.MODULE$.methodToNetty(req.method());
        HttpVersion jVersion = Conversions$.MODULE$.versionToNetty(req.version());
        String path = URL$.MODULE$.encodeHttpPath(req.url());
        HttpHeaders headers = Conversions$.MODULE$.headersToNetty(req.allHeaders());
        Option<String> option = req.url().hostPort();
        if (option instanceof Some) {
            String host = (String)((Some)option).value();
            if (!headers.contains((CharSequence)HttpHeaderNames.HOST)) {
                headers.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            }
        }
        if ((body = req.body()) instanceof Body.UnsafeBytes) {
            byte[] array = ((Body.UnsafeBytes)body).unsafeAsArray(Unsafe$.MODULE$.unsafe());
            ByteBuf content = Unpooled.wrappedBuffer((byte[])array);
            headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Integer.toString(array.length));
            DefaultFullHttpRequest jReq = new DefaultFullHttpRequest(jVersion, method2, path, content);
            jReq.headers().set(headers);
            return jReq;
        }
        Option<Object> option2 = req.body().knownContentLength();
        if (option2 instanceof Some) {
            long length = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
            headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Long.toString(length));
        } else if (None$.MODULE$.equals(option2)) {
            headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
        } else {
            throw new MatchError(option2);
        }
        return new DefaultHttpRequest(jVersion, method2, path, headers);
    }

    private NettyRequestEncoder$() {
        MODULE$ = this;
    }
}

