/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.runtime.BoxesRunTime;
import zio.Unsafe;
import zio.http.Body;
import zio.http.Method;
import zio.http.Method$HEAD$;
import zio.http.Response;
import zio.http.Status;
import zio.http.netty.CachedDateHeader;
import zio.http.netty.CachedDateHeader$;
import zio.http.netty.model.Conversions$;

public final class NettyResponseEncoder$ {
    public static NettyResponseEncoder$ MODULE$;
    private final CachedDateHeader dateHeaderCache;
    private volatile boolean bitmap$init$0;

    static {
        new NettyResponseEncoder$();
    }

    private CachedDateHeader dateHeaderCache() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/NettyResponseEncoder.scala: 30");
        }
        return this.dateHeaderCache;
    }

    public HttpResponse encode(Method method2, Response response, Unsafe unsafe) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
            return this.fastEncode(method2, response, unsafeBytes.unsafeAsArray(unsafe), unsafe);
        }
        Status status = response.status();
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(status);
        this.maybeAddDateHeader(jHeaders, status);
        boolean hasContentLength = jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Method method3 = method2;
        Method$HEAD$ method$HEAD$ = Method$HEAD$.MODULE$;
        if ((method3 != null ? !method3.equals(method$HEAD$) : method$HEAD$ != null) || !hasContentLength) {
            Option<Object> option = body.knownContentLength();
            if (option instanceof Some) {
                long contentLength = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToLong((long)contentLength));
            } else if (!hasContentLength) {
                jHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
        }
        return new DefaultHttpResponse(HttpVersion.HTTP_1_1, jStatus, jHeaders);
    }

    public FullHttpResponse fastEncode(Method method2, Response response, byte[] bytes, Unsafe unsafe) {
        if (response.encoded() == null) {
            response.encoded_$eq(this.doEncode(method2, response, bytes));
        }
        return (FullHttpResponse)response.encoded();
    }

    private FullHttpResponse doEncode(Method method2, Response response, byte[] bytes) {
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        Status status = response.status();
        this.maybeAddDateHeader(jHeaders, status);
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(status);
        ByteBuf jContent = Unpooled.wrappedBuffer((byte[])bytes);
        Method method3 = method2;
        Method$HEAD$ method$HEAD$ = Method$HEAD$.MODULE$;
        if ((method3 != null ? !method3.equals(method$HEAD$) : method$HEAD$ != null) || !jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)bytes.length));
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, jStatus, jContent, jHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    private void maybeAddDateHeader(HttpHeaders headers, Status status) {
        if (status.isInformational() || status.isServerError() || headers.contains((CharSequence)HttpHeaderNames.DATE)) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.DATE, (Object)this.dateHeaderCache().get());
    }

    private NettyResponseEncoder$() {
        MODULE$ = this;
        this.dateHeaderCache = CachedDateHeader$.MODULE$.default();
        this.bitmap$init$0 = true;
    }
}

