/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Exit;
import zio.Exit$;
import zio.FiberFailure;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ErrorResponseConfig$;
import zio.http.Header;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Server;
import zio.http.Status;
import zio.http.Status$SwitchingProtocols$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.NettyResponseEncoder$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.socket.NettySocketProtocol$;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\r-b!\u0002\u001c8\u0005vz\u0004\u0002C.\u0001\u0005+\u0007I\u0011A/\t\u0011\u0019\u0004!\u0011#Q\u0001\nyC\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tc\u0002\u0011\t\u0012)A\u0005S\"A!\u000f\u0001B\u0001B\u0003-1\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0005\u0002\f\u0001\u0011\r\u0011b\u0003\u0002\u000e!A\u0011q\u0003\u0001!\u0002\u0013\ty\u0001C\u0006\u0002\u001a\u0001\u0001\r\u00111A\u0005\n\u0005m\u0001bCA\u0018\u0001\u0001\u0007\t\u0019!C\u0005\u0003cA1\"!\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e!Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011BA!\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%I!!\u0014\t\u0017\u0005E\u0003\u00011A\u0001B\u0003&\u00111\t\u0005\n\u0003'\u0002!\u0019!C\u0001\u0003+B\u0001\"a\u001c\u0001A\u0003%\u0011q\u000b\u0005\n\u0003c\u0002!\u0019!C\u0005\u0003gB\u0001\"a\u001f\u0001A\u0003%\u0011Q\u000f\u0005\n\u0003{\u0002!\u0019!C\u0005\u0003gB\u0001\"a \u0001A\u0003%\u0011Q\u000f\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\t)\t\u0001C\u0005\u0003\u0007C\u0011\"a\"\u0001\u0005\u0004%I!!#\t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u0017Cq!a%\u0001\t\u0003\n)\nC\u0004\u0002&\u0002!\t%a*\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAp\u0001\u0011%\u0011\u0011\u001d\u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u00038\u0001!IA!\u000f\t\u000f\t-\u0003\u0001\"\u0003\u0003N!I!\u0011\u000b\u0001\u0002\u0002\u0013\u0005!1\u000b\u0005\n\u0005;\u0002\u0011\u0013!C\u0001\u0005?B\u0011B!\u001e\u0001#\u0003%\tAa\u001e\t\u0013\tm\u0004!!A\u0005B\tu\u0004\"\u0003BF\u0001\u0005\u0005I\u0011\u0001BG\u0011%\u0011)\nAA\u0001\n\u0003\u00119\nC\u0005\u0003\u001c\u0002\t\t\u0011\"\u0011\u0003\u001e\"I!1\u0016\u0001\u0002\u0002\u0013\u0005!Q\u0016\u0005\n\u0005c\u0003\u0011\u0011!C!\u0005gC\u0011B!.\u0001\u0003\u0003%\tEa.\t\u0013\te\u0006!!A\u0005B\tmv\u0001\u0003Bno!\u0005QH!8\u0007\u000fY:\u0004\u0012A\u001f\u0003`\"1ap\fC\u0001\u0005OD\u0011B!;0\u0005\u0004%\tAa;\t\u0011\r\rq\u0006)A\u0005\u0005[D\u0011b!\u00020\u0003\u0003%\tia\u0002\t\u0013\rEq&!A\u0005\u0002\u000eM\u0001\"CB\u0011_\u0005\u0005I\u0011BB\u0012\u0005Q\u0019VM\u001d<fe&s'm\\;oI\"\u000bg\u000e\u001a7fe*\u0011\u0001(O\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005iZ\u0014!\u00028fiRL(B\u0001\u001f>\u0003\u0011AG\u000f\u001e9\u000b\u0003y\n1A_5p'\u0011\u0001\u0001I\u0015-\u0011\u0007\u0005;\u0015*D\u0001C\u0015\t\u0019E)A\u0004dQ\u0006tg.\u001a7\u000b\u0005i*%\"\u0001$\u0002\u0005%|\u0017B\u0001%C\u0005m\u0019\u0016.\u001c9mK\u000eC\u0017M\u001c8fY&s'm\\;oI\"\u000bg\u000e\u001a7feB\u0011!\nU\u0007\u0002\u0017*\u0011A\b\u0014\u0006\u0003\u001b:\u000bQaY8eK\u000eT!a\u0014#\u0002\u000f!\fg\u000e\u001a7fe&\u0011\u0011k\u0013\u0002\u000b\u0011R$\bo\u00142kK\u000e$\bCA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&a\u0002)s_\u0012,8\r\u001e\t\u0003'fK!A\u0017+\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\r\u0005\u0004\bOU3g\u0007\u0001)\u0012A\u0018\t\u0003?\u000et!\u0001Y1\u000e\u0003]J!AY\u001c\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\n%>,H/Z:SK\u001aT!AY\u001c\u0002\u000f\u0005\u0004\bOU3gA\u000511m\u001c8gS\u001e,\u0012!\u001b\t\u0003U:t!a\u001b7\u000e\u0003mJ!!\\\u001e\u0002\rM+'O^3s\u0013\ty\u0007O\u0001\u0004D_:4\u0017n\u001a\u0006\u0003[n\nqaY8oM&<\u0007%A\u0003ue\u0006\u001cW\r\u0005\u0002uw:\u0011QO\u001f\b\u0003mfl\u0011a\u001e\u0006\u0003qr\u000ba\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0005\tl\u0014B\u0001?~\u0005\u0015!&/Y2f\u0015\t\u0011W(\u0001\u0004=S:LGO\u0010\u000b\u0007\u0003\u0003\t9!!\u0003\u0015\t\u0005\r\u0011Q\u0001\t\u0003A\u0002AQA\u001d\u0004A\u0004MDQa\u0017\u0004A\u0002yCQa\u001a\u0004A\u0002%\fa!\u001e8tC\u001a,WCAA\b!\u0011\t\t\"a\u0005\u000e\u0003uJ1!!\u0006>\u0005\u0019)fn]1gK\u00069QO\\:bM\u0016\u0004\u0013A\u0002:pkR,7/\u0006\u0002\u0002\u001eA91.a\b\u0002$\u0005%\u0012bAA\u0011w\t1!k\\;uKN\u00042aUA\u0013\u0013\r\t9\u0003\u0016\u0002\u0004\u0003:L\bcA6\u0002,%\u0019\u0011QF\u001e\u0003\u0011I+7\u000f]8og\u0016\f!B]8vi\u0016\u001cx\fJ3r)\u0011\t\u0019$!\u000f\u0011\u0007M\u000b)$C\u0002\u00028Q\u0013A!\u00168ji\"I\u00111\b\u0006\u0002\u0002\u0003\u0007\u0011QD\u0001\u0004q\u0012\n\u0014a\u0002:pkR,7\u000fI\u0001\beVtG/[7f+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005\u001dS\"A\u001d\n\u0007\u0005%\u0013H\u0001\u0007OKR$\u0018PU;oi&lW-A\u0006sk:$\u0018.\\3`I\u0015\fH\u0003BA\u001a\u0003\u001fB\u0011\"a\u000f\u000e\u0003\u0003\u0005\r!a\u0011\u0002\u0011I,h\u000e^5nK\u0002\n\u0001#\u001b8GY&<\u0007\u000e\u001e*fcV,7\u000f^:\u0016\u0005\u0005]\u0003\u0003BA-\u0003Wj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0007CR|W.[2\u000b\t\u0005\u0005\u00141M\u0001\u000bG>t7-\u001e:sK:$(\u0002BA3\u0003O\nA!\u001e;jY*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002n\u0005m#!\u0003'p]\u001e\fE\rZ3s\u0003EIgN\u00127jO\"$(+Z9vKN$8\u000fI\u0001\u000fe\u0016\fGm\u00117jK:$8)\u001a:u+\t\t)\bE\u0002T\u0003oJ1!!\u001fU\u0005\u001d\u0011un\u001c7fC:\fqB]3bI\u000ec\u0017.\u001a8u\u0007\u0016\u0014H\u000fI\u0001\u0012CZ|\u0017\u000eZ\"uqN;\u0018\u000e^2iS:<\u0017AE1w_&$7\t\u001e=To&$8\r[5oO\u0002\n!B]3ge\u0016\u001c\b.\u00119q)\t\t\u0019$\u0001\u0007f]N,(/\u001a%bg\u0006\u0003\b/\u0001\bsK2,\u0017m]3SKF,Xm\u001d;\u0016\u0005\u0005-\u0005#B*\u0002\u000e\u0006M\u0012bAAH)\nIa)\u001e8di&|g\u000eM\u0001\u0010e\u0016dW-Y:f%\u0016\fX/Z:uA\u0005a1\r[1o]\u0016d'+Z1eaQ1\u00111GAL\u0003CCq!!'\u001a\u0001\u0004\tY*A\u0002dib\u00042!QAO\u0013\r\tyJ\u0011\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u0019\t\u0019+\u0007a\u0001\u0013\u0006\u0019Qn]4\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$b!a\r\u0002*\u0006-\u0006bBAM5\u0001\u0007\u00111\u0014\u0005\b\u0003[S\u0002\u0019AAX\u0003\u0015\u0019\u0017-^:f!\u0011\t\t,!/\u000f\t\u0005M\u0016q\u0017\b\u0004m\u0006U\u0016\"A+\n\u0005\t$\u0016\u0002BA^\u0003{\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005\t$\u0016aE1eI\u0006\u001b\u0018P\\2C_\u0012L\b*\u00198eY\u0016\u0014H\u0003BAb\u0003\u0013\u0004B!!\u0012\u0002F&\u0019\u0011qY\u001d\u0003\u001f\u0005\u001b\u0018P\\2C_\u0012L(+Z1eKJDq!!'\u001c\u0001\u0004\tY*\u0001\tbiR,W\u000e\u001d;GCN$xK]5uKRA\u0011QOAh\u0003#\fY\u000eC\u0004\u0002\u001ar\u0001\r!a'\t\u000f\u0005MG\u00041\u0001\u0002V\u00061Q.\u001a;i_\u0012\u00042a[Al\u0013\r\tIn\u000f\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000f\u0005uG\u00041\u0001\u0002*\u0005A!/Z:q_:\u001cX-\u0001\tbiR,W\u000e\u001d;Gk2dwK]5uKRQ\u00111]Ay\u0003g\f)0a>\u0011\u000bQ\f)/!;\n\u0007\u0005\u001dXP\u0001\u0003UCN\\\u0007#B*\u0002l\u0006=\u0018bAAw)\n1q\n\u001d;j_:\u0004R\u0001^As\u0003gAq!!'\u001e\u0001\u0004\tY\nC\u0004\u0002@u\u0001\r!a\u0011\t\u000f\u0005uW\u00041\u0001\u0002*!9\u0011\u0011`\u000fA\u0002\u0005m\u0018a\u0002:fcV,7\u000f\u001e\t\u0004W\u0006u\u0018bAA\u0000w\t9!+Z9vKN$\u0018!F1ui\u0016l\u0007\u000f^%n[\u0016$\u0017.\u0019;f/JLG/\u001a\u000b\t\u0003k\u0012)Aa\u0002\u0003\n!9\u0011\u0011\u0014\u0010A\u0002\u0005m\u0005bBAj=\u0001\u0007\u0011Q\u001b\u0005\b\u0005\u0017q\u0002\u0019\u0001B\u0007\u0003\u0011)\u00070\u001b;\u0011\u0015\u0005E!qBA\u0012\u0003S\tI#C\u0002\u0003\u0012u\u00121AW%P\u00039i\u0017m[3[S>\u0014V-];fgR$b!a?\u0003\u0018\te\u0001bBAM?\u0001\u0007\u00111\u0014\u0005\b\u00057y\u0002\u0019\u0001B\u000f\u0003!qW\r\u001e;z%\u0016\f\bc\u0001&\u0003 %\u0019!\u0011E&\u0003\u0017!#H\u000f\u001d*fcV,7\u000f^\u0001\u0013kB<'/\u00193f)><VMY*pG.,G\u000f\u0006\u0006\u0002p\n\u001d\"\u0011\u0006B\u0016\u0005kAq!!'!\u0001\u0004\tY\nC\u0004\u0002z\u0002\u0002\r!a?\t\u000f\t5\u0002\u00051\u0001\u00030\u0005aq/\u001a2T_\u000e\\W\r^!qaB)1N!\r\u0002$%\u0019!1G\u001e\u0003\u0019]+'mU8dW\u0016$\u0018\t\u001d9\t\u000f\u0005}\u0002\u00051\u0001\u0002D\u0005iqO]5uKJ+7\u000f]8og\u0016$\"Ba\u000f\u0003B\t\r#Q\tB$)\u0011\t\u0019D!\u0010\t\u000f\t}\u0012\u00051\u0001\u0002\f\u00069QM\\:ve\u0016$\u0007bBAMC\u0001\u0007\u00111\u0014\u0005\b\u0003\u007f\t\u0003\u0019AA\"\u0011\u001d\u0011Y!\ta\u0001\u0005\u001bAqA!\u0013\"\u0001\u0004\tY0A\u0002sKF\f\u0001d^5uQ\u0012+g-Y;mi\u0016\u0013(o\u001c:SKN\u0004xN\\:f)\u0011\tICa\u0014\t\u000f\u00055&\u00051\u0001\u00020\u0006!1m\u001c9z)\u0019\u0011)F!\u0017\u0003\\Q!\u00111\u0001B,\u0011\u0015\u00118\u0005q\u0001t\u0011\u001dY6\u0005%AA\u0002yCqaZ\u0012\u0011\u0002\u0003\u0007\u0011.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0005$f\u00010\u0003d-\u0012!Q\r\t\u0005\u0005O\u0012\t(\u0004\u0002\u0003j)!!1\u000eB7\u0003%)hn\u00195fG.,GMC\u0002\u0003pQ\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019H!\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te$fA5\u0003d\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa \u0011\t\t\u0005%qQ\u0007\u0003\u0005\u0007SAA!\"\u0002h\u0005!A.\u00198h\u0013\u0011\u0011IIa!\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011y\tE\u0002T\u0005#K1Aa%U\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019C!'\t\u0013\u0005m\u0002&!AA\u0002\t=\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t}\u0005C\u0002BQ\u0005O\u000b\u0019#\u0004\u0002\u0003$*\u0019!Q\u0015+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003*\n\r&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001e\u00030\"I\u00111\b\u0016\u0002\u0002\u0003\u0007\u00111E\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qR\u0001\ti>\u001cFO]5oOR\u0011!qP\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U$Q\u0018\u0005\n\u0003wi\u0013\u0011!a\u0001\u0003GA3\u0001\u0001Ba!\u0011\u0011\u0019M!6\u000f\t\t\u0015'\u0011\u001b\b\u0005\u0005\u000f\u0014yM\u0004\u0003\u0003J\n5gb\u0001<\u0003L&\ta)\u0003\u0002;\u000b&\u00111\tR\u0005\u0004\u0005'\u0014\u0015AD\"iC:tW\r\u001c%b]\u0012dWM]\u0005\u0005\u0005/\u0014IN\u0001\u0005TQ\u0006\u0014\u0018M\u00197f\u0015\r\u0011\u0019NQ\u0001\u0015'\u0016\u0014h/\u001a:J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005\u0001|3\u0003B\u0018\u0003bb\u00032a\u0015Br\u0013\r\u0011)\u000f\u0016\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\tu\u0017\u0001\u00027jm\u0016,\"A!<\u0011\u0015\u0005E!q\u001eBz\u0005{\f\u0019!C\u0002\u0003rv\u0012aA\u0017'bs\u0016\u0014\b#\u0002;\u0003vzK\u0017\u0002\u0002B|\u0005s\u0014A\u0001J1na&\u0019!1`\u001f\u0003-%sG/\u001a:tK\u000e$\u0018n\u001c8UsB,7i\\7qCR\u00042a\u0015B\u0000\u0013\r\u0019\t\u0001\u0016\u0002\b\u001d>$\b.\u001b8h\u0003\u0015a\u0017N^3!\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0019Ia!\u0004\u0004\u0010Q!\u00111AB\u0006\u0011\u0015\u00118\u0007q\u0001t\u0011\u0015Y6\u00071\u0001_\u0011\u001597\u00071\u0001j\u0003\u001d)h.\u00199qYf$Ba!\u0006\u0004\u001eA)1+a;\u0004\u0018A)1k!\u0007_S&\u001911\u0004+\u0003\rQ+\b\u000f\\33\u0011%\u0019y\u0002NA\u0001\u0002\u0004\t\u0019!A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u00111Q\u0005\t\u0005\u0005\u0003\u001b9#\u0003\u0003\u0004*\t\r%AB(cU\u0016\u001cG\u000f")
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
scala.Serializable {
    private final AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef;
    private final Server.Config config;
    private final Object trace;
    private final Unsafe unsafe;
    private Routes<Object, Response> routes;
    private NettyRuntime runtime;
    private final LongAdder inFlightRequests;
    private final boolean readClientCert;
    private final boolean avoidCtxSwitching;
    private final Function0<BoxedUnit> releaseRequest;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Server.Config>> unapply(ServerInboundHandler serverInboundHandler) {
        return ServerInboundHandler$.MODULE$.unapply(serverInboundHandler);
    }

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference, Server.Config config, Object object) {
        return ServerInboundHandler$.MODULE$.apply(atomicReference, config, object);
    }

    public static ZLayer<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Nothing$, ServerInboundHandler> live() {
        return ServerInboundHandler$.MODULE$.live();
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef() {
        return this.appRef;
    }

    public Server.Config config() {
        return this.config;
    }

    private Unsafe unsafe() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 49");
        }
        return this.unsafe;
    }

    private Routes<Object, Response> routes() {
        return this.routes;
    }

    private void routes_$eq(Routes<Object, Response> x$1) {
        this.routes = x$1;
    }

    private NettyRuntime runtime() {
        return this.runtime;
    }

    private void runtime_$eq(NettyRuntime x$1) {
        this.runtime = x$1;
    }

    public LongAdder inFlightRequests() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 54");
        }
        return this.inFlightRequests;
    }

    private boolean readClientCert() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 55");
        }
        return this.readClientCert;
    }

    private boolean avoidCtxSwitching() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 56");
        }
        return this.avoidCtxSwitching;
    }

    public void refreshApp() {
        Tuple2<Routes<Object, Response>, Runtime<Object>> pair = this.appRef().get();
        this.routes_$eq((Routes)pair._1());
        this.runtime_$eq(new NettyRuntime((Runtime<Object>)((Runtime)pair._2())));
    }

    private void ensureHasApp() {
        if (this.runtime() == null) {
            this.refreshApp();
            return;
        }
    }

    private Function0<BoxedUnit> releaseRequest() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 71");
        }
        return this.releaseRequest;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.inFlightRequests().increment();
            this.ensureHasApp();
            try {
                if (httpRequest.decoderResult().isFailure()) {
                    Throwable throwable = httpRequest.decoderResult().cause();
                    this.attemptFastWrite(ctx, Conversions$.MODULE$.methodFromNetty(httpRequest.method()), Response$.MODULE$.fromThrowable(throwable, this.runtime().getRef(ErrorResponseConfig$.MODULE$.configRef())));
                    this.releaseRequest().apply$mcV$sp();
                } else {
                    Request req = this.makeZioRequest(ctx, httpRequest);
                    ZIO<Object, Response, Response> exit = this.routes().apply(req, (Predef.$less$colon$less<Response, Response>)Predef$.MODULE$.$conforms());
                    if (this.attemptImmediateWrite(ctx, req.method(), exit)) {
                        this.releaseRequest().apply$mcV$sp();
                    } else {
                        this.writeResponse(ctx, this.runtime(), exit, req, this.releaseRequest());
                    }
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)httpRequest);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ctx.fireChannelRead((Object)httpContent);
            return;
        }
        throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String msg;
        if (cause instanceof IOException && (msg = ((IOException)cause).getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.runtime() != null && this.config().logWarningOnFatalError()) {
            this.runtime().unsafeRunSync(ZIO$.MODULE$.logWarningCause((Function0 & Serializable & scala.Serializable)() -> "Fatal exception in Netty", (Function0 & Serializable & scala.Serializable)() -> Cause$.MODULE$.die(cause, Cause$.MODULE$.die$default$2()), this.trace), this.unsafe(), this.trace);
        }
        if (cause instanceof ReadTimeoutException) {
            ctx.close();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private AsyncBodyReader addAsyncBodyHandler(ChannelHandlerContext ctx) {
        ServerAsyncBodyHandler handler = new ServerAsyncBodyHandler();
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)handler);
        return handler;
    }

    private boolean attemptFastWrite(ChannelHandlerContext ctx, Method method2, Response response) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
            try {
                return this.fastEncode$1(response, unsafeBytes.unsafeAsArray(this.unsafe()), method2, ctx);
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    return this.fastEncode$1(this.withDefaultErrorResponse(e), Array$.MODULE$.emptyByteArray(), method2, ctx);
                }
                throw throwable;
            }
        }
        return false;
    }

    private ZIO<Object, Throwable, Option<ZIO<Object, Throwable, BoxedUnit>>> attemptFullWrite(ChannelHandlerContext ctx, NettyRuntime runtime, Response response, Request request) {
        Body body = response.body();
        if (body instanceof Body.WebsocketBody) {
            WebSocketApp<Object> socketApp = ((Body.WebsocketBody)body).socketApp();
            Status status = response.status();
            Status$SwitchingProtocols$ status$SwitchingProtocols$ = Status$SwitchingProtocols$.MODULE$;
            if (!(status != null ? !status.equals(status$SwitchingProtocols$) : status$SwitchingProtocols$ != null)) {
                return this.upgradeToWebSocket(ctx, request, socketApp, runtime).as((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, this.trace);
            }
        }
        return ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> {
            HttpResponse jResponse = NettyResponseEncoder$.MODULE$.encode(request.method(), response, this.unsafe());
            if (!(jResponse instanceof FullHttpResponse)) {
                String string = jResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                None$ contentLength = string == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(string)).toLong()));
                ctx.writeAndFlush((Object)jResponse);
                return NettyBodyWriter$.MODULE$.writeAndFlush(response.body(), (Option<Object>)contentLength, ctx, $this.trace);
            }
            ctx.writeAndFlush((Object)jResponse);
            return None$.MODULE$;
        }, this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, Method method2, ZIO<Object, Response, Response> exit) {
        Response response;
        if (exit instanceof Exit.Success && (response = (Response)((Exit.Success)exit).value()) != null) {
            return this.attemptFastWrite(ctx, method2, response);
        }
        return false;
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        None$ none$;
        None$ none$2;
        Version version;
        HttpVersion nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (!(httpVersion != null ? !httpVersion.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
            version = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion2 = HttpVersion.HTTP_1_1;
            if (!(httpVersion2 != null ? !httpVersion2.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
                version = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        Version$Http_1_0$ protocolVersion = version;
        if (this.readClientCert()) {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            none$2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sslHandler.engine().getSession().getPeerCertificates())).headOption();
        } else {
            none$2 = None$.MODULE$;
        }
        None$ clientCert = none$2;
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)inetSocketAddress.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteAddress = none$;
        Headers headers = Conversions$.MODULE$.headersFromNetty(nettyReq.headers());
        Option<Header> contentTypeHeader = headers.get(Header$ContentType$.MODULE$);
        if (nettyReq instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyReq;
            Body x$1 = NettyBody$.MODULE$.fromByteBuf(fullHttpRequest.content(), contentTypeHeader);
            Method x$3 = Conversions$.MODULE$.methodFromNetty(fullHttpRequest.method());
            URL x$4 = (URL)URL$.MODULE$.decode(fullHttpRequest.uri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> URL$.MODULE$.empty());
            return new Request(protocolVersion, x$3, x$4, headers, x$1, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        Option knownContentLength = headers.get(Header$ContentLength$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.length()));
        AsyncBodyReader handler = this.addAsyncBodyHandler(ctx);
        Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(Function1 & Serializable & scala.Serializable)async -> {
            handler.connect(async);
            return BoxedUnit.UNIT;
        }, (Option<Object>)knownContentLength, contentTypeHeader);
        Method x$10 = Conversions$.MODULE$.methodFromNetty(nettyReq.method());
        URL x$11 = (URL)URL$.MODULE$.decode(nettyReq.uri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> URL$.MODULE$.empty());
        return new Request(protocolVersion, x$10, x$11, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
    }

    private ZIO<Object, Throwable, BoxedUnit> upgradeToWebSocket(ChannelHandlerContext ctx, Request request, WebSocketApp<Object> webSocketApp, NettyRuntime runtime) {
        return Promise$.MODULE$.make(this.trace).flatMap((Function1 & Serializable & scala.Serializable)handshakeCompleted -> Queue$.MODULE$.unbounded($this.trace).tap((Function1 & Serializable & scala.Serializable)queue -> ZIO$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(ctx.channel());
            Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted);
            return webSocketApp.handler().runZIO(webSocketChannel).ignoreLogged($this.trace).forkDaemon($this.trace);
        }, $this.trace), $this.trace).flatMap((Function1 & Serializable & scala.Serializable)queue -> ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> {
            ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder((WebSocketConfig)webSocketApp.customConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.config().webSocketConfig())).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted, (Option<Promise<Throwable, ChannelState>>)None$.MODULE$, $this.trace));
            DefaultFullHttpRequest jReq = new DefaultFullHttpRequest(Conversions$.MODULE$.versionToNetty(request.version()), Conversions$.MODULE$.methodToNetty(request.method()), Conversions$.MODULE$.urlToNetty(request.url()));
            jReq.headers().setAll(Conversions$.MODULE$.headersToNetty(request.allHeaders()));
            return ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)jReq));
        }, $this.trace).map((Function1 & Serializable & scala.Serializable)_ -> {
            ServerInboundHandler.$anonfun$upgradeToWebSocket$8(_);
            return BoxedUnit.UNIT;
        }, $this.trace), $this.trace), this.trace);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyRuntime runtime, ZIO<Object, Response, Response> exit, Request req, Function0<BoxedUnit> ensured) {
        ZIO program = exit.foldCauseZIO((Function1 & Serializable & scala.Serializable)x$3 -> {
            boolean bl = false;
            Right right = null;
            Either either = x$3.failureOrCause();
            if (either instanceof Left) {
                Response resp = (Response)((Left)either).value();
                return this.writeResponse$1(resp, ctx, req, runtime);
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                if (((Cause)right.value()).isInterruptedOnly()) {
                    return this.closeChannel$1(ctx);
                }
            }
            if (bl) {
                Cause c = (Cause)right.value();
                return this.writeResponse$1(this.withDefaultErrorResponse((Throwable)new FiberFailure(c)), ctx, req, runtime);
            }
            throw new MatchError((Object)either);
        }, (Function1 & Serializable & scala.Serializable)response -> this.writeResponse$1((Response)response, ctx, req, runtime), this.trace);
        runtime.run(ctx, ensured, this.avoidCtxSwitching(), (ZIO<Object, Throwable, Object>)program, this.unsafe(), this.trace);
    }

    private Response withDefaultErrorResponse(Throwable cause) {
        return Response$.MODULE$.internalServerError(cause.getMessage());
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return new ServerInboundHandler(appRef, config, trace);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> copy$default$1() {
        return this.appRef();
    }

    public Server.Config copy$default$2() {
        return this.config();
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.appRef();
            }
            case 1: {
                return this.config();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerInboundHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof ServerInboundHandler)) break block3;
                ServerInboundHandler serverInboundHandler = (ServerInboundHandler)((Object)x$1);
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference = this.appRef();
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference2 = serverInboundHandler.appRef();
                if (atomicReference != null ? !atomicReference.equals(atomicReference2) : atomicReference2 != null) break block3;
                Server.Config config = this.config();
                Server.Config config2 = serverInboundHandler.config();
                if (config != null ? !((Object)config).equals(config2) : config2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private final boolean fastEncode$1(Response response, byte[] bytes, Method method$1, ChannelHandlerContext ctx$1) {
        FullHttpResponse djResponse = NettyResponseEncoder$.MODULE$.fastEncode(method$1, response, bytes, this.unsafe()).retainedDuplicate();
        io.netty.channel.Channel ch = ctx$1.channel();
        ch.writeAndFlush((Object)djResponse, ch.voidPromise());
        return true;
    }

    public static final /* synthetic */ void $anonfun$upgradeToWebSocket$8(Future _) {
    }

    private final ZIO closeChannel$1(ChannelHandlerContext ctx$4) {
        return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable & scala.Serializable)() -> ctx$4.channel().close(), this.trace);
    }

    private final ZIO writeResponse$1(Response response, ChannelHandlerContext ctx$4, Request req$1, NettyRuntime runtime$2) {
        if (this.attemptFastWrite(ctx$4, req$1.method(), response)) {
            return Exit$.MODULE$.unit();
        }
        return this.attemptFullWrite(ctx$4, runtime$2, response, req$1).foldCauseZIO((Function1 & Serializable & scala.Serializable)cause -> {
            this.attemptFastWrite(ctx$4, req$1.method(), this.withDefaultErrorResponse(cause.squash(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()))));
            return Exit$.MODULE$.unit();
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return Exit$.MODULE$.unit();
            }
            if (x0$1 instanceof Some) {
                return ((ZIO)((Some)x0$1).value()).orElse((Function0 & Serializable & scala.Serializable)() -> this.closeChannel$1(ctx$4), CanFail$.MODULE$.canFail(), $this.trace);
            }
            throw new MatchError(x0$1);
        }, this.trace);
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.trace = trace;
        super(false);
        Product.$init$((Product)this);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.inFlightRequests = new LongAdder();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.readClientCert = config.sslConfig().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.includeClientCert()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.avoidCtxSwitching = config.avoidContextSwitching();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.releaseRequest = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.inFlightRequests().decrement();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

