/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.control.NonFatal$;
import zio.CanFail;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit;
import zio.Exit$;
import zio.NonEmptyChunk;
import zio.Scope;
import zio.StackTrace;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Boundary;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.Charsets$;
import zio.http.ErrorResponseConfig$;
import zio.http.Handler;
import zio.http.Handler$$anonfun$;
import zio.http.Handler$FromFunctionHandler$;
import zio.http.Handler$FromFunctionZIO$;
import zio.http.Handler$IsRequest$;
import zio.http.Handler$ScopedPartiallyApplied$;
import zio.http.HandlerAspect;
import zio.http.HandlerPlatformSpecific;
import zio.http.HandlerVersionSpecific;
import zio.http.Header;
import zio.http.Header$Accept$;
import zio.http.Header$Accept$MediaTypeWithQFactor$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Method;
import zio.http.Middleware$;
import zio.http.Path;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Status;
import zio.http.Status$BadRequest$;
import zio.http.Status$Forbidden$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$MethodNotAllowed$;
import zio.http.Status$NotFound$;
import zio.http.Status$Ok$;
import zio.http.Status$RequestEntityTooLarge$;
import zio.http.Status$RequestTimeout$;
import zio.http.ToHandler;
import zio.http.ToHandler$;
import zio.http.WebSocketApp;
import zio.http.WebSocketApp$;
import zio.http.WebSocketFrame;
import zio.http.package$;
import zio.http.template.Html;
import zio.http.template.Template$;
import zio.package;
import zio.stream.ZStream;

public final class Handler$
implements HandlerPlatformSpecific,
HandlerVersionSpecific {
    public static Handler$ MODULE$;
    private final List<MediaType> zio$http$Handler$$errorMediaTypes;
    private final Handler<Object, Nothing$, Object, Response> badRequest;
    private final Handler<Object, Nothing$, Request, Response> notFound;
    private final Handler<Object, Nothing$, Object, Response> ok;
    private final Handler<Object, Nothing$, Object, Response> tooLarge;
    private final Handler<Object, Nothing$, Object, BoxedUnit> unit;
    private final boolean scopedPartiallyApplied;
    private volatile int bitmap$init$0;

    static {
        new Handler$();
    }

    @Override
    public Handler<Object, Throwable, Object, Response> fromResource(String path, Charset charset, Object trace) {
        return HandlerPlatformSpecific.fromResource$(this, path, charset, trace);
    }

    @Override
    public Charset fromResource$default$2() {
        return HandlerPlatformSpecific.fromResource$default$2$(this);
    }

    @Override
    public Handler<Object, Throwable, Object, Response> fromResourceWithURL(URL url, Charset charset, Object trace) {
        return HandlerPlatformSpecific.fromResourceWithURL$(this, url, charset, trace);
    }

    @Override
    public Handler<Object, Throwable, Object, URL> getResource(String path, Object trace) {
        return HandlerPlatformSpecific.getResource$(this, path, trace);
    }

    @Override
    public Handler<Object, Throwable, Object, File> getResourceAsFile(String path, Object trace) {
        return HandlerPlatformSpecific.getResourceAsFile$(this, path, trace);
    }

    public List<MediaType> zio$http$Handler$$errorMediaTypes() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Handler.scala: 694");
        }
        return this.zio$http$Handler$$errorMediaTypes;
    }

    public Handler<Object, Throwable, Object, Chunk<Object>> asChunkBounded(Request request, int limit, Object trace) {
        return this.fromZIO((Function0 & Serializable & scala.Serializable)() -> request.body().asStream(trace).chunks(trace).runFoldZIO((Function0 & Serializable & scala.Serializable)() -> Chunk$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Chunk acc = x0$1;
            Chunk bytes = x1$1;
            return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> acc.$plus$plus(bytes), trace).filterOrFail((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)Handler$.$anonfun$asChunkBounded$5(limit, x$33)), (Function0 & Serializable & scala.Serializable)() -> new Exception("Too large input"), trace);
        }, trace));
    }

    public <Out> Handler<Object, Throwable, Object, Out> attempt(Function0<Out> out) {
        return this.fromExit((Function0 & Serializable & scala.Serializable)() -> {
            try {
                return Exit$.MODULE$.succeed(out.apply());
            }
            catch (Throwable throwable) {
                if (NonFatal$.MODULE$.apply(throwable)) {
                    return Exit$.MODULE$.fail((Object)throwable);
                }
                throw throwable;
            }
        });
    }

    public Handler<Object, Nothing$, Object, Response> badRequest() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Handler.scala: 727");
        }
        return this.badRequest;
    }

    public Handler<Object, Nothing$, Object, Response> badRequest(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$BadRequest$.MODULE$, message);
    }

    public Handler<Object, Nothing$, Object, Nothing$> die(Function0<Throwable> failure) {
        return this.fromExit((Function0 & Serializable & scala.Serializable)() -> Exit$.MODULE$.die((Throwable)failure.apply()));
    }

    public Handler<Object, Nothing$, Object, Nothing$> dieMessage(Function0<String> message) {
        return this.die((Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> new RuntimeException((String)message.apply()));
    }

    public Handler<Object, Nothing$, Object, Response> error(Function0<Status.Error> status) {
        return this.fromResponse((Function0<Response>)(Function0 & Serializable & scala.Serializable)() -> Response$.MODULE$.error((Status.Error)status.apply()));
    }

    public Handler<Object, Nothing$, Object, Response> error(Function0<Status.Error> status, Function0<String> message) {
        return this.fromResponse((Function0<Response>)(Function0 & Serializable & scala.Serializable)() -> Response$.MODULE$.status((Status)status.apply())).$at$at(Middleware$.MODULE$.interceptHandlerStateful(package$.MODULE$.handler((Function0 & Serializable & scala.Serializable)() -> (Function1 & Serializable & scala.Serializable)req -> new Tuple2(req.header(Header$Accept$.MODULE$), (Object)new Tuple2(req, (Object)BoxedUnit.UNIT)), ToHandler$.MODULE$.functionIsHandlerConstructor()), package$.MODULE$.handler((Function0 & Serializable & scala.Serializable)() -> (Function2 & Serializable & scala.Serializable)(accept, res) -> ErrorResponseConfig$.MODULE$.configRef().get((Object)"zio.http.Handler.error(Handler.scala:774)").map((Function1 & Serializable & scala.Serializable)cfg -> {
            if (cfg.withErrorBody()) {
                MediaType mediaType = (MediaType)accept.flatMap((Function1 & Serializable & scala.Serializable)x$34 -> x$34.mimeTypes().sorted(Header$Accept$MediaTypeWithQFactor$.MODULE$.ordering()).map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.mediaType()).collectFirst((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends MediaType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        if (Handler$.MODULE$.zio$http$Handler$$errorMediaTypes().exists((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$error$8$1.$anonfun$applyOrElse$1(x1, x$36)))) {
                            return (B1)Handler$.MODULE$.zio$http$Handler$$errorMediaTypes().find((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$error$8$1.$anonfun$applyOrElse$2(x1, x$37))).get();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(MediaType x1) {
                        return Handler$.MODULE$.zio$http$Handler$$errorMediaTypes().exists((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$error$8$1.$anonfun$isDefinedAt$1(x1, x$36)));
                    }

                    public static final /* synthetic */ boolean $anonfun$applyOrElse$1(MediaType x1$1, MediaType x$36) {
                        return x1$1.matches(x$36, true);
                    }

                    public static final /* synthetic */ boolean $anonfun$applyOrElse$2(MediaType x1$1, MediaType x$37) {
                        return x1$1.matches(x$37, true);
                    }

                    public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(MediaType x1$2, MediaType x$36) {
                        return x1$2.matches(x$36, true);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(zio.http.MediaType zio.http.MediaType ), $anonfun$applyOrElse$2$adapted(zio.http.MediaType zio.http.MediaType ), $anonfun$isDefinedAt$1$adapted(zio.http.MediaType zio.http.MediaType )}, serializedLambda);
                    }
                })).getOrElse((Function0 & Serializable & scala.Serializable)() -> cfg.errorFormat().mediaType());
                MediaType mediaType2 = MediaType$.MODULE$.application().json();
                if (!(mediaType2 != null ? !((Object)mediaType2).equals(mediaType) : mediaType != null)) {
                    Status.Error x$1 = (Status.Error)status.apply();
                    Body x$2 = Body$.MODULE$.fromString(new StringBuilder(27).append("{\"status\": \"").append(status.apply()).append("\", \"error\": \"").append(message.apply()).append("\"}").toString(), Body$.MODULE$.fromString$default$2());
                    Headers x$3 = Response$.MODULE$.apply$default$2();
                    return new Response(x$1, x$3, x$2).contentType(MediaType$.MODULE$.application().json());
                }
                MediaType mediaType3 = MediaType$.MODULE$.text().html();
                if (!(mediaType3 != null ? !((Object)mediaType3).equals(mediaType) : mediaType != null)) {
                    Status.Error x$4 = (Status.Error)status.apply();
                    Body x$5 = Body$.MODULE$.fromString(new StringBuilder(85).append("<!DOCTYPE html><html><head><title>").append(status.apply()).append("</title></head><body><h1>").append(status.apply()).append("</h1><p>").append(message.apply()).append("</p></body></html>").toString(), Body$.MODULE$.fromString$default$2());
                    Headers x$6 = Response$.MODULE$.apply$default$2();
                    return new Response(x$4, x$6, x$5).contentType(MediaType$.MODULE$.text().html());
                }
                MediaType mediaType4 = MediaType$.MODULE$.text().plain();
                if (!(mediaType4 != null ? !((Object)mediaType4).equals(mediaType) : mediaType != null)) {
                    Status.Error x$7 = (Status.Error)status.apply();
                    Body x$8 = Body$.MODULE$.fromString((String)message.apply(), Body$.MODULE$.fromString$default$2());
                    Headers x$9 = Response$.MODULE$.apply$default$2();
                    return new Response(x$7, x$9, x$8).contentType(MediaType$.MODULE$.text().plain());
                }
                throw new Exception("Unsupported media type");
            }
            return res;
        }, (Object)"zio.http.Handler.error(Handler.scala:774)"), ToHandler$.MODULE$.function2ZIOIsHandlerConstructor())), Handler$IsRequest$.MODULE$.request(), (Predef.$less$colon$less<Response, Response>)Predef$.MODULE$.$conforms(), (Predef.$less$colon$less<Nothing$, Response>)Predef$.MODULE$.$conforms());
    }

    public <Err> Handler<Object, Err, Object, Nothing$> fail(Function0<Err> err) {
        return this.fromExit((Function0 & Serializable & scala.Serializable)() -> Exit$.MODULE$.fail(err.apply()));
    }

    public <Err> Handler<Object, Err, Object, Nothing$> failCause(Function0<Cause<Err>> cause) {
        return this.fromExit((Function0 & Serializable & scala.Serializable)() -> Exit$.MODULE$.failCause((Cause)cause.apply()));
    }

    public <R, Err, In, Out> Handler<R, Err, In, Out> firstSuccessOf(NonEmptyChunk<Handler<R, Err, In, Out>> handlers, Function1<Cause<Err>, Object> isRecoverable, Object trace) {
        return (Handler)handlers.tail().foldLeft(handlers.head(), (Function2 & Serializable & scala.Serializable)(acc, handler) -> acc.catchAllCause((Function1 & Serializable & scala.Serializable)cause -> {
            if (BoxesRunTime.unboxToBoolean((Object)isRecoverable.apply(cause))) {
                return handler;
            }
            return MODULE$.failCause((Function0 & Serializable & scala.Serializable)() -> cause);
        }, trace));
    }

    public <R, Err, In, Out> Function1<Cause<Err>, Object> firstSuccessOf$default$2() {
        return (Function1 & Serializable & scala.Serializable)cause -> BoxesRunTime.boxToBoolean((boolean)Handler$.$anonfun$firstSuccessOf$default$2$1(cause));
    }

    public Handler<Object, Nothing$, Object, Response> forbidden() {
        return this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$Forbidden$.MODULE$);
    }

    public Handler<Object, Nothing$, Object, Response> forbidden(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$Forbidden$.MODULE$, message);
    }

    public <H> Handler<Object, Object, Object, Object> from(Function0<H> handler, ToHandler<H> h) {
        return h.toHandler(handler);
    }

    public Handler<Object, Nothing$, Object, Response> fromBody(Function0<Body> body) {
        return this.fromResponse((Function0<Response>)(Function0 & Serializable & scala.Serializable)() -> {
            Body x$1 = (Body)body.apply();
            Status x$2 = Response$.MODULE$.apply$default$1();
            Headers x$3 = Response$.MODULE$.apply$default$2();
            return new Response(x$2, x$3, x$1);
        });
    }

    public <Err, Out> Handler<Object, Err, Object, Out> fromEither(Function0<Either<Err, Out>> either) {
        return this.fromExit((Function0 & Serializable & scala.Serializable)() -> Exit$.MODULE$.fromEither((Either)either.apply()));
    }

    public <Err, Out> Handler<Object, Err, Object, Out> fromExit(Function0<Exit<Err, Out>> exit) {
        return new Handler<Object, Err, Object, Out>(exit){
            private final Function0 exit$1;

            public <Env1, In1> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, BoxedUnit> aspect, Handler.IsRequest<In1> in, Predef.$less$colon$less<Out, Response> out, Predef.$less$colon$less<Err, Response> err) {
                return Handler.$at$at$(this, aspect, in, out, err);
            }

            public <Env0, Ctx, In1> Handler<Env0, Response, Request, Response> $at$at(HandlerAspect<Env0, Ctx> aspect, Handler.IsRequest<In1> in, Predef.$less$colon$less<Out, Response> out, Predef.$less$colon$less<Err, Response> err, Object trace, package.Tag<Ctx> tag) {
                return Handler.$at$at$(this, aspect, in, out, err, trace, tag);
            }

            public <Env0> HandlerVersionSpecific.ApplyContextAspect<Object, Err, Object, Out, Env0> $at$at() {
                return Handler.$at$at$(this);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $greater$greater$eq(Function1<Out, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.$greater$greater$eq$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, Object, Out1> $greater$greater$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$greater$greater$greater$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out> $less$less$less(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$less$less$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $less$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$greater$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Tuple2<Out, Out1>> $less$times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$greater$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out> $less$times(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$times$greater$(this, that, trace);
            }

            public final <Err1, Out1> Handler<Object, Err1, Object, Out1> absolve(Predef.$less$colon$less<Out, Either<Err1, Out1>> ev, Object trace) {
                return Handler.absolve$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, Object, Out1> andThen(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.andThen$(this, that, trace);
            }

            public final <Out1> Handler<Object, Err, Object, Out1> as(Out1 out, Object trace) {
                return Handler.as$(this, out, trace);
            }

            public final <R2> Handler<R2, Err, Object, Out> asEnvType(Predef.$less$colon$less<R2, Object> ev) {
                return Handler.asEnvType$(this, ev);
            }

            public final <Err2> Handler<Object, Err2, Object, Out> asErrorType(Predef.$less$colon$less<Err, Err2> ev) {
                return Handler.asErrorType$(this, ev);
            }

            public final <In2> Handler<Object, Err, In2, Out> asInType(Predef.$less$colon$less<In2, Object> ev) {
                return Handler.asInType$(this, ev);
            }

            public final <Out2> Handler<Object, Err, Object, Out2> asOutType(Predef.$less$colon$less<Out, Out2> ev) {
                return Handler.asOutType$(this, ev);
            }

            public final Handler<Object, Err, Object, Body> body(Predef.$less$colon$less<Out, Response> ev, Object trace) {
                return Handler.body$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAll(Function1<Err, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAll$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAllCause(Function1<Cause<Err>, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllCause$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAllDefect(Function1<Throwable, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllDefect$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchSome(PartialFunction<Err, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSome$(this, pf, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchSomeDefect(PartialFunction<Throwable, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSomeDefect$(this, pf, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out> compose(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.compose$(this, that, trace);
            }

            public final <In1> Handler<Object, Err, In1, Out> contramap(Function1<In1, Object> f) {
                return Handler.contramap$(this, f);
            }

            public final <R1, Err1, In1> Handler<R1, Err1, In1, Out> contramapZIO(Function1<In1, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.contramapZIO$(this, f, trace);
            }

            public final <In1> Handler<Object, Err, Object, Out> contraFlatMap() {
                return Handler.contraFlatMap$(this);
            }

            public final Handler<Object, Err, Object, Out> delay(Duration duration, Object trace) {
                return Handler.delay$(this, duration, trace);
            }

            public final Handler<Object, Err, Object, Out> delayAfter(Duration duration, Object trace) {
                return Handler.delayAfter$(this, duration, trace);
            }

            public final Handler<Object, Err, Object, Out> delayBefore(Duration duration, Object trace) {
                return Handler.delayBefore$(this, duration, trace);
            }

            public final Handler<Object, Nothing$, Object, Either<Err, Out>> either(CanFail<Err> ev, Object trace) {
                return Handler.either$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> flatten(Predef.$less$colon$less<Out, Handler<R1, Err1, In1, Out1>> ev, Object trace) {
                return Handler.flatten$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> flatMap(Function1<Out, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.flatMap$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> foldCauseHandler(Function1<Cause<Err>, Handler<R1, Err1, In1, Out1>> onFailure, Function1<Out, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldCauseHandler$(this, onFailure, onSuccess, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> foldHandler(Function1<Err, Handler<R1, Err1, In1, Out1>> onFailure, Function1<Out, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldHandler$(this, onFailure, onSuccess, trace);
            }

            public final Handler<Object, Err, Object, Headers> headers(Predef.$less$colon$less<Out, Response> ev, Object trace) {
                return Handler.headers$(this, ev, trace);
            }

            public final Handler<Object, Err, Object, Option<Header>> header(Header.HeaderType headerType, Predef.$less$colon$less<Out, Response> ev, Object trace) {
                return Handler.header$(this, headerType, ev, trace);
            }

            public final <Out1> Handler<Object, Err, Object, Out1> map(Function1<Out, Out1> f, Object trace) {
                return Handler.map$(this, f, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> mapError(Function1<Err, Err1> f, Object trace) {
                return Handler.mapError$(this, f, trace);
            }

            public final <Err2> Handler<Object, Err2, Object, Out> mapErrorCause(Function1<Cause<Err>, Err2> f, Object trace) {
                return Handler.mapErrorCause$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, Object, Out1> mapZIO(Function1<Out, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapZIO$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, Object, Out1> mapErrorZIO(Function1<Err, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorZIO$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, Object, Out1> mapErrorCauseZIO(Function1<Cause<Err>, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorCauseZIO$(this, f, trace);
            }

            public final <Err1, Out1> Handler<Object, Nothing$, Object, Out1> merge(Predef.$eq$colon$eq<Err1, Out1> ev, Object trace) {
                return Handler.merge$(this, ev, trace);
            }

            public final <In1> Handler<Object, Err, In1, Out> narrow(Predef.$less$colon$less<In1, Object> ev) {
                return Handler.narrow$(this, ev);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> onExit(Function1<Exit<Err, Out>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.onExit$(this, f, trace);
            }

            public final Handler<Object, Nothing$, Object, Option<Out>> option(CanFail<Err> ev, Object trace) {
                return Handler.option$(this, ev, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Option<Out>> optional(Predef.$less$colon$less<Err, Option<Err1>> ev, Object trace) {
                return Handler.optional$(this, ev, trace);
            }

            public final Handler<Object, Nothing$, Object, Out> orDie(Predef.$less$colon$less<Err, Throwable> ev1, CanFail<Err> ev2, Object trace) {
                return Handler.orDie$(this, ev1, ev2, trace);
            }

            public final Handler<Object, Nothing$, Object, Out> orDieWith(Function1<Err, Throwable> f, CanFail<Err> ev, Object trace) {
                return Handler.orDieWith$(this, f, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> orElse(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.orElse$(this, that, trace);
            }

            public final Handler<Object, Err, Object, Out> provideEnvironment(ZEnvironment<Object> r, Object trace) {
                return Handler.provideEnvironment$(this, r, trace);
            }

            public final <Err1, R0> Handler<R0, Err1, Object, Out> provideLayer(ZLayer<R0, Err1, Object> layer, Object trace) {
                return Handler.provideLayer$(this, layer, trace);
            }

            public final <R1> Handler<R1, Err, Object, Out> provideSomeEnvironment(Function1<ZEnvironment<R1>, ZEnvironment<Object>> f, Object trace) {
                return Handler.provideSomeEnvironment$(this, f, trace);
            }

            public final <R0, R1, Err1> Handler<R0, Err1, Object, Out> provideSomeLayer(ZLayer<R0, Err1, R1> layer, package.Tag<R1> evidence$1, Predef.$less$colon$less<R0, Object> ev, Object trace) {
                return Handler.provideSomeLayer$(this, layer, evidence$1, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> race(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.race$(this, that, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> refineOrDie(PartialFunction<Err, Err1> pf, Predef.$less$colon$less<Err, Throwable> ev1, CanFail<Err> ev2, Object trace) {
                return Handler.refineOrDie$(this, pf, ev1, ev2, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> refineOrDieWith(PartialFunction<Err, Err1> pf, Function1<Err, Throwable> f, CanFail<Err> ev, Object trace) {
                return Handler.refineOrDieWith$(this, pf, f, ev, trace);
            }

            public final ZIO<Scope, Err, Out> run(Method method2, Path path, Headers headers, Body body, Predef.$less$colon$less<Request, Object> ev) {
                return Handler.run$(this, method2, path, headers, body, ev);
            }

            public final Method run$default$1() {
                return Handler.run$default$1$(this);
            }

            public final Path run$default$2() {
                return Handler.run$default$2$(this);
            }

            public final Headers run$default$3() {
                return Handler.run$default$3$(this);
            }

            public final Body run$default$4() {
                return Handler.run$default$4$(this);
            }

            public final ZIO<Scope, Err, Out> runZIO(Object in) {
                return Handler.runZIO$(this, in);
            }

            public final Handler<Object, Response, Object, Out> sandbox(Object trace) {
                return Handler.sandbox$(this, trace);
            }

            public final Handler<Object, Err, Object, Status> status(Predef.$less$colon$less<Out, Response> ev, Object trace) {
                return Handler.status$(this, ev, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> tapAllZIO(Function1<Cause<Err>, ZIO<R1, Err1, Object>> onFailure, Function1<Out, ZIO<R1, Err1, Object>> onSuccess, Object trace) {
                return Handler.tapAllZIO$(this, onFailure, onSuccess, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> tapErrorCauseZIO(Function1<Cause<Err>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorCauseZIO$(this, f, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> tapErrorZIO(Function1<Err, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorZIO$(this, f, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> tapZIO(Function1<Out, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapZIO$(this, f, trace);
            }

            public Handler<Object, Err, Object, Option<Out>> timeout(Duration duration, Object trace) {
                return Handler.timeout$(this, duration, trace);
            }

            public <Out1> Handler<Object, Err, Object, Out1> timeoutFail(Out1 out, Duration duration, Object trace) {
                return Handler.timeoutFail$(this, out, duration, trace);
            }

            public Routes<Object, Err> toRoutes(Predef.$less$colon$less<Request, Object> in, Predef.$less$colon$less<Out, Response> out, Object trace) {
                return Handler.toRoutes$(this, in, out, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> unrefine(PartialFunction<Throwable, Err1> pf, Object trace) {
                return Handler.unrefine$(this, pf, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> unrefineTo(ClassTag<Err1> evidence$2, Object trace) {
                return Handler.unrefineTo$(this, evidence$2, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> unrefineWith(PartialFunction<Throwable, Err1> pf, Function1<Err, Err1> f, Object trace) {
                return Handler.unrefineWith$(this, pf, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, Object, Out1> unwrapZIO(Predef.$less$colon$less<Out, ZIO<R1, Err1, Out1>> ev, Object trace) {
                return Handler.unwrapZIO$(this, ev, trace);
            }

            public <Err1, Out1> Handler<Object, Err1, Object, Out1> widen(Predef.$less$colon$less<Err, Err1> ev1, Predef.$less$colon$less<Out, Out1> ev2) {
                return Handler.widen$(this, ev1, ev2);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Tuple2<Out, Out1>> zip(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zip$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out> zipLeft(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipLeft$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> zipRight(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipRight$(this, that, trace);
            }

            public ZIO<Object, Err, Out> apply(Object in) {
                try {
                    return (ZIO)this.exit$1.apply();
                }
                catch (Throwable throwable) {
                    if (NonFatal$.MODULE$.apply(throwable)) {
                        return Exit$.MODULE$.die(throwable);
                    }
                    throw throwable;
                }
            }
            {
                this.exit$1 = exit$1;
                Handler.$init$(this);
            }
        };
    }

    public <In> BoxedUnit fromFunction() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionHandler() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionEither() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionExit() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionZIO() {
        return BoxedUnit.UNIT;
    }

    public Option<MediaType> determineMediaType(String filePath) {
        int n = filePath.lastIndexOf(".");
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        String ext = filePath.substring(n + 1);
        return MediaType$.MODULE$.forFileExtension(ext);
    }

    public <R> Handler<R, Throwable, Object, Response> fromFile(Function0<File> makeFile, Charset charset, Object trace) {
        return this.fromFileZIO(ZIO$.MODULE$.attempt(makeFile, trace), charset, trace);
    }

    public <R> Charset fromFile$default$2() {
        return Charsets$.MODULE$.Utf8();
    }

    public <R> Handler<R, Throwable, Object, Response> fromFileZIO(ZIO<R, Throwable, File> getFile, Charset charset, Object trace) {
        return this.fromZIO((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> getFile.flatMap((Function1 & Serializable & scala.Serializable)file -> {
            if (!file.exists()) {
                return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new FileNotFoundException(), trace);
            }
            if (file.isFile() && !file.canRead()) {
                return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new AccessDeniedException(file.getAbsolutePath()), trace);
            }
            if (file.isFile()) {
                return Body$.MODULE$.fromFile((File)file, Body$.MODULE$.fromFile$default$2(), trace).flatMap((Function1 & Serializable & scala.Serializable)body -> {
                    Status x$2 = Response$.MODULE$.apply$default$1();
                    Headers x$3 = Response$.MODULE$.apply$default$2();
                    Response response = new Response(x$2, x$3, (Body)body);
                    String pathName = ((Object)file.toPath()).toString();
                    Option<MediaType> option = MODULE$.determineMediaType(pathName);
                    if (option instanceof Some) {
                        MediaType mediaType = (MediaType)((Some)option).value();
                        String string = mediaType.mainType();
                        String string2 = "text";
                        Some charset0 = string != null && string.equals(string2) || !mediaType.binary() ? new Some((Object)charset) : None$.MODULE$;
                        return ZIO$.MODULE$.succeed(() -> Handler$.$anonfun$fromFileZIO$7(response, mediaType, (Option)charset0), trace);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> response, trace);
                    }
                    throw new MatchError(option);
                }, trace);
            }
            return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new NotDirectoryException("Found directory instead of a file."), trace);
        }, trace), trace));
    }

    public <R> Charset fromFileZIO$default$2() {
        return Charsets$.MODULE$.Utf8();
    }

    public <R> Handler<R, Throwable, Object, Response> fromStream(ZStream<R, Throwable, String> stream, long contentLength, Charset charset, Object trace) {
        return this.fromZIO((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.environment(trace).map((Function1 & Serializable & scala.Serializable)env -> MODULE$.fromBody((Function0<Body>)(Function0 & Serializable & scala.Serializable)() -> Body$.MODULE$.fromCharSequenceStream((ZStream<Object, Throwable, CharSequence>)stream.provideEnvironment((Function0 & Serializable & scala.Serializable)() -> env, trace), contentLength, charset, trace)), trace)).flatten(Predef$.MODULE$.$conforms(), trace);
    }

    public <R> Handler<R, Throwable, Object, Response> fromStream(ZStream<R, Throwable, Object> stream, long contentLength, Object trace) {
        return this.fromZIO((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.environment(trace).map((Function1 & Serializable & scala.Serializable)env -> MODULE$.fromBody((Function0<Body>)(Function0 & Serializable & scala.Serializable)() -> Body$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)stream.provideEnvironment((Function0 & Serializable & scala.Serializable)() -> env, trace), contentLength)), trace)).flatten(Predef$.MODULE$.$conforms(), trace);
    }

    public <R> Charset fromStream$default$3() {
        return Charsets$.MODULE$.Http();
    }

    public <R> Handler<R, Throwable, Object, Response> fromStreamChunked(ZStream<R, Throwable, String> stream, Charset charset, Object trace) {
        return this.fromZIO((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.environment(trace).map((Function1 & Serializable & scala.Serializable)env -> MODULE$.fromBody((Function0<Body>)(Function0 & Serializable & scala.Serializable)() -> Body$.MODULE$.fromCharSequenceStreamChunked((ZStream<Object, Throwable, CharSequence>)stream.provideEnvironment((Function0 & Serializable & scala.Serializable)() -> env, trace), charset, trace)), trace)).flatten(Predef$.MODULE$.$conforms(), trace);
    }

    public <R> Handler<R, Throwable, Object, Response> fromStreamChunked(ZStream<R, Throwable, Object> stream, Object trace) {
        return this.fromZIO((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.environment(trace).map((Function1 & Serializable & scala.Serializable)env -> MODULE$.fromBody((Function0<Body>)(Function0 & Serializable & scala.Serializable)() -> Body$.MODULE$.fromStreamChunked((ZStream<Object, Throwable, Object>)stream.provideEnvironment((Function0 & Serializable & scala.Serializable)() -> env, trace))), trace)).flatten(Predef$.MODULE$.$conforms(), trace);
    }

    public <R> Charset fromStreamChunked$default$2() {
        return Charsets$.MODULE$.Http();
    }

    public <R, Err, Out> Handler<R, Err, Object, Out> fromZIO(Function0<ZIO<R, Err, Out>> zio) {
        return new Handler<R, Err, Object, Out>(zio){
            private final Function0 zio$1;

            public <Env1 extends R, In1> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, BoxedUnit> aspect, Handler.IsRequest<In1> in, Predef.$less$colon$less<Out, Response> out, Predef.$less$colon$less<Err, Response> err) {
                return Handler.$at$at$(this, aspect, in, out, err);
            }

            public <Env0, Ctx extends R, In1> Handler<Env0, Response, Request, Response> $at$at(HandlerAspect<Env0, Ctx> aspect, Handler.IsRequest<In1> in, Predef.$less$colon$less<Out, Response> out, Predef.$less$colon$less<Err, Response> err, Object trace, package.Tag<Ctx> tag) {
                return Handler.$at$at$(this, aspect, in, out, err, trace, tag);
            }

            public <Env0> HandlerVersionSpecific.ApplyContextAspect<R, Err, Object, Out, Env0> $at$at() {
                return Handler.$at$at$(this);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $greater$greater$eq(Function1<Out, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.$greater$greater$eq$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, Object, Out1> $greater$greater$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$greater$greater$greater$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out> $less$less$less(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$less$less$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $less$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$greater$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Tuple2<Out, Out1>> $less$times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$greater$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out> $less$times(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$times$greater$(this, that, trace);
            }

            public final <Err1, Out1> Handler<R, Err1, Object, Out1> absolve(Predef.$less$colon$less<Out, Either<Err1, Out1>> ev, Object trace) {
                return Handler.absolve$(this, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, Object, Out1> andThen(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.andThen$(this, that, trace);
            }

            public final <Out1> Handler<R, Err, Object, Out1> as(Out1 out, Object trace) {
                return Handler.as$(this, out, trace);
            }

            public final <R2> Handler<R2, Err, Object, Out> asEnvType(Predef.$less$colon$less<R2, R> ev) {
                return Handler.asEnvType$(this, ev);
            }

            public final <Err2> Handler<R, Err2, Object, Out> asErrorType(Predef.$less$colon$less<Err, Err2> ev) {
                return Handler.asErrorType$(this, ev);
            }

            public final <In2> Handler<R, Err, In2, Out> asInType(Predef.$less$colon$less<In2, Object> ev) {
                return Handler.asInType$(this, ev);
            }

            public final <Out2> Handler<R, Err, Object, Out2> asOutType(Predef.$less$colon$less<Out, Out2> ev) {
                return Handler.asOutType$(this, ev);
            }

            public final Handler<R, Err, Object, Body> body(Predef.$less$colon$less<Out, Response> ev, Object trace) {
                return Handler.body$(this, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAll(Function1<Err, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAll$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAllCause(Function1<Cause<Err>, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllCause$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAllDefect(Function1<Throwable, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllDefect$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchSome(PartialFunction<Err, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSome$(this, pf, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchSomeDefect(PartialFunction<Throwable, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSomeDefect$(this, pf, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out> compose(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.compose$(this, that, trace);
            }

            public final <In1> Handler<R, Err, In1, Out> contramap(Function1<In1, Object> f) {
                return Handler.contramap$(this, f);
            }

            public final <R1 extends R, Err1, In1> Handler<R1, Err1, In1, Out> contramapZIO(Function1<In1, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.contramapZIO$(this, f, trace);
            }

            public final <In1> Handler<R, Err, Object, Out> contraFlatMap() {
                return Handler.contraFlatMap$(this);
            }

            public final Handler<R, Err, Object, Out> delay(Duration duration, Object trace) {
                return Handler.delay$(this, duration, trace);
            }

            public final Handler<R, Err, Object, Out> delayAfter(Duration duration, Object trace) {
                return Handler.delayAfter$(this, duration, trace);
            }

            public final Handler<R, Err, Object, Out> delayBefore(Duration duration, Object trace) {
                return Handler.delayBefore$(this, duration, trace);
            }

            public final Handler<R, Nothing$, Object, Either<Err, Out>> either(CanFail<Err> ev, Object trace) {
                return Handler.either$(this, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> flatten(Predef.$less$colon$less<Out, Handler<R1, Err1, In1, Out1>> ev, Object trace) {
                return Handler.flatten$(this, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> flatMap(Function1<Out, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.flatMap$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> foldCauseHandler(Function1<Cause<Err>, Handler<R1, Err1, In1, Out1>> onFailure, Function1<Out, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldCauseHandler$(this, onFailure, onSuccess, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> foldHandler(Function1<Err, Handler<R1, Err1, In1, Out1>> onFailure, Function1<Out, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldHandler$(this, onFailure, onSuccess, trace);
            }

            public final Handler<R, Err, Object, Headers> headers(Predef.$less$colon$less<Out, Response> ev, Object trace) {
                return Handler.headers$(this, ev, trace);
            }

            public final Handler<R, Err, Object, Option<Header>> header(Header.HeaderType headerType, Predef.$less$colon$less<Out, Response> ev, Object trace) {
                return Handler.header$(this, headerType, ev, trace);
            }

            public final <Out1> Handler<R, Err, Object, Out1> map(Function1<Out, Out1> f, Object trace) {
                return Handler.map$(this, f, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> mapError(Function1<Err, Err1> f, Object trace) {
                return Handler.mapError$(this, f, trace);
            }

            public final <Err2> Handler<R, Err2, Object, Out> mapErrorCause(Function1<Cause<Err>, Err2> f, Object trace) {
                return Handler.mapErrorCause$(this, f, trace);
            }

            public final <R1 extends R, Err1, Out1> Handler<R1, Err1, Object, Out1> mapZIO(Function1<Out, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapZIO$(this, f, trace);
            }

            public final <R1 extends R, Err1, Out1> Handler<R1, Err1, Object, Out1> mapErrorZIO(Function1<Err, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorZIO$(this, f, trace);
            }

            public final <R1 extends R, Err1, Out1> Handler<R1, Err1, Object, Out1> mapErrorCauseZIO(Function1<Cause<Err>, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorCauseZIO$(this, f, trace);
            }

            public final <Err1, Out1> Handler<R, Nothing$, Object, Out1> merge(Predef.$eq$colon$eq<Err1, Out1> ev, Object trace) {
                return Handler.merge$(this, ev, trace);
            }

            public final <In1> Handler<R, Err, In1, Out> narrow(Predef.$less$colon$less<In1, Object> ev) {
                return Handler.narrow$(this, ev);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> onExit(Function1<Exit<Err, Out>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.onExit$(this, f, trace);
            }

            public final Handler<R, Nothing$, Object, Option<Out>> option(CanFail<Err> ev, Object trace) {
                return Handler.option$(this, ev, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Option<Out>> optional(Predef.$less$colon$less<Err, Option<Err1>> ev, Object trace) {
                return Handler.optional$(this, ev, trace);
            }

            public final Handler<R, Nothing$, Object, Out> orDie(Predef.$less$colon$less<Err, Throwable> ev1, CanFail<Err> ev2, Object trace) {
                return Handler.orDie$(this, ev1, ev2, trace);
            }

            public final Handler<R, Nothing$, Object, Out> orDieWith(Function1<Err, Throwable> f, CanFail<Err> ev, Object trace) {
                return Handler.orDieWith$(this, f, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> orElse(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.orElse$(this, that, trace);
            }

            public final Handler<Object, Err, Object, Out> provideEnvironment(ZEnvironment<R> r, Object trace) {
                return Handler.provideEnvironment$(this, r, trace);
            }

            public final <Err1, R0> Handler<R0, Err1, Object, Out> provideLayer(ZLayer<R0, Err1, R> layer, Object trace) {
                return Handler.provideLayer$(this, layer, trace);
            }

            public final <R1> Handler<R1, Err, Object, Out> provideSomeEnvironment(Function1<ZEnvironment<R1>, ZEnvironment<R>> f, Object trace) {
                return Handler.provideSomeEnvironment$(this, f, trace);
            }

            public final <R0, R1, Err1> Handler<R0, Err1, Object, Out> provideSomeLayer(ZLayer<R0, Err1, R1> layer, package.Tag<R1> evidence$1, Predef.$less$colon$less<R0, R> ev, Object trace) {
                return Handler.provideSomeLayer$(this, layer, evidence$1, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> race(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.race$(this, that, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> refineOrDie(PartialFunction<Err, Err1> pf, Predef.$less$colon$less<Err, Throwable> ev1, CanFail<Err> ev2, Object trace) {
                return Handler.refineOrDie$(this, pf, ev1, ev2, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> refineOrDieWith(PartialFunction<Err, Err1> pf, Function1<Err, Throwable> f, CanFail<Err> ev, Object trace) {
                return Handler.refineOrDieWith$(this, pf, f, ev, trace);
            }

            public final ZIO<Scope, Err, Out> run(Method method2, Path path, Headers headers, Body body, Predef.$less$colon$less<Request, Object> ev) {
                return Handler.run$(this, method2, path, headers, body, ev);
            }

            public final Method run$default$1() {
                return Handler.run$default$1$(this);
            }

            public final Path run$default$2() {
                return Handler.run$default$2$(this);
            }

            public final Headers run$default$3() {
                return Handler.run$default$3$(this);
            }

            public final Body run$default$4() {
                return Handler.run$default$4$(this);
            }

            public final ZIO<Scope, Err, Out> runZIO(Object in) {
                return Handler.runZIO$(this, in);
            }

            public final Handler<R, Response, Object, Out> sandbox(Object trace) {
                return Handler.sandbox$(this, trace);
            }

            public final Handler<R, Err, Object, Status> status(Predef.$less$colon$less<Out, Response> ev, Object trace) {
                return Handler.status$(this, ev, trace);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> tapAllZIO(Function1<Cause<Err>, ZIO<R1, Err1, Object>> onFailure, Function1<Out, ZIO<R1, Err1, Object>> onSuccess, Object trace) {
                return Handler.tapAllZIO$(this, onFailure, onSuccess, trace);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> tapErrorCauseZIO(Function1<Cause<Err>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorCauseZIO$(this, f, trace);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> tapErrorZIO(Function1<Err, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorZIO$(this, f, trace);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> tapZIO(Function1<Out, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapZIO$(this, f, trace);
            }

            public Handler<R, Err, Object, Option<Out>> timeout(Duration duration, Object trace) {
                return Handler.timeout$(this, duration, trace);
            }

            public <Out1> Handler<R, Err, Object, Out1> timeoutFail(Out1 out, Duration duration, Object trace) {
                return Handler.timeoutFail$(this, out, duration, trace);
            }

            public Routes<R, Err> toRoutes(Predef.$less$colon$less<Request, Object> in, Predef.$less$colon$less<Out, Response> out, Object trace) {
                return Handler.toRoutes$(this, in, out, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> unrefine(PartialFunction<Throwable, Err1> pf, Object trace) {
                return Handler.unrefine$(this, pf, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> unrefineTo(ClassTag<Err1> evidence$2, Object trace) {
                return Handler.unrefineTo$(this, evidence$2, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> unrefineWith(PartialFunction<Throwable, Err1> pf, Function1<Err, Err1> f, Object trace) {
                return Handler.unrefineWith$(this, pf, f, trace);
            }

            public final <R1 extends R, Err1, Out1> Handler<R1, Err1, Object, Out1> unwrapZIO(Predef.$less$colon$less<Out, ZIO<R1, Err1, Out1>> ev, Object trace) {
                return Handler.unwrapZIO$(this, ev, trace);
            }

            public <Err1, Out1> Handler<R, Err1, Object, Out1> widen(Predef.$less$colon$less<Err, Err1> ev1, Predef.$less$colon$less<Out, Out1> ev2) {
                return Handler.widen$(this, ev1, ev2);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Tuple2<Out, Out1>> zip(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zip$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out> zipLeft(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipLeft$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> zipRight(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipRight$(this, that, trace);
            }

            public ZIO<Scope, Err, Out> apply(Object in) {
                try {
                    return (ZIO)this.zio$1.apply();
                }
                catch (Throwable throwable) {
                    if (NonFatal$.MODULE$.apply(throwable)) {
                        return ZIO$.MODULE$.die((Function0 & Serializable & scala.Serializable)() -> throwable, (Object)"zio.http.Handler.fromZIO.$anon.apply(Handler.scala:997)");
                    }
                    throw throwable;
                }
            }
            {
                this.zio$1 = zio$1;
                Handler.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$13(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public Handler<Object, Nothing$, Object, Response> html(Function0<Html> view) {
        return this.fromResponse((Function0<Response>)(Function0 & Serializable & scala.Serializable)() -> Response$.MODULE$.html((Html)view.apply(), Response$.MODULE$.html$default$2()));
    }

    public <A> Handler<Object, Nothing$, A, A> identity() {
        return new Handler<Object, Nothing$, A, A>(){

            public <Env1, In1 extends A> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, BoxedUnit> aspect, Handler.IsRequest<In1> in, Predef.$less$colon$less<A, Response> out, Predef.$less$colon$less<Nothing$, Response> err) {
                return Handler.$at$at$(this, aspect, in, out, err);
            }

            public <Env0, Ctx, In1 extends A> Handler<Env0, Response, Request, Response> $at$at(HandlerAspect<Env0, Ctx> aspect, Handler.IsRequest<In1> in, Predef.$less$colon$less<A, Response> out, Predef.$less$colon$less<Nothing$, Response> err, Object trace, package.Tag<Ctx> tag) {
                return Handler.$at$at$(this, aspect, in, out, err, trace, tag);
            }

            public <Env0> HandlerVersionSpecific.ApplyContextAspect<Object, Nothing$, A, A, Env0> $at$at() {
                return Handler.$at$at$(this);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> $greater$greater$eq(Function1<A, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.$greater$greater$eq$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, A, Out1> $greater$greater$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$greater$greater$greater$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1 extends A> Handler<R1, Err1, In1, A> $less$less$less(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$less$less$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> $less$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$greater$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Tuple2<A, Out1>> $less$times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$greater$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, A> $less$times(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> $times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$times$greater$(this, that, trace);
            }

            public final <Err1, Out1> Handler<Object, Err1, A, Out1> absolve(Predef.$less$colon$less<A, Either<Err1, Out1>> ev, Object trace) {
                return Handler.absolve$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, A, Out1> andThen(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.andThen$(this, that, trace);
            }

            public final <Out1> Handler<Object, Nothing$, A, Out1> as(Out1 out, Object trace) {
                return Handler.as$(this, out, trace);
            }

            public final <R2> Handler<R2, Nothing$, A, A> asEnvType(Predef.$less$colon$less<R2, Object> ev) {
                return Handler.asEnvType$(this, ev);
            }

            public final <Err2> Handler<Object, Err2, A, A> asErrorType(Predef.$less$colon$less<Nothing$, Err2> ev) {
                return Handler.asErrorType$(this, ev);
            }

            public final <In2> Handler<Object, Nothing$, In2, A> asInType(Predef.$less$colon$less<In2, A> ev) {
                return Handler.asInType$(this, ev);
            }

            public final <Out2> Handler<Object, Nothing$, A, Out2> asOutType(Predef.$less$colon$less<A, Out2> ev) {
                return Handler.asOutType$(this, ev);
            }

            public final Handler<Object, Nothing$, A, Body> body(Predef.$less$colon$less<A, Response> ev, Object trace) {
                return Handler.body$(this, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchAll(Function1<Nothing$, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAll$(this, f, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchAllCause(Function1<Cause<Nothing$>, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllCause$(this, f, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchAllDefect(Function1<Throwable, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllDefect$(this, f, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchSome(PartialFunction<Nothing$, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSome$(this, pf, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchSomeDefect(PartialFunction<Throwable, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSomeDefect$(this, pf, trace);
            }

            public final <R1, Err1, In1, Out1 extends A> Handler<R1, Err1, In1, A> compose(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.compose$(this, that, trace);
            }

            public final <In1> Handler<Object, Nothing$, In1, A> contramap(Function1<In1, A> f) {
                return Handler.contramap$(this, f);
            }

            public final <R1, Err1, In1> Handler<R1, Err1, In1, A> contramapZIO(Function1<In1, ZIO<R1, Err1, A>> f, Object trace) {
                return Handler.contramapZIO$(this, f, trace);
            }

            public final <In1> Handler<Object, Nothing$, A, A> contraFlatMap() {
                return Handler.contraFlatMap$(this);
            }

            public final Handler<Object, Nothing$, A, A> delay(Duration duration, Object trace) {
                return Handler.delay$(this, duration, trace);
            }

            public final Handler<Object, Nothing$, A, A> delayAfter(Duration duration, Object trace) {
                return Handler.delayAfter$(this, duration, trace);
            }

            public final Handler<Object, Nothing$, A, A> delayBefore(Duration duration, Object trace) {
                return Handler.delayBefore$(this, duration, trace);
            }

            public final Handler<Object, Nothing$, A, Either<Nothing$, A>> either(CanFail<Nothing$> ev, Object trace) {
                return Handler.either$(this, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> flatten(Predef.$less$colon$less<A, Handler<R1, Err1, In1, Out1>> ev, Object trace) {
                return Handler.flatten$(this, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> flatMap(Function1<A, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.flatMap$(this, f, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> foldCauseHandler(Function1<Cause<Nothing$>, Handler<R1, Err1, In1, Out1>> onFailure, Function1<A, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldCauseHandler$(this, onFailure, onSuccess, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> foldHandler(Function1<Nothing$, Handler<R1, Err1, In1, Out1>> onFailure, Function1<A, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldHandler$(this, onFailure, onSuccess, trace);
            }

            public final Handler<Object, Nothing$, A, Headers> headers(Predef.$less$colon$less<A, Response> ev, Object trace) {
                return Handler.headers$(this, ev, trace);
            }

            public final Handler<Object, Nothing$, A, Option<Header>> header(Header.HeaderType headerType, Predef.$less$colon$less<A, Response> ev, Object trace) {
                return Handler.header$(this, headerType, ev, trace);
            }

            public final <Out1> Handler<Object, Nothing$, A, Out1> map(Function1<A, Out1> f, Object trace) {
                return Handler.map$(this, f, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> mapError(Function1<Nothing$, Err1> f, Object trace) {
                return Handler.mapError$(this, f, trace);
            }

            public final <Err2> Handler<Object, Err2, A, A> mapErrorCause(Function1<Cause<Nothing$>, Err2> f, Object trace) {
                return Handler.mapErrorCause$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, A, Out1> mapZIO(Function1<A, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapZIO$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, A, Out1> mapErrorZIO(Function1<Nothing$, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorZIO$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, A, Out1> mapErrorCauseZIO(Function1<Cause<Nothing$>, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorCauseZIO$(this, f, trace);
            }

            public final <Err1, Out1> Handler<Object, Nothing$, A, Out1> merge(Predef.$eq$colon$eq<Err1, Out1> ev, Object trace) {
                return Handler.merge$(this, ev, trace);
            }

            public final <In1> Handler<Object, Nothing$, In1, A> narrow(Predef.$less$colon$less<In1, A> ev) {
                return Handler.narrow$(this, ev);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> onExit(Function1<Exit<Nothing$, A>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.onExit$(this, f, trace);
            }

            public final Handler<Object, Nothing$, A, Option<A>> option(CanFail<Nothing$> ev, Object trace) {
                return Handler.option$(this, ev, trace);
            }

            public final <Err1> Handler<Object, Err1, A, Option<A>> optional(Predef.$less$colon$less<Nothing$, Option<Err1>> ev, Object trace) {
                return Handler.optional$(this, ev, trace);
            }

            public final Handler<Object, Nothing$, A, A> orDie(Predef.$less$colon$less<Nothing$, Throwable> ev1, CanFail<Nothing$> ev2, Object trace) {
                return Handler.orDie$(this, ev1, ev2, trace);
            }

            public final Handler<Object, Nothing$, A, A> orDieWith(Function1<Nothing$, Throwable> f, CanFail<Nothing$> ev, Object trace) {
                return Handler.orDieWith$(this, f, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> orElse(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.orElse$(this, that, trace);
            }

            public final Handler<Object, Nothing$, A, A> provideEnvironment(ZEnvironment<Object> r, Object trace) {
                return Handler.provideEnvironment$(this, r, trace);
            }

            public final <Err1, R0> Handler<R0, Err1, A, A> provideLayer(ZLayer<R0, Err1, Object> layer, Object trace) {
                return Handler.provideLayer$(this, layer, trace);
            }

            public final <R1> Handler<R1, Nothing$, A, A> provideSomeEnvironment(Function1<ZEnvironment<R1>, ZEnvironment<Object>> f, Object trace) {
                return Handler.provideSomeEnvironment$(this, f, trace);
            }

            public final <R0, R1, Err1> Handler<R0, Err1, A, A> provideSomeLayer(ZLayer<R0, Err1, R1> layer, package.Tag<R1> evidence$1, Predef.$less$colon$less<R0, Object> ev, Object trace) {
                return Handler.provideSomeLayer$(this, layer, evidence$1, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> race(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.race$(this, that, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> refineOrDie(PartialFunction<Nothing$, Err1> pf, Predef.$less$colon$less<Nothing$, Throwable> ev1, CanFail<Nothing$> ev2, Object trace) {
                return Handler.refineOrDie$(this, pf, ev1, ev2, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> refineOrDieWith(PartialFunction<Nothing$, Err1> pf, Function1<Nothing$, Throwable> f, CanFail<Nothing$> ev, Object trace) {
                return Handler.refineOrDieWith$(this, pf, f, ev, trace);
            }

            public final ZIO<Scope, Nothing$, A> run(Method method2, Path path, Headers headers, Body body, Predef.$less$colon$less<Request, A> ev) {
                return Handler.run$(this, method2, path, headers, body, ev);
            }

            public final Method run$default$1() {
                return Handler.run$default$1$(this);
            }

            public final Path run$default$2() {
                return Handler.run$default$2$(this);
            }

            public final Headers run$default$3() {
                return Handler.run$default$3$(this);
            }

            public final Body run$default$4() {
                return Handler.run$default$4$(this);
            }

            public final ZIO<Scope, Nothing$, A> runZIO(A in) {
                return Handler.runZIO$(this, in);
            }

            public final Handler<Object, Response, A, A> sandbox(Object trace) {
                return Handler.sandbox$(this, trace);
            }

            public final Handler<Object, Nothing$, A, Status> status(Predef.$less$colon$less<A, Response> ev, Object trace) {
                return Handler.status$(this, ev, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> tapAllZIO(Function1<Cause<Nothing$>, ZIO<R1, Err1, Object>> onFailure, Function1<A, ZIO<R1, Err1, Object>> onSuccess, Object trace) {
                return Handler.tapAllZIO$(this, onFailure, onSuccess, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> tapErrorCauseZIO(Function1<Cause<Nothing$>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorCauseZIO$(this, f, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> tapErrorZIO(Function1<Nothing$, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorZIO$(this, f, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> tapZIO(Function1<A, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapZIO$(this, f, trace);
            }

            public Handler<Object, Nothing$, A, Option<A>> timeout(Duration duration, Object trace) {
                return Handler.timeout$(this, duration, trace);
            }

            public <Out1> Handler<Object, Nothing$, A, Out1> timeoutFail(Out1 out, Duration duration, Object trace) {
                return Handler.timeoutFail$(this, out, duration, trace);
            }

            public Routes<Object, Nothing$> toRoutes(Predef.$less$colon$less<Request, A> in, Predef.$less$colon$less<A, Response> out, Object trace) {
                return Handler.toRoutes$(this, in, out, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> unrefine(PartialFunction<Throwable, Err1> pf, Object trace) {
                return Handler.unrefine$(this, pf, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> unrefineTo(ClassTag<Err1> evidence$2, Object trace) {
                return Handler.unrefineTo$(this, evidence$2, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> unrefineWith(PartialFunction<Throwable, Err1> pf, Function1<Nothing$, Err1> f, Object trace) {
                return Handler.unrefineWith$(this, pf, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, A, Out1> unwrapZIO(Predef.$less$colon$less<A, ZIO<R1, Err1, Out1>> ev, Object trace) {
                return Handler.unwrapZIO$(this, ev, trace);
            }

            public <Err1, Out1> Handler<Object, Err1, A, Out1> widen(Predef.$less$colon$less<Nothing$, Err1> ev1, Predef.$less$colon$less<A, Out1> ev2) {
                return Handler.widen$(this, ev1, ev2);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Tuple2<A, Out1>> zip(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zip$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, A> zipLeft(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipLeft$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> zipRight(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipRight$(this, that, trace);
            }

            public ZIO<Object, Nothing$, A> apply(A in) {
                return Exit$.MODULE$.succeed(in);
            }
            {
                Handler.$init$(this);
            }
        };
    }

    public Handler<Object, Nothing$, Object, Response> internalServerError() {
        return this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$InternalServerError$.MODULE$);
    }

    public Handler<Object, Nothing$, Object, Response> internalServerError(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$InternalServerError$.MODULE$, message);
    }

    public Handler<Object, Nothing$, Object, Response> methodNotAllowed() {
        return this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$MethodNotAllowed$.MODULE$);
    }

    public Handler<Object, Nothing$, Object, Response> methodNotAllowed(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$MethodNotAllowed$.MODULE$, message);
    }

    public Handler<Object, Nothing$, Request, Response> notFound() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Handler.scala: 1036");
        }
        return this.notFound;
    }

    public Handler<Object, Nothing$, Object, Response> notFound(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$NotFound$.MODULE$, message);
    }

    public Handler<Object, Nothing$, Object, Response> ok() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Handler.scala: 1048");
        }
        return this.ok;
    }

    public <A> BoxedUnit param() {
        return BoxedUnit.UNIT;
    }

    public Handler<Object, Nothing$, Object, Response> fromResponse(Function0<Response> response) {
        return this.succeed(response);
    }

    public <R, Err> Handler<R, Err, Object, Response> fromResponseZIO(ZIO<R, Err, Response> getResponse) {
        return this.fromZIO((Function0 & Serializable & scala.Serializable)() -> getResponse);
    }

    public <R> boolean scoped() {
        return this.scopedPartiallyApplied();
    }

    public Handler<Object, Nothing$, Object, StackTrace> stackTrace(Object trace) {
        return this.fromZIO((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.stackTrace(trace));
    }

    public Handler<Object, Nothing$, Object, Response> status(Function0<Status> code) {
        return this.succeed((Function0 & Serializable & scala.Serializable)() -> new Response((Status)code.apply(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3()));
    }

    public <Out> Handler<Object, Nothing$, Object, Out> succeed(Function0<Out> out) {
        return this.fromExit((Function0 & Serializable & scala.Serializable)() -> Exit$.MODULE$.succeed(out.apply()));
    }

    public Handler<Object, Nothing$, Object, Response> template(Function0<CharSequence> heading, Html view) {
        return this.fromResponse((Function0<Response>)(Function0 & Serializable & scala.Serializable)() -> Response$.MODULE$.html(Template$.MODULE$.container((CharSequence)heading.apply(), view), Response$.MODULE$.html$default$2()));
    }

    public Handler<Object, Nothing$, Object, Response> text(Function0<CharSequence> text) {
        return this.fromResponse((Function0<Response>)(Function0 & Serializable & scala.Serializable)() -> Response$.MODULE$.text((CharSequence)text.apply()));
    }

    public Handler<Object, Nothing$, Object, Response> timeout(Duration duration, Object trace) {
        return this.status((Function0<Status>)(Function0 & Serializable & scala.Serializable)() -> Status$RequestTimeout$.MODULE$).delay(duration, trace);
    }

    public Handler<Object, Nothing$, Object, Response> tooLarge() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Handler.scala: 1115");
        }
        return this.tooLarge;
    }

    public Handler<Object, Nothing$, Object, BoxedUnit> unit() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Handler.scala: 1118");
        }
        return this.unit;
    }

    public final <Env> WebSocketApp<Env> webSocket(Function1<Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>>, ZIO<Env, Throwable, Object>> f) {
        return WebSocketApp$.MODULE$.apply(Handler$FromFunctionZIO$.MODULE$.apply$extension(this.fromFunctionZIO(), f));
    }

    public <R, Err> Handler.RequestHandlerSyntax<R, Err> RequestHandlerSyntax(Handler<R, Err, Request, Response> self) {
        return new Handler.RequestHandlerSyntax<R, Err>(self);
    }

    public <R, Err, In> Handler<R, Err, In, Response> ResponseOutputSyntax(Handler<R, Err, In, Response> self) {
        return self;
    }

    private boolean scopedPartiallyApplied() {
        if ((this.bitmap$init$0 & 0x10000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Handler.scala: 1302");
        }
        return this.scopedPartiallyApplied;
    }

    public static final /* synthetic */ boolean $anonfun$asChunkBounded$5(int limit$1, Chunk x$33) {
        return x$33.size() < limit$1;
    }

    public static final /* synthetic */ boolean $anonfun$firstSuccessOf$default$2$1(Cause cause) {
        return !cause.isDie();
    }

    public static final /* synthetic */ Response $anonfun$fromFileZIO$7(Response response$1, MediaType mediaType$1, Option charset0$1) {
        Option<Boundary> x$6 = Header$ContentType$.MODULE$.apply$default$2();
        return (Response)response$1.addHeader(new Header.ContentType(mediaType$1, x$6, (Option<Charset>)charset0$1));
    }

    private Handler$() {
        MODULE$ = this;
        HandlerPlatformSpecific.$init$(this);
        HandlerVersionSpecific.$init$(this);
        this.zio$http$Handler$$errorMediaTypes = new .colon.colon((Object)MediaType$.MODULE$.text().html(), (List)new .colon.colon((Object)MediaType$.MODULE$.application().json(), (List)new .colon.colon((Object)MediaType$.MODULE$.text().plain(), (List)Nil$.MODULE$)));
        this.bitmap$init$0 |= 1;
        this.badRequest = this.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$BadRequest$.MODULE$);
        this.bitmap$init$0 |= 4;
        this.notFound = Handler$FromFunctionHandler$.MODULE$.apply$extension(this.fromFunctionHandler(), (Function1 & Serializable & scala.Serializable)request -> MODULE$.error((Function0<Status.Error>)(Function0 & Serializable & scala.Serializable)() -> Status$NotFound$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> request.url().path().encode()));
        this.bitmap$init$0 |= 8;
        this.ok = this.status((Function0<Status>)(Function0 & Serializable & scala.Serializable)() -> Status$Ok$.MODULE$);
        this.bitmap$init$0 |= 0x10;
        this.tooLarge = this.status((Function0<Status>)(Function0 & Serializable & scala.Serializable)() -> Status$RequestEntityTooLarge$.MODULE$);
        this.bitmap$init$0 |= 0x20;
        this.unit = this.fromExit((Function0 & Serializable & scala.Serializable)() -> Exit$.MODULE$.unit());
        this.bitmap$init$0 |= 0x40;
        this.scopedPartiallyApplied = Handler$ScopedPartiallyApplied$.MODULE$.$lessinit$greater$default$1();
        this.bitmap$init$0 |= 0x10000;
    }
}

