/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Chunk;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.ErrorResponseConfig;
import zio.http.ErrorResponseConfig$;
import zio.http.ErrorResponseConfig$ErrorFormat$Html$;
import zio.http.ErrorResponseConfig$ErrorFormat$Json$;
import zio.http.ErrorResponseConfig$ErrorFormat$Text$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Response;
import zio.http.ServerSentEvent;
import zio.http.ServerSentEvent$;
import zio.http.Status;
import zio.http.Status$BadRequest$;
import zio.http.Status$Forbidden$;
import zio.http.Status$GatewayTimeout$;
import zio.http.Status$HttpVersionNotSupported$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$NetworkAuthenticationRequired$;
import zio.http.Status$NotExtended$;
import zio.http.Status$NotFound$;
import zio.http.Status$NotImplemented$;
import zio.http.Status$Ok$;
import zio.http.Status$PermanentRedirect$;
import zio.http.Status$RequestTimeout$;
import zio.http.Status$SeeOther$;
import zio.http.Status$ServiceUnavailable$;
import zio.http.Status$SwitchingProtocols$;
import zio.http.Status$TemporaryRedirect$;
import zio.http.Status$Unauthorized$;
import zio.http.URL;
import zio.http.WebSocketApp;
import zio.http.internal.OutputEncoder$;
import zio.http.template.Html;
import zio.http.template.Html$;
import zio.http.template.IsAttributeValue$;
import zio.http.template.Template$;
import zio.http.template.package$;
import zio.schema.Schema;
import zio.schema.codec.BinaryCodec;
import zio.stream.ZStream;

public final class Response$
implements scala.Serializable {
    public static Response$ MODULE$;
    private final Headers contentTypeJson;
    private final Headers contentTypeHtml;
    private final Headers contentTypeText;
    private final Headers contentTypeEventStream;
    private volatile byte bitmap$init$0;

    static {
        new Response$();
    }

    public Status $lessinit$greater$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers $lessinit$greater$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body $lessinit$greater$default$3() {
        return Body$.MODULE$.empty();
    }

    public Response badRequest() {
        return this.error(Status$BadRequest$.MODULE$);
    }

    public Response badRequest(String message) {
        return this.error((Status.Error)Status$BadRequest$.MODULE$, message);
    }

    public Response error(Status.Error status, String message) {
        Body x$2 = Body$.MODULE$.fromString(OutputEncoder$.MODULE$.encodeHtml(message), Body$.MODULE$.fromString$default$2());
        Headers x$3 = this.apply$default$2();
        return new Response(status, x$3, x$2);
    }

    public Response error(Status.Error status, Body body) {
        Headers x$3 = body.mediaType().isEmpty() ? Headers$.MODULE$.empty() : Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType((MediaType)body.mediaType().get(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3())}));
        return new Response(status, x$3, body);
    }

    public Response error(Status.Error status) {
        return new Response(status, this.apply$default$2(), this.apply$default$3());
    }

    public Response forbidden() {
        return this.error(Status$Forbidden$.MODULE$);
    }

    public Response forbidden(String message) {
        return this.error((Status.Error)Status$Forbidden$.MODULE$, message);
    }

    public Response fromCause(Cause<Object> cause) {
        return this.fromCause(cause, ErrorResponseConfig$.MODULE$.default());
    }

    public Response fromCause(Cause<Object> cause, ErrorResponseConfig config) {
        Body body;
        while (true) {
            Object failure;
            Object failure2;
            boolean bl = false;
            Left left = null;
            Either either = cause.failureOrCause();
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Object failure3 = left.value();
                if (failure3 instanceof Response) {
                    return (Response)failure3;
                }
            }
            if (bl && (failure2 = left.value()) instanceof Throwable) {
                Throwable throwable = (Throwable)failure2;
                return this.fromThrowable(throwable, config);
            }
            if (!bl || !((failure = left.value()) instanceof Cause)) break;
            cause = (Cause)failure;
        }
        Body body2 = body = config.withErrorBody() ? Body$.MODULE$.fromString(cause.prettyPrint(), Body$.MODULE$.fromString$default$2()).contentType(MediaType$.MODULE$.text().plain()) : Body$.MODULE$.empty();
        if (cause.isInterruptedOnly()) {
            return this.error((Status.Error)Status$RequestTimeout$.MODULE$, body);
        }
        return this.error((Status.Error)Status$InternalServerError$.MODULE$, body);
    }

    public <E> Response fromCauseWith(Cause<E> cause, ErrorResponseConfig config, Function1<E, Response> f) {
        Either either = cause.failureOrCause();
        if (either instanceof Left) {
            Object failure = ((Left)either).value();
            return (Response)f.apply(failure);
        }
        if (either instanceof Right) {
            Cause cause2 = (Cause)((Right)either).value();
            return this.fromCause((Cause<Object>)cause2, config);
        }
        throw new MatchError((Object)either);
    }

    public <T> Response fromServerSentEvents(ZStream<Object, Nothing$, ServerSentEvent<T>> data, Schema<T> evidence$1, Object trace) {
        BinaryCodec codec2 = ServerSentEvent$.MODULE$.defaultBinaryCodec(evidence$1);
        return new Response(Status$Ok$.MODULE$, this.contentTypeEventStream(), Body$.MODULE$.fromCharSequenceStreamChunked((ZStream<Object, Throwable, CharSequence>)data.map((Function1 & Serializable & scala.Serializable)x$5 -> ((Chunk)codec2.encode(x$5)).asString(Chunk.IsText$.MODULE$.byteIsText()), trace), Body$.MODULE$.fromCharSequenceStreamChunked$default$2(), trace));
    }

    public <R> ZIO<R, Nothing$, Response> fromSocketApp(WebSocketApp<R> app, Object trace) {
        return ZIO$.MODULE$.environment(trace).map((Function1 & Serializable & scala.Serializable)env -> new Response(Status$SwitchingProtocols$.MODULE$, Headers$.MODULE$.empty(), Body$.MODULE$.fromSocketApp(app.provideEnvironment((ZEnvironment)env, trace))), trace);
    }

    public Response fromThrowable(Throwable throwable) {
        return this.fromThrowable(throwable, ErrorResponseConfig$.MODULE$.default());
    }

    public Response fromThrowable(Throwable throwable, ErrorResponseConfig config) {
        if (throwable instanceof AccessDeniedException) {
            return this.error((Status.Error)Status$Forbidden$.MODULE$, this.throwableToMessage(throwable, Status$Forbidden$.MODULE$, config));
        }
        if (throwable instanceof IllegalAccessException) {
            return this.error((Status.Error)Status$Forbidden$.MODULE$, this.throwableToMessage(throwable, Status$Forbidden$.MODULE$, config));
        }
        if (throwable instanceof IllegalAccessError) {
            return this.error((Status.Error)Status$Forbidden$.MODULE$, this.throwableToMessage(throwable, Status$Forbidden$.MODULE$, config));
        }
        if (throwable instanceof NotDirectoryException) {
            return this.error((Status.Error)Status$BadRequest$.MODULE$, this.throwableToMessage(throwable, Status$BadRequest$.MODULE$, config));
        }
        if (throwable instanceof IllegalArgumentException) {
            return this.error((Status.Error)Status$BadRequest$.MODULE$, this.throwableToMessage(throwable, Status$BadRequest$.MODULE$, config));
        }
        if (throwable instanceof FileNotFoundException) {
            return this.error((Status.Error)Status$NotFound$.MODULE$, this.throwableToMessage(throwable, Status$NotFound$.MODULE$, config));
        }
        if (throwable instanceof ConnectException) {
            return this.error((Status.Error)Status$ServiceUnavailable$.MODULE$, this.throwableToMessage(throwable, Status$ServiceUnavailable$.MODULE$, config));
        }
        if (throwable instanceof SocketTimeoutException) {
            return this.error((Status.Error)Status$GatewayTimeout$.MODULE$, this.throwableToMessage(throwable, Status$GatewayTimeout$.MODULE$, config));
        }
        return this.error((Status.Error)Status$InternalServerError$.MODULE$, this.throwableToMessage(throwable, Status$InternalServerError$.MODULE$, config));
    }

    private Body throwableToMessage(Throwable throwable, Status status, ErrorResponseConfig config) {
        StackTraceElement[] rawTrace;
        if (!config.withErrorBody()) {
            return Body$.MODULE$.empty();
        }
        StackTraceElement[] stackTraceElementArray = rawTrace = config.withStackTrace() ? throwable.getStackTrace() : (StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class));
        String stackTrace = config.withStackTrace() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawTrace)).nonEmpty() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(config.maxStackTraceDepth() == 0 ? (Object[])rawTrace : (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawTrace)).take(config.maxStackTraceDepth()))).mkString("\n", "\n", "") : "";
        String message = throwable.getMessage() == null ? "" : throwable.getMessage();
        return this.bodyFromThrowable(message, stackTrace, status, config);
    }

    private Body bodyFromThrowable(String message, String stackTrace, Status status, ErrorResponseConfig config) {
        ErrorResponseConfig.ErrorFormat errorFormat = config.errorFormat();
        if (ErrorResponseConfig$ErrorFormat$Html$.MODULE$.equals(errorFormat)) {
            return Response$.htmlResponse$1(status, message, stackTrace).contentType(config.errorFormat().mediaType());
        }
        if (ErrorResponseConfig$ErrorFormat$Text$.MODULE$.equals(errorFormat)) {
            return Response$.textResponse$1(status, message, stackTrace).contentType(config.errorFormat().mediaType());
        }
        if (ErrorResponseConfig$ErrorFormat$Json$.MODULE$.equals(errorFormat)) {
            return Response$.jsonMessage$1(status, message, stackTrace).contentType(config.errorFormat().mediaType());
        }
        throw new MatchError((Object)errorFormat);
    }

    public Response gatewayTimeout() {
        return this.error(Status$GatewayTimeout$.MODULE$);
    }

    public Response gatewayTimeout(String message) {
        return this.error((Status.Error)Status$GatewayTimeout$.MODULE$, message);
    }

    public Response html(Html data, Status status) {
        return new Response(status, this.contentTypeHtml(), Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2()));
    }

    public Status html$default$2() {
        return Status$Ok$.MODULE$;
    }

    public Response httpVersionNotSupported() {
        return this.error(Status$HttpVersionNotSupported$.MODULE$);
    }

    public Response httpVersionNotSupported(String message) {
        return this.error((Status.Error)Status$HttpVersionNotSupported$.MODULE$, message);
    }

    public Response internalServerError() {
        return this.error(Status$InternalServerError$.MODULE$);
    }

    public Response internalServerError(String message) {
        return this.error((Status.Error)Status$InternalServerError$.MODULE$, message);
    }

    public Response json(CharSequence data) {
        return new Response(Status$Ok$.MODULE$, this.contentTypeJson(), Body$.MODULE$.fromCharSequence(data, Body$.MODULE$.fromCharSequence$default$2()));
    }

    public Response networkAuthenticationRequired() {
        return this.error(Status$NetworkAuthenticationRequired$.MODULE$);
    }

    public Response networkAuthenticationRequired(String message) {
        return this.error((Status.Error)Status$NetworkAuthenticationRequired$.MODULE$, message);
    }

    public Response notExtended() {
        return this.error(Status$NotExtended$.MODULE$);
    }

    public Response notExtended(String message) {
        return this.error((Status.Error)Status$NotExtended$.MODULE$, message);
    }

    public Response notFound() {
        return this.error(Status$NotFound$.MODULE$);
    }

    public Response notFound(String message) {
        return this.error((Status.Error)Status$NotFound$.MODULE$, message);
    }

    public Response notImplemented() {
        return this.error(Status$NotImplemented$.MODULE$);
    }

    public Response notImplemented(String message) {
        return this.error((Status.Error)Status$NotImplemented$.MODULE$, message);
    }

    public Response ok() {
        return this.status(Status$Ok$.MODULE$);
    }

    public Response redirect(URL location, boolean isPermanent) {
        Status.Redirection status = isPermanent ? Status$PermanentRedirect$.MODULE$ : Status$TemporaryRedirect$.MODULE$;
        return new Response(status, Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Location(location)})), this.apply$default$3());
    }

    public boolean redirect$default$2() {
        return false;
    }

    public Response seeOther(URL location) {
        return new Response(Status$SeeOther$.MODULE$, Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Location(location)})), this.apply$default$3());
    }

    public Response serviceUnavailable() {
        return this.error(Status$ServiceUnavailable$.MODULE$);
    }

    public Response serviceUnavailable(String message) {
        return this.error((Status.Error)Status$ServiceUnavailable$.MODULE$, message);
    }

    public Response status(Status status) {
        return new Response(status, this.apply$default$2(), this.apply$default$3());
    }

    public Response text(CharSequence text) {
        return new Response(Status$Ok$.MODULE$, this.contentTypeText(), Body$.MODULE$.fromCharSequence(text, Body$.MODULE$.fromCharSequence$default$2()));
    }

    public Response unauthorized() {
        return this.error(Status$Unauthorized$.MODULE$);
    }

    public Response unauthorized(String message) {
        return this.error((Status.Error)Status$Unauthorized$.MODULE$, message);
    }

    private Headers contentTypeJson() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Response.scala: 429");
        }
        return this.contentTypeJson;
    }

    private Headers contentTypeHtml() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Response.scala: 430");
        }
        return this.contentTypeHtml;
    }

    private Headers contentTypeText() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Response.scala: 431");
        }
        return this.contentTypeText;
    }

    private Headers contentTypeEventStream() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/shared/src/main/scala/zio/http/Response.scala: 432");
        }
        return this.contentTypeEventStream;
    }

    public Response apply(Status status, Headers headers, Body body) {
        return new Response(status, headers, body);
    }

    public Status apply$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers apply$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body apply$default$3() {
        return Body$.MODULE$.empty();
    }

    public Option<Tuple3<Status, Headers, Body>> unapply(Response x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.status(), (Object)x$0.headers(), (Object)x$0.body()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Body htmlResponse$1(Status status$1, String message$1, String stackTrace$1) {
        Html data = Template$.MODULE$.container(String.valueOf(status$1), Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)Predef$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)Predef$.MODULE$.wrapRefArray((Object[])new Html[]{package$.MODULE$.styles().$colon$eq("text-align: center", IsAttributeValue$.MODULE$.instanceString()), Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)Predef$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(String.valueOf(BoxesRunTime.boxToInteger((int)status$1.code()))), package$.MODULE$.styles().$colon$eq("font-size: 20em", IsAttributeValue$.MODULE$.instanceString())}))), Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)Predef$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(message$1)}))), Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)Predef$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(stackTrace$1)})))})))}))));
        return Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2());
    }

    private static final Body textResponse$1(Status status$1, String message$1, String stackTrace$1) {
        int statusCode = status$1.code();
        return Body$.MODULE$.fromString(new StringBuilder(47).append("\u001b[1m").append("\u001b[31m").append(status$1).append("\u001b[0m").append(" - ").append("\u001b[1m").append("\u001b[36m").append(statusCode).append("\u001b[0m").append(" - ").append(message$1).append("\u001b[1m").append("\u001b[31m").append(" ").append(stackTrace$1).append(" ").append("\u001b[0m").toString(), Body$.MODULE$.fromString$default$2());
    }

    private static final Body jsonMessage$1(Status status$1, String message$1, String stackTrace$1) {
        return Body$.MODULE$.fromString(new StringBuilder(47).append("{\"status\": \"").append(status$1.code()).append("\", \"message\": \"").append(message$1).append("\", \"stackTrace\": \"").append(stackTrace$1).append("\"}").toString(), Body$.MODULE$.fromString$default$2());
    }

    private Response$() {
        MODULE$ = this;
        this.contentTypeJson = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.application().json(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.contentTypeHtml = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().html(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.contentTypeText = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().plain(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.contentTypeEventStream = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().event$minusstream(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

