/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple6;
import scala.UninitializedFieldError;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.Config;
import zio.Config$;
import zio.Duration$;
import zio.Zippable$;
import zio.http.netty.ChannelType;
import zio.http.netty.ChannelType$AUTO$;
import zio.http.netty.ChannelType$EPOLL$;
import zio.http.netty.ChannelType$KQUEUE$;
import zio.http.netty.ChannelType$NIO$;
import zio.http.netty.ChannelType$URING$;
import zio.http.netty.EventLoopGroups;
import zio.http.netty.NettyConfig;
import zio.http.netty.NettyConfig$LeakDetectionLevel$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$SIMPLE$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NettyConfig$
implements scala.Serializable {
    public static NettyConfig$ MODULE$;
    private final NettyConfig default;
    private final NettyConfig defaultWithFastShutdown;
    private volatile byte bitmap$init$0;

    static {
        new NettyConfig$();
    }

    private Config<EventLoopGroups.Config> baseConfig() {
        return Config$.MODULE$.string("channel-type").mapOrFail((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if ("auto".equals(x0$1)) {
                return package$.MODULE$.Right().apply((Object)ChannelType$AUTO$.MODULE$);
            }
            if ("nio".equals(x0$1)) {
                return package$.MODULE$.Right().apply((Object)ChannelType$NIO$.MODULE$);
            }
            if ("epoll".equals(x0$1)) {
                return package$.MODULE$.Right().apply((Object)ChannelType$EPOLL$.MODULE$);
            }
            if ("kqueue".equals(x0$1)) {
                return package$.MODULE$.Right().apply((Object)ChannelType$KQUEUE$.MODULE$);
            }
            if ("uring".equals(x0$1)) {
                return package$.MODULE$.Right().apply((Object)ChannelType$URING$.MODULE$);
            }
            String x$1 = new StringBuilder(22).append("Invalid channel type: ").append((String)x0$1).toString();
            Chunk x$2 = Config.Error$.InvalidData$.MODULE$.apply$default$1();
            return package$.MODULE$.Left().apply((Object)new Config.Error.InvalidData(x$2, x$1));
        }).withDefault((Function0 & Serializable & scala.Serializable)() -> MODULE$.default().channelType()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.int("max-threads").withDefault((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.default().nThreads()), Zippable$.MODULE$.Zippable2()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("shutdown-quiet-period").withDefault((Function0 & Serializable & scala.Serializable)() -> MODULE$.default().shutdownQuietPeriodDuration()), Zippable$.MODULE$.Zippable3()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("shutdown-timeout").withDefault((Function0 & Serializable & scala.Serializable)() -> MODULE$.default().shutdownTimeoutDuration()), Zippable$.MODULE$.Zippable4()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                ChannelType channelT = (ChannelType)x0$2._1();
                int maxThreads = BoxesRunTime.unboxToInt((Object)x0$2._2());
                Duration quietPeriod = (Duration)x0$2._3();
                Duration timeout = (Duration)x0$2._4();
                return new EventLoopGroups.Config(channelT, maxThreads, quietPeriod, timeout){
                    private final ChannelType channelType;
                    private final int nThreads;
                    private final long shutdownQuietPeriod;
                    private final long shutdownTimeOut;
                    private final TimeUnit shutdownTimeUnit;
                    private volatile byte bitmap$init$0;

                    public ChannelType channelType() {
                        if ((byte)(this.bitmap$init$0 & 1) == 0) {
                            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/NettyConfig.scala: 93");
                        }
                        return this.channelType;
                    }

                    public int nThreads() {
                        if ((byte)(this.bitmap$init$0 & 2) == 0) {
                            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/NettyConfig.scala: 94");
                        }
                        return this.nThreads;
                    }

                    public long shutdownQuietPeriod() {
                        if ((byte)(this.bitmap$init$0 & 4) == 0) {
                            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/NettyConfig.scala: 95");
                        }
                        return this.shutdownQuietPeriod;
                    }

                    public long shutdownTimeOut() {
                        if ((byte)(this.bitmap$init$0 & 8) == 0) {
                            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/NettyConfig.scala: 96");
                        }
                        return this.shutdownTimeOut;
                    }

                    public TimeUnit shutdownTimeUnit() {
                        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
                            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/NettyConfig.scala: 97");
                        }
                        return this.shutdownTimeUnit;
                    }
                    {
                        this.channelType = channelT$1;
                        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                        this.nThreads = maxThreads$1;
                        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                        this.shutdownQuietPeriod = quietPeriod$1.toMillis();
                        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
                        this.shutdownTimeOut = timeout$1.toMillis();
                        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
                        this.shutdownTimeUnit = TimeUnit.MILLISECONDS;
                        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
                    }
                };
            }
            throw new MatchError(null);
        });
    }

    public Config<NettyConfig> config() {
        return NettyConfig$LeakDetectionLevel$.MODULE$.config().nested((Function0 & Serializable & scala.Serializable)() -> "leak-detection-level").withDefault((Function0 & Serializable & scala.Serializable)() -> MODULE$.default().leakDetectionLevel()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$.baseConfig().nested((Function0 & Serializable & scala.Serializable)() -> "worker-group").orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.baseConfig()), Zippable$.MODULE$.Zippable2()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$.baseConfig().nested((Function0 & Serializable & scala.Serializable)() -> "boss-group"), Zippable$.MODULE$.Zippable3()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                NettyConfig.LeakDetectionLevel leakDetectionLevel = (NettyConfig.LeakDetectionLevel)x0$1._1();
                EventLoopGroups.Config worker = (EventLoopGroups.Config)x0$1._2();
                EventLoopGroups.Config boss = (EventLoopGroups.Config)x0$1._3();
                return new NettyConfig(leakDetectionLevel, worker.channelType(), worker.nThreads(), NettyConfig$.toDuration$1(worker.shutdownQuietPeriod(), worker.shutdownTimeUnit()), NettyConfig$.toDuration$1(worker.shutdownTimeOut(), worker.shutdownTimeUnit()), new NettyConfig.BossGroup(boss.channelType(), boss.nThreads(), NettyConfig$.toDuration$1(boss.shutdownQuietPeriod(), boss.shutdownTimeUnit()), NettyConfig$.toDuration$1(boss.shutdownTimeOut(), boss.shutdownTimeUnit())));
            }
            throw new MatchError(null);
        });
    }

    public NettyConfig default() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/NettyConfig.scala: 121");
        }
        return this.default;
    }

    public NettyConfig defaultWithFastShutdown() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/NettyConfig.scala: 140");
        }
        return this.defaultWithFastShutdown;
    }

    public NettyConfig apply(NettyConfig.LeakDetectionLevel leakDetectionLevel, ChannelType channelType, int nThreads, Duration shutdownQuietPeriodDuration, Duration shutdownTimeoutDuration, NettyConfig.BossGroup bossGroup) {
        return new NettyConfig(leakDetectionLevel, channelType, nThreads, shutdownQuietPeriodDuration, shutdownTimeoutDuration, bossGroup);
    }

    public Option<Tuple6<NettyConfig.LeakDetectionLevel, ChannelType, Object, Duration, Duration, NettyConfig.BossGroup>> unapply(NettyConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.leakDetectionLevel(), (Object)x$0.channelType(), (Object)BoxesRunTime.boxToInteger((int)x$0.nThreads()), (Object)x$0.shutdownQuietPeriodDuration(), (Object)x$0.shutdownTimeoutDuration(), (Object)x$0.bossGroup()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Duration toDuration$1(long n, TimeUnit timeUnit) {
        return Duration$.MODULE$.fromJava(Duration.of(n, timeUnit.toChronoUnit()));
    }

    private NettyConfig$() {
        MODULE$ = this;
        Duration quietPeriod = Duration$.MODULE$.fromSeconds(2L);
        Duration timeout = Duration$.MODULE$.fromSeconds(15L);
        this.default = new NettyConfig(NettyConfig$LeakDetectionLevel$SIMPLE$.MODULE$, ChannelType$AUTO$.MODULE$, Runtime.getRuntime().availableProcessors(), quietPeriod, timeout, new NettyConfig.BossGroup(ChannelType$AUTO$.MODULE$, 1, quietPeriod, timeout));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        Duration quietPeriod2 = Duration$.MODULE$.fromMillis(50L);
        Duration timeout2 = Duration$.MODULE$.fromMillis(250L);
        ChannelType x$3 = this.default().bossGroup().copy$default$1();
        int x$4 = this.default().bossGroup().copy$default$2();
        NettyConfig.BossGroup x$7 = this.default().bossGroup().copy(x$3, x$4, quietPeriod2, timeout2);
        NettyConfig.LeakDetectionLevel x$8 = this.default().copy$default$1();
        ChannelType x$9 = this.default().copy$default$2();
        int x$10 = this.default().copy$default$3();
        this.defaultWithFastShutdown = this.default().copy(x$8, x$9, x$10, quietPeriod2, timeout2, x$7);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

