/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Chunk;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.Random$;
import zio.Scope;
import zio.Scope$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZKeyedPool;
import zio.ZKeyedPool$;
import zio.http.ClientSSLConfig;
import zio.http.ConnectionPoolConfig;
import zio.http.ConnectionPoolConfig$Disabled$;
import zio.http.Decompression;
import zio.http.DnsResolver;
import zio.http.Proxy;
import zio.http.URL;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyProxy$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.client.ClientSSLConverter$;
import zio.http.netty.client.NettyClientDriver;
import zio.http.netty.client.NettyConnectionPool;
import zio.http.netty.client.NettyConnectionPool$BootstrapSyntax$;
import zio.http.netty.package$Names$;
import zio.package;

public final class NettyConnectionPool$ {
    public static NettyConnectionPool$ MODULE$;
    private volatile byte bitmap$init$0;

    static {
        new NettyConnectionPool$();
    }

    public ZIO<Scope, Throwable, Channel> createChannel(ChannelFactory<Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime, URL.Location.Absolute location, Option<Proxy> proxy, ClientSSLConfig sslOptions, int maxInitialLineLength, int maxHeaderSize, Decompression decompression, Option<Duration> idleTimeout, Option<Duration> connectionTimeout, Option<InetSocketAddress> localAddress, DnsResolver dnsResolver, Object trace) {
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(proxy, location, sslOptions, idleTimeout, nettyRuntime, trace, maxInitialLineLength, maxHeaderSize, decompression){
            private final Option proxy$1;
            private final URL.Location.Absolute location$1;
            private final ClientSSLConfig sslOptions$1;
            private final Option idleTimeout$1;
            private final NettyRuntime nettyRuntime$1;
            private final Object trace$1;
            private final int maxInitialLineLength$1;
            private final int maxHeaderSize$1;
            private final Decompression decompression$1;

            public void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                Option option = this.proxy$1;
                if (option instanceof Some) {
                    Proxy proxy = (Proxy)((Some)option).value();
                    pipeline.addLast(package$Names$.MODULE$.ProxyHandler(), (ChannelHandler)NettyProxy$.MODULE$.fromProxy(proxy).encode().getOrElse((Function0 & Serializable & scala.Serializable)() -> new HttpProxyHandler((SocketAddress)new InetSocketAddress($this.location$1.host(), $this.location$1.port()))));
                } else if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.location$1.scheme().isSecure().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
                    pipeline.addLast(package$Names$.MODULE$.SSLHandler(), (ChannelHandler)ClientSSLConverter$.MODULE$.toNettySSLContext(this.sslOptions$1).newHandler(ch.alloc(), this.location$1.host(), this.location$1.port()));
                }
                this.idleTimeout$1.foreach((Function1 & Serializable & scala.Serializable)timeout -> pipeline.addLast(package$Names$.MODULE$.ReadTimeoutHandler(), (ChannelHandler)new ReadTimeoutHandler(timeout.toMillis(), TimeUnit.MILLISECONDS)));
                pipeline.addLast(package$Names$.MODULE$.ClientReadTimeoutErrorHandler(), (ChannelHandler)new NettyConnectionPool.ReadTimeoutErrorHandler(this.nettyRuntime$1, this.trace$1));
                pipeline.addLast(package$Names$.MODULE$.HttpClientCodec(), (ChannelHandler)new HttpClientCodec(this.maxInitialLineLength$1, this.maxHeaderSize$1, 8192, true));
                if (this.decompression$1.enabled()) {
                    pipeline.addLast(package$Names$.MODULE$.HttpRequestDecompression(), (ChannelHandler)new HttpContentDecompressor(this.decompression$1.strict(), 0));
                }
            }
            {
                this.proxy$1 = proxy$1;
                this.location$1 = location$1;
                this.sslOptions$1 = sslOptions$1;
                this.idleTimeout$1 = idleTimeout$1;
                this.nettyRuntime$1 = nettyRuntime$1;
                this.trace$1 = trace$1;
                this.maxInitialLineLength$1 = maxInitialLineLength$1;
                this.maxHeaderSize$1 = maxHeaderSize$1;
                this.decompression$1 = decompression$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$initChannel$1(zio.http.netty.client.NettyConnectionPool$$anon$1 ), $anonfun$initChannel$2(), $anonfun$initChannel$3(io.netty.channel.ChannelPipeline java.time.Duration )}, serializedLambda);
            }
        };
        return dnsResolver.resolve(location.host(), trace).flatMap(arg_0 -> NettyConnectionPool$.$anonfun$createChannel$1(trace, channelFactory, eventLoopGroup, location, connectionTimeout, (ChannelInitializer)initializer, localAddress, arg_0), trace);
    }

    private <R, E, A, B> ZIO<R, E, B> collectFirstSuccess(NonEmptyChunk<A> as, Function1<A, ZIO<R, E, B>> f, Object trace) {
        return ZIO$.MODULE$.suspendSucceed((Function0 & Serializable & scala.Serializable)() -> {
            Iterator it = as.iterator();
            return NettyConnectionPool$.loop$1(f, it, trace);
        }, trace);
    }

    public boolean zio$http$netty$client$NettyConnectionPool$$refreshIdleTimeoutHandler(Channel channel, Duration timeout) {
        channel.pipeline().replace(package$Names$.MODULE$.ReadTimeoutHandler(), package$Names$.MODULE$.ReadTimeoutHandler(), (ChannelHandler)new ReadTimeoutHandler(timeout.toMillis(), TimeUnit.MILLISECONDS));
        return channel.isOpen();
    }

    public ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> fromConfig(ConnectionPoolConfig config, Object trace) {
        ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> zIO;
        if (ConnectionPoolConfig$Disabled$.MODULE$.equals(config)) {
            zIO = this.createDisabled(trace);
        } else if (config instanceof ConnectionPoolConfig.Fixed) {
            int size = ((ConnectionPoolConfig.Fixed)config).size();
            zIO = this.createFixed(size, trace);
        } else if (config instanceof ConnectionPoolConfig.FixedPerHost) {
            ConnectionPoolConfig.FixedPerHost fixedPerHost = (ConnectionPoolConfig.FixedPerHost)config;
            Map<URL.Location.Absolute, ConnectionPoolConfig.Fixed> sizes = fixedPerHost.sizes();
            ConnectionPoolConfig.Fixed fixed = fixedPerHost.default();
            zIO = this.createFixedPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable & scala.Serializable)location -> BoxesRunTime.boxToInteger((int)NettyConnectionPool$.$anonfun$fromConfig$1(sizes, fixed, location)), trace);
        } else if (config instanceof ConnectionPoolConfig.Dynamic) {
            ConnectionPoolConfig.Dynamic dynamic = (ConnectionPoolConfig.Dynamic)config;
            int minimum = dynamic.minimum();
            int maximum = dynamic.maximum();
            Duration ttl = dynamic.ttl();
            zIO = this.createDynamic(minimum, maximum, ttl, trace);
        } else if (config instanceof ConnectionPoolConfig.DynamicPerHost) {
            ConnectionPoolConfig.DynamicPerHost dynamicPerHost = (ConnectionPoolConfig.DynamicPerHost)config;
            Map<URL.Location.Absolute, ConnectionPoolConfig.Dynamic> configs = dynamicPerHost.configs();
            ConnectionPoolConfig.Dynamic dynamic = dynamicPerHost.default();
            zIO = this.createDynamicPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable & scala.Serializable)location -> BoxesRunTime.boxToInteger((int)NettyConnectionPool$.$anonfun$fromConfig$3(configs, dynamic, location)), (Function1<URL.Location.Absolute, Object>)(Function1 & Serializable & scala.Serializable)location -> BoxesRunTime.boxToInteger((int)NettyConnectionPool$.$anonfun$fromConfig$5(configs, dynamic, location)), (Function1<URL.Location.Absolute, Duration>)(Function1 & Serializable & scala.Serializable)location -> ((ConnectionPoolConfig.Dynamic)configs.getOrElse(location, (Function0 & Serializable & scala.Serializable)() -> dynamic)).ttl(), trace);
        } else {
            throw new MatchError((Object)config);
        }
        return zIO.map((Function1 & Serializable & scala.Serializable)pool -> pool, trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDisabled(Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(1016088367, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0005\u0004\u0000\u0001\u0012scala.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0005\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable & scala.Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(364405756, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable & scala.Serializable)dnsResolver -> new NettyConnectionPool.NoNettyConnectionPool(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), (DnsResolver)dnsResolver), trace), trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createFixed(int size, Object trace) {
        return this.createFixedPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)size), trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createFixedPerHost(Function1<URL.Location.Absolute, Object> size, Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(1016088367, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0005\u0004\u0000\u0001\u0012scala.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0005\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable & scala.Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(364405756, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable & scala.Serializable)dnsResolver -> {
            Function1 & Serializable & scala.Serializable poolFn = (Function1 & Serializable & scala.Serializable)key -> MODULE$.createChannel(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), key.location(), key.proxy(), key.sslOptions(), key.maxInitialLineLength(), key.maxHeaderSize(), key.decompression(), key.idleTimeout(), key.connectionTimeout(), (Option<InetSocketAddress>)None$.MODULE$, (DnsResolver)dnsResolver, trace).uninterruptible(trace);
            Function1 & Serializable & scala.Serializable _size = (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToInteger((int)NettyConnectionPool$.$anonfun$createFixedPerHost$4(size, key));
            return new Tuple3(dnsResolver, (Object)poolFn, (Object)_size);
        }, trace).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            if (x$4 != null) {
                Function1 poolFn = (Function1)x$4._2();
                Function1 _size = (Function1)x$4._3();
                return ZKeyedPool$.MODULE$.make(poolFn, _size, Tag$.MODULE$.apply(Scope.class, LightTypeTag$.MODULE$.parse(113574327, "\u0004\u0000\u0001\tzio.Scope\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\tzio.Scope\u0001\u0001\u0002\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0012scala.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 30)), trace).map((Function1 & Serializable & scala.Serializable)keyedPool -> new NettyConnectionPool.ZioNettyConnectionPool((ZKeyedPool<Throwable, NettyConnectionPool.PoolKey, Channel>)keyedPool, (Function1<NettyConnectionPool.PoolKey, Object>)_size), trace);
            }
            throw new MatchError(null);
        }, trace), trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDynamic(int min, int max, Duration ttl, Object trace) {
        return this.createDynamicPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)min), (Function1<URL.Location.Absolute, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)max), (Function1<URL.Location.Absolute, Duration>)(Function1 & Serializable & scala.Serializable)x$7 -> ttl, trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDynamicPerHost(Function1<URL.Location.Absolute, Object> min, Function1<URL.Location.Absolute, Object> max, Function1<URL.Location.Absolute, Duration> ttl, Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(1016088367, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0005\u0004\u0000\u0001\u0012scala.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0005\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable & scala.Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(364405756, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable & scala.Serializable)dnsResolver -> {
            Function1 & Serializable & scala.Serializable poolFn = (Function1 & Serializable & scala.Serializable)key -> MODULE$.createChannel(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), key.location(), key.proxy(), key.sslOptions(), key.maxInitialLineLength(), key.maxHeaderSize(), key.decompression(), key.idleTimeout(), key.connectionTimeout(), (Option<InetSocketAddress>)None$.MODULE$, (DnsResolver)dnsResolver, trace).uninterruptible(trace);
            return new Tuple2(dnsResolver, (Object)poolFn);
        }, trace).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
            if (x$8 != null) {
                Function1 poolFn = (Function1)x$8._2();
                return ZKeyedPool$.MODULE$.make(poolFn, (Function1 & Serializable & scala.Serializable)key -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)min.apply((Object)key.location()))), BoxesRunTime.unboxToInt((Object)max.apply((Object)key.location()))), (Function1 & Serializable & scala.Serializable)key -> (Duration)ttl.apply((Object)key.location()), Tag$.MODULE$.apply(Scope.class, LightTypeTag$.MODULE$.parse(113574327, "\u0004\u0000\u0001\tzio.Scope\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\tzio.Scope\u0001\u0001\u0002\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0012scala.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 30)), trace).map((Function1 & Serializable & scala.Serializable)keyedPool -> new NettyConnectionPool.ZioNettyConnectionPool((ZKeyedPool<Throwable, NettyConnectionPool.PoolKey, Channel>)keyedPool, (Function1<NettyConnectionPool.PoolKey, Object>)(Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToInteger((int)NettyConnectionPool$.$anonfun$createDynamicPerHost$8(max, key))), trace);
            }
            throw new MatchError(null);
        }, trace), trace);
    }

    public Bootstrap BootstrapSyntax(Bootstrap bootstrap) {
        return bootstrap;
    }

    public static final /* synthetic */ ZIO $anonfun$createChannel$1(Object trace$1, ChannelFactory channelFactory$1, EventLoopGroup eventLoopGroup$1, URL.Location.Absolute location$1, Option connectionTimeout$1, ChannelInitializer initializer$1, Option localAddress$1, Chunk resolvedHosts) {
        return Random$.MODULE$.shuffle((Function0 & Serializable & scala.Serializable)() -> resolvedHosts.toList(), trace$1).flatMap((Function1 & Serializable & scala.Serializable)hosts -> ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> NonEmptyChunk$.MODULE$.fromIterable(hosts.head(), (Iterable)hosts.tail()), trace$1).flatMap((Function1 & Serializable & scala.Serializable)hostsNec -> MODULE$.collectFirstSuccess((NonEmptyChunk)hostsNec, (Function1 & Serializable & scala.Serializable)host -> ZIO$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            Bootstrap bootstrap = (Bootstrap)NettyConnectionPool$BootstrapSyntax$.MODULE$.withOption$extension(MODULE$.BootstrapSyntax(((Bootstrap)new Bootstrap().channelFactory(channelFactory$1).group(eventLoopGroup$1)).remoteAddress((SocketAddress)new InetSocketAddress((InetAddress)host, location$1.port()))), ChannelOption.CONNECT_TIMEOUT_MILLIS, connectionTimeout$1.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.int2Integer((int)x$1.toMillis()))).handler((ChannelHandler)initializer$1);
            localAddress$1.foreach((Function1 & Serializable & scala.Serializable)x$1 -> (Bootstrap)bootstrap.localAddress(x$1));
            ChannelFuture channelFuture = bootstrap.connect();
            Channel ch = channelFuture.channel();
            return Scope$.MODULE$.addFinalizer((Function0 & Serializable & scala.Serializable)() -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable & scala.Serializable)() -> {
                channelFuture.cancel(true);
                return ch.close();
            }, trace$1).when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ch.isOpen(), trace$1).ignoreLogged(trace$1), trace$1).$times$greater((Function0 & Serializable & scala.Serializable)() -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable & scala.Serializable)() -> channelFuture, trace$1).as((Function0 & Serializable & scala.Serializable)() -> ch, trace$1), trace$1);
        }, trace$1), trace$1).map((Function1 & Serializable & scala.Serializable)ch -> ch, trace$1), trace$1), trace$1);
    }

    private static final ZIO loop$1(Function1 f$1, Iterator it$1, Object trace$2) {
        return ((ZIO)f$1.apply(it$1.next())).catchAll((Function1 & Serializable & scala.Serializable)e -> {
            if (it$1.hasNext()) {
                return NettyConnectionPool$.loop$1(f$1, it$1, trace$2);
            }
            return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> e, trace$2);
        }, CanFail$.MODULE$.canFail(), trace$2);
    }

    public static final /* synthetic */ int $anonfun$fromConfig$1(Map sizes$1, ConnectionPoolConfig.Fixed default$1, URL.Location.Absolute location) {
        return ((ConnectionPoolConfig.Fixed)sizes$1.getOrElse((Object)location, (Function0 & Serializable & scala.Serializable)() -> default$1)).size();
    }

    public static final /* synthetic */ int $anonfun$fromConfig$3(Map configs$1, ConnectionPoolConfig.Dynamic default$2, URL.Location.Absolute location) {
        return ((ConnectionPoolConfig.Dynamic)configs$1.getOrElse((Object)location, (Function0 & Serializable & scala.Serializable)() -> default$2)).minimum();
    }

    public static final /* synthetic */ int $anonfun$fromConfig$5(Map configs$1, ConnectionPoolConfig.Dynamic default$2, URL.Location.Absolute location) {
        return ((ConnectionPoolConfig.Dynamic)configs$1.getOrElse((Object)location, (Function0 & Serializable & scala.Serializable)() -> default$2)).maximum();
    }

    public static final /* synthetic */ int $anonfun$createFixedPerHost$4(Function1 size$2, NettyConnectionPool.PoolKey key) {
        return BoxesRunTime.unboxToInt((Object)size$2.apply((Object)key.location()));
    }

    public static final /* synthetic */ int $anonfun$createDynamicPerHost$8(Function1 max$2, NettyConnectionPool.PoolKey key) {
        return BoxesRunTime.unboxToInt((Object)max$2.apply((Object)key.location()));
    }

    private NettyConnectionPool$() {
        MODULE$ = this;
    }
}

