/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Exit;
import zio.Exit$;
import zio.FiberFailure;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Scope;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ErrorResponseConfig$;
import zio.http.Handler;
import zio.http.Header;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Server;
import zio.http.Status;
import zio.http.Status$SwitchingProtocols$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.NettyResponseEncoder$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.socket.NettySocketProtocol$;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\r=b!\u0002\u001c8\u0005vz\u0004\u0002C.\u0001\u0005+\u0007I\u0011A/\t\u0011\u0019\u0004!\u0011#Q\u0001\nyC\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tc\u0002\u0011\t\u0012)A\u0005S\"A!\u000f\u0001B\u0001B\u0003-1\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0005\u0002\f\u0001\u0011\r\u0011b\u0003\u0002\u000e!A\u0011q\u0003\u0001!\u0002\u0013\ty\u0001\u0003\u0006P\u0001\u0001\u0007\t\u0019!C\u0005\u00033A1\"!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<!Y\u0011q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000e\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%I!a\u0013\t\u0017\u0005U\u0003\u00011AA\u0002\u0013%\u0011q\u000b\u0005\f\u00037\u0002\u0001\u0019!A!B\u0013\ti\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0001\u0002`!A\u0011\u0011\u0010\u0001!\u0002\u0013\t\t\u0007C\u0005\u0002|\u0001\u0011\r\u0011\"\u0003\u0002~!A\u0011Q\u0011\u0001!\u0002\u0013\ty\bC\u0005\u0002\b\u0002\u0011\r\u0011\"\u0003\u0002~!A\u0011\u0011\u0012\u0001!\u0002\u0013\ty\bC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u000e\"I\u0011\u0011\u0013\u0001C\u0002\u0013%\u00111\u0013\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002\u0016\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!!;\u0001\t\u0013\tY\u000fC\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!Q\u0006\u0001\u0005\n\t=\u0002b\u0002B!\u0001\u0011%!1\t\u0005\b\u0005+\u0002A\u0011\u0002B,\u0011%\u0011Y\u0006AA\u0001\n\u0003\u0011i\u0006C\u0005\u0003h\u0001\t\n\u0011\"\u0001\u0003j!I!q\u0010\u0001\u0012\u0002\u0013\u0005!\u0011\u0011\u0005\n\u0005\u000b\u0003\u0011\u0011!C!\u0005\u000fC\u0011B!&\u0001\u0003\u0003%\tAa&\t\u0013\t}\u0005!!A\u0005\u0002\t\u0005\u0006\"\u0003BS\u0001\u0005\u0005I\u0011\tBT\u0011%\u0011)\fAA\u0001\n\u0003\u00119\fC\u0005\u0003<\u0002\t\t\u0011\"\u0011\u0003>\"I!q\u0018\u0001\u0002\u0002\u0013\u0005#\u0011\u0019\u0005\n\u0005\u0007\u0004\u0011\u0011!C!\u0005\u000b<\u0001B!:8\u0011\u0003i$q\u001d\u0004\bm]B\t!\u0010Bu\u0011\u0019qx\u0006\"\u0001\u0003r\"I!1_\u0018C\u0002\u0013\u0005!Q\u001f\u0005\t\u0007\u000fy\u0003\u0015!\u0003\u0003x\"I1\u0011B\u0018\u0002\u0002\u0013\u000551\u0002\u0005\n\u0007+y\u0013\u0011!CA\u0007/A\u0011b!\n0\u0003\u0003%Iaa\n\u0003)M+'O^3s\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s\u0015\tA\u0014(\u0001\u0004tKJ4XM\u001d\u0006\u0003um\nQA\\3uifT!\u0001P\u001f\u0002\t!$H\u000f\u001d\u0006\u0002}\u0005\u0019!0[8\u0014\t\u0001\u0001%\u000b\u0017\t\u0004\u0003\u001eKU\"\u0001\"\u000b\u0005\r#\u0015aB2iC:tW\r\u001c\u0006\u0003u\u0015S\u0011AR\u0001\u0003S>L!\u0001\u0013\"\u00037MKW\u000e\u001d7f\u0007\"\fgN\\3m\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s!\tQ\u0005+D\u0001L\u0015\taDJ\u0003\u0002N\u001d\u0006)1m\u001c3fG*\u0011q\nR\u0001\bQ\u0006tG\r\\3s\u0013\t\t6J\u0001\u0006IiR\u0004xJ\u00196fGR\u0004\"a\u0015,\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002T3&\u0011!\f\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007CB\u0004(+\u001a4\u0004\u0001U\ta\f\u0005\u0002`G:\u0011\u0001-Y\u0007\u0002o%\u0011!mN\u0001\ba\u0006\u001c7.Y4f\u0013\t!WMA\u0005S_V$Xm\u001d*fM*\u0011!mN\u0001\bCB\u0004(+\u001a4!\u0003\u0019\u0019wN\u001c4jOV\t\u0011\u000e\u0005\u0002k]:\u00111\u000e\\\u0007\u0002w%\u0011QnO\u0001\u0007'\u0016\u0014h/\u001a:\n\u0005=\u0004(AB\"p]\u001aLwM\u0003\u0002nw\u000591m\u001c8gS\u001e\u0004\u0013!\u0002;sC\u000e,\u0007C\u0001;|\u001d\t)(P\u0004\u0002ws6\tqO\u0003\u0002y9\u00061AH]8pizJ\u0011AP\u0005\u0003EvJ!\u0001`?\u0003\u000bQ\u0013\u0018mY3\u000b\u0005\tl\u0014A\u0002\u001fj]&$h\b\u0006\u0004\u0002\u0002\u0005\u001d\u0011\u0011\u0002\u000b\u0005\u0003\u0007\t)\u0001\u0005\u0002a\u0001!)!O\u0002a\u0002g\")1L\u0002a\u0001=\")qM\u0002a\u0001S\u00061QO\\:bM\u0016,\"!a\u0004\u0011\t\u0005E\u00111C\u0007\u0002{%\u0019\u0011QC\u001f\u0003\rUs7/\u00194f\u0003\u001d)hn]1gK\u0002*\"!a\u0007\u0011\u0017-\fi\"!\t\u0002(\u00055\u00121G\u0005\u0004\u0003?Y$a\u0002%b]\u0012dWM\u001d\t\u0004'\u0006\r\u0012bAA\u0013)\n\u0019\u0011I\\=\u0011\u0007M\u000bI#C\u0002\u0002,Q\u0013qAT8uQ&tw\rE\u0002l\u0003_I1!!\r<\u0005\u001d\u0011V-];fgR\u00042a[A\u001b\u0013\r\t9d\u000f\u0002\t%\u0016\u001c\bo\u001c8tK\u0006Y\u0001.\u00198eY\u0016\u0014x\fJ3r)\u0011\ti$a\u0011\u0011\u0007M\u000by$C\u0002\u0002BQ\u0013A!\u00168ji\"I\u0011Q\t\u0006\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014\u0001\u00035b]\u0012dWM\u001d\u0011\u0002\u000fI,h\u000e^5nKV\u0011\u0011Q\n\t\u0005\u0003\u001f\n\t&D\u0001:\u0013\r\t\u0019&\u000f\u0002\r\u001d\u0016$H/\u001f*v]RLW.Z\u0001\feVtG/[7f?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005e\u0003\"CA#\u001b\u0005\u0005\t\u0019AA'\u0003!\u0011XO\u001c;j[\u0016\u0004\u0013\u0001E5o\r2Lw\r\u001b;SKF,Xm\u001d;t+\t\t\t\u0007\u0005\u0003\u0002d\u0005UTBAA3\u0015\u0011\t9'!\u001b\u0002\r\u0005$x.\\5d\u0015\u0011\tY'!\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002p\u0005E\u0014\u0001B;uS2T!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\n)GA\u0005M_:<\u0017\t\u001a3fe\u0006\t\u0012N\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\u0002\u001dI,\u0017\rZ\"mS\u0016tGoQ3siV\u0011\u0011q\u0010\t\u0004'\u0006\u0005\u0015bAAB)\n9!i\\8mK\u0006t\u0017a\u0004:fC\u0012\u001cE.[3oi\u000e+'\u000f\u001e\u0011\u0002#\u00054x.\u001b3Dib\u001cv/\u001b;dQ&tw-\u0001\nbm>LGm\u0011;y'^LGo\u00195j]\u001e\u0004\u0013A\u0003:fMJ,7\u000f[!qaR\u0011\u0011QH\u0001\rK:\u001cXO]3ICN\f\u0005\u000f]\u0001\u000fe\u0016dW-Y:f%\u0016\fX/Z:u+\t\t)\nE\u0003T\u0003/\u000bi$C\u0002\u0002\u001aR\u0013\u0011BR;oGRLwN\u001c\u0019\u0002\u001fI,G.Z1tKJ+\u0017/^3ti\u0002\nAb\u00195b]:,GNU3bIB\"b!!\u0010\u0002\"\u0006-\u0006bBAR3\u0001\u0007\u0011QU\u0001\u0004GRD\bcA!\u0002(&\u0019\u0011\u0011\u0016\"\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\"1\u0011QV\rA\u0002%\u000b1!\\:h\u0003=)\u0007pY3qi&|gnQ1vO\"$HCBA\u001f\u0003g\u000b)\fC\u0004\u0002$j\u0001\r!!*\t\u000f\u0005]&\u00041\u0001\u0002:\u0006)1-Y;tKB!\u00111XAb\u001d\u0011\ti,!1\u000f\u0007Y\fy,C\u0001V\u0013\t\u0011G+\u0003\u0003\u0002F\u0006\u001d'!\u0003+ie><\u0018M\u00197f\u0015\t\u0011G+A\nbI\u0012\f5/\u001f8d\u0005>$\u0017\u0010S1oI2,'\u000f\u0006\u0003\u0002N\u0006M\u0007\u0003BA(\u0003\u001fL1!!5:\u0005=\t5/\u001f8d\u0005>$\u0017PU3bI\u0016\u0014\bbBAR7\u0001\u0007\u0011QU\u0001\u0011CR$X-\u001c9u\r\u0006\u001cHo\u0016:ji\u0016$\u0002\"a \u0002Z\u0006m\u0017Q\u001d\u0005\b\u0003Gc\u0002\u0019AAS\u0011\u001d\ti\u000e\ba\u0001\u0003?\fa!\\3uQ>$\u0007cA6\u0002b&\u0019\u00111]\u001e\u0003\r5+G\u000f[8e\u0011\u001d\t9\u000f\ba\u0001\u0003g\t\u0001B]3ta>t7/Z\u0001\u0011CR$X-\u001c9u\rVdGn\u0016:ji\u0016$\"\"!<\u0002|\u0006u\u0018q B\u0001!\u0015!\u0018q^Az\u0013\r\t\t0 \u0002\u0005)\u0006\u001c8\u000eE\u0003T\u0003k\fI0C\u0002\u0002xR\u0013aa\u00149uS>t\u0007#\u0002;\u0002p\u0006u\u0002bBAR;\u0001\u0007\u0011Q\u0015\u0005\b\u0003\u0013j\u0002\u0019AA'\u0011\u001d\t9/\ba\u0001\u0003gAqAa\u0001\u001e\u0001\u0004\ti#A\u0004sKF,Xm\u001d;\u0002+\u0005$H/Z7qi&kW.\u001a3jCR,wK]5uKRA\u0011q\u0010B\u0005\u0005\u0017\u0011i\u0001C\u0004\u0002$z\u0001\r!!*\t\u000f\u0005ug\u00041\u0001\u0002`\"9!q\u0002\u0010A\u0002\tE\u0011\u0001B3ySR\u0004\"\"!\u0005\u0003\u0014\t]\u00111GA\u001a\u0013\r\u0011)\"\u0010\u0002\u00045&{\u0005\u0003BA\t\u00053I1Aa\u0007>\u0005\u0015\u00196m\u001c9f\u00039i\u0017m[3[S>\u0014V-];fgR$b!!\f\u0003\"\t\r\u0002bBAR?\u0001\u0007\u0011Q\u0015\u0005\b\u0005Ky\u0002\u0019\u0001B\u0014\u0003!qW\r\u001e;z%\u0016\f\bc\u0001&\u0003*%\u0019!1F&\u0003\u0017!#H\u000f\u001d*fcV,7\u000f^\u0001\u0013kB<'/\u00193f)><VMY*pG.,G\u000f\u0006\u0006\u0002z\nE\"1\u0007B\u001b\u0005\u007fAq!a)!\u0001\u0004\t)\u000bC\u0004\u0003\u0004\u0001\u0002\r!!\f\t\u000f\t]\u0002\u00051\u0001\u0003:\u0005aq/\u001a2T_\u000e\\W\r^!qaB)1Na\u000f\u0002\"%\u0019!QH\u001e\u0003\u0019]+'mU8dW\u0016$\u0018\t\u001d9\t\u000f\u0005%\u0003\u00051\u0001\u0002N\u0005iqO]5uKJ+7\u000f]8og\u0016$\"B!\u0012\u0003L\t5#q\nB))\u0011\tiDa\u0012\t\u000f\t%\u0013\u00051\u0001\u0002\u0016\u00069QM\\:ve\u0016$\u0007bBARC\u0001\u0007\u0011Q\u0015\u0005\b\u0003\u0013\n\u0003\u0019AA'\u0011\u001d\u0011y!\ta\u0001\u0005#AqAa\u0015\"\u0001\u0004\ti#A\u0002sKF\f\u0001d^5uQ\u0012+g-Y;mi\u0016\u0013(o\u001c:SKN\u0004xN\\:f)\u0011\t\u0019D!\u0017\t\u000f\u0005]&\u00051\u0001\u0002:\u0006!1m\u001c9z)\u0019\u0011yFa\u0019\u0003fQ!\u00111\u0001B1\u0011\u0015\u00118\u0005q\u0001t\u0011\u001dY6\u0005%AA\u0002yCqaZ\u0012\u0011\u0002\u0003\u0007\u0011.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t-$f\u00010\u0003n-\u0012!q\u000e\t\u0005\u0005c\u0012Y(\u0004\u0002\u0003t)!!Q\u000fB<\u0003%)hn\u00195fG.,GMC\u0002\u0003zQ\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iHa\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\r%fA5\u0003n\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!#\u0011\t\t-%\u0011S\u0007\u0003\u0005\u001bSAAa$\u0002r\u0005!A.\u00198h\u0013\u0011\u0011\u0019J!$\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I\nE\u0002T\u00057K1A!(U\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\tCa)\t\u0013\u0005\u0015\u0003&!AA\u0002\te\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t%\u0006C\u0002BV\u0005c\u000b\t#\u0004\u0002\u0003.*\u0019!q\u0016+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00034\n5&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a \u0003:\"I\u0011Q\t\u0016\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!\u0011T\u0001\ti>\u001cFO]5oOR\u0011!\u0011R\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}$q\u0019\u0005\n\u0003\u000bj\u0013\u0011!a\u0001\u0003CA3\u0001\u0001Bf!\u0011\u0011iMa8\u000f\t\t='1\u001c\b\u0005\u0005#\u0014IN\u0004\u0003\u0003T\n]gb\u0001<\u0003V&\ta)\u0003\u0002;\u000b&\u00111\tR\u0005\u0004\u0005;\u0014\u0015AD\"iC:tW\r\u001c%b]\u0012dWM]\u0005\u0005\u0005C\u0014\u0019O\u0001\u0005TQ\u0006\u0014\u0018M\u00197f\u0015\r\u0011iNQ\u0001\u0015'\u0016\u0014h/\u001a:J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005\u0001|3\u0003B\u0018\u0003lb\u00032a\u0015Bw\u0013\r\u0011y\u000f\u0016\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u001d\u0018\u0001\u00027jm\u0016,\"Aa>\u0011\u0015\u0005E!\u0011 B\u007f\u0003O\t\u0019!C\u0002\u0003|v\u0012aA\u0017'bs\u0016\u0014\b#\u0002;\u0003\u0000zK\u0017\u0002BB\u0001\u0007\u0007\u0011A\u0001J1na&\u00191QA\u001f\u0003-%sG/\u001a:tK\u000e$\u0018n\u001c8UsB,7i\\7qCR\fQ\u0001\\5wK\u0002\nQ!\u00199qYf$ba!\u0004\u0004\u0012\rMA\u0003BA\u0002\u0007\u001fAQA]\u001aA\u0004MDQaW\u001aA\u0002yCQaZ\u001aA\u0002%\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u001a\r\u0005\u0002#B*\u0002v\u000em\u0001#B*\u0004\u001eyK\u0017bAB\u0010)\n1A+\u001e9mKJB\u0011ba\t5\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAB\u0015!\u0011\u0011Yia\u000b\n\t\r5\"Q\u0012\u0002\u0007\u001f\nTWm\u0019;")
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
scala.Serializable {
    private final AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef;
    private final Server.Config config;
    private final Object trace;
    private final Unsafe unsafe;
    private Handler<Object, Nothing$, Request, Response> handler;
    private NettyRuntime runtime;
    private final LongAdder inFlightRequests;
    private final boolean readClientCert;
    private final boolean avoidCtxSwitching;
    private final Function0<BoxedUnit> releaseRequest;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Server.Config>> unapply(ServerInboundHandler serverInboundHandler) {
        return ServerInboundHandler$.MODULE$.unapply(serverInboundHandler);
    }

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference, Server.Config config, Object object) {
        return ServerInboundHandler$.MODULE$.apply(atomicReference, config, object);
    }

    public static ZLayer<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Nothing$, ServerInboundHandler> live() {
        return ServerInboundHandler$.MODULE$.live();
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef() {
        return this.appRef;
    }

    public Server.Config config() {
        return this.config;
    }

    private Unsafe unsafe() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 49");
        }
        return this.unsafe;
    }

    private Handler<Object, Nothing$, Request, Response> handler() {
        return this.handler;
    }

    private void handler_$eq(Handler<Object, Nothing$, Request, Response> x$1) {
        this.handler = x$1;
    }

    private NettyRuntime runtime() {
        return this.runtime;
    }

    private void runtime_$eq(NettyRuntime x$1) {
        this.runtime = x$1;
    }

    public LongAdder inFlightRequests() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 54");
        }
        return this.inFlightRequests;
    }

    private boolean readClientCert() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 55");
        }
        return this.readClientCert;
    }

    private boolean avoidCtxSwitching() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 56");
        }
        return this.avoidCtxSwitching;
    }

    public void refreshApp() {
        Tuple2<Routes<Object, Response>, Runtime<Object>> pair = this.appRef().get();
        this.handler_$eq(((Routes)pair._1()).toHandler(Predef$.MODULE$.$conforms()));
        this.runtime_$eq(new NettyRuntime((Runtime<Object>)((Runtime)pair._2())));
    }

    private void ensureHasApp() {
        if (this.runtime() == null) {
            this.refreshApp();
            return;
        }
    }

    private Function0<BoxedUnit> releaseRequest() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/jvm/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 71");
        }
        return this.releaseRequest;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.inFlightRequests().increment();
            this.ensureHasApp();
            try {
                if (httpRequest.decoderResult().isFailure()) {
                    Throwable throwable = httpRequest.decoderResult().cause();
                    this.attemptFastWrite(ctx, Conversions$.MODULE$.methodFromNetty(httpRequest.method()), Response$.MODULE$.fromThrowable(throwable, this.runtime().getRef(ErrorResponseConfig$.MODULE$.configRef())));
                    this.releaseRequest().apply$mcV$sp();
                } else {
                    Request req = this.makeZioRequest(ctx, httpRequest);
                    ZIO<Scope, Nothing$, Response> exit = this.handler().apply(req);
                    if (this.attemptImmediateWrite(ctx, req.method(), exit)) {
                        this.releaseRequest().apply$mcV$sp();
                    } else {
                        this.writeResponse(ctx, this.runtime(), exit, req, this.releaseRequest());
                    }
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)httpRequest);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ctx.fireChannelRead((Object)httpContent);
            return;
        }
        throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String msg;
        if (cause instanceof IOException && (msg = ((IOException)cause).getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.runtime() != null && this.config().logWarningOnFatalError()) {
            this.runtime().unsafeRunSync(ZIO$.MODULE$.logWarningCause((Function0 & Serializable & scala.Serializable)() -> "Fatal exception in Netty", (Function0 & Serializable & scala.Serializable)() -> Cause$.MODULE$.die(cause, Cause$.MODULE$.die$default$2()), this.trace), this.unsafe(), this.trace);
        }
        if (cause instanceof ReadTimeoutException) {
            ctx.close();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private AsyncBodyReader addAsyncBodyHandler(ChannelHandlerContext ctx) {
        ServerAsyncBodyHandler handler = new ServerAsyncBodyHandler();
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)handler);
        return handler;
    }

    private boolean attemptFastWrite(ChannelHandlerContext ctx, Method method2, Response response) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
            try {
                return this.fastEncode$1(response, unsafeBytes.unsafeAsArray(this.unsafe()), method2, ctx);
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    return this.fastEncode$1(this.withDefaultErrorResponse(e), Array$.MODULE$.emptyByteArray(), method2, ctx);
                }
                throw throwable;
            }
        }
        return false;
    }

    private ZIO<Object, Throwable, Option<ZIO<Object, Throwable, BoxedUnit>>> attemptFullWrite(ChannelHandlerContext ctx, NettyRuntime runtime, Response response, Request request) {
        Body body = response.body();
        if (body instanceof Body.WebsocketBody) {
            WebSocketApp<Object> socketApp = ((Body.WebsocketBody)body).socketApp();
            Status status = response.status();
            Status$SwitchingProtocols$ status$SwitchingProtocols$ = Status$SwitchingProtocols$.MODULE$;
            if (!(status != null ? !status.equals(status$SwitchingProtocols$) : status$SwitchingProtocols$ != null)) {
                return this.upgradeToWebSocket(ctx, request, socketApp, runtime).as((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, this.trace);
            }
        }
        return ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> {
            HttpResponse jResponse = NettyResponseEncoder$.MODULE$.encode(request.method(), response, this.unsafe());
            if (!(jResponse instanceof FullHttpResponse)) {
                String string = jResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                None$ contentLength = string == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(string)).toLong()));
                ctx.writeAndFlush((Object)jResponse);
                return NettyBodyWriter$.MODULE$.writeAndFlush(response.body(), (Option<Object>)contentLength, ctx, $this.trace);
            }
            ctx.writeAndFlush((Object)jResponse);
            return None$.MODULE$;
        }, this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, Method method2, ZIO<Scope, Response, Response> exit) {
        Response response;
        if (exit instanceof Exit.Success && (response = (Response)((Exit.Success)exit).value()) != null) {
            return this.attemptFastWrite(ctx, method2, response);
        }
        return false;
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        None$ none$;
        None$ none$2;
        Version version;
        HttpVersion nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (!(httpVersion != null ? !httpVersion.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
            version = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion2 = HttpVersion.HTTP_1_1;
            if (!(httpVersion2 != null ? !httpVersion2.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
                version = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        Version$Http_1_0$ protocolVersion = version;
        if (this.readClientCert()) {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            none$2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sslHandler.engine().getSession().getPeerCertificates())).headOption();
        } else {
            none$2 = None$.MODULE$;
        }
        None$ clientCert = none$2;
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)inetSocketAddress.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteAddress = none$;
        Headers headers = Conversions$.MODULE$.headersFromNetty(nettyReq.headers());
        Option<Header> contentTypeHeader = headers.get(Header$ContentType$.MODULE$);
        if (nettyReq instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyReq;
            Body x$1 = NettyBody$.MODULE$.fromByteBuf(fullHttpRequest.content(), contentTypeHeader);
            Method x$3 = Conversions$.MODULE$.methodFromNetty(fullHttpRequest.method());
            URL x$4 = (URL)URL$.MODULE$.decode(fullHttpRequest.uri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> URL$.MODULE$.empty());
            return new Request(protocolVersion, x$3, x$4, headers, x$1, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        Option knownContentLength = headers.get(Header$ContentLength$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.length()));
        AsyncBodyReader handler = this.addAsyncBodyHandler(ctx);
        Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(Function1 & Serializable & scala.Serializable)async -> {
            handler.connect(async);
            return BoxedUnit.UNIT;
        }, (Option<Object>)knownContentLength, contentTypeHeader);
        Method x$10 = Conversions$.MODULE$.methodFromNetty(nettyReq.method());
        URL x$11 = (URL)URL$.MODULE$.decode(nettyReq.uri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> URL$.MODULE$.empty());
        return new Request(protocolVersion, x$10, x$11, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
    }

    private ZIO<Object, Throwable, BoxedUnit> upgradeToWebSocket(ChannelHandlerContext ctx, Request request, WebSocketApp<Object> webSocketApp, NettyRuntime runtime) {
        return Promise$.MODULE$.make(this.trace).flatMap((Function1 & Serializable & scala.Serializable)handshakeCompleted -> Queue$.MODULE$.unbounded($this.trace).tap((Function1 & Serializable & scala.Serializable)queue -> ZIO$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(ctx.channel());
            Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted);
            return ZIO.ScopedPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.scoped(), (Function0 & Serializable & scala.Serializable)() -> webSocketApp.handler().runZIO(webSocketChannel), $this.trace).ignoreLogged($this.trace).forkDaemon($this.trace);
        }, $this.trace), $this.trace).flatMap((Function1 & Serializable & scala.Serializable)queue -> ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> {
            ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder((WebSocketConfig)webSocketApp.customConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.config().webSocketConfig())).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted, (Option<Promise<Throwable, ChannelState>>)None$.MODULE$, $this.trace));
            DefaultFullHttpRequest jReq = new DefaultFullHttpRequest(Conversions$.MODULE$.versionToNetty(request.version()), Conversions$.MODULE$.methodToNetty(request.method()), Conversions$.MODULE$.urlToNetty(request.url()));
            jReq.headers().setAll(Conversions$.MODULE$.headersToNetty(request.allHeaders()));
            return ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)jReq));
        }, $this.trace).map((Function1 & Serializable & scala.Serializable)_ -> {
            ServerInboundHandler.$anonfun$upgradeToWebSocket$9(_);
            return BoxedUnit.UNIT;
        }, $this.trace), $this.trace), this.trace);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyRuntime runtime, ZIO<Scope, Response, Response> exit, Request req, Function0<BoxedUnit> ensured) {
        Scope.Closeable scope = Scope.unsafe$.MODULE$.make(this.unsafe());
        ZIO program = Scope.UsePartiallyApplied$.MODULE$.apply$extension(scope.use(), (Function0 & Serializable & scala.Serializable)() -> exit.foldCauseZIO((Function1 & Serializable & scala.Serializable)x$3 -> {
            boolean bl = false;
            Right right = null;
            Either either = x$3.failureOrCause();
            if (either instanceof Left) {
                Response resp = (Response)((Left)either).value();
                return this.writeResponse$1(resp, ctx, req, runtime);
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                if (((Cause)right.value()).isInterruptedOnly()) {
                    return this.closeChannel$1(ctx);
                }
            }
            if (bl) {
                Cause c = (Cause)right.value();
                return this.writeResponse$1(this.withDefaultErrorResponse((Throwable)new FiberFailure(c)), ctx, req, runtime);
            }
            throw new MatchError((Object)either);
        }, (Function1 & Serializable & scala.Serializable)response -> this.writeResponse$1((Response)response, ctx, req, runtime), $this.trace), this.trace);
        runtime.run(ctx, ensured, this.avoidCtxSwitching(), (ZIO<Object, Throwable, Object>)program, this.unsafe(), this.trace);
    }

    private Response withDefaultErrorResponse(Throwable cause) {
        return Response$.MODULE$.internalServerError(cause.getMessage());
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return new ServerInboundHandler(appRef, config, trace);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> copy$default$1() {
        return this.appRef();
    }

    public Server.Config copy$default$2() {
        return this.config();
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.appRef();
            }
            case 1: {
                return this.config();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerInboundHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof ServerInboundHandler)) break block3;
                ServerInboundHandler serverInboundHandler = (ServerInboundHandler)((Object)x$1);
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference = this.appRef();
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference2 = serverInboundHandler.appRef();
                if (atomicReference != null ? !atomicReference.equals(atomicReference2) : atomicReference2 != null) break block3;
                Server.Config config = this.config();
                Server.Config config2 = serverInboundHandler.config();
                if (config != null ? !((Object)config).equals(config2) : config2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private final boolean fastEncode$1(Response response, byte[] bytes, Method method$1, ChannelHandlerContext ctx$1) {
        FullHttpResponse djResponse = NettyResponseEncoder$.MODULE$.fastEncode(method$1, response, bytes, this.unsafe()).retainedDuplicate();
        io.netty.channel.Channel ch = ctx$1.channel();
        ch.writeAndFlush((Object)djResponse, ch.voidPromise());
        return true;
    }

    public static final /* synthetic */ void $anonfun$upgradeToWebSocket$9(Future _) {
    }

    private final ZIO closeChannel$1(ChannelHandlerContext ctx$4) {
        return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable & scala.Serializable)() -> ctx$4.channel().close(), this.trace);
    }

    private final ZIO writeResponse$1(Response response, ChannelHandlerContext ctx$4, Request req$1, NettyRuntime runtime$2) {
        if (this.attemptFastWrite(ctx$4, req$1.method(), response)) {
            return Exit$.MODULE$.unit();
        }
        return this.attemptFullWrite(ctx$4, runtime$2, response, req$1).foldCauseZIO((Function1 & Serializable & scala.Serializable)cause -> {
            this.attemptFastWrite(ctx$4, req$1.method(), this.withDefaultErrorResponse(cause.squash(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()))));
            return Exit$.MODULE$.unit();
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return Exit$.MODULE$.unit();
            }
            if (x0$1 instanceof Some) {
                return ((ZIO)((Some)x0$1).value()).orElse((Function0 & Serializable & scala.Serializable)() -> this.closeChannel$1(ctx$4), CanFail$.MODULE$.canFail(), $this.trace);
            }
            throw new MatchError(x0$1);
        }, this.trace);
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.trace = trace;
        super(false);
        Product.$init$((Product)this);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.inFlightRequests = new LongAdder();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.readClientCert = config.sslConfig().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.includeClientCert()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.avoidCtxSwitching = config.avoidContextSwitching();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.releaseRequest = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.inFlightRequests().decrement();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

