/*
 * Copyright 2021 - 2023 Sporta Technologies PVT LTD & the ZIO HTTP contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package zio.http

import scala.language.implicitConversions

package object codec {
  type ContentCodec[A] = HttpCodec[HttpCodecType.Content, A]
  type HeaderCodec[A]  = HttpCodec[HttpCodecType.Header, A]
  type MethodCodec[A]  = HttpCodec[HttpCodecType.Method, A]
  type PathCodec[A]    = HttpCodec[HttpCodecType.Path, A]
  type QueryCodec[A]   = HttpCodec[HttpCodecType.Query, A]
  type StatusCodec[A]  = HttpCodec[HttpCodecType.Status, A]
}
