/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.ChannelEvent;
import zio.http.Handler;
import zio.http.Response;
import zio.http.html.Html;
import zio.http.model.Headers;
import zio.http.model.Headers$;
import zio.http.model.HttpError;
import zio.http.model.Status;
import zio.http.model.Status$Ok$;
import zio.http.model.Status$PermanentRedirect$;
import zio.http.model.Status$SeeOther$;
import zio.http.model.Status$SwitchingProtocols$;
import zio.http.model.Status$TemporaryRedirect$;
import zio.http.model.package$HeaderNames$;
import zio.http.model.package$HeaderValues$;
import zio.http.socket.SocketApp;
import zio.http.socket.WebSocketFrame;

public final class Response$ {
    public static final Response$ MODULE$ = new Response$();
    private static volatile byte bitmap$init$0;

    public Response apply(Status status, Headers headers, Body body) {
        return new Response.BasicResponse(body, headers, status);
    }

    public Status apply$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers apply$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body apply$default$3() {
        return Body$.MODULE$.empty();
    }

    public Response fromHttpError(HttpError error) {
        return new Response.ErrorResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), error, error.status());
    }

    public <R> ZIO<R, Nothing$, Response> fromSocket(Handler<R, Throwable, ChannelEvent<WebSocketFrame, WebSocketFrame>, BoxedUnit> http, Object trace) {
        return this.fromSocketApp(http.toSocketApp((.less.colon.less<ChannelEvent<WebSocketFrame, WebSocketFrame>, ChannelEvent<WebSocketFrame, WebSocketFrame>>)$less$colon$less$.MODULE$.refl(), (.less.colon.less<Throwable, Throwable>)$less$colon$less$.MODULE$.refl(), trace), trace);
    }

    public <R> ZIO<R, Nothing$, Response> fromSocketApp(SocketApp<R> app, Object trace) {
        return ZIO$.MODULE$.environment(trace).map((Function1 & Serializable)env -> new Response.SocketAppResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), app.provideEnvironment((ZEnvironment)env, trace), Status$SwitchingProtocols$.MODULE$), trace);
    }

    public Response html(Html data, Status status) {
        return new Response.BasicResponse(Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2()), Headers$.MODULE$.apply(package$HeaderNames$.MODULE$.contentType(), package$HeaderValues$.MODULE$.textHtml()), status);
    }

    public Status html$default$2() {
        return Status$Ok$.MODULE$;
    }

    public Response json(CharSequence data) {
        return new Response.BasicResponse(Body$.MODULE$.fromCharSequence(data, Body$.MODULE$.fromCharSequence$default$2()), Headers$.MODULE$.apply(package$HeaderNames$.MODULE$.contentType(), package$HeaderValues$.MODULE$.applicationJson()), Status$Ok$.MODULE$);
    }

    public Response ok() {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), Status$Ok$.MODULE$);
    }

    public Response redirect(CharSequence location, boolean isPermanent) {
        Status status = isPermanent ? Status$PermanentRedirect$.MODULE$ : Status$TemporaryRedirect$.MODULE$;
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.location(location), status);
    }

    public boolean redirect$default$2() {
        return false;
    }

    public Response seeOther(CharSequence location) {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.location(location), Status$SeeOther$.MODULE$);
    }

    public Response status(Status status) {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), status);
    }

    public Response text(CharSequence text) {
        return new Response.BasicResponse(Body$.MODULE$.fromCharSequence(text, Body$.MODULE$.fromCharSequence$default$2()), Headers$.MODULE$.apply(package$HeaderNames$.MODULE$.contentType(), package$HeaderValues$.MODULE$.textPlain()), Status$Ok$.MODULE$);
    }

    private Response$() {
    }
}

