/*
 * Decompiled with CFR 0.152.
 */
package zio.http.model.headers.values;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import zio.Chunk;
import zio.Chunk$;
import zio.http.model.headers.values.CacheControl;
import zio.http.model.headers.values.CacheControl$Immutable$;
import zio.http.model.headers.values.CacheControl$InvalidCacheControl$;
import zio.http.model.headers.values.CacheControl$MustRevalidate$;
import zio.http.model.headers.values.CacheControl$MustUnderstand$;
import zio.http.model.headers.values.CacheControl$NoCache$;
import zio.http.model.headers.values.CacheControl$NoStore$;
import zio.http.model.headers.values.CacheControl$NoTransform$;
import zio.http.model.headers.values.CacheControl$OnlyIfCached$;
import zio.http.model.headers.values.CacheControl$Private$;
import zio.http.model.headers.values.CacheControl$ProxyRevalidate$;
import zio.http.model.headers.values.CacheControl$Public$;

public final class CacheControl$ {
    public static final CacheControl$ MODULE$ = new CacheControl$();
    private static volatile int bitmap$init$0;

    public String fromCacheControl(CacheControl value2) {
        String string;
        if (CacheControl$Immutable$.MODULE$.equals(value2)) {
            string = CacheControl$Immutable$.MODULE$.raw();
        } else if (CacheControl$InvalidCacheControl$.MODULE$.equals(value2)) {
            string = "";
        } else if (value2 instanceof CacheControl.MaxAge) {
            CacheControl.MaxAge maxAge = (CacheControl.MaxAge)value2;
            int freshForSeconds = maxAge.freshForSeconds();
            string = new StringBuilder(1).append(maxAge.raw()).append("=").append(freshForSeconds).toString();
        } else if (value2 instanceof CacheControl.MaxStale) {
            CacheControl.MaxStale maxStale = (CacheControl.MaxStale)value2;
            int staleWithinSeconds = maxStale.staleWithinSeconds();
            string = new StringBuilder(1).append(maxStale.raw()).append("=").append(staleWithinSeconds).toString();
        } else if (value2 instanceof CacheControl.MinFresh) {
            CacheControl.MinFresh minFresh = (CacheControl.MinFresh)value2;
            int freshAtLeastSeconds = minFresh.freshAtLeastSeconds();
            string = new StringBuilder(1).append(minFresh.raw()).append("=").append(freshAtLeastSeconds).toString();
        } else if (CacheControl$MustRevalidate$.MODULE$.equals(value2)) {
            string = CacheControl$MustRevalidate$.MODULE$.raw();
        } else if (CacheControl$MustUnderstand$.MODULE$.equals(value2)) {
            string = CacheControl$MustUnderstand$.MODULE$.raw();
        } else if (value2 instanceof CacheControl.MultipleCacheControlValues) {
            string = ((CacheControl.MultipleCacheControlValues)value2).values().map((Function1 & Serializable)value -> MODULE$.fromCacheControl((CacheControl)value)).mkString(",");
        } else if (CacheControl$NoCache$.MODULE$.equals(value2)) {
            string = CacheControl$NoCache$.MODULE$.raw();
        } else if (CacheControl$NoStore$.MODULE$.equals(value2)) {
            string = CacheControl$NoStore$.MODULE$.raw();
        } else if (CacheControl$NoTransform$.MODULE$.equals(value2)) {
            string = CacheControl$NoTransform$.MODULE$.raw();
        } else if (CacheControl$OnlyIfCached$.MODULE$.equals(value2)) {
            string = CacheControl$OnlyIfCached$.MODULE$.raw();
        } else if (CacheControl$Private$.MODULE$.equals(value2)) {
            string = CacheControl$Private$.MODULE$.raw();
        } else if (CacheControl$ProxyRevalidate$.MODULE$.equals(value2)) {
            string = CacheControl$ProxyRevalidate$.MODULE$.raw();
        } else if (CacheControl$Public$.MODULE$.equals(value2)) {
            string = CacheControl$Public$.MODULE$.raw();
        } else if (value2 instanceof CacheControl.SMaxAge) {
            CacheControl.SMaxAge sMaxAge = (CacheControl.SMaxAge)value2;
            int freshForSeconds = sMaxAge.freshForSeconds();
            string = new StringBuilder(1).append(sMaxAge.raw()).append("=").append(freshForSeconds).toString();
        } else if (value2 instanceof CacheControl.StaleIfError) {
            CacheControl.StaleIfError staleIfError = (CacheControl.StaleIfError)value2;
            int seconds = staleIfError.seconds();
            string = new StringBuilder(1).append(staleIfError.raw()).append("=").append(seconds).toString();
        } else if (value2 instanceof CacheControl.StaleWhileRevalidate) {
            CacheControl.StaleWhileRevalidate staleWhileRevalidate = (CacheControl.StaleWhileRevalidate)value2;
            int seconds = staleWhileRevalidate.seconds();
            string = new StringBuilder(1).append(staleWhileRevalidate.raw()).append("=").append(seconds).toString();
        } else {
            throw new MatchError((Object)value2);
        }
        return string;
    }

    public CacheControl toCacheControl(String value) {
        int index = value.indexOf(",");
        if (index == -1) {
            return this.identifyCacheControl(value);
        }
        return this.loop$1(value, index, new CacheControl.MultipleCacheControlValues((Chunk<CacheControl>)Chunk$.MODULE$.empty()));
    }

    private CacheControl identifyCacheControl(String value) {
        int index = value.indexOf("=");
        if (index == -1) {
            return this.identifyCacheControlValue(value, this.identifyCacheControlValue$default$2());
        }
        return this.identifyCacheControlValue(value.substring(0, index), (Option<Object>)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value.substring(index + 1)))).toOption());
    }

    private CacheControl identifyCacheControlValue(String value, Option<Object> seconds) {
        CacheControl cacheControl;
        String valueNoSpace = value.trim();
        if ("max-age".equals(valueNoSpace)) {
            cacheControl = new CacheControl.MaxAge(BoxesRunTime.unboxToInt((Object)seconds.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
        } else if ("max-stale".equals(valueNoSpace)) {
            cacheControl = new CacheControl.MaxStale(BoxesRunTime.unboxToInt((Object)seconds.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
        } else if ("min-fresh".equals(valueNoSpace)) {
            cacheControl = new CacheControl.MinFresh(BoxesRunTime.unboxToInt((Object)seconds.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
        } else if ("s-maxage".equals(valueNoSpace)) {
            cacheControl = new CacheControl.SMaxAge(BoxesRunTime.unboxToInt((Object)seconds.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
        } else {
            String string = CacheControl$NoCache$.MODULE$.raw();
            if (!(string != null ? !string.equals(valueNoSpace) : valueNoSpace != null)) {
                cacheControl = CacheControl$NoCache$.MODULE$;
            } else {
                String string2 = CacheControl$NoStore$.MODULE$.raw();
                if (!(string2 != null ? !string2.equals(valueNoSpace) : valueNoSpace != null)) {
                    cacheControl = CacheControl$NoStore$.MODULE$;
                } else {
                    String string3 = CacheControl$NoTransform$.MODULE$.raw();
                    if (!(string3 != null ? !string3.equals(valueNoSpace) : valueNoSpace != null)) {
                        cacheControl = CacheControl$NoTransform$.MODULE$;
                    } else {
                        String string4 = CacheControl$OnlyIfCached$.MODULE$.raw();
                        if (!(string4 != null ? !string4.equals(valueNoSpace) : valueNoSpace != null)) {
                            cacheControl = CacheControl$OnlyIfCached$.MODULE$;
                        } else {
                            String string5 = CacheControl$MustRevalidate$.MODULE$.raw();
                            if (!(string5 != null ? !string5.equals(valueNoSpace) : valueNoSpace != null)) {
                                cacheControl = CacheControl$MustRevalidate$.MODULE$;
                            } else {
                                String string6 = CacheControl$ProxyRevalidate$.MODULE$.raw();
                                if (!(string6 != null ? !string6.equals(valueNoSpace) : valueNoSpace != null)) {
                                    cacheControl = CacheControl$ProxyRevalidate$.MODULE$;
                                } else {
                                    String string7 = CacheControl$MustUnderstand$.MODULE$.raw();
                                    if (!(string7 != null ? !string7.equals(valueNoSpace) : valueNoSpace != null)) {
                                        cacheControl = CacheControl$MustUnderstand$.MODULE$;
                                    } else {
                                        String string8 = CacheControl$Private$.MODULE$.raw();
                                        if (!(string8 != null ? !string8.equals(valueNoSpace) : valueNoSpace != null)) {
                                            cacheControl = CacheControl$Private$.MODULE$;
                                        } else {
                                            String string9 = CacheControl$Public$.MODULE$.raw();
                                            if (!(string9 != null ? !string9.equals(valueNoSpace) : valueNoSpace != null)) {
                                                cacheControl = CacheControl$Public$.MODULE$;
                                            } else {
                                                String string10 = CacheControl$Immutable$.MODULE$.raw();
                                                cacheControl = !(string10 != null ? !string10.equals(valueNoSpace) : valueNoSpace != null) ? CacheControl$Immutable$.MODULE$ : ("stale-while-revalidate".equals(valueNoSpace) ? new CacheControl.StaleWhileRevalidate(BoxesRunTime.unboxToInt((Object)seconds.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0))) : ("stale-if-error".equals(valueNoSpace) ? new CacheControl.StaleIfError(BoxesRunTime.unboxToInt((Object)seconds.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0))) : CacheControl$InvalidCacheControl$.MODULE$));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return cacheControl;
    }

    private Option<Object> identifyCacheControlValue$default$2() {
        return None$.MODULE$;
    }

    private final CacheControl.MultipleCacheControlValues loop$1(String value, int index, CacheControl.MultipleCacheControlValues acc) {
        while (index != -1) {
            String valueChunk = value.substring(0, index);
            String remaining = value.substring(index + 1);
            int nextIndex = remaining.indexOf(",");
            Chunk acceptedEncoding = Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CacheControl[]{this.identifyCacheControl(valueChunk)}));
            acc = acc.copy((Chunk<CacheControl>)acc.values().$plus$plus(acceptedEncoding));
            index = nextIndex;
            value = remaining;
        }
        return acc.copy((Chunk<CacheControl>)acc.values().$plus$plus(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CacheControl[]{this.identifyCacheControl(value)}))));
    }

    private CacheControl$() {
    }
}

