/*
 * Decompiled with CFR 0.152.
 */
package zio.http.model.headers.values;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.util.matching.Regex;
import zio.http.model.headers.values.ContentDisposition;
import zio.http.model.headers.values.ContentDisposition$Invalid$;

public final class ContentDisposition$ {
    public static final ContentDisposition$ MODULE$ = new ContentDisposition$();
    private static final Regex AttachmentRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("attachment; filename=\"(.*)\""));
    private static final Regex InlineRegex;
    private static final Regex FormDataRegex;
    private static final Regex FormDataNoFileNameRegex;
    private static final ContentDisposition inline;
    private static final ContentDisposition attachment;
    private static volatile int bitmap$init$0;

    static {
        bitmap$init$0 |= 0x10;
        InlineRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("inline; filename=\"(.*)\""));
        bitmap$init$0 |= 0x20;
        FormDataRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("form-data; name=\"(.*)\"; filename=\"(.*)\""));
        bitmap$init$0 |= 0x40;
        FormDataNoFileNameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("form-data; name=\"(.*)\""));
        bitmap$init$0 |= 0x80;
        inline = new ContentDisposition.Inline((Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x100;
        attachment = new ContentDisposition.Attachment((Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x200;
    }

    private Regex AttachmentRegex() {
        if ((bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/model/headers/values/ContentDisposition.scala: 27");
        }
        return AttachmentRegex;
    }

    private Regex InlineRegex() {
        if ((bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/model/headers/values/ContentDisposition.scala: 28");
        }
        return InlineRegex;
    }

    private Regex FormDataRegex() {
        if ((bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/model/headers/values/ContentDisposition.scala: 29");
        }
        return FormDataRegex;
    }

    private Regex FormDataNoFileNameRegex() {
        if ((bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/model/headers/values/ContentDisposition.scala: 30");
        }
        return FormDataNoFileNameRegex;
    }

    public ContentDisposition toContentDisposition(CharSequence contentDisposition) {
        String asString = ((Object)contentDisposition).toString();
        if (asString.startsWith("attachment")) {
            ContentDisposition.Attachment attachment;
            Option option = this.AttachmentRegex().unapplySeq(contentDisposition);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String filename = (String)((LinearSeqOps)option.get()).apply(0);
                attachment = new ContentDisposition.Attachment((Option<String>)new Some((Object)filename));
            } else {
                attachment = new ContentDisposition.Attachment((Option<String>)None$.MODULE$);
            }
            return attachment;
        }
        if (asString.startsWith("inline")) {
            ContentDisposition.Inline inline;
            Option option = this.InlineRegex().unapplySeq(contentDisposition);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String filename = (String)((LinearSeqOps)option.get()).apply(0);
                inline = new ContentDisposition.Inline((Option<String>)new Some((Object)filename));
            } else {
                inline = new ContentDisposition.Inline((Option<String>)None$.MODULE$);
            }
            return inline;
        }
        if (asString.startsWith("form-data")) {
            Option option;
            ContentDisposition contentDisposition2;
            Option option2 = this.FormDataRegex().unapplySeq(contentDisposition);
            if (!option2.isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
                String name = (String)((LinearSeqOps)option2.get()).apply(0);
                String filename = (String)((LinearSeqOps)option2.get()).apply(1);
                contentDisposition2 = new ContentDisposition.FormData(name, (Option<String>)new Some((Object)filename));
            } else if (contentDisposition != null && !(option = this.FormDataNoFileNameRegex().unapplySeq(contentDisposition)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String name = (String)((LinearSeqOps)option.get()).apply(0);
                contentDisposition2 = new ContentDisposition.FormData(name, (Option<String>)None$.MODULE$);
            } else {
                contentDisposition2 = ContentDisposition$Invalid$.MODULE$;
            }
            return contentDisposition2;
        }
        return ContentDisposition$Invalid$.MODULE$;
    }

    public String fromContentDisposition(ContentDisposition contentDisposition) {
        String string;
        if (contentDisposition instanceof ContentDisposition.Attachment) {
            Option<String> filename = ((ContentDisposition.Attachment)contentDisposition).filename();
            string = new StringBuilder(12).append("attachment; ").append(filename.map((Function1 & Serializable)x$1 -> new StringBuilder(9).append("filename=").append((String)x$1).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
        } else if (contentDisposition instanceof ContentDisposition.Inline) {
            Option<String> filename = ((ContentDisposition.Inline)contentDisposition).filename();
            string = new StringBuilder(8).append("inline; ").append(filename.map((Function1 & Serializable)x$2 -> new StringBuilder(9).append("filename=").append((String)x$2).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
        } else if (contentDisposition instanceof ContentDisposition.FormData) {
            ContentDisposition.FormData formData = (ContentDisposition.FormData)contentDisposition;
            String name = formData.name();
            Option<String> filename = formData.filename();
            string = new StringBuilder(18).append("form-data; name=").append(name).append("; ").append(filename.map((Function1 & Serializable)x$3 -> new StringBuilder(9).append("filename=").append((String)x$3).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
        } else if (ContentDisposition$Invalid$.MODULE$.equals(contentDisposition)) {
            string = "";
        } else {
            throw new MatchError((Object)contentDisposition);
        }
        return string;
    }

    public ContentDisposition inline() {
        if ((bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/model/headers/values/ContentDisposition.scala: 64");
        }
        return inline;
    }

    public ContentDisposition attachment() {
        if ((bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/model/headers/values/ContentDisposition.scala: 65");
        }
        return attachment;
    }

    public ContentDisposition inline(String filename) {
        return new ContentDisposition.Inline((Option<String>)new Some((Object)filename));
    }

    public ContentDisposition attachment(String filename) {
        return new ContentDisposition.Attachment((Option<String>)new Some((Object)filename));
    }

    public ContentDisposition formData(String name) {
        return new ContentDisposition.FormData(name, (Option<String>)None$.MODULE$);
    }

    public ContentDisposition formData(String name, String filename) {
        return new ContentDisposition.FormData(name, (Option<String>)new Some((Object)filename));
    }

    private ContentDisposition$() {
    }
}

