/*
 * Decompiled with CFR 0.152.
 */
package zio.http.model.headers.values;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import zio.http.model.headers.values.Warning;
import zio.http.model.headers.values.Warning$InvalidWarning$;

public final class Warning$ {
    public static final Warning$ MODULE$ = new Warning$();
    private static final List<Object> validCodes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{110, 111, 112, 113, 199, 214, 299}));
    private static final DateTimeFormatter expectedDateFormat;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        expectedDateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz");
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    private List<Object> validCodes() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/model/headers/values/Warning.scala: 42");
        }
        return validCodes;
    }

    private DateTimeFormatter expectedDateFormat() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/model/headers/values/Warning.scala: 43");
        }
        return expectedDateFormat;
    }

    public Warning toWarning(String warningString) {
        int warnCode = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.parseInt(warningString.split(" ")[0])).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
        String warnAgent = warningString.split(" ")[1];
        int descriptionStartIndex = warningString.indexOf(34);
        int descriptionEndIndex = warningString.indexOf("\"", warningString.indexOf("\"") + 1);
        String description = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> warningString.substring(descriptionStartIndex, descriptionEndIndex + 1)).getOrElse((Function0 & Serializable)() -> "");
        int dateStartIndex = warningString.indexOf("\"", descriptionEndIndex + 1);
        int dateEndIndex = warningString.indexOf("\"", dateStartIndex + 1);
        Option warningDate = Try$.MODULE$.apply((Function0 & Serializable)() -> ZonedDateTime.parse(warningString.substring(dateStartIndex + 1, dateEndIndex), MODULE$.expectedDateFormat())).toOption();
        Warning.WarningValue fullWarning = new Warning.WarningValue(warnCode, warnAgent, description, (Option<ZonedDateTime>)warningDate);
        if (Warning$.isDateInvalid$1(warningString, warningDate)) {
            return Warning$InvalidWarning$.MODULE$;
        }
        if (Warning$.isAgentMissing$1(warningString, descriptionStartIndex)) {
            return Warning$InvalidWarning$.MODULE$;
        }
        if (this.isCodeValid$1(fullWarning.code()) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(fullWarning.text()))) {
            return fullWarning;
        }
        return Warning$InvalidWarning$.MODULE$;
    }

    public String fromWarning(Warning warning) {
        String string;
        if (warning instanceof Warning.WarningValue) {
            String string2;
            Warning.WarningValue warningValue = (Warning.WarningValue)warning;
            int code = warningValue.code();
            String agent = warningValue.agent();
            String text = warningValue.text();
            Option<ZonedDateTime> date = warningValue.date();
            if (date instanceof Some) {
                string2 = ((ZonedDateTime)((Some)date).value()).format(this.expectedDateFormat());
            } else if (None$.MODULE$.equals(date)) {
                string2 = "";
            } else {
                throw new MatchError(date);
            }
            string = string2.isEmpty() ? new StringBuilder(2).append(Integer.toString(code)).append(" ").append(agent).append(" ").append(text).toString() : new StringBuilder(25).append(Integer.toString(code)).append(" ").append(agent).append(" ").append(text).append(" ").append('\"').append(string2).append('\"').toString();
        } else if (Warning$InvalidWarning$.MODULE$.equals(warning)) {
            string = "";
        } else {
            throw new MatchError((Object)warning);
        }
        return string;
    }

    private final boolean isCodeValid$1(int warningCode) {
        return this.validCodes().contains((Object)BoxesRunTime.boxToInteger((int)warningCode));
    }

    private static final boolean isAgentMissing$1(String text, int descriptionStartIndex$1) {
        return Predef$.MODULE$.wrapString(text).toList().take(descriptionStartIndex$1).length() <= 4;
    }

    private static final boolean isDateInvalid$1(String warningText, Option warningDate) {
        String trimmedWarningText = warningText.trim();
        int descriptionEndIndexNoSpace = trimmedWarningText.indexOf("\"", trimmedWarningText.indexOf("\"") + 1);
        return warningDate.isEmpty() && trimmedWarningText.length() - descriptionEndIndexNoSpace > 1;
    }

    private Warning$() {
    }
}

