/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.UninitializedFieldError;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.Unsafe;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Response;
import zio.http.netty.model.Conversions$;

public final class NettyResponseEncoder$ {
    public static final NettyResponseEncoder$ MODULE$ = new NettyResponseEncoder$();
    private static final ConcurrentHashMap<Response, HttpResponse> frozenCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Response, ZIO<Object, Nothing$, HttpResponse>> frozenZioCache;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        frozenZioCache = new ConcurrentHashMap();
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    private ConcurrentHashMap<Response, HttpResponse> frozenCache() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/netty/NettyResponseEncoder.scala: 31");
        }
        return frozenCache;
    }

    private ConcurrentHashMap<Response, ZIO<Object, Nothing$, HttpResponse>> frozenZioCache() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/netty/NettyResponseEncoder.scala: 32");
        }
        return frozenZioCache;
    }

    public ZIO<Object, Throwable, HttpResponse> encode(Response response) {
        Body body = response.body();
        if (body.isComplete()) {
            ZIO<Object, Nothing$, HttpResponse> cachedValue = this.frozenZioCache().get(response);
            if (cachedValue != null) {
                return cachedValue;
            }
            return body.asArray("zio.http.netty.NettyResponseEncoder.encode(NettyResponseEncoder.scala:40)").flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.attemptUnsafe((Function1 & Serializable)unsafe -> MODULE$.fastEncode(response, (byte[])bytes, (Unsafe)unsafe), (Object)"zio.http.netty.NettyResponseEncoder.encode(NettyResponseEncoder.scala:40)"), (Object)"zio.http.netty.NettyResponseEncoder.encode(NettyResponseEncoder.scala:40)");
        }
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(response.status());
        if (!jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            jHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> new DefaultHttpResponse(HttpVersion.HTTP_1_1, jStatus, jHeaders), (Object)"zio.http.netty.NettyResponseEncoder.encode(NettyResponseEncoder.scala:46)");
    }

    public HttpResponse fastEncode(Response response, byte[] bytes, Unsafe unsafe) {
        if (response.frozen()) {
            HttpResponse encodedResponse = this.frozenCache().get(response);
            if (encodedResponse != null) {
                return encodedResponse;
            }
            HttpResponse encoded = this.doEncode(response, bytes);
            ZIO encodedZio = ZIO$.MODULE$.succeed((Function0 & Serializable)() -> encoded, (Object)"zio.http.netty.NettyResponseEncoder.fastEncode.encodedZio(NettyResponseEncoder.scala:58)");
            this.frozenZioCache().put(response, (ZIO<Object, Nothing$, HttpResponse>)encodedZio);
            this.frozenCache().put(response, encoded);
            return encoded;
        }
        return this.doEncode(response, bytes);
    }

    private HttpResponse doEncode(Response response, byte[] bytes) {
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        boolean hasContentLength = jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(response.status());
        ByteBuf jContent = Unpooled.wrappedBuffer((byte[])bytes);
        DefaultFullHttpResponse jResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, jStatus, jContent, false);
        if (!hasContentLength) {
            jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)jContent.readableBytes()));
        }
        jResponse.headers().add(jHeaders);
        return jResponse;
    }

    private NettyResponseEncoder$() {
    }
}

