/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import zio.Promise;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.http.Request;
import zio.http.Response;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyResponse$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.NettyRuntime$;
import zio.http.netty.Versions$;
import zio.http.netty.client.ChannelState;
import zio.http.netty.model.Conversions$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\t\u0012\u0005iA\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tg\u0001\u0011\t\u0011)A\u0005_!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!\u0011!Q\u0001\fmCQa\u0019\u0001\u0005\u0002\u0011Dq!\u001c\u0001C\u0002\u0013-a\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006{\u0002!\tE \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!a\u0007\u0001\t\u0013\tiBA\u000fDY&,g\u000e^%oE>,h\u000eZ*ue\u0016\fW.\u001b8h\u0011\u0006tG\r\\3s\u0015\t\u00112#\u0001\u0004dY&,g\u000e\u001e\u0006\u0003)U\tQA\\3uifT!AF\f\u0002\t!$H\u000f\u001d\u0006\u00021\u0005\u0019!0[8\u0004\u0001M\u0011\u0001a\u0007\t\u00049\t\"S\"A\u000f\u000b\u0005yy\u0012aB2iC:tW\r\u001c\u0006\u0003)\u0001R\u0011!I\u0001\u0003S>L!aI\u000f\u00037MKW\u000e\u001d7f\u0007\"\fgN\\3m\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s!\t)3&D\u0001'\u0015\t1rE\u0003\u0002)S\u0005)1m\u001c3fG*\u0011!fH\u0001\bQ\u0006tG\r\\3s\u0013\tacE\u0001\u0006IiR\u0004xJ\u00196fGR\f1A\u001d;n+\u0005y\u0003C\u0001\u00192\u001b\u0005\u0019\u0012B\u0001\u001a\u0014\u00051qU\r\u001e;z%VtG/[7f\u0003\u0011\u0011H/\u001c\u0011\u0002\u0007I,\u0017\u000f\u0005\u00027o5\tQ#\u0003\u00029+\t9!+Z9vKN$\u0018AC8o%\u0016\u001c\bo\u001c8tKB!1\b\u0010 M\u001b\u00059\u0012BA\u001f\u0018\u0005\u001d\u0001&o\\7jg\u0016\u0004\"aP%\u000f\u0005\u00013eBA!E\u001b\u0005\u0011%BA\"\u001a\u0003\u0019a$o\\8u}%\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\u0011\u00069\u0001/Y2lC\u001e,'\"A#\n\u0005)[%!\u0003+ie><\u0018M\u00197f\u0015\t9\u0005\n\u0005\u00027\u001b&\u0011a*\u0006\u0002\t%\u0016\u001c\bo\u001c8tK\u0006QqN\\\"p[BdW\r^3\u0011\tmbd(\u0015\t\u0003%Nk\u0011!E\u0005\u0003)F\u0011Ab\u00115b]:,Gn\u0015;bi\u0016\fq\"\u001a8bE2,7*Z3q\u00032Lg/\u001a\t\u0003/bk\u0011\u0001S\u0005\u00033\"\u0013qAQ8pY\u0016\fg.A\u0003ue\u0006\u001cW\r\u0005\u0002]A:\u0011Ql\u0018\b\u0003\u0003zK\u0011\u0001G\u0005\u0003\u000f^I!!\u00192\u0003\u000bQ\u0013\u0018mY3\u000b\u0005\u001d;\u0012A\u0002\u001fj]&$h\b\u0006\u0004fQ&T7\u000e\u001c\u000b\u0003M\u001e\u0004\"A\u0015\u0001\t\u000biC\u00019A.\t\u000b5B\u0001\u0019A\u0018\t\u000bQB\u0001\u0019A\u001b\t\u000beB\u0001\u0019\u0001\u001e\t\u000b=C\u0001\u0019\u0001)\t\u000bUC\u0001\u0019\u0001,\u0002\u0017Ut7/\u00194f\u00072\f7o]\u000b\u0002_B\u00111\b]\u0005\u0003c^\u0011a!\u00168tC\u001a,\u0017\u0001D;og\u00064Wm\u00117bgN\u0004\u0013!D2iC:tW\r\\!di&4X\r\u0006\u0002vqB\u0011qK^\u0005\u0003o\"\u0013A!\u00168ji\")\u0011p\u0003a\u0001u\u0006\u00191\r\u001e=\u0011\u0005qY\u0018B\u0001?\u001e\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqR\fAb\u00195b]:,GNU3bIB\"B!^@\u0002\u0002!)\u0011\u0010\u0004a\u0001u\"1\u00111\u0001\u0007A\u0002\u0011\n1!\\:h\u0003=)\u0007pY3qi&|gnQ1vO\"$H#B;\u0002\n\u0005-\u0001\"B=\u000e\u0001\u0004Q\bBBA\u0007\u001b\u0001\u0007a(A\u0003feJ|'/A\u0007f]\u000e|G-\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003'\tI\u0002E\u0002&\u0003+I1!a\u0006'\u0005-AE\u000f\u001e9SKF,Xm\u001d;\t\u000bQr\u0001\u0019A\u001b\u0002\u0019]\u0014\u0018\u000e^3SKF,Xm\u001d;\u0015\u000bU\fy\"!\t\t\r\u0005\rq\u00021\u00016\u0011\u0015Ix\u00021\u0001{\u0001")
public final class ClientInboundStreamingHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final NettyRuntime rtm;
    private final Request req;
    private final Promise<Throwable, Response> onResponse;
    private final Promise<Throwable, ChannelState> onComplete;
    private final boolean enableKeepAlive;
    private final Object trace;
    private final Unsafe unsafeClass;
    private volatile boolean bitmap$init$0;

    public NettyRuntime rtm() {
        return this.rtm;
    }

    private Unsafe unsafeClass() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/netty/client/ClientInboundStreamingHandler.scala: 38");
        }
        return this.unsafeClass;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.writeRequest(this.req, ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)msg;
            ctx.channel().config().setAutoRead(false);
            this.rtm().runUninterruptible(ctx, NettyRuntime$.MODULE$.noopEnsuring(), (ZIO<Object, Throwable, Object>)this.onResponse.succeed((Object)NettyResponse$.MODULE$.make(ctx, httpResponse, this.rtm(), this.onComplete, this.enableKeepAlive && HttpUtil.isKeepAlive((HttpMessage)httpResponse), this.unsafeClass(), this.trace), this.trace), this.unsafeClass(), this.trace);
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ctx.fireChannelRead((Object)httpContent);
            return;
        }
        throw new IllegalStateException(new StringBuilder(32).append("Client unexpected message type: ").append(msg).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        this.rtm().runUninterruptible(ctx, NettyRuntime$.MODULE$.noopEnsuring(), (ZIO<Object, Throwable, Object>)this.onResponse.fail((Object)error, this.trace).$times$greater((Function0 & Serializable)() -> $this.onComplete.fail((Object)error, $this.trace), this.trace), this.unsafeClass(), this.trace);
    }

    private HttpRequest encodeRequest(Request req) {
        HttpHeaders httpHeaders;
        HttpMethod method = Conversions$.MODULE$.methodToNetty(req.method());
        HttpVersion jVersion = Versions$.MODULE$.convertToZIOToNetty(req.version());
        String path = req.url().relative().encode();
        HttpHeaders encodedReqHeaders = Conversions$.MODULE$.headersToNetty(req.headers());
        Option<String> option = req.url().hostWithOptionalPort();
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            httpHeaders = encodedReqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)value);
        } else if (None$.MODULE$.equals(option)) {
            httpHeaders = encodedReqHeaders;
        } else {
            throw new MatchError(option);
        }
        HttpHeaders h = httpHeaders.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked").add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"zhttp-client");
        return new DefaultHttpRequest(jVersion, method, path, h);
    }

    private void writeRequest(Request msg, ChannelHandlerContext ctx) {
        ctx.write((Object)this.encodeRequest(msg));
        this.rtm().run(ctx, NettyRuntime$.MODULE$.noopEnsuring(), this.rtm().run$default$3(), (ZIO<Object, Throwable, Object>)NettyBodyWriter$.MODULE$.write(msg.body(), ctx).unit(this.trace), Unsafe$.MODULE$.unsafe(), this.trace);
        ctx.flush();
    }

    public ClientInboundStreamingHandler(NettyRuntime rtm, Request req, Promise<Throwable, Response> onResponse, Promise<Throwable, ChannelState> onComplete, boolean enableKeepAlive, Object trace) {
        this.rtm = rtm;
        this.req = req;
        this.onResponse = onResponse;
        this.onComplete = onComplete;
        this.enableKeepAlive = enableKeepAlive;
        this.trace = trace;
        super(false);
        this.unsafeClass = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = true;
    }
}

