/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Exit;
import zio.FiberFailure;
import zio.IsSubtypeOfError$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Http;
import zio.http.Request;
import zio.http.Response;
import zio.http.ServerConfig;
import zio.http.URL;
import zio.http.URL$;
import zio.http.model.HttpError;
import zio.http.model.HttpError$InternalServerError$;
import zio.http.model.Version;
import zio.http.model.Version$Http_1_0$;
import zio.http.model.Version$Http_1_1$;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyResponseEncoder$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.NettyRuntime$;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.server.ServerTime;
import zio.http.netty.socket.NettySocketProtocol$;
import zio.http.socket.SocketApp;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0005\ref!B A\u0005\u001aC\u0005\u0002\u00038\u0001\u0005+\u0007I\u0011A8\t\u0011]\u0004!\u0011#Q\u0001\nAD\u0001\u0002\u001f\u0001\u0003\u0016\u0004%\t!\u001f\u0005\t}\u0002\u0011\t\u0012)A\u0005u\"Iq\u0010\u0001BK\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003\u0013\u0001!\u0011#Q\u0001\n\u0005\r\u0001BCA\u0006\u0001\tU\r\u0011\"\u0001\u0002\u000e!Q\u0011q\u0003\u0001\u0003\u0012\u0003\u0006I!a\u0004\t\u0015\u0005e\u0001A!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0002$\u0001\u0011\t\u0012)A\u0005\u0003;A!\"!\n\u0001\u0005\u0003\u0005\u000b1BA\u0014\u0011\u001d\t9\u0004\u0001C\u0001\u0003sA\u0011\"a\u0013\u0001\u0005\u0004%Y!!\u0014\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u001fB1\"!\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\\!Y\u00111\u000f\u0001A\u0002\u0003\u0007I\u0011BA;\u0011-\t\t\t\u0001a\u0001\u0002\u0003\u0006K!!\u0018\t\u0017\u0005\r\u0005\u00011AA\u0002\u0013%\u0011Q\u0011\u0005\f\u0003\u001b\u0003\u0001\u0019!a\u0001\n\u0013\ty\tC\u0006\u0002\u0014\u0002\u0001\r\u0011!Q!\n\u0005\u001d\u0005bCAK\u0001\u0001\u0007\t\u0019!C\u0005\u0003/C1\"a*\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*\"Y\u0011Q\u0016\u0001A\u0002\u0003\u0005\u000b\u0015BAM\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a-\u0001\t\u0013\t\t\fC\u0004\u00026\u0002!\t%a.\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\"9\u0011q\u001b\u0001\u0005\n\u0005e\u0007bBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005KAqA!\u000e\u0001\t\u0013\u00119\u0004C\u0004\u0003F\u0001!IAa\u0012\t\u000f\t]\u0003\u0001\"\u0003\u0003Z!9!Q\u000f\u0001\u0005\n\t]\u0004b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u00053\u0003A\u0011\u0002BN\u0011%\u00119\u000bAA\u0001\n\u0003\u0011I\u000bC\u0005\u0003:\u0002\t\n\u0011\"\u0001\u0003<\"I!Q\u001a\u0001\u0012\u0002\u0013\u0005!q\u001a\u0005\n\u0005'\u0004\u0011\u0013!C\u0001\u0005+D\u0011B!7\u0001#\u0003%\tAa7\t\u0013\t}\u0007!%A\u0005\u0002\t\u0005\b\"\u0003Bs\u0001\u0005\u0005I\u0011\tBt\u0011%\u0011I\u0010AA\u0001\n\u0003\u0011Y\u0010C\u0005\u0004\u0004\u0001\t\t\u0011\"\u0001\u0004\u0006!I1\u0011\u0002\u0001\u0002\u0002\u0013\u000531\u0002\u0005\n\u00073\u0001\u0011\u0011!C\u0001\u00077A\u0011ba\b\u0001\u0003\u0003%\te!\t\t\u0013\r\u0015\u0002!!A\u0005B\r\u001d\u0002\"CB\u0015\u0001\u0005\u0005I\u0011IB\u0016\u0011%\u0019i\u0003AA\u0001\n\u0003\u001aycB\u0004\u0004P\u0001C\ta!\u0015\u0007\r}\u0002\u0005\u0012AB*\u0011\u001d\t9D\u000eC\u0001\u0007GB!b!\u001a7\u0005\u0004%\tARB4\u0011!\u0019)H\u000eQ\u0001\n\r%\u0004\"CB<m\t\u0007I\u0011AB=\u0011!\u00199I\u000eQ\u0001\n\rm\u0004\"CBEm\u0005\u0005I\u0011QBF\u0011%\u0019YJNA\u0001\n\u0003\u001bi\nC\u0005\u00040Z\n\t\u0011\"\u0003\u00042\n!2+\u001a:wKJLeNY8v]\u0012D\u0015M\u001c3mKJT!!\u0011\"\u0002\rM,'O^3s\u0015\t\u0019E)A\u0003oKR$\u0018P\u0003\u0002F\r\u0006!\u0001\u000e\u001e;q\u0015\u00059\u0015a\u0001>j_N!\u0001!S.b!\rQ\u0005KU\u0007\u0002\u0017*\u0011A*T\u0001\bG\"\fgN\\3m\u0015\t\u0019eJC\u0001P\u0003\tIw.\u0003\u0002R\u0017\nY2+[7qY\u0016\u001c\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJ\u0004\"aU-\u000e\u0003QS!!R+\u000b\u0005Y;\u0016!B2pI\u0016\u001c'B\u0001-N\u0003\u001dA\u0017M\u001c3mKJL!A\u0017+\u0003\u0015!#H\u000f](cU\u0016\u001cG\u000f\u0005\u0002]?6\tQLC\u0001_\u0003\u0015\u00198-\u00197b\u0013\t\u0001WLA\u0004Qe>$Wo\u0019;\u0011\u0005\t\\gBA2j\u001d\t!\u0007.D\u0001f\u0015\t1w-\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005q\u0016B\u00016^\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005)l\u0016AB1qaJ+g-F\u0001q!\t\tHO\u0004\u0002sg6\t\u0001)\u0003\u0002k\u0001&\u0011QO\u001e\u0002\u0007\u0003B\u0004(+\u001a4\u000b\u0005)\u0004\u0015aB1qaJ+g\rI\u0001\u0007G>tg-[4\u0016\u0003i\u0004\"a\u001f?\u000e\u0003\u0011K!! #\u0003\u0019M+'O^3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005qQM\u001d:DC2d'-Y2l%\u00164WCAA\u0002!\r\t\u0018QA\u0005\u0004\u0003\u000f1(\u0001E#se>\u00148)\u00197mE\u0006\u001c7NU3g\u0003=)'O]\"bY2\u0014\u0017mY6SK\u001a\u0004\u0013a\u0002:v]RLW.Z\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00145\t!)C\u0002\u0002\u0016\t\u0013ABT3uif\u0014VO\u001c;j[\u0016\f\u0001B];oi&lW\rI\u0001\u0005i&lW-\u0006\u0002\u0002\u001eA\u0019!/a\b\n\u0007\u0005\u0005\u0002I\u0001\u0006TKJ4XM\u001d+j[\u0016\fQ\u0001^5nK\u0002\nQ\u0001\u001e:bG\u0016\u0004B!!\u000b\u000229!\u00111FA\u0018\u001d\r!\u0017QF\u0005\u0002\u000f&\u0011!NR\u0005\u0005\u0003g\t)DA\u0003Ue\u0006\u001cWM\u0003\u0002k\r\u00061A(\u001b8jiz\"B\"a\u000f\u0002B\u0005\r\u0013QIA$\u0003\u0013\"B!!\u0010\u0002@A\u0011!\u000f\u0001\u0005\b\u0003Ka\u00019AA\u0014\u0011\u0015qG\u00021\u0001q\u0011\u0015AH\u00021\u0001{\u0011\u0019yH\u00021\u0001\u0002\u0004!9\u00111\u0002\u0007A\u0002\u0005=\u0001bBA\r\u0019\u0001\u0007\u0011QD\u0001\u0007k:\u001c\u0018MZ3\u0016\u0005\u0005=\u0003\u0003BA)\u0003'j\u0011AR\u0005\u0004\u0003+2%AB+og\u00064W-A\u0004v]N\fg-\u001a\u0011\u0002\u0007\u0005\u0004\b/\u0006\u0002\u0002^A1\u0011qLA4\u0003[rA!!\u0019\u0002f9!\u00111FA2\u0013\t)e)\u0003\u0002k\t&!\u0011\u0011NA6\u0005\r\t\u0005\u000f\u001d\u0006\u0003U\u0012\u00032\u0001XA8\u0013\r\t\t(\u0018\u0002\u0004\u0003:L\u0018aB1qa~#S-\u001d\u000b\u0005\u0003o\ni\bE\u0002]\u0003sJ1!a\u001f^\u0005\u0011)f.\u001b;\t\u0013\u0005}\u0004#!AA\u0002\u0005u\u0013a\u0001=%c\u0005!\u0011\r\u001d9!\u0003\r)gN^\u000b\u0003\u0003\u000f\u0003b!!\u0015\u0002\n\u00065\u0014bAAF\r\na!,\u00128wSJ|g.\\3oi\u00069QM\u001c<`I\u0015\fH\u0003BA<\u0003#C\u0011\"a \u0014\u0003\u0003\u0005\r!a\"\u0002\t\u0015tg\u000fI\u0001\fKJ\u00148)\u00197mE\u0006\u001c7.\u0006\u0002\u0002\u001aB!\u00111TAQ\u001d\rY\u0018QT\u0005\u0004\u0003?#\u0015AB*feZ,'/\u0003\u0003\u0002$\u0006\u0015&!D#se>\u00148)\u00197mE\u0006\u001c7NC\u0002\u0002 \u0012\u000bq\"\u001a:s\u0007\u0006dGNY1dW~#S-\u001d\u000b\u0005\u0003o\nY\u000bC\u0005\u0002\u0000Y\t\t\u00111\u0001\u0002\u001a\u0006aQM\u001d:DC2d'-Y2lA\u0005Q!/\u001a4sKND\u0017\t\u001d9\u0015\u0005\u0005]\u0014\u0001D3ogV\u0014X\rS1t\u0003B\u0004\u0018\u0001D2iC:tW\r\u001c*fC\u0012\u0004DCBA<\u0003s\u000b\u0019\rC\u0004\u0002<j\u0001\r!!0\u0002\u0007\r$\b\u0010E\u0002K\u0003\u007fK1!!1L\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDa!!2\u001b\u0001\u0004\u0011\u0016aA7tO\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0004\u0002x\u0005-\u0017Q\u001a\u0005\b\u0003w[\u0002\u0019AA_\u0011\u001d\tym\u0007a\u0001\u0003#\fQaY1vg\u0016\u00042AYAj\u0013\r\t).\u001c\u0002\n)\"\u0014xn^1cY\u0016\f1#\u00193e\u0003NLhn\u0019\"pIfD\u0015M\u001c3mKJ$b!a\u001e\u0002\\\u0006u\u0007bBA^9\u0001\u0007\u0011Q\u0018\u0005\b\u0003?d\u0002\u0019AAq\u0003\u0015\t7/\u001f8d!\u0011\t\u0019/!;\u000f\t\u0005E\u0011Q]\u0005\u0004\u0003O\u0014\u0015!\u0003(fiRL(i\u001c3z\u0013\u0011\tY/!<\u0003\u0017Us7/\u00194f\u0003NLhn\u0019\u0006\u0004\u0003O\u0014\u0015\u0001E1ui\u0016l\u0007\u000f\u001e$bgR<&/\u001b;f)!\t\u00190!?\u0002|\n\u0015\u0001c\u0001/\u0002v&\u0019\u0011q_/\u0003\u000f\t{w\u000e\\3b]\"9\u00111X\u000fA\u0002\u0005u\u0006bBA\u007f;\u0001\u0007\u0011q`\u0001\te\u0016\u001c\bo\u001c8tKB\u00191P!\u0001\n\u0007\t\rAI\u0001\u0005SKN\u0004xN\\:f\u0011\u001d\tI\"\ba\u0001\u0003;\t\u0001#\u0019;uK6\u0004HOR;mY^\u0013\u0018\u000e^3\u0015\u0019\t-!\u0011\u0003B\n\u0005+\u0011yB!\t\u0011\r\u0005%\"QBA<\u0013\u0011\u0011y!!\u000e\u0003\tQ\u000b7o\u001b\u0005\b\u0003ws\u0002\u0019AA_\u0011\u001d\tiP\ba\u0001\u0003\u007fDqAa\u0006\u001f\u0001\u0004\u0011I\"\u0001\u0005k%\u0016\fX/Z:u!\r\u0019&1D\u0005\u0004\u0005;!&a\u0003%uiB\u0014V-];fgRDq!!\u0007\u001f\u0001\u0004\ti\u0002C\u0004\u0002\fy\u0001\r!a\u0004\u0002+\u0005$H/Z7qi&kW.\u001a3jCR,wK]5uKRA\u00111\u001fB\u0014\u0005S\u0011\u0019\u0004C\u0004\u0002<~\u0001\r!!0\t\u000f\t-r\u00041\u0001\u0003.\u0005!Q\r_5u!)\t\tFa\f\u0002n\u0005}\u0018q`\u0005\u0004\u0005c1%a\u0001.J\u001f\"9\u0011\u0011D\u0010A\u0002\u0005u\u0011AD7bW\u0016T\u0016n\u001c*fcV,7\u000f\u001e\u000b\u0007\u0005s\u0011yD!\u0011\u0011\u0007m\u0014Y$C\u0002\u0003>\u0011\u0013qAU3rk\u0016\u001cH\u000fC\u0004\u0002<\u0002\u0002\r!!0\t\u000f\t\r\u0003\u00051\u0001\u0003\u001a\u0005Aa.\u001a;usJ+\u0017/A\u0007tKR\u001cVM\u001d<feRKW.\u001a\u000b\t\u0003o\u0012IEa\u0013\u0003N!9\u0011\u0011D\u0011A\u0002\u0005u\u0001bBA\u007fC\u0001\u0007\u0011q \u0005\b\u0005\u001f\n\u0003\u0019\u0001B)\u0003%Q'+Z:q_:\u001cX\rE\u0002T\u0005'J1A!\u0016U\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u0003I)\bo\u001a:bI\u0016$vnV3c'>\u001c7.\u001a;\u0015\u0015\u0005]$1\fB/\u0005C\u0012)\u0007C\u0004\u0002<\n\u0002\r!!0\t\u000f\t}#\u00051\u0001\u0003\u001a\u0005!!NU3r\u0011\u001d\u0011\u0019G\ta\u0001\u0003\u007f\f1A]3t\u0011\u001d\tYA\ta\u0001\u0003\u001fA3A\tB5!\u0011\u0011YG!\u001d\u000e\u0005\t5$b\u0001B8;\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM$Q\u000e\u0002\bi\u0006LGN]3d\u000359(/\u001b;f\u001d>$hi\\;oIR1!\u0011\u0010BC\u0005\u000f#B!a\u001e\u0003|!9!QP\u0012A\u0002\t}\u0014aB3ogV\u0014X\r\u001a\t\u00069\n\u0005\u0015qO\u0005\u0004\u0005\u0007k&!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\tYl\ta\u0001\u0003{CqAa\u0018$\u0001\u0004\u0011I\"A\u0007xe&$XMU3ta>t7/\u001a\u000b\u000b\u0005\u001b\u0013\tJa%\u0003\u0016\n]E\u0003BA<\u0005\u001fCqA! %\u0001\u0004\u0011y\bC\u0004\u0002<\u0012\u0002\r!!0\t\u000f\u0005\rE\u00051\u0001\u0002\b\"9!1\u0006\u0013A\u0002\t5\u0002b\u0002B0I\u0001\u0007!\u0011D\u0001\fS:$XM\u001d:vaR,G\r\u0006\u0003\u0003\u001e\n\u0015\u0006CCA)\u0005_\tiGa(\u0002xA\u0019AL!)\n\u0007\t\rVLA\u0004O_RD\u0017N\\4\t\u000f\u0005mV\u00051\u0001\u0002>\u0006!1m\u001c9z)1\u0011YKa,\u00032\nM&Q\u0017B\\)\u0011\tiD!,\t\u000f\u0005\u0015b\u0005q\u0001\u0002(!9aN\nI\u0001\u0002\u0004\u0001\bb\u0002='!\u0003\u0005\rA\u001f\u0005\t\u007f\u001a\u0002\n\u00111\u0001\u0002\u0004!I\u00111\u0002\u0014\u0011\u0002\u0003\u0007\u0011q\u0002\u0005\n\u000331\u0003\u0013!a\u0001\u0003;\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003>*\u001a\u0001Oa0,\u0005\t\u0005\u0007\u0003\u0002Bb\u0005\u0013l!A!2\u000b\t\t\u001d'QN\u0001\nk:\u001c\u0007.Z2lK\u0012LAAa3\u0003F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u001b\u0016\u0004u\n}\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005/TC!a\u0001\u0003@\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001BoU\u0011\tyAa0\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u001d\u0016\u0005\u0003;\u0011y,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005S\u0004BAa;\u0003v6\u0011!Q\u001e\u0006\u0005\u0005_\u0014\t0\u0001\u0003mC:<'B\u0001Bz\u0003\u0011Q\u0017M^1\n\t\t](Q\u001e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tu\bc\u0001/\u0003\u0000&\u00191\u0011A/\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u000554q\u0001\u0005\n\u0003\u007fr\u0013\u0011!a\u0001\u0005{\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u001b\u0001baa\u0004\u0004\u0016\u00055TBAB\t\u0015\r\u0019\u0019\"X\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\f\u0007#\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111_B\u000f\u0011%\ty\bMA\u0001\u0002\u0004\ti'\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002Bu\u0007GA\u0011\"a 2\u0003\u0003\u0005\rA!@\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!@\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!;\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019p!\r\t\u0013\u0005}D'!AA\u0002\u00055\u0004f\u0001\u0001\u00046A!1qGB%\u001d\u0011\u0019Id!\u0012\u000f\t\rm21\t\b\u0005\u0007{\u0019\tED\u0002e\u0007\u007fI\u0011aT\u0005\u0003\u0007:K!\u0001T'\n\u0007\r\u001d3*\u0001\bDQ\u0006tg.\u001a7IC:$G.\u001a:\n\t\r-3Q\n\u0002\t'\"\f'/\u00192mK*\u00191qI&\u0002)M+'O^3s\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s!\t\u0011hgE\u00037\u0007+\u001aY\u0006E\u0002]\u0007/J1a!\u0017^\u0005\u0019\te.\u001f*fMB!1QLB1\u001b\t\u0019yFC\u0002P\u0005cL1\u0001\\B0)\t\u0019\t&A\u0005jgJ+\u0017\rZ&fsV\u00111\u0011\u000e\t\u0007\u0007W\u001a\t(a=\u000e\u0005\r5$bAB8\u001b\u0006!Q\u000f^5m\u0013\u0011\u0019\u0019h!\u001c\u0003\u0019\u0005#HO]5ckR,7*Z=\u0002\u0015%\u001c(+Z1e\u0017\u0016L\b%A\u0003mCf,'/\u0006\u0002\u0004|AQ\u0011\u0011KB?\u0007\u0003\u0013y*!\u0010\n\u0007\r}dI\u0001\u0004[\u0019\u0006LXM\u001d\n\u000b\u0007\u0007\u000biB_A\b\u0003\u0007\u0001hABBCm\u0001\u0019\tI\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0001\u0004mCf,'\u000fI\u0001\u0006CB\u0004H.\u001f\u000b\r\u0007\u001b\u001b\tja%\u0004\u0016\u000e]5\u0011\u0014\u000b\u0005\u0003{\u0019y\tC\u0004\u0002&q\u0002\u001d!a\n\t\u000b9d\u0004\u0019\u00019\t\u000bad\u0004\u0019\u0001>\t\r}d\u0004\u0019AA\u0002\u0011\u001d\tY\u0001\u0010a\u0001\u0003\u001fAq!!\u0007=\u0001\u0004\ti\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r}51\u0016\t\u00069\u000e\u00056QU\u0005\u0004\u0007Gk&AB(qi&|g\u000eE\u0006]\u0007O\u0003(0a\u0001\u0002\u0010\u0005u\u0011bABU;\n1A+\u001e9mKVB\u0011b!,>\u0003\u0003\u0005\r!!\u0010\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00044B!!1^B[\u0013\u0011\u00199L!<\u0003\r=\u0013'.Z2u\u0001")
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
Serializable {
    private final AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>> appRef;
    private final ServerConfig config;
    private final AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>> errCallbackRef;
    private final NettyRuntime runtime;
    private final ServerTime time;
    private final Object trace;
    private final Unsafe unsafe;
    private Http<Object, Response, Request, Response> app;
    private ZEnvironment<Object> env;
    private Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>> errCallback;
    private volatile boolean bitmap$init$0;

    public static Option<Tuple5<AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>>, ServerConfig, AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>>, NettyRuntime, ServerTime>> unapply(ServerInboundHandler x$0) {
        return ServerInboundHandler$.MODULE$.unapply(x$0);
    }

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>> appRef, ServerConfig config, AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>> errCallbackRef, NettyRuntime runtime, ServerTime time, Object trace) {
        return ServerInboundHandler$.MODULE$.apply(appRef, config, errCallbackRef, runtime, time, trace);
    }

    public static ZLayer<ServerTime, Nothing$, ServerInboundHandler> layer() {
        return ServerInboundHandler$.MODULE$.layer();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>> appRef() {
        return this.appRef;
    }

    public ServerConfig config() {
        return this.config;
    }

    public AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>> errCallbackRef() {
        return this.errCallbackRef;
    }

    public NettyRuntime runtime() {
        return this.runtime;
    }

    public ServerTime time() {
        return this.time;
    }

    private Unsafe unsafe() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/netty/server/ServerInboundHandler.scala: 49");
        }
        return this.unsafe;
    }

    private Http<Object, Response, Request, Response> app() {
        return this.app;
    }

    private void app_$eq(Http<Object, Response, Request, Response> x$1) {
        this.app = x$1;
    }

    private ZEnvironment<Object> env() {
        return this.env;
    }

    private void env_$eq(ZEnvironment<Object> x$1) {
        this.env = x$1;
    }

    private Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>> errCallback() {
        return this.errCallback;
    }

    private void errCallback_$eq(Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>> x$1) {
        this.errCallback = x$1;
    }

    public void refreshApp() {
        Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>> pair = this.appRef().get();
        Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>> callback = this.errCallbackRef().get();
        this.app_$eq((Http)pair._1());
        this.env_$eq((ZEnvironment<Object>)((ZEnvironment)pair._2()));
        this.errCallback_$eq((Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>)((Function1)callback.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private void ensureHasApp() {
        if (this.app() == null) {
            this.refreshApp();
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)msg;
            Request req = this.makeZioRequest(ctx, (HttpRequest)fullHttpRequest);
            JFunction0.mcV.sp & Serializable releaseRequest = (JFunction0.mcV.sp & Serializable)() -> {
                if (fullHttpRequest.refCnt() > 0) {
                    fullHttpRequest.release();
                    return;
                }
            };
            this.ensureHasApp();
            ZIO<Object, Response, Response> exit = this.app().runZIOOrNull(req, this.unsafe(), this.trace);
            if (!this.attemptImmediateWrite(ctx, exit, this.time())) {
                this.writeResponse(ctx, this.env(), exit, (HttpRequest)fullHttpRequest, (Function0<BoxedUnit>)releaseRequest);
                return;
            }
            ServerInboundHandler.$anonfun$channelRead0$1(fullHttpRequest);
            return;
        }
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            Request req = this.makeZioRequest(ctx, httpRequest);
            this.ensureHasApp();
            ZIO<Object, Response, Response> exit = this.app().runZIOOrNull(req, this.unsafe(), this.trace);
            if (!this.attemptImmediateWrite(ctx, exit, this.time())) {
                HttpMethod httpMethod = httpRequest.method();
                HttpMethod httpMethod2 = HttpMethod.TRACE;
                if (!(httpMethod == null ? httpMethod2 != null : !httpMethod.equals(httpMethod2)) || httpRequest.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) || httpRequest.headers().contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                    ctx.channel().config().setAutoRead(false);
                }
                this.writeResponse(ctx, this.env(), exit, httpRequest, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ctx.channel().config().setAutoRead(true));
                return;
            }
        } else {
            if (msg instanceof HttpContent) {
                HttpContent httpContent = (HttpContent)msg;
                ctx.fireChannelRead((Object)httpContent);
                return;
            }
            throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.errCallback() != null) {
            this.runtime().run(ctx, NettyRuntime$.MODULE$.noopEnsuring(), this.runtime().run$default$3(), (ZIO<Object, Throwable, Object>)((ZIO)this.errCallback().apply((Object)Cause$.MODULE$.die(cause, Cause$.MODULE$.die$default$2()))), this.unsafe(), this.trace);
            return;
        }
        if (cause instanceof IOException && ((IOException)cause).getMessage().contentEquals("Connection reset by peer")) {
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private void addAsyncBodyHandler(ChannelHandlerContext ctx, NettyBody.UnsafeAsync async) {
        if (BoxesRunTime.unboxToBoolean((Object)ctx.channel().attr(ServerInboundHandler$.MODULE$.isReadKey()).get())) {
            throw new RuntimeException("Unable to add the async body handler as the content has already been read.");
        }
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)new ServerAsyncBodyHandler(async));
        ctx.channel().attr(ServerInboundHandler$.MODULE$.isReadKey()).set((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean attemptFastWrite(ChannelHandlerContext ctx, Response response, ServerTime time) {
        Body body = response.body();
        if (!(body instanceof Body.UnsafeBytes)) return false;
        Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
        HttpResponse httpResponse = NettyResponseEncoder$.MODULE$.fastEncode(response, unsafeBytes.unsafeAsArray(this.unsafe()), this.unsafe());
        if (httpResponse instanceof FullHttpResponse) {
            FullHttpResponse fullHttpResponse = (FullHttpResponse)httpResponse;
            if (response.frozen()) {
                FullHttpResponse djResponse = fullHttpResponse.retainedDuplicate();
                this.setServerTime(time, response, (HttpResponse)djResponse);
                ctx.writeAndFlush((Object)djResponse, ctx.voidPromise());
                return true;
            }
        }
        if (!response.frozen()) return false;
        throw new IllegalArgumentException(new StringBuilder(127).append("The ").append(httpResponse.getClass().getName()).append(" was marked as 'frozen'.  However, zio-http only supports frozen responses when the response is of type 'FullHttpResponse'.").toString());
    }

    private ZIO<Object, Throwable, BoxedUnit> attemptFullWrite(ChannelHandlerContext ctx, Response response, HttpRequest jRequest, ServerTime time, NettyRuntime runtime) {
        return (response.isWebSocket() ? ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable)() -> this.upgradeToWebSocket(ctx, jRequest, response, runtime), this.trace) : NettyResponseEncoder$.MODULE$.encode(response).flatMap((Function1 & Serializable)jResponse -> ZIO$.MODULE$.attempt((Function0 & Serializable)() -> {
            this.setServerTime(time, response, (HttpResponse)jResponse);
            return ctx.writeAndFlush(jResponse);
        }, $this.trace).flatMap((Function1 & Serializable)x$8 -> (!(jResponse instanceof FullHttpResponse) ? NettyBodyWriter$.MODULE$.write(response.body(), ctx) : ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> true, $this.trace)).flatMap((Function1 & Serializable)flushed -> ServerInboundHandler.$anonfun$attemptFullWrite$6(this, ctx, BoxesRunTime.unboxToBoolean((Object)flushed)), $this.trace), $this.trace), this.trace)).flatMap((Function1 & Serializable)x$10 -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable)() -> ctx.channel().attr(ServerInboundHandler$.MODULE$.isReadKey()).set((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.trace).map((Function1 & Serializable)x$9 -> {
            ServerInboundHandler.$anonfun$attemptFullWrite$12(x$9);
            return BoxedUnit.UNIT;
        }, $this.trace), this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, ZIO<Object, Response, Response> exit, ServerTime time) {
        Response response;
        boolean bl = exit instanceof Exit.Success && (response = (Response)((Exit.Success)exit).value()) != null ? this.attemptFastWrite(ctx, response, time) : false;
        return bl;
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        Request request;
        None$ none$;
        Product product;
        HttpVersion nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (!(httpVersion != null ? !httpVersion.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
            product = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion2 = HttpVersion.HTTP_1_1;
            if (!(httpVersion2 != null ? !httpVersion2.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
                product = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)inetSocketAddress.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        if (nettyReq instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyReq;
            request = new Request(NettyBody$.MODULE$.fromByteBuf(fullHttpRequest.content()), Conversions$.MODULE$.headersFromNetty(fullHttpRequest.headers()), Conversions$.MODULE$.methodFromNetty(fullHttpRequest.method()), (URL)URL$.MODULE$.fromString(fullHttpRequest.uri()).getOrElse((Function0 & Serializable)() -> URL$.MODULE$.empty()), (Version)product, (Option<InetAddress>)none$);
        } else {
            Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(Function1 & Serializable)async -> {
                this.addAsyncBodyHandler(ctx, async);
                return BoxedUnit.UNIT;
            });
            request = new Request(body, Conversions$.MODULE$.headersFromNetty(nettyReq.headers()), Conversions$.MODULE$.methodFromNetty(nettyReq.method()), (URL)URL$.MODULE$.fromString(nettyReq.uri()).getOrElse((Function0 & Serializable)() -> URL$.MODULE$.empty()), (Version)product, (Option<InetAddress>)none$);
        }
        return request;
    }

    private void setServerTime(ServerTime time, Response response, HttpResponse jResponse) {
        if (response.serverTime()) {
            jResponse.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)time.refreshAndGet());
            return;
        }
    }

    private void upgradeToWebSocket(ChannelHandlerContext ctx, HttpRequest jReq, Response res, NettyRuntime runtime) {
        while (true) {
            Option<SocketApp<Object>> app = res.socketApp();
            if (jReq instanceof FullHttpRequest) {
                FullHttpRequest fullHttpRequest = (FullHttpRequest)jReq;
                ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder(((SocketApp)app.get()).protocol()).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (SocketApp)app.get(), this.trace));
                FullHttpRequest retained = fullHttpRequest.retainedDuplicate();
                ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)retained));
                return;
            }
            if (jReq == null) break;
            DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(jReq.protocolVersion(), jReq.method(), jReq.uri());
            fullRequest.headers().setAll(jReq.headers());
            jReq = fullRequest;
        }
        throw new MatchError(null);
    }

    private void writeNotFound(ChannelHandlerContext ctx, HttpRequest jReq, Function0<BoxedUnit> ensured) {
        this.runtime().run(ctx, ensured, this.runtime().run$default$3(), (ZIO<Object, Throwable, Object>)ZIO$.MODULE$.succeed((Function0 & Serializable)() -> new HttpError.NotFound(jReq.uri()).toResponse(), this.trace).flatMap((Function1 & Serializable)response -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.attemptFastWrite(ctx, (Response)response, this.time()), $this.trace).flatMap((Function1 & Serializable)done -> ServerInboundHandler.$anonfun$writeNotFound$4(this, ctx, response, jReq, BoxesRunTime.unboxToBoolean((Object)done)), $this.trace), this.trace), this.unsafe(), this.trace);
    }

    private void writeResponse(ChannelHandlerContext ctx, ZEnvironment<Object> env, ZIO<Object, Response, Response> exit, HttpRequest jReq, Function0<BoxedUnit> ensured) {
        this.runtime().run(ctx, ensured, this.runtime().run$default$3(), (ZIO<Object, Throwable, Object>)exit.sandbox(this.trace).catchAll((Function1 & Serializable)error -> (ZIO)error.failureOrCause().fold((Function1 & Serializable)response -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> response, $this.trace), (Function1 & Serializable)cause -> {
            if (cause.isInterruptedOnly()) {
                return this.interrupted(ctx).as((Function0 & Serializable)() -> null, $this.trace);
            }
            return (this.errCallback() != null ? this.errCallback().apply(cause) : ZIO$.MODULE$.unit()).as((Function0 & Serializable)() -> {
                Some x$1 = new Some((Object)new FiberFailure(cause));
                String x$2 = HttpError$InternalServerError$.MODULE$.apply$default$1();
                return new HttpError.InternalServerError(x$2, (Option<Throwable>)x$1).toResponse();
            }, $this.trace);
        }), CanFail$.MODULE$.canFail(), this.trace).flatMap((Function1 & Serializable)response -> (response != null ? ZIO$.MODULE$.attempt((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.attemptFastWrite(ctx, (Response)response, this.time()), $this.trace).flatMap((Function1 & Serializable)done -> ServerInboundHandler.$anonfun$writeResponse$9(this, ctx, response, jReq, BoxesRunTime.unboxToBoolean((Object)done)), $this.trace) : ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (ctx.channel().isOpen()) {
                this.writeNotFound(ctx, jReq, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {});
            }
        }, $this.trace)).map((Function1 & Serializable)x$15 -> {
            ServerInboundHandler.$anonfun$writeResponse$14(x$15);
            return BoxedUnit.UNIT;
        }, $this.trace), this.trace).provideEnvironment((Function0 & Serializable)() -> env, this.trace), this.unsafe(), this.trace);
    }

    private ZIO<Object, Nothing$, BoxedUnit> interrupted(ChannelHandlerContext ctx) {
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> ctx.channel().close(), this.trace).unit(this.trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(), this.trace);
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>> appRef, ServerConfig config, AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>> errCallbackRef, NettyRuntime runtime, ServerTime time, Object trace) {
        return new ServerInboundHandler(appRef, config, errCallbackRef, runtime, time, trace);
    }

    public AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>> copy$default$1() {
        return this.appRef();
    }

    public ServerConfig copy$default$2() {
        return this.config();
    }

    public AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>> copy$default$3() {
        return this.errCallbackRef();
    }

    public NettyRuntime copy$default$4() {
        return this.runtime();
    }

    public ServerTime copy$default$5() {
        return this.time();
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.appRef();
            }
            case 1: {
                return this.config();
            }
            case 2: {
                return this.errCallbackRef();
            }
            case 3: {
                return this.runtime();
            }
            case 4: {
                return this.time();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerInboundHandler;
    }

    public String productElementName(int x$1) {
        switch (x$1) {
            case 0: {
                return "appRef";
            }
            case 1: {
                return "config";
            }
            case 2: {
                return "errCallbackRef";
            }
            case 3: {
                return "runtime";
            }
            case 4: {
                return "time";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof ServerInboundHandler)) return false;
        boolean bl = true;
        if (!bl) return false;
        ServerInboundHandler serverInboundHandler = (ServerInboundHandler)x$1;
        AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>> atomicReference = this.appRef();
        AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>> atomicReference2 = serverInboundHandler.appRef();
        if (atomicReference == null) {
            if (atomicReference2 != null) {
                return false;
            }
        } else if (!atomicReference.equals(atomicReference2)) return false;
        ServerConfig serverConfig = this.config();
        ServerConfig serverConfig2 = serverInboundHandler.config();
        if (serverConfig == null) {
            if (serverConfig2 != null) {
                return false;
            }
        } else if (!((Object)serverConfig).equals(serverConfig2)) return false;
        AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>> atomicReference3 = this.errCallbackRef();
        AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>> atomicReference4 = serverInboundHandler.errCallbackRef();
        if (atomicReference3 == null) {
            if (atomicReference4 != null) {
                return false;
            }
        } else if (!atomicReference3.equals(atomicReference4)) return false;
        NettyRuntime nettyRuntime = this.runtime();
        NettyRuntime nettyRuntime2 = serverInboundHandler.runtime();
        if (nettyRuntime == null) {
            if (nettyRuntime2 != null) {
                return false;
            }
        } else if (!nettyRuntime.equals(nettyRuntime2)) return false;
        ServerTime serverTime = this.time();
        ServerTime serverTime2 = serverInboundHandler.time();
        if (serverTime == null) {
            if (serverTime2 == null) return true;
            return false;
        } else {
            if (!serverTime.equals(serverTime2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ void $anonfun$attemptFullWrite$9(Option x$7) {
    }

    public static final /* synthetic */ ZIO $anonfun$attemptFullWrite$6(ServerInboundHandler $this, ChannelHandlerContext ctx$2, boolean flushed) {
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> ctx$2.flush(), $this.trace).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> !flushed, $this.trace).map((Function1 & Serializable)x$7 -> {
            ServerInboundHandler.$anonfun$attemptFullWrite$9(x$7);
            return BoxedUnit.UNIT;
        }, $this.trace);
    }

    public static final /* synthetic */ void $anonfun$attemptFullWrite$12(BoxedUnit x$9) {
    }

    public static final /* synthetic */ ZIO $anonfun$writeNotFound$4(ServerInboundHandler $this, ChannelHandlerContext ctx$5, Response response$2, HttpRequest jReq$1, boolean done) {
        return $this.attemptFullWrite(ctx$5, response$2, jReq$1, $this.time(), $this.runtime()).unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> done, $this.trace).map((Function1 & Serializable)x$13 -> BoxedUnit.UNIT, $this.trace);
    }

    public static final /* synthetic */ void $anonfun$writeResponse$11(Option x$14) {
    }

    public static final /* synthetic */ ZIO $anonfun$writeResponse$9(ServerInboundHandler $this, ChannelHandlerContext ctx$6, Response response$4, HttpRequest jReq$2, boolean done) {
        return $this.attemptFullWrite(ctx$6, response$4, jReq$2, $this.time(), $this.runtime()).unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> done, $this.trace).map((Function1 & Serializable)x$14 -> {
            ServerInboundHandler.$anonfun$writeResponse$11(x$14);
            return BoxedUnit.UNIT;
        }, $this.trace);
    }

    public static final /* synthetic */ void $anonfun$writeResponse$14(BoxedUnit x$15) {
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Http<Object, Response, Request, Response>, ZEnvironment<Object>>> appRef, ServerConfig config, AtomicReference<Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>> errCallbackRef, NettyRuntime runtime, ServerTime time, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.errCallbackRef = errCallbackRef;
        this.runtime = runtime;
        this.time = time;
        this.trace = trace;
        super(false);
        Product.$init$((Product)this);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = true;
    }
}

