/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.socket;

import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import scala.;
import scala.$less$colon$less$;
import scala.MatchError;
import zio.http.socket.CloseStatus;
import zio.http.socket.CloseStatus$AbnormalClosure$;
import zio.http.socket.CloseStatus$BadGateway$;
import zio.http.socket.CloseStatus$Empty$;
import zio.http.socket.CloseStatus$EndpointUnavailable$;
import zio.http.socket.CloseStatus$InternalServerError$;
import zio.http.socket.CloseStatus$InvalidMessageType$;
import zio.http.socket.CloseStatus$InvalidPayloadData$;
import zio.http.socket.CloseStatus$MandatoryExtension$;
import zio.http.socket.CloseStatus$MessageTooBig$;
import zio.http.socket.CloseStatus$NormalClosure$;
import zio.http.socket.CloseStatus$PolicyViolation$;
import zio.http.socket.CloseStatus$ProtocolError$;
import zio.http.socket.CloseStatus$ServiceRestart$;
import zio.http.socket.CloseStatus$TlsHandshakeFailed$;
import zio.http.socket.CloseStatus$TryAgainLater$;
import zio.http.socket.SocketDecoder;
import zio.http.socket.SocketProtocol;

public final class NettySocketProtocol$ {
    public static final NettySocketProtocol$ MODULE$ = new NettySocketProtocol$();

    public WebSocketClientProtocolConfig.Builder clientBuilder(SocketProtocol socketProtocol) {
        return WebSocketClientProtocolConfig.newBuilder().subprotocol((String)socketProtocol.subprotocols().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).handshakeTimeoutMillis(socketProtocol.handshakeTimeoutMillis()).forceCloseTimeoutMillis(socketProtocol.forceCloseTimeoutMillis()).handleCloseFrames(socketProtocol.handleCloseFrames()).sendCloseFrame(this.closeStatusToNetty(socketProtocol.sendCloseFrame())).dropPongFrames(socketProtocol.dropPongFrames());
    }

    public WebSocketServerProtocolConfig.Builder serverBuilder(SocketProtocol socketProtocol) {
        return WebSocketServerProtocolConfig.newBuilder().checkStartsWith(true).websocketPath("").subprotocols((String)socketProtocol.subprotocols().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).handshakeTimeoutMillis(socketProtocol.handshakeTimeoutMillis()).forceCloseTimeoutMillis(socketProtocol.forceCloseTimeoutMillis()).handleCloseFrames(socketProtocol.handleCloseFrames()).sendCloseFrame(this.closeStatusToNetty(socketProtocol.sendCloseFrame())).dropPongFrames(socketProtocol.dropPongFrames()).decoderConfig(this.socketDecoderToNetty(socketProtocol.decoderConfig()));
    }

    private WebSocketCloseStatus closeStatusToNetty(CloseStatus closeStatus) {
        WebSocketCloseStatus webSocketCloseStatus;
        if (CloseStatus$NormalClosure$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.NORMAL_CLOSURE;
        } else if (CloseStatus$EndpointUnavailable$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.ENDPOINT_UNAVAILABLE;
        } else if (CloseStatus$ProtocolError$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.PROTOCOL_ERROR;
        } else if (CloseStatus$InvalidMessageType$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.INVALID_MESSAGE_TYPE;
        } else if (CloseStatus$InvalidPayloadData$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.INVALID_PAYLOAD_DATA;
        } else if (CloseStatus$PolicyViolation$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.POLICY_VIOLATION;
        } else if (CloseStatus$MessageTooBig$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.MESSAGE_TOO_BIG;
        } else if (CloseStatus$MandatoryExtension$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.MANDATORY_EXTENSION;
        } else if (CloseStatus$InternalServerError$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.INTERNAL_SERVER_ERROR;
        } else if (CloseStatus$ServiceRestart$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.SERVICE_RESTART;
        } else if (CloseStatus$TryAgainLater$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.TRY_AGAIN_LATER;
        } else if (CloseStatus$BadGateway$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.BAD_GATEWAY;
        } else if (CloseStatus$Empty$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.EMPTY;
        } else if (CloseStatus$AbnormalClosure$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.ABNORMAL_CLOSURE;
        } else if (CloseStatus$TlsHandshakeFailed$.MODULE$.equals(closeStatus)) {
            webSocketCloseStatus = WebSocketCloseStatus.TLS_HANDSHAKE_FAILED;
        } else if (closeStatus instanceof CloseStatus.Custom) {
            CloseStatus.Custom custom = (CloseStatus.Custom)closeStatus;
            int code = custom.code();
            String message = custom.reason();
            webSocketCloseStatus = new WebSocketCloseStatus(code, message);
        } else {
            throw new MatchError((Object)closeStatus);
        }
        return webSocketCloseStatus;
    }

    private WebSocketDecoderConfig socketDecoderToNetty(SocketDecoder socketDecoder) {
        return WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(socketDecoder.maxFramePayloadLength()).expectMaskedFrames(socketDecoder.expectMaskedFrames()).allowMaskMismatch(socketDecoder.allowMaskMismatch()).allowExtensions(socketDecoder.allowExtensions()).closeOnProtocolViolation(socketDecoder.closeOnProtocolViolation()).withUTF8Validator(socketDecoder.withUTF8Validator()).build();
    }

    private NettySocketProtocol$() {
    }
}

