/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.ChannelEvent;
import zio.http.Handler;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.HttpError;
import zio.http.MediaType$;
import zio.http.Response;
import zio.http.Status;
import zio.http.Status$Ok$;
import zio.http.Status$PermanentRedirect$;
import zio.http.Status$SeeOther$;
import zio.http.Status$SwitchingProtocols$;
import zio.http.Status$TemporaryRedirect$;
import zio.http.URL;
import zio.http.html.Html;
import zio.http.socket.SocketApp;
import zio.http.socket.WebSocketFrame;

public final class Response$ {
    public static final Response$ MODULE$ = new Response$();
    private static Headers contentTypeJson;
    private static Headers contentTypeHtml;
    private static Headers contentTypeText;
    private static volatile byte bitmap$0;
    private static volatile byte bitmap$init$0;

    public Response apply(Status status, Headers headers, Body body) {
        return new Response.BasicResponse(body, headers, status);
    }

    public Status apply$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers apply$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body apply$default$3() {
        return Body$.MODULE$.empty();
    }

    public Response fromHttpError(HttpError error) {
        return new Response.ErrorResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), error, error.status());
    }

    public <R> ZIO<R, Nothing$, Response> fromSocket(Handler<R, Throwable, ChannelEvent<WebSocketFrame, WebSocketFrame>, BoxedUnit> http, Object trace) {
        return this.fromSocketApp(http.toSocketApp((.less.colon.less<ChannelEvent<WebSocketFrame, WebSocketFrame>, ChannelEvent<WebSocketFrame, WebSocketFrame>>)$less$colon$less$.MODULE$.refl(), (.less.colon.less<Throwable, Throwable>)$less$colon$less$.MODULE$.refl(), trace), trace);
    }

    public <R> ZIO<R, Nothing$, Response> fromSocketApp(SocketApp<R> app, Object trace) {
        return ZIO$.MODULE$.environment(trace).map((Function1 & Serializable)env -> new Response.SocketAppResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), app.provideEnvironment((ZEnvironment)env, trace), Status$SwitchingProtocols$.MODULE$), trace);
    }

    public Response html(Html data, Status status) {
        return new Response.BasicResponse(Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2()), this.contentTypeHtml(), status);
    }

    public Status html$default$2() {
        return Status$Ok$.MODULE$;
    }

    public Response json(CharSequence data) {
        return new Response.BasicResponse(Body$.MODULE$.fromCharSequence(data, Body$.MODULE$.fromCharSequence$default$2()), this.contentTypeJson(), Status$Ok$.MODULE$);
    }

    public Response ok() {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), Status$Ok$.MODULE$);
    }

    public Response redirect(URL location, boolean isPermanent) {
        Status status = isPermanent ? Status$PermanentRedirect$.MODULE$ : Status$TemporaryRedirect$.MODULE$;
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Location(location)})), status);
    }

    public boolean redirect$default$2() {
        return false;
    }

    public Response seeOther(URL location) {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Location(location)})), Status$SeeOther$.MODULE$);
    }

    public Response status(Status status) {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), status);
    }

    public Response text(CharSequence text) {
        return new Response.BasicResponse(Body$.MODULE$.fromCharSequence(text, Body$.MODULE$.fromCharSequence$default$2()), this.contentTypeText(), Status$Ok$.MODULE$);
    }

    private Headers contentTypeJson$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 1) == 0) {
                contentTypeJson = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.application().json(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return contentTypeJson;
    }

    private Headers contentTypeJson() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.contentTypeJson$lzycompute();
        }
        return contentTypeJson;
    }

    private Headers contentTypeHtml$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 2) == 0) {
                contentTypeHtml = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().html(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return contentTypeHtml;
    }

    private Headers contentTypeHtml() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.contentTypeHtml$lzycompute();
        }
        return contentTypeHtml;
    }

    private Headers contentTypeText$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 4) == 0) {
                contentTypeText = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().plain(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return contentTypeText;
    }

    private Headers contentTypeText() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.contentTypeText$lzycompute();
        }
        return contentTypeText;
    }

    private Response$() {
    }
}

