/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import zio.http.Charsets$;
import zio.http.Path;
import zio.http.Path$;
import zio.http.QueryParams;
import zio.http.QueryParams$;
import zio.http.Scheme;
import zio.http.Scheme$;
import zio.http.Scheme$HTTP$;
import zio.http.Scheme$HTTPS$;
import zio.http.Scheme$WS$;
import zio.http.Scheme$WSS$;
import zio.http.URL;
import zio.http.URL$Fragment$;
import zio.http.URL$Location$Relative$;
import zio.http.internal.QueryParamEncoding$;
import zio.http.package$;

public final class URL$
implements Serializable {
    public static final URL$ MODULE$ = new URL$();
    private static volatile byte bitmap$init$0;

    public URL.Location $lessinit$greater$default$2() {
        return URL$Location$Relative$.MODULE$;
    }

    public QueryParams $lessinit$greater$default$3() {
        return QueryParams$.MODULE$.empty();
    }

    public Option<URL.Fragment> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public URL empty() {
        return new URL(Path$.MODULE$.empty(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4());
    }

    public Either<Exception, URL> decode(String string) {
        try {
            Left left;
            Option<URL> url;
            URI uri = new URI(string);
            Option<URL> option = url = uri.isAbsolute() ? this.fromAbsoluteURI(uri) : this.fromRelativeURI(uri);
            if (None$.MODULE$.equals(url)) {
                left = URL$.invalidURL$1(string);
            } else if (url instanceof Some) {
                URL value = (URL)((Some)url).value();
                left = scala.package$.MODULE$.Right().apply((Object)value);
            } else {
                throw new MatchError(url);
            }
            return left;
        }
        catch (Exception e) {
            return scala.package$.MODULE$.Left().apply((Object)e);
        }
    }

    public Option<URL> fromURI(URI uri) {
        if (uri.isAbsolute()) {
            return this.fromAbsoluteURI(uri);
        }
        return this.fromRelativeURI(uri);
    }

    public URL root() {
        return new URL(package$.MODULE$.$bang$bang(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4());
    }

    public String zio$http$URL$$encode(URL url) {
        String string;
        URL.Location location = url.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            string = URL$.path$1(url);
        } else if (location instanceof URL.Location.Absolute) {
            URL.Location.Absolute absolute = (URL.Location.Absolute)location;
            Scheme scheme = absolute.scheme();
            String host = absolute.host();
            int port = absolute.port();
            string = port == this.zio$http$URL$$portFromScheme(scheme) ? new StringBuilder(3).append(scheme.encode()).append("://").append(host).append(URL$.path$1(url)).toString() : new StringBuilder(4).append(scheme.encode()).append("://").append(host).append(":").append(port).append(URL$.path$1(url)).toString();
        } else {
            throw new MatchError((Object)location);
        }
        return string;
    }

    private Option<URL> fromAbsoluteURI(URI uri) {
        return Scheme$.MODULE$.decode(uri.getScheme()).flatMap((Function1 & Serializable)scheme -> Option$.MODULE$.apply((Object)uri.getHost()).flatMap((Function1 & Serializable)host -> Option$.MODULE$.apply((Object)uri.getRawPath()).map((Function1 & Serializable)path -> {
            int port = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)uri.getPort())).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != -1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.zio$http$URL$$portFromScheme((Scheme)scheme)));
            URL.Location.Absolute connection = new URL.Location.Absolute((Scheme)scheme, (String)host, port);
            return new Tuple3(path, (Object)BoxesRunTime.boxToInteger((int)port), (Object)connection);
        }).map((Function1 & Serializable)x$2 -> {
            if (x$2 == null) {
                throw new MatchError(null);
            }
            String path = (String)x$2._1();
            URL.Location.Absolute connection = (URL.Location.Absolute)x$2._3();
            URL uRL = new URL(Path$.MODULE$.decode(path), connection, QueryParams$.MODULE$.decode(uri.getRawQuery(), QueryParams$.MODULE$.decode$default$2()), URL$Fragment$.MODULE$.fromURI(uri));
            return uRL;
        })));
    }

    private Option<URL> fromRelativeURI(URI uri) {
        return Option$.MODULE$.apply((Object)uri.getRawPath()).map((Function1 & Serializable)path -> new URL(Path$.MODULE$.decode((String)path), URL$Location$Relative$.MODULE$, QueryParams$.MODULE$.decode(uri.getRawQuery(), QueryParams$.MODULE$.decode$default$2()), URL$Fragment$.MODULE$.fromURI(uri)));
    }

    public int zio$http$URL$$portFromScheme(Scheme scheme) {
        int n;
        boolean bl = Scheme$HTTP$.MODULE$.equals(scheme) ? true : Scheme$WS$.MODULE$.equals(scheme);
        if (bl) {
            n = 80;
        } else {
            boolean bl2 = Scheme$HTTPS$.MODULE$.equals(scheme) ? true : Scheme$WSS$.MODULE$.equals(scheme);
            if (bl2) {
                n = 443;
            } else {
                throw new MatchError((Object)scheme);
            }
        }
        return n;
    }

    public URL apply(Path path, URL.Location kind, QueryParams queryParams, Option<URL.Fragment> fragment) {
        return new URL(path, kind, queryParams, fragment);
    }

    public URL.Location apply$default$2() {
        return URL$Location$Relative$.MODULE$;
    }

    public QueryParams apply$default$3() {
        return QueryParams$.MODULE$.empty();
    }

    public Option<URL.Fragment> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Tuple4<Path, URL.Location, QueryParams, Option<URL.Fragment>>> unapply(URL x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.path(), (Object)x$0.kind(), (Object)x$0.queryParams(), x$0.fragment()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(URL$.class);
    }

    private static final Left invalidURL$1(String string$1) {
        return scala.package$.MODULE$.Left().apply((Object)new MalformedURLException(new StringBuilder(15).append("Invalid URL: \"").append(string$1).append("\"").toString()));
    }

    private static final String path$1(URL url$1) {
        return new StringBuilder(0).append(QueryParamEncoding$.MODULE$.default().encode(url$1.path().encode(), url$1.queryParams().normalize(), Charsets$.MODULE$.Http())).append(url$1.fragment().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)f -> new StringBuilder(1).append("#").append(f.raw()).toString())).toString();
    }

    private URL$() {
    }
}

